#ifndef _FILE_H_
#define _FILE_H_

#include "Migra.h"

typedef enum FILEOPENMODE
{
	FILE_INPUT = 0,
	FILE_OUTPUT = -1
} FILEOPENMODE;

class File
{
public:
	File(void){};
	virtual ~File(void){};
	virtual MIGRAERROR Open(char *filename, FILEOPENMODE mode, char *owner) = 0;
	virtual MIGRAERROR GetSpecs(void **specs) = 0;
	virtual MIGRAERROR NumberOfRecords(int *recs) = 0;
	virtual MIGRAERROR Close(void) = 0;
	virtual MIGRAERROR Create(char *filename, void *filedefs) = 0;
	virtual MIGRAERROR GetRecord(void **recbuf, unsigned short *reclen) = 0;
	virtual MIGRAERROR First(void) = 0;
	virtual MIGRAERROR Next(void) = 0;
	virtual MIGRAERROR Insert(void *recbuf, unsigned short reclen) = 0;
	virtual bool IsOpen(void) = 0;
};

#endif /* ~_FILE_H_ */
