#ifndef _FILEBTRV_H_
#define _FILEBTRV_H_

#include "File.h"
#include "RtgBtrv.h"

struct FILE_SPECS {
	BTI_WORD recLength;
	BTI_WORD pageSize;
	BTI_BYTE indexCount;
	BTI_BYTE fileVersion;
	BTI_BYTE recordCount[4];
	BTI_WORD flags;
	BTI_BYTE dupPointers;
	BTI_BYTE notUsed;
	BTI_WORD allocations;
} ;
struct KEY_SPECS {
	BTI_WORD position;
	BTI_WORD length;
	BTI_WORD flags;
	BTI_BYTE reserved[4];
	BTI_BYTE type;
	BTI_BYTE null;
	BTI_BYTE notUsed[2];
	BTI_BYTE manualKeyNumber;
	BTI_BYTE acsNumber;
} ;
struct ACS_SPECS {
	BTI_CHAR acs[265];
} ;
struct FILE_CREATE_BUF {
	FILE_SPECS fileSpecs;
	KEY_SPECS  keySpecs[119];
	ACS_SPECS  acsSpecs[119];
} ;

class FileBtrv : public File
{
public:
	FileBtrv(RtgBtrv *rtg);
	~FileBtrv(void);
	MIGRAERROR Open(BTI_CHAR_PTR filename, FILEOPENMODE mode, BTI_CHAR_PTR owner);
	MIGRAERROR GetSpecs(BTI_VOID_PTR *specs);
	MIGRAERROR NumberOfRecords(BTI_INT_PTR recs);
	MIGRAERROR NumberOfIndices(BTI_BUFFER_PTR idxs);
	MIGRAERROR Close(void);
	MIGRAERROR Create(BTI_CHAR_PTR filename, BTI_VOID_PTR _fcb);
	MIGRAERROR GetRecord(BTI_VOID_PTR *recbuf, BTI_WORD *reclen);
	MIGRAERROR First(void);
	MIGRAERROR Next(void);
	MIGRAERROR Insert(BTI_VOID_PTR recbuf, BTI_WORD reclen);
	bool IsOpen(void){return open;};
private:
	MIGRAERROR AllocRecord(void);
	MIGRAERROR FreeRecord(void);
	MIGRAERROR MapError(BTI_SINT bterror);
private:
	bool open;
	BTI_BYTE posBlock[128];
	BTI_BYTE dataBuf[255];
	BTI_WORD dataLen;
	BTI_BYTE keyBuf[255];
	BTI_SINT keyNum;
	FILE_CREATE_BUF fcb;
	BTI_VOID_PTR recBuf;
	BTI_WORD recBufLen;
	BTI_WORD recLen;
protected:
	const char *rtgFunc;
	const char *rtgLib;
private:
	bool gotfcb;
	BTRV_fn fpBTRV;
	BTI_SINT BTRV(
		BTI_WORD     operation,
		BTI_VOID_PTR _posBlock,
		BTI_VOID_PTR dataBuffer,
		BTI_WORD_PTR dataLength,
		BTI_VOID_PTR keyBuffer,
		BTI_SINT     keyNumber)
	{
		BTI_SINT rc = B_INVALID_FUNCTION;
		if (fpBTRV)
		{
			rc = fpBTRV(operation,
						_posBlock,
						dataBuffer,
						dataLength,
						keyBuffer,
						keyNumber);
		}
		return rc;
	};
};

#endif /* ~_FILEBTRV_H_ */
