#ifndef _FILEEXTFH_H_
#define _FILEEXTFH_H_

#include "File.h"
#include "RtgExtfh.h"

void from_compx(EXTFH_VOID_PTR Dst, EXTFH_VOID_PTR Src, size_t DstSize, size_t SrcSize);
void to_compx(EXTFH_VOID_PTR Dst, EXTFH_VOID_PTR Src, size_t DstSize, size_t SrcSize);

#define BIT_0 0x01
#define BIT_1 0x02
#define BIT_2 0x04
#define BIT_3 0x08
#define BIT_4 0x10
#define BIT_5 0x20
#define BIT_6 0x40
#define BIT_7 0x80

class Fcd
{
public:
	Fcd(void)
	{
		empty = true;
		fcdlen = 216; // max(FCD3,FCD2) = max(216,100) = 216
		kdlen = 22510; // Global+((N)*Key)+((N*M)*Component) = 14+((128)*16)+((128*16)*10) = 22510
		fcdsize = fcdlen + kdlen;

		fcd = calloc(fcdsize, 1);
		if (fcd != NULL)
		{
			EXTFH_BYTE version = (sizeof(EXTFH_VOID_PTR) > 4) ? 1 : 0;
			SetField(4, 1, 1, &version, sizeof(version));

			kd = (EXTFH_BUFFER_PTR)fcd + fcdlen;
			if (Version())
				SetField(184, 8, 2, &kd);
			else
				SetField(64, 4, 2, &kd);
		}
	};
	~Fcd(void)
	{
		if (fcd)
			free(fcd);
		fcd = NULL;
		kd = NULL;
	};
	EXTFH_VOID Set(EXTFH_VOID_PTR ptr)
	{
		if (ptr)
		{
			memcpy(fcd, ptr, fcdsize);
			if (Version())
				SetField(184, 8, 2, &kd);
			else
				SetField(64, 4, 2, &kd);
			empty = false;
		}
	}
	EXTFH_BUFFER_PTR Get()
	{
		return (EXTFH_BUFFER_PTR)fcd;
	}
	EXTFH_STATUS GetStatus(void)
	{
		return (EXTFH_STATUS)fcd;
	}
	bool IsStatus(EXTFH_STATUS status)
	{
		return (strncmp(status, GetStatus(), 2)) ? false : true;
	}
	EXTFH_VOID SetStatus(EXTFH_STATUS status)
	{
		EXTFH_BYTE statustype;
		EXTFH_BYTE accessmode;
		GetField((Version()) ? 33 : 20, 1, 1, &statustype, sizeof(statustype));
		GetField(6, 1, 1, &accessmode, sizeof(accessmode));
		if (statustype & BIT_7)
		{
			SetField(0, 1, 0, &status[0], sizeof(status[0]));
			SetField(1, 1, 0, &status[1], sizeof(status[1]));
		}
		else
		{
#if 0
			EXTFH_CHAR ansi74[2];
			ANSI85toANSI74(status,ansi74);
			SetField(0, 1, 0, &ansi74[0], sizeof(ansi74[0]));
			SetField(1, 1, 0, &ansi74[1], sizeof(ansi74[1]));
#else
			SetField(0, 1, 0, &status[0], sizeof(status[0]));
			SetField(1, 1, 0, &status[1], sizeof(status[1]));
#endif
		}
		accessmode |= (EXTFH_BYTE) BIT_7; /* User Status is indicated by bit 7.The bit is set if you have defined a file status */
		SetField(6, 1, 1, &accessmode, sizeof(accessmode));
	};
	EXTFH_VOID SetFileName(EXTFH_CHAR_PTR input)
	{
		EXTFH_UINT len = 0;
		if (Version())
			SetField(168, 8, 2, &input);
		else
			SetField(60, 4, 2, &input);
		if (input)
			len = (EXTFH_UINT)strlen(input);
		if (Version())
			SetField(54, 2, 1, &len, sizeof(len));
		else
			SetField(11, 2, 1, &len, sizeof(len));
	};
	EXTFH_VOID SetFileOrganization(EXTFH_WORD input)
	{
		SetField(5, 1, 1, &input, sizeof(input));
	};
	EXTFH_VOID SetCurrentRecordLength(EXTFH_UINT input)
	{
		if (Version())
			SetField(88, 4, 1, &input, sizeof(input));
		else
			SetField(48, 2, 1, &input, sizeof(input));
	};
	EXTFH_VOID SetRecordAddress(EXTFH_VOID_PTR input)
	{
		if (Version())
			SetField(160, 8, 2, &input);
		else
			SetField(56, 4, 2, &input);
	}
	EXTFH_VOID SetKeyLength(EXTFH_UINT input)
	{
		if (Version())
			SetField(66, 2, 1, &input, sizeof(input));
		else
			SetField(54, 2, 1, &input, sizeof(input));
	}
	EXTFH_UINT GetCurrentRecordLength()
	{
		EXTFH_UINT output;
		if (Version())
			GetField(88, 4, 1, &output, sizeof(output));
		else
			GetField(48, 2, 1, &output, sizeof(output));
		return output;
	}
	EXTFH_UINT GetMaxRecordLength()
	{
		EXTFH_UINT output;
		if (Version())
			GetField(96, 4, 1, &output, sizeof(output));
		else
			GetField(38, 2, 1, &output, sizeof(output));
		return output;
	}
	EXTFH_UINT GetNumberOfRecords()
	{
		EXTFH_UINT output;
		if (Version())
			GetField(144, 8, 1, &output, sizeof(output));
		else
			GetField(43, 4, 1, &output, sizeof(output));
		return output;
	}
private:
	EXTFH_BYTE Version()
	{
		return *(Get()+4);
	}
	EXTFH_VOID SetField(EXTFH_WORD offset, EXTFH_WORD size, EXTFH_WORD type, EXTFH_VOID_PTR input, size_t inpsize = 0)
	{
		switch (type)
		{
			case 0: /* native */
				memcpy(Get()+offset, input, size);
				break;
			case 1: /* comp-x */
				to_compx(Get()+offset, input, size, inpsize); 
				break;
			case 2: /* pointer */
				memcpy(Get()+offset, input, size);
				break;
		}
	}
	EXTFH_VOID_PTR GetField(EXTFH_WORD offset, EXTFH_WORD size, EXTFH_WORD type, EXTFH_VOID_PTR output, size_t outsize)
	{
		EXTFH_VOID_PTR address = Get()+offset;
		switch (type)
		{
			case 0: /* native */
				memcpy(output, address, outsize);
				break;
			case 1: /* comp-x */
				from_compx(output, address, outsize, size);
				break;
			case 2: /* pointer */
				memcpy(output, address, outsize);
				break;
		}
		return address;
	}

public:
	bool empty;
private:
	EXTFH_VOID_PTR fcd;
	EXTFH_VOID_PTR kd;
	size_t fcdlen;
	size_t kdlen;
	size_t fcdsize;
};

class FileExtfh : public File
{
public:
	FileExtfh(RtgExtfh *rtg);
	~FileExtfh(void);
	MIGRAERROR Open(EXTFH_CHAR_PTR filename, FILEOPENMODE mode, EXTFH_CHAR_PTR owner);
	MIGRAERROR GetSpecs(EXTFH_VOID_PTR *specs = NULL);
	MIGRAERROR NumberOfRecords(EXTFH_INT *recs);
	MIGRAERROR Close(void);
	MIGRAERROR Create(EXTFH_CHAR_PTR filename, EXTFH_VOID_PTR _fcb);
	MIGRAERROR GetRecord(EXTFH_VOID_PTR *recbuf, EXTFH_WORD *reclen);
	MIGRAERROR First(void);
	MIGRAERROR Next(void);
	MIGRAERROR Insert(EXTFH_VOID_PTR recbuf, EXTFH_WORD reclen);
	bool IsOpen(void){return open;};
protected:
	const char *rtgFunc;
	const char *rtgLib;
private:
	MIGRAERROR GetSpecs(Fcd &f, EXTFH_VOID_PTR *specs = NULL);
	MIGRAERROR AllocRecord(void);
	MIGRAERROR FreeRecord(void);
	MIGRAERROR MapError();
	MIGRAERROR MapError(EXTFH_CHAR status[2]);
private:
	bool open;
	Fcd fcd;
	Fcd defs;
	EXTFH_CHAR_PTR fileName;
	EXTFH_VOID_PTR recBuf;
	EXTFH_UINT recBufLen;
	EXTFH_UINT recLen;
private:
	EXTFH_fn fpEXTFH;
	EXTFH_INT EXTFH(EXTFH_OPCODE op, Fcd &f)
	{
		EXTFH_INT rc = 0;
		if (fpEXTFH)
		{
			EXTFH_BYTE opcode[2];
			if (op >= 0xFA00)
			{
				opcode[0] = 0xFA; // standard operation
				op -= 0xFA00;
			}
			else
				opcode[0] = 0x00; // special operation
			opcode[1] = (EXTFH_BYTE)op;

			rc = fpEXTFH(opcode, f.Get());
		}
		else
		{
			f.SetStatus(E_85_IO_NOTSUPP);
		}
		return rc;
	}
};

#endif /* ~_FILEEXTFH_H_ */
