#ifndef _LOADLIB_H_
#define _LOADLIB_H_

#ifdef _WIN32

#include <Windows.h>
#ifdef UNICODE
#define ctLoadLib(l)               LoadLibraryA(l)
#else /* ~UNICODE */
#define ctLoadLib(l)               LoadLibrary(l)
#endif /* ~UNICODE */
#define ctFreeLib(h)               (!FreeLibrary((HMODULE)h))
#define ctGetFunc(h,f,p)           (void (*)(void))GetProcAddress((HMODULE)h,f)
#define ctLoadLibErr()             GetLastError()
#define ctLoadLibErrMsg()          NULL
static int ctMissingLib(const char *l)
{
	HMODULE h=LoadLibraryEx(l,NULL,LOAD_LIBRARY_AS_DATAFILE);
	if (h==NULL && GetLastError()==ERROR_FILE_NOT_FOUND)
		return 1;
	if (h) FreeLibrary(h);
	return 0;
}

#else  /* ~_WIN32 */

/* If compiling with gcc 3.2.2 on HP/UX 11: */
#ifdef HPUX
#if ((__GNUC__ == 3) && (__GNUC_MINOR__ == 2) && (__GNUC_PATCHLEVEL__ == 2))
/*
** Use shl_load(), shl_unload(), and shl_findsym() instead of
** dlopen(), dlclose(), and dlsym().
*/
#define ctUSE_SHL_FUNC
#endif
#endif

#ifdef ctUSE_SHL_FUNC

#include <dl.h>
#define ctLoadLib(l)            shl_load(l,BIND_IMMEDIATE,0L)
#define ctFreeLib(h)            shl_unload(h)
#define ctGetFunc(h,f,p)        shl_findsym(h,f,TYPE_PROCEDURE,&p)
#define ctLoadLibErr()          errno
#define ctLoadLibErrMsg()       NULL
static int ctMissingLib(const char *l)
{
	void *h=ctLoadLib(l);
	if (h==NULL && errno=ENOENT)
		return 1;
	if (h) dlclose(h);
	return 0;
}

#else  /* ~ctUSE_SHL_FUNC */

#include <dlfcn.h>
#define ctLoadLib(l)            dlopen(l,RTLD_NOW)
#define ctFreeLib(h)            dlclose(h)
#define ctGetFunc(h,f,p)        dlsym(h,f)
#define ctLoadLibErr()          0
#define ctLoadLibErrMsg()       dlerror()
#include <string.h>
static int ctMissingLib(const char *l)
{
	void *h=ctLoadLib(l);
	if (h==NULL && strstr(dlerror(), "No such file or directory"))
		return 1;
	if (h) dlclose(h);
	return 0;
}

#endif /* ~ctUSE_SHL_FUNC */

#endif /* ~_WIN32 */

#endif /* ~_LOADLIB_H_ */
