#ifndef _MIGRA_H_
#define _MIGRA_H_

#ifdef _WIN32
#include <windows.h>
#else
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include <errno.h>
#endif

#if defined _MSC_VER && _MSC_VER >= 1400
/* avoid compiler warning C4996 */
#define putenv _putenv
#endif

#ifndef UNREFERENCED_PARAMETER
#define UNREFERENCED_PARAMETER(P) (P=P)
#endif

typedef enum MIGRAERROR
{
	MIGRA_OK = 0,
	MIGRA_EOF = -1,
	MIGRA_CONFIG = -2,
	MIGRA_NOLIB = -3,
	MIGRA_NOINTF = -4,
	MIGRA_NOMEM = -5,
	MIGRA_NORECS = -6,
	MIGRA_NOSUPP = -7,
	MIGRA_NOFILE = -8,
	MIGRA_EXIST = -9,
	MIGRA_NOSRV = -10,
	MIGRA_NOUSR = -11,
	MIGRA_NORTGSRV = -12,
	MIGRA_NOREDIR = -13,
	MIGRA_BADREDIR = -14,
	MIGRA_BADLIB = -15,
	MIGRA_BADPWD = -16
} MIGRAERROR;

typedef enum MigraCallbackOp
{
	MigraProgress = 1,
	MigraError,
	MigraNoMemory,
	MigraNoLibrary,
	MigraNoInterface,
	MigraBadConfig,
	MigraMissingRecords,
	MigraAlreadyExists,
	MigraFileNotFound,
	MigraServerNotRunning,
	MigraInvalidUser,
	MigraInvalidServer,
	MigraLibNotFound,
	MigraInvalidLib,
	MigraBadLibrary,
	MigraNoFeature,
	MigraBadEncryption,
	MigraBadCompression,
	MigraBadTransaction,
	MigraProfile,
	MigraComplete
} MigraCallbackOp;

typedef struct {
	int opcode;
	int error;
	int num1;
	int num2;
	int num3;
	const char *str1;
	const char *str2;
} MigraCallbackData, *pMigraCallbackData;
typedef void (*pMigraCallback)(pMigraCallbackData);

typedef enum MigraInterface
{
	MigraBtrv = 1,
	MigraExtfh
} MigraInterface;

class Migra
{
public:
	Migra(void);
	~Migra(void);
	void SetCallback(pMigraCallback fn) {fnCallback = fn;};
	int CopyBtrv(char *src, char *dst, bool replace, bool clone, char *owner){return Copy(MigraBtrv, src, dst, replace, clone, owner);};
	int CopyExtfh(char *src, char *dst, bool replace, bool clone){return Copy(MigraBtrv, src, dst, replace, clone, NULL);};
	int Copy(MigraInterface api, char *src, char *dst, bool replace, bool clone, char *owner);
	int Ping(MigraInterface api, char *srv, char *usr, char *pwd);
private:
	pMigraCallback fnCallback;
	MigraCallbackData dataCallback;
};

const size_t MAX_PATH_LEN = 256;
const char EXT_SEP = '.';
const char WIN_PATH_SEP = '\\';
const char UNIX_PATH_SEP = '/';
#ifdef _WIN32
const char PATH_SEP = WIN_PATH_SEP;
#else
const char PATH_SEP = UNIX_PATH_SEP;
#endif

#define SOURCETAG "$SOURCE$"
#define DESTTAG "$DEST$"

#ifdef _WIN32
__declspec(dllexport)
#endif
int Migrate(
	pMigraCallback progress,
	MigraInterface api,
	char *src,
	char *dst,
	char *cfg,
	char *log,
	unsigned int bat,
	char *sfn,
	char *dfn,
	char *dsn,
	char *dus,
	char *dpw,
	char *dix,
	char *ssn,
	char *sus,
	char *spw,
	char *six,
	char *own,
	bool replace,
	bool clone,
	bool appendext,
	char *enc,
	char *cmp,
	char *trn
);

#ifdef _WIN32
__declspec(dllexport)
#endif
int Ping(
	MigraInterface api,
	char *srv,
	char *usr,
	char *pwd
);

#include <time.h>
#include <sys/timeb.h>
class Timer
{
public:
	Timer(void){Reset();};
	~Timer(void){};
	void Start() {
		ftime(&tstart);
	};
	void Stop() {
		ftime(&tend);
		tdiff = (1000.0*(tend.time-tstart.time))+tend.millitm-tstart.millitm;
		telap += tdiff;
	};
	void Reset() {
		telap = tdiff = 0.0;
	};
	int Total() {
		return (int)telap;
	};
private:
	struct timeb tstart, tend;
	double telap;
	double tdiff;
};

#endif /* ~_MIGRA_H_ */
