#ifndef _RTG_H_
#define _RTG_H_

#include "Migra.h"

#ifdef _WIN32
#include <windows.h>
#endif
#include "LoadLib.h"

#if defined(__STDC__) && defined(__STDC_VERSION__) && __STDC_VERSION__ >= 199901L  
#include <stdint.h>

typedef int32_t          RTG_INT;
typedef uint32_t         RTG_UINT;
typedef int16_t          RTG_SINT;
typedef uint16_t         RTG_WORD;
typedef char             RTG_CHAR;
typedef uint8_t          RTG_BYTE;
typedef void             RTG_VOID;
#else
typedef int              RTG_INT;
typedef unsigned int     RTG_UINT;
typedef short int        RTG_SINT;
typedef unsigned short   RTG_WORD;
typedef char             RTG_CHAR;
typedef unsigned char    RTG_BYTE;
typedef void             RTG_VOID;
#endif

typedef RTG_INT        * RTG_INT_PTR;
typedef RTG_WORD       * RTG_WORD_PTR;
typedef RTG_CHAR       * RTG_CHAR_PTR;
typedef RTG_BYTE       * RTG_BUFFER_PTR;
typedef RTG_VOID       * RTG_VOID_PTR;

typedef struct {
	RTG_SINT logical;
	RTG_SINT padERR1;
	RTG_INT ctree;
	RTG_INT system;
} CT_ERROR, *pCT_ERROR;

typedef struct {
	CT_ERROR	err;
} CT_INIT, *pCT_INIT;

typedef RTG_VOID_PTR(*ctl_config_fn) (RTG_VOID_PTR conn, RTG_INT op, RTG_VOID_PTR conf, RTG_VOID_PTR item, RTG_INT argc, RTG_CHAR_PTR *argv);
typedef pCT_INIT(*ctl_init_fn) (RTG_CHAR_PTR cnf_file, RTG_VOID_PTR env, RTG_VOID_PTR conf, RTG_INT intf, pCT_ERROR _err, RTG_CHAR_PTR _errmsg);
typedef RTG_VOID(*ctl_exit_fn) (pCT_INIT conn, RTG_VOID_PTR *env, RTG_VOID_PTR *conf);
typedef RTG_INT(*ctl_connect_fn) (pCT_INIT conn, RTG_SINT instance);

///////////////////////////////////////////////////////////////////////////////

class Rtg
{
public:
	Rtg(void)
	{
		isLoaded = false;
		isFound = false;
		hLib = NULL;
		szLib = NULL;
		hasInterface = false;
		hFunc = NULL;
		szFunc = NULL;
		hasPing = false;
		fpConfig = NULL;
		fpInit = NULL;
		fpExit = NULL;
		fpConnect = NULL;
	};
	virtual ~Rtg(void)
	{
		isLoaded = false;
		if (hLib)
		{
			ctFreeLib(hLib);
		}
		hLib = NULL;
		szLib = NULL;
		hasInterface = false;
		hFunc = NULL;
		szFunc = NULL;
		hasPing = false;
		fpConfig = NULL;
		fpInit = NULL;
		fpExit = NULL;
		fpConnect = NULL;
	};
	const char *GetLibName(void){return szLib;};
	const char *GetFuncName(void){return szFunc;};
	virtual void (*Load(void))(void) = 0;
	MIGRAERROR Ping(RTG_CHAR_PTR srv, RTG_CHAR_PTR usr, RTG_CHAR_PTR pwd)
	{
		MIGRAERROR rc = MIGRA_OK;
		RTG_VOID_PTR conf = NULL;
		pCT_INIT conn = NULL;
		RTG_VOID_PTR confinst = NULL;
		RTG_CHAR_PTR instattr[3] = { srv, usr, pwd };
		RTG_CHAR_PTR fileattr[2] = { (RTG_CHAR_PTR)"*", (RTG_CHAR_PTR)"*" };

		if (!hasPing)
		{
			rc = MIGRA_BADLIB;
			goto exit;
		}

		if ((conf = fpConfig(NULL, 4, NULL, NULL, 0, NULL)) == NULL ||
			(confinst = fpConfig(NULL, 5, conf, NULL, 3, instattr)) == NULL ||
			fpConfig(NULL, 7, conf, confinst, 2, fileattr) == NULL)
		{
			rc = MIGRA_CONFIG;
			goto exit;
		}

		if ((conn = fpInit(NULL, NULL, conf, 0, NULL, NULL)) == NULL)
		{
			rc = MIGRA_NOMEM;
			goto exit;
		}

		if (!fpConnect(conn, 0))
		{
			const RTG_SINT ARQS_ERR = 127;
			const RTG_SINT ARSP_ERR = 128;
			const RTG_SINT ASKY_ERR = 133;
			const RTG_SINT SHUT_ERR = 150;
			const RTG_SINT LUID_ERR = 450;
			const RTG_SINT LPWD_ERR = 451;
			const RTG_SINT LGST_ERR = 470;
			const RTG_SINT LMTC_ERR = 530;
			const RTG_SINT LDPA_ERR = 787;

			const RTG_SINT CTE_PARAM_ERR = 2;

			if (conn->err.logical == CTE_PARAM_ERR)
				rc = MIGRA_CONFIG;
			else
			switch (conn->err.ctree)
			{
			case ARQS_ERR:
			case ARSP_ERR:
			case ASKY_ERR:
			case SHUT_ERR:
				rc = MIGRA_NOSRV;
				break;
			case LUID_ERR:
			case LGST_ERR:
			case LDPA_ERR:
				rc = MIGRA_NOUSR;
				break;
			case LPWD_ERR:
				rc = MIGRA_BADPWD;
				break;
			case LMTC_ERR:
				rc = MIGRA_NORTGSRV;
				break;
			default:
				rc = MIGRA_NOSUPP;
				break;
			}
		}

exit:
		if (conn)
			fpExit(conn, NULL, NULL);
		if (conf)
			fpConfig(NULL, 8, conf, NULL, 0, NULL);

		return rc;
	};
protected:
	virtual void* LoadLib(void)
	{
		hLib = ctLoadLib(szLib);
		if (hLib != NULL)
		{
			isLoaded = isFound = true;

			fpConfig = (ctl_config_fn)ctGetFunc(hLib, "ctl_config", fpConfig);
			fpInit = (ctl_init_fn)ctGetFunc(hLib, "ctl_init", fpInit);
			fpExit = (ctl_exit_fn)ctGetFunc(hLib, "ctl_exit", fpExit);
			fpConnect = (ctl_connect_fn)ctGetFunc(hLib, "ctl_connect", fpConnect);
			if (fpConnect != NULL && fpInit != NULL && fpExit != NULL && fpConnect != NULL)
			{
				hasPing = true;
			}
		}
		else
		if (!ctMissingLib(szLib))
		{
			isFound = true;
		}
		return hLib;
	};
public:
	bool isFound;
	bool isLoaded;
	bool hasInterface;
	bool hasPing;
protected:
	void *hLib;
	void (*hFunc)(void);
	const char *szLib;
	const char *szFunc;
private:
	ctl_config_fn fpConfig;
	ctl_init_fn fpInit;
	ctl_exit_fn fpExit;
	ctl_connect_fn fpConnect;
private:
};

#endif /* ~_RTG_H_ */
