#ifndef _RTGBTRV_H_
#define _RTGBTRV_H_

#include "Rtg.h"

#ifdef _WIN32
#include <windows.h>
#endif

#define BTI_FAR
#define BTI_PASCAL
/* Platform-Independent Data Types */
typedef long                  BTI_LONG;
typedef unsigned long         BTI_ULONG;
typedef short int             BTI_SINT;
typedef unsigned short        BTI_WORD;
typedef int                   BTI_INT;
typedef char                  BTI_CHAR;
typedef unsigned char         BTI_BYTE;
typedef void                  BTI_VOID;
typedef BTI_CHAR     BTI_FAR* BTI_CHAR_PTR;
typedef BTI_BYTE     BTI_FAR* BTI_BUFFER_PTR;
typedef BTI_INT      BTI_FAR* BTI_INT_PTR;
typedef BTI_WORD     BTI_FAR* BTI_WORD_PTR;
typedef BTI_LONG     BTI_FAR* BTI_LONG_PTR;
typedef BTI_VOID     BTI_FAR* BTI_VOID_PTR;

#ifdef _WIN32
#define BTI_API extern BTI_SINT BTI_FAR WINAPI
typedef BTI_SINT (WINAPI* BTRV_fn)(
#else
#define BTI_API extern BTI_SINT BTI_FAR BTI_PASCAL
typedef BTI_SINT (* BTRV_fn)(
#endif
	BTI_WORD     operation,
	BTI_VOID_PTR posBlock,
	BTI_VOID_PTR dataBuffer,
	BTI_WORD_PTR dataLength,
	BTI_VOID_PTR keyBuffer,
	BTI_SINT     keyNumber
);

/* file flags */
#define VAR_RECS             0x0001

#define B_OPEN               0
#define B_CLOSE              1
#define B_INSERT             2
#define B_UPDATE             3
#define B_GET_EQUAL          5
#define B_GET_NEXT           6
#define B_GET_FIRST         12
#define B_CREATE            14
#define B_STAT              15
#define B_BEGIN_TRAN        19
#define B_END_TRAN          20
#define B_ABORT_TRAN        21
#define B_STEP_NEXT         24
#define B_STOP              25
#define B_STEP_FIRST        33

#define B_NO_ERROR                          0
#define B_INVALID_FUNCTION                  1
#define B_END_OF_FILE                       9
#define B_FILE_NOT_FOUND                    12
#define B_UNRECOVERABLE_ERROR               19
#define B_INVALID_INTERFACE                 53
#define B_SERVER_ERROR                      91
#define B_NO_OS_MEMORY_AVAIL                101
#define B_INVALID_USERNAME                  141
#define B_NO_DATABASE_SERVICES              145
#define B_MK_INVALID_CONFIG                3008

///////////////////////////////////////////////////////////////////////////////

class RtgBtrv : public Rtg
{
public:
	RtgBtrv(void)
	{
#ifdef _WIN32
		szLib = "mtclient.dll";
#else
		szLib = "libmtclient.so";
#endif
#if defined(_WIN32) && !defined(_WIN64) // Windows x64 does not support stdcall
		szFunc = "_BTRV@24";
#else
		szFunc = "BTRV";
#endif
		Load();
	};
	~RtgBtrv(void)
	{
		szLib = NULL;
		szFunc = NULL;

		if (hFunc != NULL)
		{
			((BTRV_fn)hFunc)(B_STOP,
				NULL,
				NULL,
				NULL,
				NULL,
				0);
		}
	};
	BTRV_fn GetIntf(void)
	{
		return (BTRV_fn)hFunc;
	};
private:
	void (*Load(void))(void)
	{
		if (LoadLib())
		{
			hFunc = (void(*)(void))ctGetFunc(hLib, szFunc, hFunc);
			if (hFunc != NULL)
			{
				hasInterface = true;
			}
		}
		return hFunc;
	}
};

#endif /* ~_RTGBTRV_H_ */
