#ifndef _RTGEXTFH_H_
#define _RTGEXTFH_H_

#include "Rtg.h"

typedef RTG_SINT           EXTFH_SINT;
typedef RTG_WORD           EXTFH_WORD;
typedef RTG_INT            EXTFH_INT;
typedef RTG_UINT           EXTFH_UINT;
typedef RTG_CHAR           EXTFH_CHAR;
typedef RTG_BYTE           EXTFH_BYTE;
typedef RTG_VOID           EXTFH_VOID;
typedef RTG_WORD_PTR       EXTFH_WORD_PTR;
typedef RTG_INT_PTR        EXTFH_INT_PTR;
typedef RTG_BUFFER_PTR     EXTFH_BUFFER_PTR;
typedef RTG_CHAR_PTR       EXTFH_CHAR_PTR;
typedef RTG_VOID_PTR       EXTFH_VOID_PTR;

typedef RTG_CHAR_PTR       EXTFH_STATUS;
typedef RTG_WORD           EXTFH_OPCODE;

#define EXTFH_OPENMODE_INPUT               0xFA00
#define EXTFH_OPENMODE_OUTPUT              0xFA01
#define EXTFH_OPENMODE_EXTEND              0xFA03
#define EXTFH_CLOSEMODE_CLOSE              0xFA80
#define EXTFH_STARTMODE_NOT_LESS           0xFAEB
#define EXTFH_WRITEMODE_WRITE              0xFAF3
#define EXTFH_READMODE_SEQ                 0xFAF5
#define EXTFH_FILEINFO                     0x0006

#define E_85_SUCCESS              (EXTFH_STATUS)"00"
#define E_85_IO_ENDFILE           (EXTFH_STATUS)"10"
#define E_85_IO_NOREC             (EXTFH_STATUS)"23"
#define E_85_IO_SYSTEM            (EXTFH_STATUS)"30"
#define E_85_IO_MISSINGFILE       (EXTFH_STATUS)"35"
#define E_85_IO_FILENOTFOUND      (EXTFH_STATUS)"9\x0d" /* RT013 */
#define E_85_IO_NOTSUPP           (EXTFH_STATUS)"9\x45" /* RT069 */ /* Illegal argument to isam module*/
#define E_85_IO_NO_MEMORY         (EXTFH_STATUS)"9\x69" /* RT105 */ /* Memory allocation error. */

typedef int (* EXTFH_fn) (unsigned char *op, unsigned char *fcd);

class RtgExtfh : public Rtg
{
public:
	RtgExtfh(void)
	{
#ifdef _WIN32
		szLib = "CTEXTFH.dll";
		szFunc = "CTEXTFH";
#else
		szLib = "CTEXTFH.so";
		szFunc = "CTEXTFH";
#endif
		Load();
	};
	~RtgExtfh(void)
	{
		szLib = NULL;
		szFunc = NULL;
	};
	EXTFH_fn GetIntf(void)
	{
		return (EXTFH_fn)hFunc;
	};
private:
	void (*Load(void))(void)
	{
		if (LoadLib())
		{
			hFunc = (void(*)(void))ctGetFunc(hLib, szFunc, hFunc);
			if (hFunc != NULL)
			{
				hasInterface = true;
			}
		}
		return hFunc;
	}
};

#endif /* ~_RTGEXTFH_H_ */
