/*
 *      OFFICIAL NOTIFICATION: the following CONFIDENTIAL and PROPRIETARY 
 * 	property legend shall not be removed from this source code module 
 * 	for any reason.
 *
 *	This program is the CONFIDENTIAL and PROPRIETARY property 
 *	of FairCom(R) Corporation. Any unauthorized use, reproduction or
 *	transfer of this computer program is strictly prohibited. The 
 *      contents of this file may not be disclosed to third parties, copied or
 *      duplicated in any form, in whole or in part, without the prior written
 *      permission of the FairCom(R) Corporation.
 *
 *      Copyright (c) 1992 - 2023 FairCom Corporation.
 *	This is an unpublished work, and is subject to limited distribution and
 *	restricted disclosure only. ALL RIGHTS RESERVED.
 *
 *			RESTRICTED RIGHTS LEGEND
 *	Use, duplication, or disclosure by the Government is subject to
 *	restrictions set forth in subparagraph (c)(1)(ii) of the Rights in
 * 	Technical Data and Computer Software clause at DFARS 252.227-7013, and/or
 *      in similar or successor clauses in the FAR, DOD or NASA FAR Supplement.
 *      Unpublished rights reserved under the Copyright Laws of the United States.
 *	FairCom Corporation, 6300 West Sugar Creek Drive, Columbia, MO 65203.
 *
 *	c-treeACE(tm)	Version 12
 */

#ifndef _CTCBAPI_H_
#define _CTCBAPI_H_

#include "ctcboptn.h"
#include "ctdbport.h"
#include "ctcbtype.h"
#include "ctcbthrd.h"

/* configuration types */
typedef enum CONFTYPE {
	CONF_NONE = 0,
	CONF_OLD = 1,
	CONF_NEW = 2
} CONFTYPE;
/* file extensions */
typedef enum FILEXTYPE {
	CT_DAT = 0,
	CT_IDX = 1
} FILEXTYPE;
/* transaction operations */
typedef enum TRANOP {
	CT_COMMIT = 1,
	CT_ROLLBACK = 2
} TRANOP;
/* path comparison */
typedef enum PATHCMP {
	EXACT = 0,
	PARTOF = 1
} PATHCMP;
/* image operations */
typedef enum IMAGEOP {
	CTMAKE_INVALID = 0,
	CTMAKE_FILE2IMG = 1,
	CTMAKE_IMG2MAKE = 2,
	CTMAKE_MAKE2IMG = 3,
	CTMAKE_IMG2RBL = 4,
	CTMAKE_IMGCHECK = 5,
	CTMAKE_IMGADDIDX = 6,
	CTMAKE_IMGIDX2MAKE = 7
} IMAGEOP;
/* copy modes */
typedef enum COPYMODE {
	CTCOPY_COPY_REPLACE = 0,
	CTCOPY_CLONE_REPLACE,
	CTCOPY_FILECOPY,
	CTCOPY_FILECOPY_REPLACE,
	CTCOPY_UPGRADE,
	CTCOPY_COPY,
	CTCOPY_CLONE
} COPYMODE;
/* key segment mismatches */
typedef enum KEYMISMATCH {
	KEYMISMATCH_KEYSEG = -1,
	KEYMISMATCH_KEYTYP = -2,
	KEYMISMATCH_SEGOFF = 1,
	KEYMISMATCH_SEGLEN = 2,
	KEYMISMATCH_SEGTYP = 3,
	KEYMISMATCH_SEGMOD = 4
} KEYMISMATCH;

typedef struct {
	UCOUNT idx;
	UCOUNT off;
	UCOUNT len;
} AUTOINC;

typedef struct {
	TEXT	name[CT_PATH_LEN];
	TEXT	rname[CT_PATH_LEN];
#ifdef ctFeatRTG_MAXFILE32
	FILNO	filno;
#else
	COUNT	filno;
#endif
	LONG	drvfilemode;
	LONG	current_offset;  /* current record pointer */
	LONG	current_offseth; /* current record pointer (highword) */
	COUNT	context;
	COUNT	io_context;
	COUNT	act_context;
	COUNT	curr_index;
	COUNT	instance;
#ifdef ctFeatRTG_FAILOVER
	ULONG	reconnected;
#endif
	LONG	got_filtyp;
	LONG	got_physiz;
	LONG	got_iphysiz;
	LONG	got_physizh;
	LONG	got_iphysizh;
	LONG	got_filmod;
	LONG	got_flmode2;
	LONG	got_flmode3;
	LONG	got_cmptype;
	LONG	got_ifilmod;
	LONG	got_numrecords;
	LONG	got_delrecords;
	ULONG	got_segsiz;
	LONG	got_segmax;
	TEXT	got_segmented;
	TEXT	got_encrypted;
#ifdef ctFeatRTG_MAXSIZE
	LONG	got_mxfilz;
	LONG	got_mxfilzh;
#endif
	TEXT	is_huge;
	TEXT	signconv;
	ULONG	xmllen;
	VRLEN	minlen;
	VRLEN	maxlen;
	COUNT	nkeys;
	COUNT	maxkeysize;
	pTEXT	filter;
	pTEXT	filter_mask;
	VRLEN	filter_size;
	pTEXT	fetptr;          /* prefetch buffer pointer */
	VRLEN	fetsiz;          /* prefetch buffer size */
	pTEXT	fetpos;          /* current record position in prefetch buffer */
	ULONG	fetret;          /* number of records to process in prefetch buffer */
	COUNT	fetcnx;          /* context in which prefetch was executed */
#ifdef ctFeatRTG_PREFETCHTTL
	LONG8	fetttl;          /* prefetch time to live */
	LONG8	fettime;         /* time of prefetch */
#endif
	pTEXT	batptr;          /* batchadd buffer pointer */
	VRLEN	batsiz;          /* batchadd buffer size */
	VRLEN	batlen;          /* batchadd buffer length */
	ULONG	batrdy;          /* number of records to process in batchadd buffer */
	ULONG	batadd;          /* number of records successfully added */
#ifdef ctFeatRTG_CCC
	LONG	cccstatus;
	CBPTR	ccchandle;       /* store FILE* in a LONG8 to avoid problems in 32/64 bit environments */
	LONG8	cccargv[16];     /* store char* in a LONG8 to avoid problems in 32/64 bit environments */
	LONG	cccargc;
#endif
	LONG	blockfact;
	LONG	prealloc;
	LONG	extension;
	TEXT	compress;
	TEXT	comment[CT_COMMENT_LEN];
	TEXT	trans[256];
	TEXT	fileformat;
	UTEXT	rechdr;
#ifdef ctFeatRTG_SRLSEGSIZ
	TEXT	srlsegsiz; 
#endif
	NINT	openthrd;
	pCONFFILE	conf;
	CT_INSTANCE	*ctinst;
	AUTOINC	autoinc;
	ULONG	last_recnum;     /* record number of last record accessed either read or write */
	LONG	last_offset;     /* record offset of last record accessed either read or write for EXTFH */
	LONG	last_offseth;    /* record offset of last record accessed either read or write for EXTFH (highword) */
	LONG	last_retrvd;     /* record offset of last record read */
	LONG	last_retrvdh;    /* record offset of last record read (highword) */
	LONG	env;
	LONG	io_env;
	LONG	env2;
	LONG	trnum;
	LONG	trnumh;
	pTEXT	recptr;
#ifdef ctFeatRTG_DELCURRENT
	TEXT	delcurrent;
	TEXT	delcurrent_found;
	TEXT	delcurrent_key[CT_MAX_KEY_SIZE];
	ULONG8	delcurrent_trnid;
#endif
#ifdef ctFeatRTG_FILEPOOL
#ifdef ctFeatRTG_KEYS
	CT_OPEN3	ct_open;
#else /* ~ctFeatRTG_KEYS */
	CT_OPEN2	ct_open;
#endif /* ~ctFeatRTG_KEYS */
	TEXT	filepool_reopen;
#endif /* ctFeatRTG_FILEPOOL */
#ifdef ctFeatRTG_START_ON_READ
	TEXT	startread;
	COUNT	startread_keyno;
	COUNT	startread_keylen;
	COUNT	startread_keysiz;
	LONG	startread_keytype;
	TEXT	startread_key[MAXLEN];
#endif
#ifdef ctFeatRTG_CTBTRV_FILES
	TEXT ctbtrv;
#endif
	VRLEN	var_len;
	/*
	**	var[] must be large enough to have
	**
	ifdef ctFeatRTG_KEYS
	**	RTGKEY[nkeys];
	**	RTGSEG[nsegs];
	else
	**	CT_KEY[nkeys];		this is static !!!
	endif
	**	CT_COMM_INPUT
	**	key[maxkeysize];
	**	CT_COMM_OUTPUT
	**	vkey[maxkeysize];
	**	rec[maxlen+rechdr];
	**
	*/
	TEXT	var[MEMU];
} CT_FILE, *pCT_FILE, **ppCT_FILE;

#define ACU_VISION      1
#define ACU_CTREE       2

#ifdef _WIN32
#define CT_OSDIR '\\'
#else
#define CT_OSDIR '/'
#endif
#define CT_DIRSEPW '\\'
#define CT_DIRSEPU '/'

#define INIT_BUFS  ((COUNT)1280) /* 10 MB */
#define INIT_NFILS ((COUNT)32)
#define INIT_SECT  ((COUNT)64) /* 8 KB */

#define INS_DECLARED        0x0001
#define INS_ACTIVE          0x0002
#define INS_CLOSED          0x0004
#define INS_READ_ONLY       0x0008
#define INS_CLASH           0x0010
#define INS_CORRUPT         0x0020
#define INS_CLIENT          0x0040
#define INS_LOCAL           0x0080
#define INS_REDIR           0x0100
#define INSTANCE_DECLARED(c,i) (c->instance[i].status & INS_DECLARED)
#define INSTANCE_ACTIVE(c,i) (c->instance[i].status & INS_ACTIVE)
#define INSTANCE_CLOSED(c,i) (c->instance[i].status & INS_CLOSED)
#define INSTANCE_READ_ONLY(c,i) (c->instance[i].status & INS_READ_ONLY)
#define INSTANCE_CLASH(c,i) (c->instance[i].status & INS_CLASH)
#define INSTANCE_CORRUPT(c,i) (c->instance[i].status & INS_CORRUPT)
#define INSTANCE_CLIENT(c,i) (c->instance[i].status & INS_CLIENT)
#define INSTANCE_LOCAL(c,i) (c->instance[i].status & INS_LOCAL)
#define INSTANCE_REDIR(c,i) (c->instance[i].status & INS_REDIR)

#define CT_LOCK_WAIT         0x0001
#define CT_FAST_DELETE       0x0002
#define CT_READ_LOCK_TEST    0x0004
#define CT_RETURN_LOCKED_REC 0x0008
#define CT_INTERNAL_LOCKS    0x0010
#define CT_EXTRA_KEYS_OK     0x0020

#ifdef ctFeatRTG_FAILOVER
#define DISCONNECTED_ERR(err) (err == ARQS_ERR || err == ARSP_ERR || err == NINT_ERR || err == SHUT_ERR || \
							err == TUSR_ERR || err == TRQS_ERR || err == TRSP_ERR || err == QTBK_PND)
#define RECONNECT_ENABLED(conn, inst) (conn->instance[inst].reconnect)
#define DISCONNECTED_FILE(conn, ct) (INSTANCE_CLOSED(conn, ct->instance) || \
							conn->instance[ct->instance].reconnected != ct->reconnected)
#endif

/*
**	client side
*/
cbDLLexport CONFTYPE ctl_initcnf(pRTGENV env, pTEXT cnf, ppRTGCONF cnfptr, pTEXT cnf_file_ptr, NINT cnf_file_len, CT_ERROR *_err, pTEXT _errmsg, pNINT instredir);
cbDLLexport CT_INIT *ctl_init(pRTGENV env, pTEXT cnf_file, pRTGCONF conf, CT_ERROR *_err, pTEXT _errmsg, pTEXT nodename);
cbDLLexport VOID ctl_exitcnf(pRTGCONF conf);
#ifdef ctFeatRTG_BTRV_LOGIN
cbDLLexport COUNT ctl_exitinst(CT_INIT *conn, COUNT ii);
#endif
cbDLLexport VOID ctl_exit(CT_INIT *conn, ppRTGCONF conf);
NINT ctl_rpc(pCONFFILE file);

#ifdef ctFeatRTG_KEYS
cbDLLexport NINT ctl_make(pCT_INIT conn, pCT_OPEN3 make, pRTGKEY keys);
cbDLLexport pCT_FILE ctl_open(pCT_INIT conn, pCT_OPEN3 op, pRTGKEY keys);
pCT_FILE ctl_open2(pCT_INIT conn, pCT_OPEN3 op, pRTGKEY keys, pTEXT name, COUNT inst, pCONFFILE file);
NINT ctl_addidx(pCT_INIT conn, pCT_FILE ct, pRTGKEY key, UCOUNT nkeys, pTEXT trans);
cbDLLexport NINT ctl_sqlize(pCT_INIT conn, pCT_OPEN3 op, pTEXT name, COUNT inst, pCONFFILE file, TEXT refresh);
#else /* ~ctFeatRTG_KEYS */
cbDLLexport NINT ctl_make(pCT_INIT conn, pCT_OPEN2 make, pCT_KEY2 keys);
cbDLLexport pCT_FILE ctl_open(pCT_INIT conn, pCT_OPEN2 op, pCT_KEY2 keys);
pCT_FILE ctl_open2(pCT_INIT conn, pCT_OPEN2 op, pCT_KEY2 keys, pTEXT name, COUNT inst, pCONFFILE file);
NINT ctl_addidx(pCT_INIT conn, pCT_FILE ct, pCT_KEY2 key, UCOUNT nkeys, pTEXT trans);
cbDLLexport NINT ctl_sqlize(CT_INIT *conn, pCT_OPEN2 op, pTEXT name, COUNT inst, pCONFFILE file, TEXT refresh);
#endif /* ~ctFeatRTG_KEYS */
cbDLLexport NINT ctl_close(CT_INIT *, CT_FILE *);
NINT ctl_close2(CT_INIT *conn, CT_FILE *ct, TEXT callsrv);
NINT ctl_info(CT_INIT *, CT_FILE *);
cbDLLexport NINT ctl_sqlinfo(CT_INIT *conn, CT_FILE *ct, pTEXT xml, TEXT sign, pTEXT rules);
cbDLLexport NINT ctl_sqllink(CT_INIT *conn, pTEXT name, pTEXT dbname, pTEXT adminpw, TEXT unlink, pTEXT symname, pTEXT tblowner, TEXT grantpub, pTEXT prefix, TEXT logerror, TEXT refresh, TEXT skipmissing);
cbDLLexport NINT ctl_write(CT_INIT *conn, CT_FILE *ct, pTEXT rec, VRLEN len, LONG mode);
NINT ctl_write2(CT_INIT *conn, CT_FILE *ct, pTEXT buffer, VRLEN buflen, LONG addmode);
cbDLLexport COUNT ctl_buildkey(CT_INIT *conn, CT_FILE *, pTEXT rec, COUNT keyno, pTEXT key, COUNT maxkeysize);
cbDLLexport NINT ctl_read(CT_INIT *, CT_FILE *, LONG mode, LONG mode2, COUNT keyno, pTEXT rec, ULONG len, pTEXT key);
cbDLLexport NINT ctl_start(CT_INIT *, CT_FILE *, LONG mode, LONG mode2, STARTOP op, COUNT keyno, pTEXT rec, pTEXT key, COUNT keysize);
cbDLLexport NINT ctl_nextprev(CT_INIT *, CT_FILE *, LONG mode, LONG mode2, SEQOP op, pTEXT rec, ULONG len);
cbDLLexport NINT ctl_rewdel(CT_INIT *, CT_FILE *, LONG keymode, pTEXT rec, VRLEN len);
NINT ctl_startinsttransaction(CT_INIT *conn, COUNT ii);
cbDLLexport NINT ctl_starttransaction(CT_INIT *conn, TEXT excl);
NINT ctl_endinsttransaction(CT_INIT *conn, TRANOP mode, COUNT ii, TEXT xplict, TEXT keeplocks);
cbDLLexport NINT ctl_endtransaction(CT_INIT *conn, TRANOP mode, TEXT keeplocks);
NINT ctl_execute(CT_INIT *conn, pTEXT cmd);
cbDLLexport NINT ctl_execos(CT_INIT *conn, NINT argc, ppTEXT argv, FILE* fp);

NINT ctl_getinstance(CT_INIT *conn, pRTGCONF conf, COUNT instance);
cbDLLexport NINT ctl_setinstance(CT_INIT *conn, COUNT instance);
NINT ctl_reginstance(CT_INIT *conn, COUNT instance);
TEXT ctl_getdirsep(pTEXT name, size_t len);
#ifdef ctFeatRTG_MIXED_DIRSEP
cbDLLexport pTEXT ctl_filename(pTEXT path);
VOID ctl_dirname(pTEXT path, pTEXT dir, VRLEN dirlen);
#define ctl_basename(p) ctl_filename(p)
#else
pTEXT ctl_getdirname(pTEXT name, pTEXT bufptr, VRLEN buflen, TEXT dirsep);
cbDLLexport pTEXT ctl_basename(pTEXT name);
#endif
pTEXT ctl_replsep(pTEXT path, TEXT sep);
cbDLLexport NINT ctl_normalize(pRTGCONF conf, pTEXT filepath, pTEXT outpath);
cbDLLexport pCONFFILE ctl_conffile(pRTGCONF conf, pTEXT name);
cbDLLexport pCONFFILE ctl_conffile2(pRTGCONF conf, pTEXT name, TEXT normalize);
cbDLLexport pCONFFILE ctl_conffile3(pRTGCONF conf, pTEXT name, TEXT filetype, TEXT normalize);
cbDLLexport pCONFINST ctl_confinst(pRTGCONF conf, COUNT inst);
cbDLLexport COUNT ctl_getfileinst(CT_INIT *conn, ppTEXT name);
cbDLLexport COUNT ctl_getfileinst2(CT_INIT *conn, ppTEXT name, ppCONFFILE file);
NINT ctl_expandname(CT_INIT *conn, pTEXT format, pTEXT dest, NINT destlen, pTEXT filepath);
NINT ctl_mapfile(CT_INIT *conn, pCONFFILE file, pTEXT oname);
COUNT ctl_getfileinst_no(CT_INIT *conn, ppTEXT name, ppCONFFILE file);

cbDLLexport NINT ctl_check(CT_INIT *conn, pTEXT name, COUNT chkkey, TEXT full, pVFYMSGCBFNC fnMessage, pVFYPRGCBFNC fnProgress, pVFYERRCBFNC fnError);
NINT ctl_remove(CT_INIT *conn, pTEXT name);
NINT ctl_rename(CT_INIT *conn, cpTEXT namefrom, cpTEXT nameto, TEXT overwrite);
NINT ctl_copy(CT_INIT *conn, cpTEXT namefrom, cpTEXT nameto, COPYMODE mode);
NINT ctl_unlock(CT_INIT *conn, CT_FILE *file);
NINT ctl_unlockrec(CT_INIT *conn, CT_FILE *file, LONG offset, LONG offset_h);

cbDLLexport pVOID ctl_config(pRTGENV env, CT_INIT *conn, NINT op, pRTGCONF conf, pVOID item, NINT argc, cpTEXT *argv);
#ifdef NOT_YET
NINT ctl_confsetinstattr(pRTGCONF conf, pCONFINST institem, cpTEXT option, cpTEXT value);
#endif
#ifdef ctFeatRTG_CONFINST_ATTR_ARRAY
pCONFINST ctl_confaddinst(CT_INIT *conn, INTFTYPE intf, pRTGCONF conf, INSTTYPE instype, cpTEXT attr[], UINT nattr);
#else /* ~ctFeatRTG_CONFINST_ATTR_ARRAY */
#ifdef ctFeatRTG_CTSHMEMDIR
pCONFINST ctl_confaddinst(CT_INIT *conn, INTFTYPE intf, pRTGCONF conf, INSTTYPE instype, cpTEXT attr1, cpTEXT attr2, cpTEXT attr3, cpTEXT attr4, cpTEXT attr5, cpTEXT attr6, cpTEXT attr7, cpTEXT attr8, cpTEXT attr9, cpTEXT attr10, cpTEXT attr11);
#else
#ifdef ctFeatRTG_SSL
pCONFINST ctl_confaddinst(CT_INIT *conn, INTFTYPE intf, pRTGCONF conf, INSTTYPE instype, cpTEXT attr1, cpTEXT attr2, cpTEXT attr3, cpTEXT attr4, cpTEXT attr5, cpTEXT attr6, cpTEXT attr7, cpTEXT attr8, cpTEXT attr9, cpTEXT attr10);
#else
#ifdef ctFeatRTG_ENDIANCHECK
pCONFINST ctl_confaddinst(CT_INIT *conn, INTFTYPE intf, pRTGCONF conf, INSTTYPE instype, cpTEXT attr1, cpTEXT attr2, cpTEXT attr3, cpTEXT attr4, cpTEXT attr5, cpTEXT attr6, cpTEXT attr7, cpTEXT attr8);
#else
pCONFINST ctl_confaddinst(CT_INIT *conn, INTFTYPE intf, pRTGCONF conf, INSTTYPE instype, cpTEXT attr1, cpTEXT attr2, cpTEXT attr3, cpTEXT attr4, cpTEXT attr5, cpTEXT attr6, cpTEXT attr7);
#endif
#endif
#endif
pCONFINST ctl_confaddinst2(CT_INIT *conn, INTFTYPE intf, pRTGCONF conf, INSTTYPE instype, cpTEXT attr[]);
#endif /* ~ctFeatRTG_CONFINST_ATTR_ARRAY */
NINT ctl_confdelinst(pRTGCONF conf, pCONFINST item);
pCONFFILE ctl_confaddfile(CT_INIT *conn, INTFTYPE intf, pRTGCONF conf, pCONFINST institem, cpTEXT name, cpTEXT dir, cpTEXT priority, cpTEXT casesensitive, cpTEXT filetype);
pCONFFILE ctl_confaddfile2(CT_INIT *conn, INTFTYPE intf, pRTGCONF conf, pCONFINST institem, TEXT sort, cpTEXT name, cpTEXT dir, cpTEXT priority, cpTEXT casesensitive, cpTEXT filetype);
NINT ctl_confdelfile(pRTGCONF conf, pCONFFILE item);
NINT ctl_confsetinstopt(pRTGCONF conf, pCONFINST institem, cpTEXT option, cpTEXT value);
NINT ctl_confsetfileopt(pRTGCONF conf, pCONFFILE fileitem, cpTEXT option, cpTEXT value);

cbDLLexport NINT ctl_connect(CT_INIT *conn, COUNT instance);
cbDLLexport ULONG ctl_logons(CT_INIT *conn);

#ifdef ctThrds
cbDLLexport NINT ctl_initthrd();
cbDLLexport NINT ctl_termthrd();
NINT ctl_getthrdhandle();
NINT ctl_attachthrd();
NINT ctl_detachthrd();
#endif /* ctThrds */
NINT ctl_inimtx(MUTEX *mtx, CT_ERROR *err);
NINT ctl_getmtx(MUTEX *mtx, CT_ERROR *err);
NINT ctl_relmtx(MUTEX *mtx, CT_ERROR *err);
NINT ctl_clsmtx(MUTEX *mtx, CT_ERROR *err);

#ifdef ctFeatRTG_FILEPOOL
CT_FILEPOOL *ctl_initFP(CT_INIT *conn, UCOUNT size);
#ifdef ctFeatRTG_KEYS
pVOID ctl_findFP(pCT_INIT conn, pCONFFILE conffile, CT_FILEPOOL* Handle, pCT_OPEN3 ctopen, pTEXT name);
#else /* ~ctFeatRTG_KEYS */
pVOID ctl_findFP(pCT_INIT conn, pCONFFILE conffile, CT_FILEPOOL *Handle, pCT_OPEN2 ctopen, pTEXT name);
#endif /* ~ctFeatRTG_KEYS */
COUNT ctl_addFP(CT_INIT *conn, CT_FILEPOOL *Handle, pCONFFILE conf, pVOID ctfile);
VOID ctl_delFP(CT_INIT *conn, pCONFFILE conffile, CT_FILEPOOL *Handle, pTEXT name);
VOID ctl_closeFP(CT_INIT *conn, pCT_FILE ct);
VOID ctl_exitFP(CT_INIT *conn, CT_FILEPOOL *Handle);
#endif /* ctFeatRTG_FILEPOOL */

cbDLLexport NINT ctl_forcelocal(CT_INIT *);

#ifdef ctFeatRTG_API_ENTRYPOINT
typedef enum {
	rtgMAKE,
	rtgOPEN,
	rtgCLOSE,
	rtgSTART,
	rtgREAD,
	rtgNEXTPREV,
	rtgWRITE,
	rtgREWDEL,
	rtgSTARTTRANSACTION,
	rtgENDTRANSACTION,
	rtgREMOVE,
	rtgRENAME,
	rtgCOPY,
	rtgUNLOCK,
	rtgUNLOCKREC,
	rtgADDIDX,
	rtgSQLINFO,
	rtgSQLLINK,
} RTGOP;

typedef union {
	pVOID p;
	LONG l;
	COUNT c;
	TEXT b;
} RTGPARM;

cbDLLexport NINT rtgCALL(RTGOP opcode, CT_INIT *conn, pCT_FILE ctfile, RTGPARM parm[]);

#ifdef ctFeatRTG_KEYS
cbDLLexport NINT rtg_make(CT_INIT *conn, pCT_OPEN3 op, pRTGKEY key);
cbDLLexport pCT_FILE rtg_open(CT_INIT* conn, pCT_OPEN3 op, pRTGKEY key);
NINT rtg_addidx(CT_INIT* conn, CT_FILE* ct, pRTGKEY key, UCOUNT nkeys, pTEXT trans);
#else /* ~ctFeatRTG_KEYS */
cbDLLexport NINT rtg_make(CT_INIT *conn, pCT_OPEN2 op, pCT_KEY2 key);
cbDLLexport pCT_FILE rtg_open(CT_INIT *conn, pCT_OPEN2 op, pCT_KEY2 key);
NINT rtg_addidx(CT_INIT *conn, CT_FILE *ct, pCT_KEY2 key, UCOUNT nkeys, pTEXT trans);
#endif /* ~ctFeatRTG_KEYS */
cbDLLexport NINT rtg_close(CT_INIT *conn, CT_FILE *ct);
cbDLLexport NINT rtg_start(CT_INIT *conn, CT_FILE *ct, LONG mode, LONG mode2, STARTOP op, COUNT keyno, pTEXT rec, pTEXT key, COUNT keysize);
cbDLLexport NINT rtg_read(CT_INIT *conn, CT_FILE *ct, LONG mode, LONG mode2, COUNT keyno, pTEXT rec, ULONG len, pTEXT key);
cbDLLexport NINT rtg_nextprev(CT_INIT *conn, CT_FILE *ct, LONG mode, LONG mode2, SEQOP op, pTEXT rec, ULONG len);
cbDLLexport NINT rtg_write(CT_INIT *conn, CT_FILE *ct, pTEXT rec, VRLEN len, LONG mode);
cbDLLexport NINT rtg_rewdel(CT_INIT *conn, CT_FILE *ct, LONG keymode, pTEXT rec, VRLEN len);
cbDLLexport NINT rtg_starttransaction(CT_INIT *conn, TEXT excl);
cbDLLexport NINT rtg_endtransaction(CT_INIT *conn, TRANOP op, TEXT keeplocks);
NINT rtg_remove(CT_INIT *conn, pTEXT name);
NINT rtg_rename(CT_INIT *conn, pTEXT namefrom, pTEXT nameto, TEXT overwrite);
NINT rtg_copy(CT_INIT *conn, pTEXT namefrom, pTEXT nameto, COPYMODE mode);
NINT rtg_unlock(CT_INIT *conn, CT_FILE *file);
NINT rtg_unlockrec(CT_INIT *conn, CT_FILE *file, LONG offset, LONG offset_h);
cbDLLexport NINT rtg_sqlinfo(CT_INIT *conn, CT_FILE *ct, pTEXT xml, TEXT sign, pTEXT rules);
cbDLLexport NINT rtg_sqllink(CT_INIT *conn, pTEXT name, pTEXT dbname, pTEXT adminpw, TEXT unlink, pTEXT symname, pTEXT tblowner, TEXT grantpub, pTEXT prefix, TEXT logerror, TEXT refresh, TEXT skipmissing);

#ifdef USE_API_ENTRYPOINT 
#define ctl_make rtg_make
#define ctl_open rtg_open
#define ctl_close rtg_close
#define ctl_start rtg_start
#define ctl_read rtg_read
#define ctl_nextprev rtg_nextprev
#define ctl_write rtg_write
#define ctl_rewdel rtg_rewdel
#define ctl_starttransaction rtg_starttransaction
#define ctl_endtransaction rtg_endtransaction
#define ctl_remove rtg_remove
#define ctl_rename rtg_rename
#define ctl_copy rtg_copy
#define ctl_unlock rtg_unlock
#define ctl_unlockrec rtg_unlockrec
#define ctl_addidx rtg_addidx
#define ctl_sqlinfo rtg_sqlinfo
#define ctl_sqllink rtg_sqllink
#endif /* USE_API_ENTRYPOINT */

#endif /* ctFeatRTG_API_ENTRYPOINT */

#endif /* ~_CTCBAPI_H_ */

/* end of ctcbapi.h */
