/*
 *      OFFICIAL NOTIFICATION: the following CONFIDENTIAL and PROPRIETARY 
 * 	property legend shall not be removed from this source code module 
 * 	for any reason.
 *
 *	This program is the CONFIDENTIAL and PROPRIETARY property 
 *	of FairCom(R) Corporation. Any unauthorized use, reproduction or
 *	transfer of this computer program is strictly prohibited. The 
 *      contents of this file may not be disclosed to third parties, copied or
 *      duplicated in any form, in whole or in part, without the prior written
 *      permission of the FairCom(R) Corporation.
 *
 *      Copyright (c) 1992 - 2023 FairCom Corporation.
 *	This is an unpublished work, and is subject to limited distribution and
 *	restricted disclosure only. ALL RIGHTS RESERVED.
 *
 *			RESTRICTED RIGHTS LEGEND
 *	Use, duplication, or disclosure by the Government is subject to
 *	restrictions set forth in subparagraph (c)(1)(ii) of the Rights in
 * 	Technical Data and Computer Software clause at DFARS 252.227-7013, and/or
 *      in similar or successor clauses in the FAR, DOD or NASA FAR Supplement.
 *      Unpublished rights reserved under the Copyright Laws of the United States.
 *	FairCom Corporation, 6300 West Sugar Creek Drive, Columbia, MO 65203.
 *
 *	c-treeACE(tm)	Version 12
 */

#ifndef _CTCBOPTN_H_
#define _CTCBOPTN_H_

#define CTPERM
#include "ctstdr.h"
#include "ctoptn.h"
#ifdef ctCLIENT
#define ctCLIENTcore
#endif
#include "ctaerr.h"
#include "cterrc.h"
#include "ctifil.h"
#include "ctparm.h"
#include "ctsrvf.h"
#ifndef MULTITRD
#include "ctcomm.h"
#endif
#ifdef MULTITRD
#include "ctbtrd.h"
#endif

#include "ctdbsdk.h"

#if defined(ctCLIENT) || defined(ctMTCLIENT)
#define ctcbCLIENT
#endif
#if defined(ctLOCLIB) && !defined(ctFRCSNG)
#define ctcbLOCLIBCLIENT
#endif
#if defined(ctcbCLIENT) || defined(ctcbLOCLIBCLIENT)
#define ctcbANYCLIENT
#endif
#if defined(CTBOUND) && !defined(MULTITRD) && !defined(ctLOCLIB)
#define ctcbSTANDALONE
#endif

/* use critical section instead of mutex */
#define ctFeatCOBOL_USE_CRITICAL_SECTION

/* MYFUNCTION time profiling... total ticks stored in global variable total_myf */
/*#define ctFeatCOBOL_MYFUNCTION_PROFILE*/

#if defined(ctCobolIS)
#define ctFeatCOBOL_MULTITHREAD_TASKS
#endif

#if defined(ctCobolIS)
#define ctFeatCOBOL_MAX_INSTANCES 512
#else
#define ctFeatCOBOL_MAX_INSTANCES 128
#endif

/* the condition below must match the condition 
 * that enables #define ctFeatIICT in ctopt2.h */
#if ctVER_GE(9,6) || defined(ctFeatCOBOL)
/* use ctIICT instead of TRANSACTION_INSTANCE technique
 * to handle files that are not open WITH ROLLBACK */
#define ctFeatCOBOL_USE_IICT
#endif

#if defined(ctcbANYCLIENT) || defined(MULTITRD)
#if ctVER3_GE(10,4,0)
/* support for <runitlockdetect>no file locking */
#define ctFeatCOBOL_COFILE_FILELOCK
#endif
#endif

/* used to mark the code where we assumed to look for
 * CTCB_FILE_TYPE_INDEXED filetype since we have no idea of
 * the filetype and for now we only support indexed files */
#define ctFeatCOBOL_FILETYPE_FORCE_INDEXED

#if ctVER3_GE(10,4,1)
#define ctFeatCOBOL_FILECOPY
#endif

#if ctVER3_GE(11,2,0)
#define ctFeatRTG_FILEPOOL
#endif

/* since 11.2.2 but not controlled by #define to avoid trouble with CT_STRUCTVER_CTSSQLLINK in case of wrong merge into a previous version */
#define ctFeatRTG_SQLLINK_SRVR
#if ctVER3_GE(11,2,2)
#define ctFeatRTG_REDUCE_STACK
#define ctFeatRTG_ITIM_RETRY
#endif

#if ctVER3_GE(11,2,3)
#define ctFeatRTG_DELETE_FLAG
#endif

#if ctVER3_GE(11,5,0)
#define ctFeatRTG_DELCURRENT
#define ctFeatRTG_DEFERAUTOTRAN
#endif

#if ctVER3_GE(11,5,2)
#define ctFeatRTG_FILEID
#define ctFeatRTG_SUBALLOCATOR
#endif

#if ctVER3_GE(11,8,0)
#define ctFeatRTG_KEYCOMPRESS_VLENNOD /* <keycompress vlennod> */
#define ctFeatRTG_FILEPERMISSION /* <permission> */
#define ctFeatRTG_MIXED_DIRSEP /* support path with mixed path separators */
#define ctFeatRTG_SSL /* <instance ssl sslcert> */
#define ctFeatRTG_ENDIANCHECK /* <instance endiancheck> */
#define ctFeatRTG_MEMFILE_PERSIST /* <memoryfile persist> */
#define ctFeatRTG_CTSHMEMDIR /* <instance ctshmemdir> */
#endif

#if ctVER3_GE(11,8,1)
#define ctFeatRTG_CHECK_ATOMICop /* check that ATOMICop is available at runtime */
#define ctFeatRTG_DETECTLOCK_CHKLOK /* <detectlock> to use ctCHKLOK_OTHER instead of get+release ctREADREC */
#define ctFeatRTG_REWRITE_BLOCKING_LOCK /* use BLKRQS lock mode for rewrite operations */
#define ctFeatRTG_STRUCT_2019 /* expand RPC structures */
#define ctFeatRTG_BULKADDITION_SKIPREBUILD /* skip bulkaddition rebuild if no record was changed */
#define ctFeatRTG_BULKADDITION_PRMIIDX /* use PRMIIDX instead of RBLIFIL */
#define ctFeatRTG_EXTFH_OPCODE_VALIDATE /* validate EXTFH opcode */
#define ctFeatRTG_BTRV_LOGIN /* BTRV login/logout */
#define ctFeatRTG_CONFROWID /* <rowid> for RTG BTRV files larger than 4GB */
#endif

#if ctVER3_GE(11,9,0)
#define ctFeatRTG_CTBTRV_FILES /* support files created with CTBTRV interface */
#endif

#if ctVER3_GE(11,9,5)
#define ctFeatRTG_FILEMATCH_FIX /* <config filematch> */
#define ctFeatRTG_SCANCACHE /* <scancache> */
#define ctFeatRTG_START_ON_READ /* <startonread> */
#define ctFeatRTG_SRLSEGSIZ /* <rowid size> */
#define ctFeatRTG_FALLBACK_REDIRINSTANCE /* <redirinstance> without lib and func attributes */
#define ctBehavRTG_NO_ctNOENCRYP /* create files without ctNOENCRYP file mode */
#define ctFeatRTG_LOG_DEBUG_LOCK /* <log><debug><lock> */
#define ctBehavRTG_ctTRANMODE /* create files with ctTRANMODE/ctPIMGMODE file mode */
#define ctFeatRTG_LOCAL_FILES /* <localinstance> */
#else
#define ctFeatRTG_CCC /* <ccc> */
#endif

#if ctVER3_GE(12,0,1)
#define ctFeatRTG_API_ENTRYPOINT /* single entry-point rtgCALL */
#define ctFeatRTG_FAILOVER /* <instance failover> */
#define ctFeatRTG_CONFINST_ATTR_ARRAY /* pass instance attributes in array */
#define ctBehavRTG_ctTRANMODE_MEMFILE /* create memory files with ctTRANMODE/ctPIMGMODE file mode */
#define ctFeatRTG_FILEVERSION /* <fileversion> */
#endif

#ifdef ctFeatMAXFILE32
#define ctFeatRTG_MAXFILE32 /* 4-bytes file number support */
#endif

#ifdef ctFeatCOMPACT_TRUNCATE
#define ctFeatRTG_TRUNCATE_FILE /* file truncate support */
#define ctFeatRTG_TRUNCATE_IF_EXIST /* <truncateifexist> */
#endif

/*
RAB:191013: Marco had this ON for everyone v11.8.0 forward, yet we had issues
with Infotrax, so Ray only activated for AMBEV
*/
#ifdef  ctPortHBRTG
#ifndef ctFeatRTG_DETECTLOCK_CHKLOK
#define ctFeatRTG_DETECTLOCK_CHKLOK
#endif
#ifndef ctFeatRTG_REWRITE_BLOCKING_LOCK
#define ctFeatRTG_REWRITE_BLOCKING_LOCK
#endif
#ifndef ctFeatRTG_START_ON_READ
#define ctFeatRTG_START_ON_READ
#endif
#ifndef ctFeatRTG_FALLBACK_REDIRINSTANCE
#define ctFeatRTG_FALLBACK_REDIRINSTANCE
#endif
#ifndef ctFeatRTG_LOG_DEBUG_LOCK
#define ctFeatRTG_LOG_DEBUG_LOCK
#endif
#ifndef ctFeatRTG_TRUNCATE_IF_EXIST
#define ctFeatRTG_TRUNCATE_IF_EXIST
#endif
#endif

#if (defined(ctPortDSTINTL) || defined(ctPortDSTRTG))
#ifndef ctFeatRTG_BTRV_LOGIN_INSTANCE
#define ctFeatRTG_BTRV_LOGIN_INSTANCE /* BTRV LOGIN URI 'rtg.instance' parameter */
#endif
#ifndef ctFeatRTG_DATAFILESUFFIX_APPEND
#define ctFeatRTG_DATAFILESUFFIX_APPEND /* <datafilesuffix append> */
#endif
#ifndef ctFeatRTG_MAXSIZE
#define ctFeatRTG_MAXSIZE /* <maxsize> */
#ifndef ctFeatRTG_KEYS
#define ctFeatRTG_KEYS
#endif
#endif
#endif

#if (defined(ctPortDSTINTL) || defined(ctPortDSTRTG) || defined(ctPortHBRTG) )
#ifndef ctFeatRTG_LOCAL_FILES
#define ctFeatRTG_LOCAL_FILES /* <localinstance> */
#endif
#endif

#if defined(ctPortVERYANT)
#if ctVER_LT(12,5)
#ifndef ctBehavRTG_BULKADDITION_MEMFILE_WA
#define ctBehavRTG_BULKADDITION_MEMFILE_WA
#endif
#endif
#endif

#define ctFeatRTG_EXITSRV_FIX
#define ctFeatRTG_CHECK_REDIREC_KEY
#define ctFeatRTG_PREFETCHPREV
/*
MB:200108: the #define ctFeatRTG_KEEPLOK_TRN_FIX is a workaround for an issue in
ctree's MULTIOPN_SAMUSR logic that is fixed in r201582. Since the issue has been fixed 
and the workaround is the cause of another issue, we are disabling it but leave it here
disabled for future reference.
#define ctFeatRTG_KEEPLOK_TRN_FIX
*/
#define ctFeatRTG_REPAIRDATA
#define ctFixRTG_NORMALIZE_MIXED_DIRSEP
#define ctFeatRTG_SQLLINK_ADJUST_DIRSEP
#define ctFeatRTG_PREFETCHTTL
#define ctFeatRTG_BULKADDITION_SKIPDATASCAN
#define ctFixRTG_SWITCHER_MAPFILE
#define ctFeatRTG_LOCAL_TEMPPATH_SORTMEM
#define ctFeatRTG_RPC_PREFETCH_OPTIMIZATION
#define ctFeatRTG_SQLUNLINK_SKIP_MISSING
#define ctFixRTG_BTRCALL_DATALENGTH /* get only 2-bytes from 4-bytes data length BTRCALL functions parameter */
#define ctFeatRTG_PREFETCH_LOCK_OPTIMIZATION /* avoid LOKREC(ctFREE_REDLOKS) if <prefetch allowwriters="1"> */
#define ctFeatRTG_BLOCKING_OPEN /* support for blocking file opens */

#ifdef STREE_TRUNK
/*#define ctFeatRTG_KEYS*/ /* RTGKEY/RTGSEG */
/*#define ctFeatRTG_MAXSIZE*/ /* <maxsize> */
#endif /* STREE_TRUNK */

#define ctFeatRTG_BTRV_LOGIN_INSTANCE /* BTRV LOGIN URI 'rtg.instance' parameter */
#define ctFeatRTG_DATAFILESUFFIX_APPEND /* <datafilesuffix append> */
#define ctFixRTG_LOGDEBUGCONFIG /* fix log.debug.config for dynamic config */
#define ctFeatRTG_LOGWHOFORMAT /* <log whoformat> */
#define ctFeatRTG_TASKID /* substitution specifier '%o' fotr server task ID */
#define ctFixRTG_PREFETCH_ON_LOCKED /* fix prefetch on locked record */
#define ctBehavRTG_BULKADDITION_IDX_XCREBLK /* get XCREblk from index file */

#ifdef STREE_TRUNK
#endif

#if defined(ctFeatRTG_BLOCKING_OPEN) && !defined(ctFeatBLOCKING_OPEN)
#error #define ctFeatRTG_BLOCKING_OPEN requires #define ctFeatBLOCKING_OPEN
#endif

#ifdef ctFeatRTG_MAXSIZE
#ifndef ctFeatRTG_KEYS
#error #define ctFeatRTG_MAXSIZE requires #define ctFeatRTG_KEYS
#endif
#endif

#ifdef ctFeatRTG_KEYS
#if !defined(ctFeatRTG_STRUCT_2019) || !defined(ctFeatRTG_SRLSEGSIZ) || !defined(ctFeatRTG_REDUCE_STACK)
#error #define ctFeatRTG_KEYS requires #define ctFeatRTG_STRUCT_2019 and #define ctFeatRTG_SRLSEGSIZ and #define ctFeatRTG_REDUCE_STACK
#endif
#endif

#ifdef ctFeatRTG_STATIC_REDIRINSTANCE /* fallback redirinstance is statically resolved to mFFH function */
#ifndef ctFeatRTG_FALLBACK_REDIRINSTANCE
#define ctFeatRTG_FALLBACK_REDIRINSTANCE
#endif
#endif

#if defined ctFeatRTG_CTBTRV_FILES && !defined ctFeatNOISAMKEYUPDuser && defined ctSRVR
#error ctFeatRTG_CTBTRV_FILES requires ctFeatNOISAMKEYUPDuser (ctopt2.h)
#endif

#if defined ctFeatRTG_MEMFILE_PERSIST && !defined ctFeatKEEPOPENoffAtLogoff && defined ctSRVR
#error ctFeatRTG_MEMFILE_PERSIST requires ctFeatKEEPOPENoffAtLogoff (ctopt2.h)
#endif

#ifdef ctFeatRTG_SSL
#ifndef ctFeatRTG_ENDIANCHECK
/* <instance ssl sslcert> support assumes <instance endiancheck> being enabled */
#error #define ctFeatRTG_SSL requires #define ctFeatRTG_ENDIANCHECK
#endif
#endif

#ifdef ctFeatRTG_FALLBACK_REDIRINSTANCE
#ifndef ctFixRTG_SWITCHER_MAPFILE
/* fallback redirinstance requires fix to switcher file map */
#error #define ctFeatRTG_FALLBACK_REDIRINSTANCE requires #define ctFixRTG_SWITCHER_MAPFILE
#endif
#endif

#ifndef ctFeatRTG_STRUCT_2019
#ifdef ctFeatRTG_SRLSEGSIZ
/* rowid size requires expanded RPC structures */
#error #define ctFeatRTG_SRLSEGSIZ requires #define ctFeatRTG_STRUCT_2019
#endif
#ifdef ctFeatRTG_MAXFILE32
/* 4 bytes file number support require expanded RPC structures */
#error #define ctFeatRTG_MAXFILE32 requires #define ctFeatRTG_STRUCT_2019
#endif
#ifdef ctFeatRTG_BULKADDITION_SKIPREBUILD
/* bulkaddition optimization requires expanded RPC structures */
#error #define ctFeatRTG_BULKADDITION_SKIPREBUILD requires #define ctFeatRTG_STRUCT_2019
#endif
#ifdef ctFeatRTG_BULKADDITION_PRMIIDX
/* bulkaddition optimization requires expanded RPC structures */
#error #define ctFeatRTG_BULKADDITION_PRMIIDX requires #define ctFeatRTG_STRUCT_2019
#endif
#endif

#if defined ctFeatRTG_SQLLINK_SRVR && ! defined CTDB_NEW_SQLIMP
#error ctFeatRTG_SQLLINK_SRVR requires CTDB_NEW_SQLIMP (ctdbsdk.h)
#endif

#if defined ctFeatRTG_DEFERAUTOTRAN && !defined ctFeatDeferAutotrn && defined ctSRVR
#error ctFeatRTG_DEFERAUTOTRAN requires ctFeatDeferAutotrn (ctopt2.h)
#endif

#if defined ctFeatRTG_KEYCOMPRESS_VLENNOD && !defined ctFeatVARLENnodefmt && defined ctFeat6BT
#error ctFeatRTG_KEYCOMPRESS_VLENNOD requires ctFeatVARLENnodefmt (ctopt2.h)
#endif

#if defined ctFeatRTG_REWRITE_BLOCKING_LOCK && !defined ctFeatFORCE_BLOCKING_LOCK && defined ctSRVR
#error ctFeatRTG_REWRITE_BLOCKING_LOCK requires ctFeatFORCE_BLOCKING_LOCK (ctopt2.h)
#endif

#if defined ctFeatRTG_FAILOVER && !defined ctFeatRTG_API_ENTRYPOINT
#error ctFeatRTG_FAILOVER requires ctFeatRTG_API_ENTRYPOINT
#endif

#ifndef NO_ctFeatRTG_SQL
#define ctFeatRTG_SQL
#endif

#ifdef _MSC_VER
#pragma warning(1 : 4701) 
#if (_MSC_VER < 1400)
#pragma warning(disable : 4761) 
#endif
#endif

#ifndef UNREFERENCED_PARAMETER
#define UNREFERENCED_PARAMETER(P) (P=P)
#endif

#ifdef _WIN32
#define cbDLLexport __declspec(dllexport)
#define cbDLLimport __declspec(dllimport)
#else
#define cbDLLexport
#define cbDLLimport extern
#endif

#define MEMU (8)
#define MEMW(n) (((n) % MEMU) ? (n) + MEMU - (n) % MEMU : (n))
#define MEMDW(n) (((n) % (16)) ? (n) + (16) - (n) % (16) : (n))

#define CT_PATH_LEN             (255+1) /* includes terminator */
#define CT_EXTN_LEN                 16
#define CT_SERV_LEN           MAX_NAME
#define CT_USER_LEN                IDZ
#define CT_PASS_LEN                 64
#define CT_NODE_LEN           MAX_NAME
#define CT_VERSION_LEN              32
#define CT_COMMENT_LEN           (30+1) /* includes terminator */

#define LOGWHOMAXLEN 64

#if !defined(TPE_MAX_IDLEN)
#define TPE_MAX_IDLEN	64
#endif
#if !defined(TPE_MAX_DBIDLEN)
#define TPE_MAX_DBIDLEN	TPE_MAX_IDLEN
#endif

/* interface types */
typedef enum INTFTYPE { 
	/* do not change these values! they affect licensing and c/s, just add at the end.*/
	INTF_INVALID_ACE = 0,
	INTF_ACUCOBOL = 1,
	INTF_ISCOBOL = 2,
	INTF_EXTFH = 3,
	INTF_BTRV = 4
	/* do not change these values! they affect licensing and c/s, just add at the end.*/
} INTFTYPE;

#define INTFNAME(a) ( \
	(a == INTF_ACUCOBOL) ? "ACUCOBOL" : \
	(a == INTF_ISCOBOL) ? "isCOBOL" : \
	(a == INTF_EXTFH) ? "ExtFH" : \
	(a == INTF_BTRV) ? "BTRV" : "" )

typedef struct {
	UCOUNT	off;
	UCOUNT	len;
	UTEXT	pad[2];
	UTEXT	typ;
	UTEXT	mod;
} RTGSEG, * pRTGSEG;
typedef struct {
	ULONG	segoff;
	LONG	type;
	UCOUNT	nsegs;
	UCOUNT	len;
	UTEXT	pad[3];
	UTEXT	nulval;
} RTGKEY, * pRTGKEY;

typedef ULONG RTGTASKID, * pRTGTASKID;

#ifdef ctFeatRTG_KEYS
#define rtgADDROFVAR(x) ((pTEXT)(x) + MEMW((pTEXT)&((x)->var[0]) - (pTEXT)(x)))
#define rtgADDROFRTGKEY(x) (pRTGKEY)(rtgADDROFVAR(x))
#define rtgADDROFRTGSEG(x) (pRTGSEG)(rtgADDROFRTGKEY(x) + (x)->nkeys)
#define rtgNUMOFRTGSEG(x) (rtgNumOfRTGSEG(rtgADDROFRTGKEY(x), (x)->nkeys))
#define rtgSIZEOFRTGKEYSEG(x) (rtgSizeOfRTGKEYSEG(rtgADDROFRTGKEY(x), (x)->nkeys))
#define rtgADDROFKEYSEG(k) (pRTGSEG)((pTEXT)(k) + (k)->segoff)
#endif /* ctFeatRTG_KEYS */

#endif /* ~_CTCBOPTN_H_ */

/* end of ctcboptn.h */
