/*
 *      OFFICIAL NOTIFICATION: the following CONFIDENTIAL and PROPRIETARY 
 * 	property legend shall not be removed from this source code module 
 * 	for any reason.
 *
 *	This program is the CONFIDENTIAL and PROPRIETARY property 
 *	of FairCom(R) Corporation. Any unauthorized use, reproduction or
 *	transfer of this computer program is strictly prohibited. The 
 *      contents of this file may not be disclosed to third parties, copied or
 *      duplicated in any form, in whole or in part, without the prior written
 *      permission of the FairCom(R) Corporation.
 *
 *      Copyright (c) 1992 - 2023 FairCom Corporation.
 *	This is an unpublished work, and is subject to limited distribution and
 *	restricted disclosure only. ALL RIGHTS RESERVED.
 *
 *			RESTRICTED RIGHTS LEGEND
 *	Use, duplication, or disclosure by the Government is subject to
 *	restrictions set forth in subparagraph (c)(1)(ii) of the Rights in
 * 	Technical Data and Computer Software clause at DFARS 252.227-7013, and/or
 *      in similar or successor clauses in the FAR, DOD or NASA FAR Supplement.
 *      Unpublished rights reserved under the Copyright Laws of the United States.
 *	FairCom Corporation, 6300 West Sugar Creek Drive, Columbia, MO 65203.
 *
 *	c-treeACE(tm)	Version 12
 */

#ifndef _CTCBSTDR_H_
#define _CTCBSTDR_H_

#include "ctcboptn.h"
#include "ctcrsdk.h"
#include "ctcberr.h"

#include <memory.h>
#include <string.h>

#define rtgMAX(x,y) ((x)>(y)?(x):(y))
#define rtgMIN(x,y) ((x)<(y)?(x):(y))

#ifndef MAX
#define MAX(A,B) rtgMAX(A,B)
#endif
#ifndef MIN
#define MIN(A,B) rtgMIN(A,B)
#endif

cbDLLexport VOID rtgFREE(pVOID ptr);
cbDLLexport pVOID rtgMALLOC(size_t size);
cbDLLexport pVOID rtgCALLOC(size_t num, size_t size);
cbDLLexport pVOID rtgREALLOC(ppVOID ptr, size_t size);
cbDLLexport pVOID rtgSTRDUP(cpTEXT str);

#define rtgSIZEOF(x) (ctSIZE(x))
#define rtgSIZEOFARRAY(a) (rtgSIZEOF(a)/rtgSIZEOF(a[0]))

#define rtgMEMCPY(d, s, n) cpybuf(d, s, (UINT)n)
#define rtgAMEMCPY(d, s) rtgMEMCPY(d, s, rtgSIZEOF(d))
#define rtgMEMMOVE(d, s, n) memmove(d, s, n)
#define rtgMEMZERO(d, n) ctbfill(d, 0, (size_t)n)
#define rtgAMEMZERO(a) rtgMEMZERO(a, rtgSIZEOF(a))

#define rtgMEMFREE(p) {if (p != NULL) {pVOID _p = p; p = NULL; rtgFREE(_p);}}

#define cbMEMGET(n) rtgCALLOC(1,n)
#define rtgMEMPUT(ptr) { \
	if (ptr != NULL) { \
		void *_tmp = (void*)ptr; \
		ptr = NULL; \
		rtgFREE(_tmp); \
	} \
}
#define cbMEMFREE(p) rtgMEMPUT(p)
#define cbMEMCPY(d,s,n) cpybuf(d,s,n)
#define cbMEMSET(d,c,n) ctbfill(d,c,(size_t)n)
#define cbMEMZERO(d,n) cbMEMSET(d,0,n)

cbDLLexport cpTEXT rtgSTRSTR(cpTEXT s1, cpTEXT s2, TEXT casesensitive);
cbDLLexport cpTEXT rtgSTRRSTR(cpTEXT s1, cpTEXT s2, TEXT casesensitive);
#define cbSTRSTR(s1, s2, cs) ((pTEXT)rtgSTRSTR(s1, s2, cs))
#define cbSTRRSTR(s1, s2) ((pTEXT)rtgSTRRSTR(s1, s2, NO))

#define rtgSTRLEN(s) ((s != NULL) ? ctrt_strlen(s) : (size_t)0)
#define rtgSTRCMP(s1, s2) ctrt_strcmp(s1, s2)
#define rtgSTRNCMP(s1, s2, n) ctrt_strncmp(s1, s2, n)
#define rtgSTRICMP(s1, s2) ctrt_stricmp(s1, s2)
#define rtgSTRCPY(d, s) ctrt_strcpy(d, s)
#define rtgSTRNCPY(d, s, l) \
 { \
	if (d) *d = '\0'; \
	if (d && s) { \
		ctrt_strncpy(d, s, l); \
		d[l] = '\0'; \
	} \
}
#define rtgASTRCPY(d, s) rtgSTRNCPY(d, s, rtgSIZEOF(d)-1)
#define cbSTRNCPY(d, s, l) {strncpy(d, s, (size_t)l);}
#define cbSTRCPY(d, s) { \
	cpTEXT _d = d, _s = s; \
	if (_d) d[0] = '\0'; \
	if (_d && _s) { \
		cbSTRNCPY(d, s, sizeof(d)-1); \
		d[sizeof(d)-1] = '\0'; \
	} \
}
#define rtgSTRCAT(d, s) ctrt_strcat(d, s)
#define rtgSTRNCAT(d, s, n) ctrt_strncat(d, s, n)
#define rtgASTRCAT(d, s) rtgSTRNCAT(d, s, rtgSIZEOF(d)-1)
#define rtgASTRNCAT(d, s, n) rtgSTRNCAT(d, s, MIN(n, rtgSIZEOF(d)-1))
#define cbSTRCAT(d, s) { \
	cpTEXT _d = d, _s = s; \
	if (_d && _s) strncat(d, s, sizeof(d)-1); \
}
#define cbSPRINTFCATCOUNT(dst, src, dstlen, cntlen, arg) \
{ \
	sprintf arg; \
	cntlen += strlen(src); \
	if (dst && (strlen(dst)+strlen(src)) < dstlen) { \
		strcat(dst, src); \
	} \
}

#ifdef _WIN32
#define cbSTRICMP(s1, s2) _stricmp(s1, s2)
#define cbSTRNICMP(s1, s2, n) _strnicmp(s1, s2, n)
#define cbSNPRINTF _snprintf
#else
#define cbSTRICMP(s1, s2) ctrt_stricmp(s1, s2)
#define cbSTRNICMP(s1, s2, n) ctrt_strnicmp(s1, s2, n)
#define cbSNPRINTF snprintf
#endif
#define cbSTRCMP(s1, s2, cs) ((cs) ? strcmp(s1, s2) : cbSTRICMP(s1, s2))
#define cbSTRNCMP(s1, s2, n, cs) ((cs) ? strncmp(s1, s2, n) : cbSTRNICMP(s1, s2, n))

#define cbACCESS(p,m) access(p,m)
#define cbUNLINK(n) unlink(n)

#define cbISSPACE(p) isspace((int)p)
#define cbISDIGIT(p) isdigit((int)p)
#define cbISPRINT(p) isprint((int)p)

#ifdef ctcr_sprintf
#define rtgSNPRINTF ctcr_sprintf
#else
#define rtgSNPRINTF ctrt_snprintf
#endif

#if (defined(_WIN32) && _MSC_VER >= 1400) || (__STDC_VERSION__ >= 199901L) /* support variadic macros */
#define rtgAPRINTF(arr, format, ...) rtgSNPRINTF(arr, sizeof(arr)-1, format, __VA_ARGS__)
#else
#define rtgAPRINTF ctrt_sprintf
#endif

#define rtgATOL atol
#ifdef ctN8
#ifdef ctPortUNIX
#define rtgATOLL atoll
#else
#define rtgATOLL _atoi64
#endif
#endif

typedef VOID (*pFUNC)();

#ifdef _WIN32

#ifdef UNICODE
#define ctLoadLib(l)               LoadLibraryA(l)
#else /* ~UNICODE */
#define ctLoadLib(l)               LoadLibrary(l)
#endif /* ~UNICODE */
#define ctFreeLib(h)               !FreeLibrary(h)
#define ctGetFunc(h,f,p)           (void (*)(void))GetProcAddress((HINSTANCE)h,f)
#define ctLoadLibErr()             GetLastError()
#define ctLoadLibErrMsg()          NULL

#else  /* ~_WIN32 */

/* If compiling with gcc 3.2.2 on HP/UX 11: */
#ifdef HPUX
#if ((__GNUC__ == 3) && (__GNUC_MINOR__ == 2) && (__GNUC_PATCHLEVEL__ == 2))
/*
** Use shl_load(), shl_unload(), and shl_findsym() instead of
** dlopen(), dlclose(), and dlsym().
*/
#define ctUSE_SHL_FUNC
#endif
#endif

#ifdef ctUSE_SHL_FUNC

#include <dl.h>
#define ctLoadLib(l)            shl_load(l,BIND_IMMEDIATE,0L)
#define ctFreeLib(h)            shl_unload(h)
#define ctGetFunc(h,f,p)        shl_findsym(h,f,TYPE_PROCEDURE,&p)
#define ctLoadLibErr()          errno
#define ctLoadLibErrMsg()       NULL

#else  /* ~ctUSE_SHL_FUNC */

#include <dlfcn.h>
#define ctLoadLib(l)            dlopen(l,RTLD_NOW|RTLD_LOCAL)
#define ctFreeLib(h)            dlclose(h)
#define ctGetFunc(h,f,p)        dlsym(h,f)
#define ctLoadLibErr()          0
#define ctLoadLibErrMsg()       dlerror()

#endif /* ~ctUSE_SHL_FUNC */

#endif /* ~_WIN32 */

#define rtgSTRUCTVERHAS(structver, feature) ((feature <= CT_STRUCTVER_LAST) ? (structver >= feature) : (structver & feature))

LONG ctcbStructverID(VOID);
LONG ctcbStructverHas(LONG structver, LONG feature);
NINT ctcbFileExist(pTEXT path);
NINT ctcbIsXmlFile(pTEXT path);
cbDLLexport NINT ctcbIsXml(pTEXT str);
#ifdef ctFeatMAXFILE32
FILNO ctcbOPNRFIL(FILNO filno, pTEXT filnam, COUNT filmod, LONG xfilmod);
#else
COUNT ctcbOPNRFIL(COUNT filno, pTEXT filnam, COUNT filmod, LONG xfilmod);
#endif
pIFIL ctcbGETIFIL(pTEXT filnam);
int cbISSPACESTR(const char *s);
void* ctcbLoadLibrary(const char *name);
int ctcbLoadLibraryError(void);
char* ctcbLoadLibraryErrorMessage(void);
void (*ctcbGetProcAddress(void* hlib, const char *name))(void);
VOID ctcbSetError(CT_ERROR *err, COUNT logical, LONG ctree, LONG system, pTEXT errmsg, pTEXT msg);
VOID ctcbGetError(pCOUNT _errno, pLONG _int_errno, pLONG _int2_errno, pTEXT _errmsg, CT_ERROR *err, pTEXT msg);
ULONG ctcbGetPID(VOID);
ULONG ctcbGetTID(VOID);
cbDLLexport NINT ctcbEncryptFile(pTEXT inpfile, pTEXT outfile, CT_ERROR *err, pTEXT errmsg);
size_t ctcbDecryptFile(pTEXT inpfile, pTEXT outbuf, size_t outlen, CT_ERROR *err);
#ifdef ctFeatRTG_TASKID
NINT ctcbExpandName(pTEXT format, pTEXT dest, NINT destlen, pTEXT filedir, pTEXT filename, pCOUNT instance, pRTGTASKID taskid);
#else
NINT ctcbExpandName(pTEXT format, pTEXT dest, NINT destlen, pTEXT filedir, pTEXT filename, pCOUNT instance);
#endif
RTGTASKID ctcb_filelocktaskid(pTEXT filname);
#ifdef ctFeatRTG_SRLSEGSIZ
NINT ctcbGetRecordNumber(ULONG *recnum, pTEXT recbuf, UTEXT hdrsiz, UTEXT srlsiz);
#endif
#ifdef ctFeatRTG_KEYS
UCOUNT rtgNumOfRTGSEG(pRTGKEY keys, UCOUNT nkeys);
UCOUNT rtgMaxRTGSEG(pRTGKEY keys, UCOUNT nkeys);
size_t rtgSizeOfRTGKEYSEG(pRTGKEY keys, UCOUNT nkeys);
VOID rtgAdjustRTGKEY(pRTGKEY key, UCOUNT nkeys, LONG offset);
UCOUNT rtgDeleteRTGKEY(pRTGKEY key, UCOUNT nkeys);
VOID rtgAdjustRTGSEG(pRTGSEG seg, UCOUNT nsegs, COUNT offset);
#endif

#endif /* ~_CTCBSTDR_H_ */

/* end of ctcbstdr.h */
