/*
 *      OFFICIAL NOTIFICATION: the following CONFIDENTIAL and PROPRIETARY 
 * 	property legend shall not be removed from this source code module 
 * 	for any reason.
 *
 *	This program is the CONFIDENTIAL and PROPRIETARY property 
 *	of FairCom(R) Corporation. Any unauthorized use, reproduction or
 *	transfer of this computer program is strictly prohibited. The 
 *      contents of this file may not be disclosed to third parties, copied or
 *      duplicated in any form, in whole or in part, without the prior written
 *      permission of the FairCom(R) Corporation.
 *
 *      Copyright (c) 1992 - 2023 FairCom Corporation.
 *	This is an unpublished work, and is subject to limited distribution and
 *	restricted disclosure only. ALL RIGHTS RESERVED.
 *
 *			RESTRICTED RIGHTS LEGEND
 *	Use, duplication, or disclosure by the Government is subject to
 *	restrictions set forth in subparagraph (c)(1)(ii) of the Rights in
 * 	Technical Data and Computer Software clause at DFARS 252.227-7013, and/or
 *      in similar or successor clauses in the FAR, DOD or NASA FAR Supplement.
 *      Unpublished rights reserved under the Copyright Laws of the United States.
 *	FairCom Corporation, 6300 West Sugar Creek Drive, Columbia, MO 65203.
 *
 *	c-treeACE(tm)	Version 12
 */

#ifndef _CTCBXFD_H_
#define _CTCBXFD_H_

/****************************************************************************\
*
*	header files
*
\****************************************************************************/
#include "ctdbsdk.h"
#include "ctdbport.h"
#include "ctdbxml.h"
#include "ctcboptn.h"
#include "ctcbtype.h"

/****************************************************************************\
*
*   Protect against C++ compilers
*
\****************************************************************************/
#ifdef __cplusplus
extern "C" {
#endif
pCTDBLIST ctdbLOCAL _ctdbListAlloc(void);


/****************************************************************************\
*
*	CTXFDNODE
*	Definition of each parsed XML node.
*
\****************************************************************************/
typedef struct tagCTXFD		CTXFD, *pCTXFD;
typedef struct tagCTXFDKEY	CTXFDKEY, *pCTXFDKEY;
typedef struct tagCTXFDKEYSEG	CTXFDKEYSEG, *pCTXFDKEYSEG;
typedef struct tagCTXFDCONDDET	CTXFDCONDDET, *pCTXFDCONDDET;
typedef struct tagCTXFDFIELD	CTXFDFIELD, *pCTXFDFIELD;
typedef struct tagCTXFDOCCURS	CTXFDOCCURS, *pCTXFDOCCURS;

#define CTXFD_MAXSTRLEN 256
#define CTXFD_MAXSTACK 1024
#define CTXFD_MAXYYSTRLEN 1024
#define CTXFD_BTRV_VERSION 10000

struct tagCTXFD
{
	pVOID		yyscanner;
	pTEXT		instr;		/* input text to be parsed						*/
	NINT		size;		/* size in bytes of input text					*/
	NINT		pos;		
	TEXT		errmsg[CTXFD_MAXSTRLEN];/* error message buffer							*/
	NINT		errflag;	/* error flag: >0 indicate errors. -1 indicates XFD in XML format 	*/
	NINT		debug; /* set to != 0 to output debug information */
	NINT		lineno;
	pVOID		stack[CTXFD_MAXSTACK];
	NINT		stackptr;
	
	/**/
	TEXT basename[CTXFD_MAXSTRLEN];
	TEXT selectname[CTXFD_MAXSTRLEN];
	TEXT xfd_fromacu;
	NINT xfdversion;
	NINT filetype;
	LONG minlen;
	LONG maxlen;
	LONG nbrofkeys;
	pCTDBLIST keys;
	LONG nbrofconds;
	pCTDBLIST conditions;
	pCTDBLIST fields;
	pCTDBLIST cout;
	pTEXT tmpptr; /* pointer used in the grammar to pass information during condition parsing */
};

struct tagCTXFDKEY
{
	LONG dupl;
	pCTDBLIST segments;
	pCTDBLIST fieldnames;
};

struct tagCTXFDKEYSEG
{
	LONG offset;
	LONG size;
};

struct tagCTXFDCONDDET
{
	LONG number;
	LONG type;
	LONG lcond;
	LONG rcond;
	pTEXT field;
	pTEXT value;
	pTEXT tblname;
	CTBOOL inuse;
};

#define BINDEFAULT 1
#define CBDEFAULT  2
#define NULLDEFAULT 3

struct tagCTXFDFIELD
{
	LONG    offset;
	LONG    size;
	COUNT   type;
	COUNT   digits;
	COUNT   scale;
	COUNT   usertype;
	COUNT   deftype;
	LONG    condition;
	LONG    level;
	TEXT    hidden;
	TEXT    indexed;
	pTEXT   fld_name;
	pTEXT   datefmt;
	pTEXT   fld_name_ext;
	pTEXT   def;
};

struct tagCTXFDOCCURS
{
	LONG occur;
	LONG size;
	pCTDBLIST fields;
};

union tag_xfd_STYPE {
LONG yInt;
TEXT yStr[CTXFD_MAXYYSTRLEN];
pVOID yPtr;
} ;
typedef union tag_xfd_STYPE YYSTYPE;	
#define YYSTYPE_IS_DECLARED 1
#define YYSTYPE_IS_TRIVIAL 1

/****************************************************************************/
     
#define YY_EXTRA_TYPE   pCTXFD

int     xfd_lex(YYSTYPE *, void *);
int     xfd_lex_init(void **);
int     xfd_lex_destroy(void *);
void    xfd_set_extra(YY_EXTRA_TYPE, void *);
int     xfd_parse(pCTXFD, void *);
void    xfd_error (pCTXFD, void *, pTEXT);
    
pTEXT fldstrdup (pTEXT const txt);
pCTXFDKEY XFDAllocKeyInfo();
pCTXFDKEYSEG XFDAllocKeySeg(LONG offset, LONG size);
pCTXFDCONDDET XFDAllocConditionDetails();
pCTXFDFIELD XFDAllocField();
pCTXFDOCCURS XFDAllocOccurs();
pCTXFDOCCURS XFDFreeOccurs (pCTXFDOCCURS occ);
pCTXFDFIELD XFDFieldDup(pCTXFDFIELD src);

NINT CTXFDPushStack(pCTXFD handle, pVOID ptr);
pVOID CTXFDPopStack(pCTXFD handle);
NINT CTXFDIsStackEmpty(pCTXFD handle);

VOID XFDParseASCII(pCTXFD handle, pTEXT buffer, NINT size);
pTEXT fldstrcpy (pTEXT dest, const pTEXT src);

cbDLLexport pCTXFD XFDInit();
cbDLLexport VOID XFDFree(pCTXFD handle);
cbDLLexport NINT XFDParse(pCTXFD handle, pTEXT buffer, NINT size);
#ifdef ctFeatRTG_KEYS
cbDLLexport NINT GenCTMAKEfromXDD(pCTXML hXDD, pCT_OPEN3 makeinfo, pRTGKEY key);
#else /* ~ctFeatRTG_KEYS */
cbDLLexport NINT GenCTMAKEfromXDD(pCTXML hXDD, pCT_OPEN2 makeinfo, pCT_KEY2 key);
#endif /* ~ctFeatRTG_KEYS */
cbDLLexport size_t XFDGetXMLText (pCTXFD XFD, pTEXT buffer, size_t size);
cbDLLexport size_t XDDGetXMLText (pCTXML XDD, pTEXT buffer, size_t size);
cbDLLexport pCTXML ApplyXDDRules(pTEXT xdd, size_t xddlen, pTEXT rules, size_t ruleslen, pTEXT errmsg, pNINT errflag);


/* BTRV DDF */

typedef struct {
	TEXT len[3]; /* this is expected to always be "97,"*/
	TEXT id[2];  /*File ID*/
	TEXT filename[20]; /* logical filename*/
	TEXT location[64]; /* file location */
	TEXT flags; /* file flag. If bit 4 equals 1, the file is a dictionary (.DDF) file. If bit 4 equals 0, the file is a user-defined file */
	TEXT reserved[10];
} DDF_file;

typedef struct {
	TEXT len[3]; /* this is expected to always be "32,"*/
	TEXT id[2];  /* Field ID */
	TEXT fileid[2]; /* File ID */
	TEXT fieldname[20]; /* name of the field */
	TEXT type; /* field type */
	TEXT offset[2]; 
	TEXT size[2]; 
	TEXT dec; /* number of decimal places */
	TEXT reserved[2];
} DDF_field;

typedef struct {
	TEXT len[3]; /* this is expected to always be "32,"*/
	TEXT fileid[2];  /* File ID */
	TEXT fieldid[2]; /* Field ID */
	TEXT idxnumber[2]; /* Index number */
	TEXT segment[2]; /* segment number */
	TEXT flags[2]; /*key flags as per btrv documentation*/
} DDF_index;


typedef enum BT_types
{
	BT_CHAR = 0,
	BT_INTEGER = 1,
	BT_FLOAT = 2,
	BT_DATE = 3,
	BT_TIME = 4,
	BT_DECIMAL = 5,
	BT_MONEY = 6,
	BT_LOGICAL = 7,
	BT_NUMERIC = 8,
	BT_BFLOAT = 9,
	BT_LSTRING = 10,
	BT_ZSTRING = 11,
	BT_UBINARY = 14,
	BT_AUTOINCR = 15,
	BT_BIT =16,
	BT_NUMERICSTS = 17,
	BT_NUMERICSA = 18,
	BT_CURRENCY = 19,
	BT_TIMESTAMP = 20,
	BT_WSTRING = 25,
	BT_WZSTRING = 26,
	BT_GUID = 27,
	BT_NUMERICSLB = 28,
	BT_NUMERICSLS = 29,
	BT_DATETIME = 30,
	BT_NUMERICSTB = 31,
	BT_BINBUFF = 200, /* PF psql BINARY, this type is not defined in psql, added here to distinguish from BT_CHAR */
	BT_NOTNULL_IND = 227, 
	BT_FILLER = 228, /* seems unused using it because this is what is set in fld.type by XFDEmitXMLFiller*/
	BT_IDX_NAME_IND = 255

} BT_types;

cbDLLexport pCTXFD DDF2XFD(DDF_file fileDDF, pTEXT ddfdir);

#ifdef __cplusplus
}
#endif /* ~__cplusplus */

#define DEBUG_LEX        1
#define DEBUG_YRULES	 2

#endif /* ~_CTCBXFD_H_ */

/* end of ctcbxfd.h */
