/*
 *      OFFICIAL NOTIFICATION: the following CONFIDENTIAL and PROPRIETARY 
 * 	property legend shall not be removed from this source code module 
 * 	for any reason.
 *
 *	This program is the CONFIDENTIAL and PROPRIETARY property 
 *	of FairCom(R) Corporation. Any unauthorized use, reproduction or
 *	transfer of this computer program is strictly prohibited. The 
 *      contents of this file may not be disclosed to third parties, copied or
 *      duplicated in any form, in whole or in part, without the prior written
 *      permission of the FairCom(R) Corporation.
 *
 *      Copyright (c) 1992 - 2023 FairCom Corporation.
 *	This is an unpublished work, and is subject to limited distribution and
 *	restricted disclosure only. ALL RIGHTS RESERVED.
 *
 *			RESTRICTED RIGHTS LEGEND
 *	Use, duplication, or disclosure by the Government is subject to
 *	restrictions set forth in subparagraph (c)(1)(ii) of the Rights in
 * 	Technical Data and Computer Software clause at DFARS 252.227-7013, and/or
 *      in similar or successor clauses in the FAR, DOD or NASA FAR Supplement.
 *      Unpublished rights reserved under the Copyright Laws of the United States.
 *	FairCom Corporation, 6300 West Sugar Creek Drive, Columbia, MO 65203.
 *
 *	c-treeACE(tm)	Version 12
 */

#ifndef _CTDBAPIA_H_
#define _CTDBAPIA_H_

NINT ii_ctdbDayOfWeek(CTDATE date);
COUNT ii_ctdbGetDatno(CTHANDLE hTable);
NINT ii_ctdbGetDay(CTDATE date);
NINT ii_ctdbGetHour(CTTIME Time);
NINT ii_ctdbGetMinute(CTTIME Time);
NINT ii_ctdbGetMonth(CTDATE date);
NINT ii_ctdbGetSecond(CTTIME Time);
NINT ii_ctdbGetYear(CTDATE date);
CTBOOL ii_ctdbGetFieldNullFlag(CTHANDLE Handle);
CTBOOL ii_ctdbGetIndexDuplicateFlag(CTHANDLE Handle);
CTBOOL ii_ctdbGetIndexNullFlag(CTHANDLE Handle);
CTBOOL ii_ctdbGetIndexTemporaryFlag(CTHANDLE Handle);
CTBOOL ii_ctdbGetLockActive(pCTDBLOCK pLock);
CTBOOL ii_ctdbGetLogonOnly(CTHANDLE Handle);
CTBOOL ii_ctdbHasNullFieldSupport(CTHANDLE Handle);
CTBOOL ii_ctdbIsActiveDatabase(CTHANDLE Handle);
CTBOOL ii_ctdbIsActiveSession(CTHANDLE Handle);
CTBOOL ii_ctdbIsActiveTable(CTHANDLE Handle);
CTBOOL ii_ctdbIsEditedRecord(CTHANDLE Handle);
CTBOOL ii_ctdbIsExtSegment(CTSEG_MODE SegMode);
CTBOOL ii_ctdbIsLeapYear(CTDATE date);
CTBOOL ii_ctdbIsLockActive(CTHANDLE Handle);
CTBOOL ii_ctdbIsNewRecord(CTHANDLE Handle);
CTBOOL ii_ctdbIsNullField(CTHANDLE Handle, NINT FieldNbr);
CTBOOL ii_ctdbIsTransActive(CTHANDLE Handle);
CTBOOL ii_ctdbIsVariableField(CTHANDLE Handle, NINT FieldNbr);
CTBOOL ii_ctdbSuperIsExclusive(pCTDBSUPER pSuper);
CTBOOL ii_ctdbSuperIsOpen(pCTDBSUPER pSuper);
CTBOOL ii_ctdbTestBit(pUTEXT pArray, NINT BitNumber);
CTCREATE_MODE ii_ctdbGetTableCreateMode(CTHANDLE Handle);
CTDATE_TYPE ii_ctdbGetDefDateType(CTHANDLE Handle);
CTDBKEY ii_ctdbGetIndexKeyType(CTHANDLE Handle);
CTDBRET ii_ctdbGetNumberOfIndexEntries(COUNT idxno, pULONG pCount);
CTDBRET ii_ctdbGetNumberOfRecords(COUNT filnum, CTBOOL IsVarLen, pULONG pCount);
CTDBRET ii_ctdbADDREC(COUNT datno, pVOID recbuf);
CTDBRET ii_ctdbADDRES(COUNT datno, pVOID resptr, VRLEN varlen);
CTDBRET ii_ctdbADDVREC(COUNT datno, pVOID recbuf, VRLEN reclen);
CTDBRET ii_ctdbAVLFILNBR(NINT numfils, pCOUNT pDatno);
CTDBRET ii_ctdbAbort(CTHANDLE Handle);
CTDBRET ii_ctdbAddDatabase(CTHANDLE Handle, pTEXT Name, pTEXT Path);
CTDBRET ii_ctdbAddLock(pCTDBLOCK pLock, COUNT datno, LONG recbyt, CTLOCK_MODE mode);
CTDBRET ii_ctdbAddTable(CTHANDLE Handle, pTEXT Name, pTEXT Path);
CTDBRET ii_ctdbAddTableXtd(CTHANDLE Handle, pTEXT Name, pTEXT PhysicName, pTEXT Path);
CTDBRET ii_ctdbAlterTable(CTHANDLE Handle, NINT Action);
CTDBRET ii_ctdbBegin(CTHANDLE Handle);
CTDBRET ii_ctdbPrepareCommit(CTHANDLE Handle);
CTDBRET ii_ctdbBlobClear(pCTBLOB pBlob);
CTDBRET ii_ctdbBlobSet(pCTBLOB pBlob, cpVOID buffer, VRLEN size);
CTDBRET ii_ctdbBuildTargetKey(CTHANDLE Handle, CTFIND_MODE FindMode, pVOID targetkey, pVRLEN targetlen);
CTDBRET ii_ctdbCHGICON(COUNT context);
CTDBRET ii_ctdbCLRFIL(COUNT datno);
CTDBRET ii_ctdbCLSFIL(COUNT datno);
CTDBRET ii_ctdbCLSICON(COUNT context);
CTDBRET ii_ctdbCREDAT(CTHANDLE Handle, COUNT datno, pTEXT filnam, UCOUNT datlen, UCOUNT xtdsiz, COUNT filmod, LONG permmask, pTEXT groupid, pTEXT fileword);
CTDBRET ii_ctdbCREIFILX(pCTDBTABLE pTable);
CTDBRET ii_ctdbCREIFILXX(pIFIL ifilptr, pDATOBJ dodaptr, NINT nfields, pTEXT fileword, LONG permmask, pTEXT groupid, pTEXT dext, pTEXT iext);
CTDBRET ii_ctdbClearDict(pCTDBDICT pDict);
CTDBRET ii_ctdbClearField(CTHANDLE Handle, NINT FieldNbr);
CTDBRET ii_ctdbClearRecord(CTHANDLE Handle);
CTDBRET ii_ctdbClearTableSuperFile(CTHANDLE Handle);
CTDBRET ii_ctdbCloseAll(CTHANDLE Handle);
CTDBRET ii_ctdbCloseDict(pCTDBDICT pDict);
CTDBRET ii_ctdbCloseTable(CTHANDLE Handle);
CTDBRET ii_ctdbCommit(CTHANDLE Handle);
CTDBRET ii_ctdbConnect(CTHANDLE Handle, pTEXT Name);
CTDBRET ii_ctdbCopyRecordBuffer(CTHANDLE pSource, CTHANDLE pDest);
CTDBRET ii_ctdbCreateDatabase(CTHANDLE Handle, pTEXT Name, pTEXT Path);
CTDBRET ii_ctdbCreateDict(pCTDBDICT pDict, pTEXT FileName);
CTDBRET ii_ctdbCreateSession(CTHANDLE Handle, pTEXT dbengine, pTEXT userid, pTEXT password);
CTDBRET ii_ctdbCreateTable(CTHANDLE Handle, pTEXT TableName, CTCREATE_MODE CreateMode);
CTDBRET ii_ctdbCurrentDate(pCTDATE pDate);
CTDBRET ii_ctdbCurrentDateTime(pCTDATETIME pDateTime);
CTDBRET ii_ctdbCurrentTime(pCTTIME pTime);
CTDBRET ii_ctdbDELFIL(COUNT datno);
CTDBRET ii_ctdbDELREC(COUNT datno);
CTDBRET ii_ctdbDELRFIL(COUNT datno);
CTDBRET ii_ctdbDELVREC(COUNT datno);
CTDBRET ii_ctdbDateCheck(NINT year, NINT month, NINT day);
CTDBRET ii_ctdbDatePack(pCTDATE pDate, NINT year, NINT month, NINT day);
CTDBRET ii_ctdbDateTimeGetDate(CTDATETIME DateTime, pCTDATE pDate);
CTDBRET ii_ctdbDateTimeGetTime(CTDATETIME DateTime, pCTTIME pTime);
CTDBRET ii_ctdbDateTimePack(pCTDATETIME pDateTime, NINT year, NINT month, NINT day, NINT hour, NINT minute, NINT second);
CTDBRET ii_ctdbDateTimeSetDate(pCTDATETIME pDateTime, CTDATE Date);
CTDBRET ii_ctdbDateTimeSetTime(pCTDATETIME pDateTime, CTTIME Time);
CTDBRET ii_ctdbDateTimeToString(CTDATETIME DateTime, CTDATE_TYPE DateType, CTTIME_TYPE TimeType, pTEXT pStr, VRLEN size);
CTDBRET ii_ctdbDateTimeUnpack(CTDATETIME DateTime, pNINT pYear, pNINT pMonth, pNINT pDay, pNINT pHour, pNINT pMinute, pNINT pSecond);
CTDBRET ii_ctdbDateToString(CTDATE date, CTDATE_TYPE DateType, pTEXT pStr, VRLEN size);
CTDBRET ii_ctdbDateUnpack(CTDATE date, pNINT pyear, pNINT pmonth, pNINT pday);
CTDBRET ii_ctdbDelField(CTHANDLE Handle, NINT Index);
CTDBRET ii_ctdbDelFieldByName(CTHANDLE Handle, pTEXT FieldName);
CTDBRET ii_ctdbDelIndex(CTHANDLE Handle, NINT IndexNumber);
CTDBRET ii_ctdbDelLock(pCTDBLOCK pLock, COUNT datno, LONG recbyt);
CTDBRET ii_ctdbDelSegment(CTHANDLE Handle, NINT SegNumber);
CTDBRET ii_ctdbDelSegmentEx(CTHANDLE Handle);
CTDBRET ii_ctdbDeleteDatabase(CTHANDLE Handle, pTEXT Name);
CTDBRET ii_ctdbDeleteDict(pCTDBDICT pDict);
CTDBRET ii_ctdbDeleteRecord(CTHANDLE Handle);
CTDBRET ii_ctdbDeleteTable(CTHANDLE Handle, pTEXT TableName, pTEXT Password);
CTDBRET ii_ctdbDictAddAllIndex(CTHANDLE hDatabase, CTHANDLE hTable);
CTDBRET ii_ctdbDictAddDatabase(CTHANDLE hSession, pTEXT name, pTEXT path);
CTDBRET ii_ctdbDictAddIndex(CTHANDLE hDatabase, CTHANDLE hTable, NINT indexno);
CTDBRET ii_ctdbDictAddTable(CTHANDLE hDatabase, pTEXT name, pTEXT path, pTEXT fext, pTEXT mirr_name, pTEXT mirr_path, UCOUNT dict_mark);
CTDBRET ii_ctdbDictDropAllIndex(CTHANDLE hDatabase, CTHANDLE hTable);
CTDBRET ii_ctdbDictDropDatabase(CTHANDLE hSession, pTEXT name);
CTDBRET ii_ctdbDictDropIndex(CTHANDLE hDatabase, CTHANDLE hTable, pTEXT name);
CTDBRET ii_ctdbDictDropTable(CTHANDLE hDatabase, pTEXT name);
CTDBRET ii_ctdbDictFindDatabase(CTHANDLE hSession, pTEXT name, pDICTDATA pData);
CTDBRET ii_ctdbDictFindDatabaseByUID(CTHANDLE hSession, ULONG uid, pDICTDATA pData);
CTDBRET ii_ctdbDictFindIndex(CTHANDLE hDatabase, pTEXT name, pDICTDATA pData);
CTDBRET ii_ctdbDictFindIndexByUID(CTHANDLE hDatabase, ULONG uid, pDICTDATA pData);
CTDBRET ii_ctdbDictFindTable(CTHANDLE hDatabase, pTEXT name, pDICTDATA pData);
CTDBRET ii_ctdbDictFindTableByUID(CTHANDLE hDatabase, ULONG uid, pDICTDATA pData);
CTDBRET ii_ctdbDictFirstDatabase(CTHANDLE hSession, pDICTDATA pData);
CTDBRET ii_ctdbDictFirstTable(CTHANDLE hDatabase, pDICTDATA pData);
CTDBRET ii_ctdbDictGetDatabaseUID(CTHANDLE hSession, pTEXT name, pULONG puid);
CTDBRET ii_ctdbDictGetTableUID(CTHANDLE hDatabase, pTEXT name, pULONG puid);
CTDBRET ii_ctdbDictNextDatabase(CTHANDLE hSession, pDICTDATA pData);
CTDBRET ii_ctdbDictNextTable(CTHANDLE hDatabase, pDICTDATA pData);
CTDBRET ii_ctdbDictReserveIndex(CTHANDLE hDatabase, pTEXT name, pULONG puid);
CTDBRET ii_ctdbDictReserveTable(CTHANDLE hDatabase, pTEXT name, pULONG puid);
CTDBRET ii_ctdbDictUpdateIndex(CTHANDLE hDatabase, CTHANDLE hTable);
CTDBRET ii_ctdbDisconnect(CTHANDLE Handle);
CTDBRET ii_ctdbDisconnectAll(CTHANDLE Handle);
CTDBRET ii_ctdbDropDatabase(CTHANDLE Handle, pTEXT Name);
CTDBRET ii_ctdbDropTable(CTHANDLE Handle, pTEXT TableName);
CTDBRET ii_ctdbDumpDict(CTHANDLE hSession, CTHANDLE hDatabase);
CTDBRET ii_ctdbEndDebug(pCTDBDBUG hDebug);
CTDBRET ii_ctdbFINDREC(COUNT datno, COUNT idxno, pVOID target, pVOID recbuf, pLONG pOffset, NINT FindMode);
CTDBRET ii_ctdbFRESET(void);
CTDBRET ii_ctdbFileExist(pTEXT Path, pTEXT Name, pTEXT Ext);
CTDBRET ii_ctdbFindDatabase(CTHANDLE Handle, pTEXT Name, pTEXT Path, VRLEN PathSize);
CTDBRET ii_ctdbFindDatabaseByUID(CTHANDLE Handle, ULONG uid, pTEXT Name, VRLEN NameSize, pTEXT Path, VRLEN PathSize);
CTDBRET ii_ctdbFindDict(pCTDBDICT pDict, ULONG Type, ULONG Status, pTEXT Name);
CTDBRET ii_ctdbFindDictByUID(pCTDBDICT pDict, ULONG uid);
CTDBRET ii_ctdbFindRecord(CTHANDLE Handle, CTFIND_MODE FindMode);
CTBOOL  ii_ctdbLocateRecord(CTHANDLE Handle, CTLOC_MODE LocateMode);
CTDBRET ii_ctdbSetRecordCriteria(CTHANDLE Handle, CTLOC_MODE LocateMode);
CTDBRET ii_ctdbUpdateRecordCriteria(CTHANDLE Handle, CTLOC_MODE LocateMode);
CTHANDLE ii_ctdbGetBestIndex(CTHANDLE Handle, pCTDBLIST fieldNameList, CTLOC_MODE LocateMode);
CTDBRET ii_ctdbAddLocateCriteria(CTHANDLE Handle, CTSTRING LocateFieldName, CTSTRING LocateFieldValue);
CTDBRET ii_ctdbFindTable(CTHANDLE Handle, pTEXT Name, pTEXT Path, VRLEN PathSize);
CTDBRET ii_ctdbFindTableByUID(CTHANDLE Handle, ULONG uid, pTEXT Name, VRLEN NameSize, pTEXT Path, VRLEN PathSize);
CTDBRET ii_ctdbFindTarget(CTHANDLE Handle, pVOID target, CTFIND_MODE FindMode);
CTDBRET ii_ctdbFirstDatabase(CTHANDLE Handle, pTEXT Name, VRLEN NameSize, pTEXT Path, VRLEN PathSize);
CTDBRET ii_ctdbFirstDict(pCTDBDICT pDict, ULONG Type, ULONG Status);
CTDBRET ii_ctdbFirstRecord(CTHANDLE Handle);
CTDBRET ii_ctdbFirstTable(CTHANDLE Handle, pTEXT Name, VRLEN NameSize, pTEXT Path, VRLEN PathSize);
CTDBRET ii_ctdbFloatToMoney(CTFLOAT value, pCTMONEY pMoney);
CTDBRET ii_ctdbGETCURP(COUNT datno, pLONG pOffset);
CTDBRET ii_ctdbGETDODA(COUNT datno, ppDATOBJ ppDoda, pVRLEN pSize);
CTDBRET ii_ctdbGETFIL(COUNT datno, COUNT mode, pLONG pInfo);
CTDBRET ii_ctdbGETIFIL(COUNT datno, ppIFIL ppIfil, pVRLEN pSize);
CTDBRET ii_ctdbGETRES(COUNT datno, pVOID resptr, pVOID buffer, VRLEN bufsize, COUNT resmode);
CTDBRET ii_ctdbGETSCHEMA(COUNT datno, ppConvMap ppSchema, pVRLEN pSize);
CTDBRET ii_ctdbGETVLEN(COUNT datno, pVRLEN pLen);
CTDBRET ii_ctdbGetActiveDatabaseUID(CTHANDLE Handle, pULONG puid);
CTDBRET ii_ctdbGetActiveTableUID(CTHANDLE Handle, pULONG puid);
CTDBRET ii_ctdbGetDatabaseUID(CTHANDLE Handle, pTEXT Name, pULONG puid);
CTDBRET ii_ctdbGetDict(pCTDBDICT pDict, pDICTDATA pData);
CTDBRET ii_ctdbGetDictUID(pCTDBDICT pDict, pULONG puid);
CTDBRET ii_ctdbGetError(CTHANDLE Handle);
CTDBRET ii_ctdbGetFieldAsBinary(CTHANDLE Handle, NINT FieldNbr, pVOID pValue, VRLEN size);
CTDBRET ii_ctdbGetFieldAsBlob(CTHANDLE Handle, NINT FieldNbr, pCTBLOB pValue);
CTDBRET ii_ctdbGetFieldAsBool(CTHANDLE Handle, NINT FieldNbr, pCTBOOL pValue);
CTDBRET ii_ctdbGetFieldAsDate(CTHANDLE Handle, NINT FieldNbr, pCTDATE pValue);
CTDBRET ii_ctdbGetFieldAsDateTime(CTHANDLE Handle, NINT FieldNbr, pCTDATETIME pValue);
CTDBRET ii_ctdbGetFieldAsFloat(CTHANDLE Handle, NINT FieldNbr, pCTFLOAT pValue);
CTDBRET ii_ctdbGetFieldAsMoney(CTHANDLE Handle, NINT FieldNbr, pCTMONEY pValue);
CTDBRET ii_ctdbGetFieldAsSigned(CTHANDLE Handle, NINT FieldNbr, pCTSIGNED pValue);
CTDBRET ii_ctdbGetFieldAsString(CTHANDLE Handle, NINT FieldNbr, CTSTRING pValue, VRLEN size);
CTDBRET ii_ctdbGetFieldAsTime(CTHANDLE Handle, NINT FieldNbr, pCTTIME pValue);
CTDBRET ii_ctdbGetFieldAsUnsigned(CTHANDLE Handle, NINT FieldNbr, pCTUNSIGNED pValue);
CTDBRET ii_ctdbGetFieldProperties(CTHANDLE Handle, ppTEXT FieldName, pCTDBTYPE pType, pVRLEN pLength);
CTDBRET ii_ctdbGetFldx(CTHANDLE hTable);
CTDBRET ii_ctdbGetIndexNbr(CTHANDLE Handle, pVRLEN pNumber);
CTDBRET ii_ctdbGetRecordCount(CTHANDLE Handle, pULONG pCount);
CTDBRET ii_ctdbGetRecordPos(CTHANDLE Handle, pLONG pOffset);
CTDBRET ii_ctdbGetSegmentNbr(CTHANDLE Handle, pVRLEN pNumber);
CTDBRET ii_ctdbGetSessionPath(CTHANDLE Handle, pTEXT Path, VRLEN PathSize);
CTDBRET ii_ctdbGetTableUID(CTHANDLE Handle, pTEXT Name, pULONG puid);
CTDBRET ii_ctdbGetUserTag(CTHANDLE Handle, ppVOID tagptr);
CTDBRET ii_ctdbIconAdd(CTHANDLE Handle, pNINT pIcon);
CTDBRET ii_ctdbIconAlloc(CTHANDLE Handle);
CTDBRET ii_ctdbIconFree(CTHANDLE Handle);
CTDBRET ii_ctdbIconReset(CTHANDLE Handle);
CTDBRET ii_ctdbIconSwitch(CTHANDLE Handle, pNINT pIcon);
CTDBRET ii_ctdbLKISAM(COUNT mode);
CTDBRET ii_ctdbLOKREC(COUNT datno, COUNT mode, LONG recbyt);
CTDBRET ii_ctdbLastRecord(CTHANDLE Handle);
CTDBRET ii_ctdbListAdd(pCTDBLIST hList, pVOID Item);
CTDBRET ii_ctdbListClear(pCTDBLIST hList);
CTDBRET ii_ctdbListDelete(pCTDBLIST hList, NINT Index);
CTDBRET ii_ctdbListDeleteEx(pCTDBLIST hList, pVOID Item);
CTDBRET ii_ctdbListExchange(pCTDBLIST hList, NINT Index1, NINT Index2);
CTDBRET ii_ctdbListExpand(pCTDBLIST hList);
CTDBRET ii_ctdbListInsert(pCTDBLIST hList, NINT Index, pVOID Item);
CTDBRET ii_ctdbListMove(pCTDBLIST hList, NINT CurIndex, NINT NewIndex);
CTDBRET ii_ctdbListReplace(pCTDBLIST hList, NINT Index, pVOID Item);
CTDBRET ii_ctdbLock(CTHANDLE Handle, CTLOCK_MODE mode);
CTDBRET ii_ctdbLockRecord(CTHANDLE Handle, CTLOCK_MODE mode);
CTDBRET ii_ctdbLogon(CTHANDLE Handle, pTEXT dbengine, pTEXT userid, pTEXT password);
CTDBRET ii_ctdbLogout(CTHANDLE Handle);
CTDBRET ii_ctdbLongToMoney(CTSIGNED value, pCTMONEY pMoney);
CTDBRET ii_ctdbMOVREC(COUNT datno, COUNT idxno, pVOID recbuf, pLONG pOffset, NINT Direction);
CTDBRET ii_ctdbMOVSET(COUNT datno, COUNT idxno, pVOID target, pVOID recbuf, COUNT siglen, pLONG pOffset, NINT Direction);
CTDBRET ii_ctdbMoneyAdd(CTMONEY left, CTMONEY right, pCTMONEY pResult);
CTDBRET ii_ctdbMoneyDiv(CTMONEY left, CTMONEY right, pCTMONEY pResult);
CTDBRET ii_ctdbMoneyMul(CTMONEY left, CTMONEY right, pCTMONEY pResult);
CTDBRET ii_ctdbMoneySub(CTMONEY left, CTMONEY right, pCTMONEY pResult);
CTDBRET ii_ctdbMoneyToFloat(CTMONEY money, pCTFLOAT pValue);
CTDBRET ii_ctdbMoneyToLong(CTMONEY money, pCTSIGNED pValue);
CTDBRET ii_ctdbMoneyToString(CTMONEY money, pTEXT pStr, VRLEN size);
CTDBRET ii_ctdbMoveField(CTHANDLE Handle, NINT newIndex);
CTDBRET ii_ctdbNextDatabase(CTHANDLE Handle, pTEXT Name, VRLEN NameSize, pTEXT Path, VRLEN PathSize);
CTDBRET ii_ctdbNextDict(pCTDBDICT pDict, ULONG Type, ULONG Status);
CTDBRET ii_ctdbNextRecord(CTHANDLE Handle);
CTDBRET ii_ctdbNextTable(CTHANDLE Handle, pTEXT Name, VRLEN NameSize, pTEXT Path, VRLEN PathSize);
CTDBRET ii_ctdbOPNFIL(CTHANDLE Handle, COUNT datno, pTEXT filnam, COUNT filmod);
CTDBRET ii_ctdbOPNICON(COUNT datno, pCOUNT pContext);
CTDBRET ii_ctdbOPNRFILX(CTHANDLE pTable, pTEXT filnam, NINT filmod, pTEXT fileword, pTEXT dext, pCOUNT pdatno);
CTDBRET ii_ctdbOpenDict(pCTDBDICT pDict, pTEXT FileName, CTBOOL OpenExclusive);
CTDBRET ii_ctdbOpenTable(CTHANDLE Handle, pTEXT TableName, CTOPEN_MODE OpenMode);
CTDBRET ii_ctdbOpenTableByUID(CTHANDLE Handle, ULONG uid, CTOPEN_MODE OpenMode);
CTDBRET ii_ctdbPRMIIDX(pIFIL ifilptr);
CTDBRET ii_ctdbPrevRecord(CTHANDLE Handle);
CTDBRET ii_ctdbPutDict(pCTDBDICT pDict, pDICTDATA pData);
CTDBRET ii_ctdbPutFldx(CTHANDLE hTable);
CTDBRET ii_ctdbRBLIFILX(CTHANDLE Handle, pIFIL ifilptr, pTEXT datext, pTEXT idxext, LONG permmask, pTEXT groupid, pTEXT fileword);
CTDBRET ii_ctdbREDIREC(COUNT datno, LONG offset, pVOID recbuf);
CTDBRET ii_ctdbREDIVREC(COUNT datno, LONG offset, pVOID recbuf, pVRLEN pLen);
CTDBRET ii_ctdbREDVREC(COUNT datno, pVOID recbuf, VRLEN recsize);
CTDBRET ii_ctdbREGCTREE(pTEXT regid);
CTDBRET ii_ctdbRENIFIL(pIFIL ifilptr);
CTDBRET ii_ctdbRWTREC(COUNT datno, pVOID recbuf);
CTDBRET ii_ctdbRWTVREC(COUNT datno, pVOID recbuf, VRLEN reclen);
CTDBRET ii_ctdbRWTPREC(COUNT datno, pVOID recbuf, VRLEN reclen);
CTDBRET ii_ctdbReadRecord(CTHANDLE Handle);
CTDBRET ii_ctdbRecLock(pCTDBLOCK pLock, COUNT datno, LONG recbyt, CTLOCK_MODE mode);
CTDBRET ii_ctdbRecUnlock(pCTDBLOCK pLock, COUNT datno, LONG recbyt);
CTDBRET ii_ctdbRecordSetOff(CTHANDLE Handle);
CTDBRET ii_ctdbRecordSetOn(CTHANDLE Handle, NINT siglen);
CTDBRET ii_ctdbReleaseLocks(pCTDBLOCK pLock);
CTDBRET ii_ctdbReleaseTableLocks(pCTDBLOCK pLock, COUNT datno);
CTDBRET ii_ctdbRemoveDict(pCTDBDICT pDict, ULONG type, ULONG Status, pTEXT Name);
CTDBRET ii_ctdbRemoveDictByUID(pCTDBDICT pDict, ULONG uid);
CTDBRET ii_ctdbReopenDict(pCTDBDICT pDict, CTBOOL OpenExclusive);
CTDBRET ii_ctdbResetAll(CTHANDLE Handle);
CTDBRET ii_ctdbResetRecord(CTHANDLE Handle);
CTDBRET ii_ctdbRestoreSavePoint(CTHANDLE Handle, NINT SavePoint);
CTDBRET ii_ctdbSETCURI(COUNT datno, LONG offset, pVOID recbuf, VRLEN reclen);
CTDBRET ii_ctdbSWTCTREE(pTEXT regid);
CTDBRET ii_ctdbSeekRecord(CTHANDLE Handle, LONG offset);
CTDBRET ii_ctdbSetDatabaseObjptr(CTHANDLE Handle, pVOID ptr);
CTDBRET ii_ctdbSetDefDateType(CTHANDLE Handle, CTDATE_TYPE DateType);
CTDBRET ii_ctdbSetDefFloatFormat(CTHANDLE Handle, pTEXT format);
CTDBRET ii_ctdbSetDefTimeType(CTHANDLE Handle, CTTIME_TYPE TimeType);
CTDBRET ii_ctdbSetDefaultIndex(CTHANDLE Handle, NINT indexno);
CTDBRET ii_ctdbSetEditedRecord(CTHANDLE Handle, CTBOOL flag);
CTDBRET ii_ctdbSetError(CTHANDLE Handle, CTDBRET ErrorCode);
CTDBRET ii_ctdbSetFieldAsBinary(CTHANDLE Handle, NINT FieldNbr, pVOID value, VRLEN size);
CTDBRET ii_ctdbSetFieldAsBlob(CTHANDLE Handle, NINT FieldNbr, pCTBLOB pValue);
CTDBRET ii_ctdbSetFieldAsBool(CTHANDLE Handle, NINT FieldNbr, CTBOOL Value);
CTDBRET ii_ctdbSetFieldAsDate(CTHANDLE Handle, NINT FieldNbr, CTDATE Value);
CTDBRET ii_ctdbSetFieldAsDateTime(CTHANDLE Handle, NINT FieldNbr, CTDATETIME Value);
CTDBRET ii_ctdbSetFieldAsFloat(CTHANDLE Handle, NINT FieldNbr, CTFLOAT Value);
CTDBRET ii_ctdbSetFieldAsMoney(CTHANDLE Handle, NINT FieldNbr, CTMONEY Value);
CTDBRET ii_ctdbSetFieldAsSigned(CTHANDLE Handle, NINT FieldNbr, CTSIGNED Value);
CTDBRET ii_ctdbSetFieldAsString(CTHANDLE Handle, NINT FieldNbr, CTSTRING Value);
CTDBRET ii_ctdbSetFieldAsTime(CTHANDLE Handle, NINT FieldNbr, CTTIME Value);
CTDBRET ii_ctdbSetFieldAsUnsigned(CTHANDLE Handle, NINT FieldNbr, CTUNSIGNED Value);
CTDBRET ii_ctdbSetFieldLength(CTHANDLE Handle, VRLEN len);
CTDBRET ii_ctdbSetFieldName(CTHANDLE Handle, pTEXT name);
CTDBRET ii_ctdbSetFieldNullFlag(CTHANDLE Handle, CTBOOL flag);
CTDBRET ii_ctdbSetFieldPrecision(CTHANDLE Handle, NINT fprec);
CTDBRET ii_ctdbSetFieldProperties(CTHANDLE Handle, pTEXT FieldName, CTDBTYPE Type, VRLEN Length);
CTDBRET ii_ctdbSetFieldScale(CTHANDLE Handle, NINT fscale);
CTDBRET ii_ctdbSetFieldType(CTHANDLE Handle, CTDBTYPE type);
CTBOOL  ii_ctdbIsFieldNumeric(CTHANDLE Handle);
CTDBRET ii_ctdbSetIndexDuplicateFlag(CTHANDLE Handle, CTBOOL DupFlag);
CTDBRET ii_ctdbSetIndexEmptyChar(CTHANDLE Handle, NINT EmptyChar);
CTDBRET ii_ctdbSetIndexExtension(CTHANDLE Handle, pTEXT ext);
CTDBRET ii_ctdbSetIndexKeyType(CTHANDLE Handle, CTDBKEY KeyType);
CTDBRET ii_ctdbSetIndexNullFlag(CTHANDLE Handle, CTBOOL NulFlag);
CTDBRET ii_ctdbSetIndexTemporaryFlag(CTHANDLE Handle, CTBOOL TempFlag);
CTDBRET ii_ctdbSetIndexCndxExpr(CTHANDLE Handle, pTEXT conditionExpr);
CTDBRET ii_ctdbSetLockActive(pCTDBLOCK pLock, CTBOOL flag);
CTDBRET ii_ctdbSetLockMode(pCTDBLOCK pLock, CTLOCK_MODE mode);
CTDBRET ii_ctdbSetLogonOnly(CTHANDLE Handle, CTBOOL flag);
CTDBRET ii_ctdbSetNewRecord(CTHANDLE Handle, CTBOOL flag);
CTDBRET ii_ctdbSetRecordOffset(CTHANDLE Handle, LONG offset);
CTDBRET ii_ctdbSetRecordPos(CTHANDLE Handle, LONG offset);
CTDBRET ii_ctdbSetSegmentMode(CTHANDLE Handle, CTSEG_MODE SegMode);
CTDBRET ii_ctdbSetSessionParams(CTHANDLE Handle, CTSESSION_PARAM ParamType, NINT value);
CTDBRET ii_ctdbSetSessionPath(CTHANDLE Handle, pTEXT Path);
CTDBRET ii_ctdbSetTableDefaultDataExtentSize(CTHANDLE Handle, NINT size);
CTDBRET ii_ctdbSetTableDefaultIndexExtentSize(CTHANDLE Handle, NINT size);
CTDBRET ii_ctdbSetTableExtension(CTHANDLE Handle, pTEXT fExt);
CTDBRET ii_ctdbSetTableGroupid(CTHANDLE Handle, pTEXT groupid);
CTDBRET ii_ctdbSetTableObjptr(CTHANDLE Handle, pVOID ptr);
CTDBRET ii_ctdbSetTablePassword(CTHANDLE Handle, pTEXT password);
CTDBRET ii_ctdbSetTablePath(CTHANDLE Handle, pTEXT Path);
CTDBRET ii_ctdbSetTablePermission(CTHANDLE Handle, LONG permmask);
CTDBRET ii_ctdbSetTableSuperFile(CTHANDLE Handle, pCTDBSUPER pSuper);
CTDBRET ii_ctdbSetUserTag(CTHANDLE Handle, pVOID tagptr);
CTDBRET ii_ctdbStartDebug(pCTDBDBUG hDebug, pTEXT fileName);
CTDBRET ii_ctdbStringToDate(pTEXT pStr, CTDATE_TYPE DateType, pCTDATE pDate);
CTDBRET ii_ctdbStringToDateTime(pTEXT pStr, pCTDATETIME DateTime, CTDATE_TYPE DateType, CTTIME_TYPE TimeType);
CTDBRET ii_ctdbStringToMoney(pTEXT pStr, pCTMONEY pMoney);
CTDBRET ii_ctdbStringToTime(pTEXT pStr, CTTIME_TYPE TimeType, pCTTIME pTime);
CTDBRET ii_ctdbSuperClose(pCTDBSUPER pSuper);
CTDBRET ii_ctdbSuperCreate(pCTDBSUPER pSuper);
CTDBRET ii_ctdbSuperDrop(pCTDBSUPER pSuper);
CTDBRET ii_ctdbSuperOpen(pCTDBSUPER pSuper, CTBOOL exclusive);
CTDBRET ii_ctdbSuperReopen(pCTDBSUPER pSuper, CTBOOL exclusive);
CTDBRET ii_ctdbSuperSetName(pCTDBSUPER pSuper, pTEXT path, pTEXT name, pTEXT ext);
CTDBRET ii_ctdbSuperSetPath(pCTDBSUPER pSuper, pTEXT path);
CTDBRET ii_ctdbSysTime(pNINT pYear, pNINT pMonth, pNINT pDay, pNINT pHour, pNINT pMinute, pNINT pSecond);
CTDBRET ii_ctdbTFRMKEY(COUNT keyno, pVOID target);
CTDBRET ii_ctdbTimeCheck(NINT hour, NINT minute, NINT second);
CTDBRET ii_ctdbTimePack(pCTTIME pTime, NINT hour, NINT minute, NINT second);
CTDBRET ii_ctdbTimeToString(CTTIME Time, CTTIME_TYPE TimeType, pTEXT pStr, VRLEN size);
CTDBRET ii_ctdbTimeUnpack(CTTIME Time, pNINT hour, pNINT minute, pNINT second);
CTDBRET ii_ctdbUNRCTREE(pTEXT regid);
CTDBRET ii_ctdbUnlock(CTHANDLE Handle);
CTDBRET ii_ctdbUnlockDict(pCTDBDICT pDict);
CTDBRET ii_ctdbUnlockRecord(CTHANDLE Handle);
CTDBRET ii_ctdbUnlockTable(CTHANDLE Handle);
CTDBRET ii_ctdbUpdLock(pCTDBLOCK pLock, COUNT datno, LONG recbyt, CTLOCK_MODE mode);
CTDBRET ii_ctdbWriteDict(pCTDBDICT pDict);
CTDBRET ii_ctdbWriteRecord(CTHANDLE Handle);
CTDBRET ii_ctdb_FullPath(pTEXT Path, VRLEN PathSize);
CTDBRET ii_ctdb_GetFileExt(pTEXT FileName, pTEXT pExt, VRLEN ExtSize);
CTDBRET ii_ctdb_GetFileName(pTEXT FileName, pTEXT pName, VRLEN NameSize);
CTDBRET ii_ctdb_GetFilePath(pTEXT FileName, pTEXT pPath, VRLEN PathSize);
#ifdef CTDB_MIRROR
CTDBRET ii_ctdb_GetMirrorFileName(pTEXT FileName, pTEXT pName, VRLEN NameSize);
#endif
CTDBRET ii_ctdbfrmkey(COUNT idxno, pUTEXT recbuf, pTEXT key, LONG pntr, VRLEN datlen);
CTDBTYPE ii_ctdbGetFieldType(CTHANDLE Handle);
CTHANDLE ii_ctdbAddField(CTHANDLE Handle, pTEXT FieldName, CTDBTYPE FieldType, VRLEN FieldLength);
CTHANDLE ii_ctdbAddIndex(CTHANDLE Handle, pTEXT name, CTDBKEY key_type, CTBOOL AllowDuplicates, CTBOOL NullFlag);
CTHANDLE ii_ctdbAddSegment(CTHANDLE Handle, CTHANDLE FieldHandle, CTSEG_MODE SegMode);
CTHANDLE ii_ctdbAddSegmentByName(CTHANDLE Handle, NINT IndexNbr, pTEXT FieldName, CTSEG_MODE SegMode);
CTHANDLE ii_ctdbAddSegmentByNbr(CTHANDLE Handle, NINT IndexNbr, NINT FieldNbr, CTSEG_MODE SegMode);
CTHANDLE ii_ctdbAddSegmentEx(CTHANDLE Handle, NINT offset, NINT length, CTSEG_MODE SegMode);
CTHANDLE ii_ctdbAllocDatabase(CTHANDLE Handle);
CTHANDLE ii_ctdbAllocRecord(CTHANDLE Handle);
CTHANDLE ii_ctdbAllocSession(CTSESSION_TYPE SessionType);
CTHANDLE ii_ctdbAllocTable(CTHANDLE Handle);
CTHANDLE ii_ctdbDuplicateRecord(CTHANDLE Handle);
CTHANDLE ii_ctdbFindActiveDatabase(CTHANDLE Handle, pTEXT Name);
CTHANDLE ii_ctdbFindActiveDatabaseByUID(CTHANDLE Handle, ULONG uid);
CTHANDLE ii_ctdbFindActiveTable(CTHANDLE Handle, pTEXT Name);
CTHANDLE ii_ctdbFindActiveTableByUID(CTHANDLE Handle, ULONG uid);
CTHANDLE ii_ctdbGetActiveTableByUID(CTHANDLE Handle, ULONG uid);
CTHANDLE ii_ctdbGetDatabaseHandle(CTHANDLE Handle);
CTHANDLE ii_ctdbGetField(CTHANDLE Handle, NINT Index);
CTHANDLE ii_ctdbGetFieldByName(CTHANDLE Handle, pTEXT FieldName);
CTHANDLE ii_ctdbGetFieldHandle(CTHANDLE Handle);
CTHANDLE ii_ctdbGetFirstActiveDatabase(CTHANDLE Handle, pVRLEN pScanIndex);
CTHANDLE ii_ctdbGetFirstActiveTable(CTHANDLE Handle, pVRLEN pScanRec);
CTHANDLE ii_ctdbGetIndex(CTHANDLE Handle, NINT IndexNumber);
CTHANDLE ii_ctdbGetIndexByName(CTHANDLE Handle, pTEXT name);
CTHANDLE ii_ctdbGetIndexByUID(CTHANDLE Handle, ULONG uid);
CTHANDLE ii_ctdbGetIndexHandle(CTHANDLE Handle);
CTHANDLE ii_ctdbGetNextActiveDatabase(CTHANDLE Handle, pVRLEN pScanIndex);
CTHANDLE ii_ctdbGetNextActiveTable(CTHANDLE Handle, pVRLEN pScanRec);
CTHANDLE ii_ctdbGetRecord(CTHANDLE Handle, NINT index);
CTHANDLE ii_ctdbGetRecordHandle(CTHANDLE Handle);
CTHANDLE ii_ctdbGetSegment(CTHANDLE Handle, NINT SegNumber);
CTHANDLE ii_ctdbGetSegmentField(CTHANDLE Handle);
CTHANDLE ii_ctdbGetSegmentPartialField(CTHANDLE Handle);
CTHANDLE ii_ctdbGetSegmentHandle(CTHANDLE Handle);
CTHANDLE ii_ctdbGetSessionHandle(CTHANDLE Handle);
CTHANDLE ii_ctdbGetTable(CTHANDLE Handle, NINT index);
CTHANDLE ii_ctdbGetTableHandle(CTHANDLE Handle);
CTHANDLE ii_ctdbInsField(CTHANDLE Handle, NINT Index, pTEXT FieldName, CTDBTYPE FieldType, VRLEN FieldLength);
CTHANDLE ii_ctdbInsFieldByName(CTHANDLE Handle, pTEXT FieldIndex, pTEXT FieldName, CTDBTYPE FieldType, VRLEN FieldLength);
CTHANDLE ii_ctdbInsSegment(CTHANDLE Handle, NINT SegNumber, CTHANDLE FieldHandle, CTSEG_MODE SegMode);
CTHANDLE ii_ctdbInsSegmentByName(CTHANDLE Handle, NINT IndexNbr, NINT SegNumber, pTEXT FieldName, CTSEG_MODE SegMode);
CTHANDLE ii_ctdbInsSegmentByNbr(CTHANDLE Handle, NINT IndexNbr, NINT SegNumber, NINT FieldNbr, CTSEG_MODE SegMode);
CTHANDLE ii_ctdbInsSegmentEx(CTHANDLE Handle, NINT SegNumber, NINT offset, NINT length, CTSEG_MODE SegMode);
CTHANDLE ii_ctdbSelectHandle(CTHANDLE Handle, NINT HandleId);
CTLOCK_MODE ii_ctdbGetLockMode(pCTDBLOCK pLock);
CTMONEY ii_ctdbMoneyAbs(CTMONEY left);
CTOPEN_MODE ii_ctdbGetTableOpenMode(CTHANDLE Handle);
CTSEG_MODE ii_ctdbGetSegmentMode(CTHANDLE Handle);
CTTIME_TYPE ii_ctdbGetDefTimeType(CTHANDLE Handle);
LONG ii_ctdbGetTablePermission(CTHANDLE Handle);
NINT ii_ctdbDictGetDatabaseCount(CTHANDLE hSession);
NINT ii_ctdbDictGetTableCount(CTHANDLE hDatabase);
NINT ii_ctdbGetDatabaseCount(CTHANDLE Handle);
NINT ii_ctdbGetDictCount(pCTDBDICT pDict, ULONG Type, ULONG Status);
NINT ii_ctdbGetFieldNbr(CTHANDLE Handle);
NINT ii_ctdbGetFieldPrecision(CTHANDLE Handle);
NINT ii_ctdbGetFieldScale(CTHANDLE Handle);
NINT ii_ctdbGetIndexEmptyChar(CTHANDLE Handle);
NINT ii_ctdbGetIndexNbrByName(CTHANDLE Handle, pTEXT name);
NINT ii_ctdbGetRecordNbr(CTHANDLE Handle);
NINT ii_ctdbGetSessionParams(CTHANDLE Handle, CTSESSION_PARAM ParamType);
NINT ii_ctdbGetTableCount(CTHANDLE Handle);
NINT ii_ctdbGetTableDefaultDataExtentSize(CTHANDLE Handle);
NINT ii_ctdbGetTableDefaultIndexExtentSize(CTHANDLE Handle);
NINT ii_ctdbGetTableNbr(CTHANDLE Handle);
NINT ii_ctdbListCount(pCTDBLIST hList);
NINT ii_ctdbListIndexOf(pCTDBLIST hList, pVOID Item);
NINT ii_ctdbListSize(pCTDBLIST hList);
NINT ii_ctdbLocateDatabase(pCTDBSESSION pSession, pTEXT Name);
NINT ii_ctdbLocateTable(pCTDBDATABASE pDatabase, pTEXT Name);
NINT ii_ctdbLockCount(pCTDBLOCK pLock);
CTDBRET ii_ctdbGetIndexUID(CTHANDLE Handle, pTEXT Name, pULONG puid);
VRLEN ii_ctdbBlobGetSize(pCTBLOB pBlob);
VRLEN ii_ctdbGetFieldDataLength(CTHANDLE Handle, NINT FieldNbr);
VRLEN ii_ctdbGetFieldLength(CTHANDLE Handle);
NINT ii_ctdbGetFieldNumberByName(CTHANDLE Handle, pTEXT FieldName);
VRLEN ii_ctdbGetFieldOffset(CTHANDLE Handle, NINT FieldNbr);
VRLEN ii_ctdbGetFieldSize(CTHANDLE Handle, NINT FieldNbr);
VRLEN ii_ctdbGetIndexKeyLength(CTHANDLE Handle);
VRLEN ii_ctdbGetIndexSegmentCount(CTHANDLE Handle);
VRLEN ii_ctdbGetRecordLength(CTHANDLE Handle);
VRLEN ii_ctdbGetRecordSize(CTHANDLE Handle);
VRLEN ii_ctdbGetTableFieldCount(CTHANDLE Handle);
VRLEN ii_ctdbGetTableIndexCount(CTHANDLE Handle);
VRLEN ii_ctdb_lastdelimiter(pTEXT str, TEXT delimiter);
NINT ii_ctdbBlobCmp(pCTBLOB left, pCTBLOB right);
NINT ii_ctdbGetDefaultIndex(CTHANDLE Handle);
NINT ii_ctdbGetFieldNumber(CTHANDLE Handle, pTEXT FieldName);
NINT ii_ctdbGetHandleId(CTHANDLE Handle);
NINT ii_ctdbMoneyCmp(CTMONEY left, CTMONEY right);
NINT ii_ctdbSetSavePoint(CTHANDLE Handle);
NINT ii_ctdbSetSaveSinglePoint(CTHANDLE Handle);
pCTBLOB ii_ctdbBlobAlloc(VRLEN size);
pCTDBDATA ii_ctdbGetFieldData(pCTDBRECORD pRecord, NINT FieldNbr);
pCTDBDICT ii_ctdbAllocDict(CTHANDLE Handle, CTBOOL is_session);
pCTDBFIELD ii_ctdbAllocField(pCTDBTABLE pTable, pTEXT FieldName, CTDBTYPE FieldType, VRLEN FieldLength);
pCTDBFLDR ii_ctdbAllocFldx(CTHANDLE hTable);
pCTDBINDEX ii_ctdbAllocIndex(CTHANDLE Handle);
pCTDBISEG ii_ctdbAllocSegment(CTHANDLE Handle);
pCTDBLIST ii_ctdbListAlloc(void);
pCTDBLIST ii_ctdbListDup(pCTDBLIST hList);
pCTDBLIST ii_ctdbListFree(pCTDBLIST hList);
CTDBRET ii_ctdbListDeleteEx(pCTDBLIST hList, pVOID Item);
pCTDBLKI ii_ctdbFindLock(pCTDBLOCK pLock, COUNT datno, LONG recbyt);
pCTDBLKI ii_ctdbLockItem(pCTDBLOCK pLock, NINT index);
pCTDBLOCK ii_ctdbAllocLock(void);
pCTDBLOCK ii_ctdbFreeLock(pCTDBLOCK pLock);
pCTDBSUPER ii_ctdbGetTableSuperFile(CTHANDLE Handle);
pCTDBSUPER ii_ctdbSuperAlloc(CTHANDLE Handle);
pCTDBSUPER ii_ctdbSuperFree(pCTDBSUPER pSuper);
pTEXT ii_ctdbFieldTypeName(CTDBTYPE ftype);
pTEXT ii_ctdbGetDatabaseName(CTHANDLE Handle);
pTEXT ii_ctdbGetDatabasePath(CTHANDLE Handle);
pTEXT ii_ctdbGetDefFloatFormat(CTHANDLE Handle);
pTEXT ii_ctdbGetFieldName(CTHANDLE Handle);
pTEXT ii_ctdbGetIndexExtension(CTHANDLE Handle);
pTEXT ii_ctdbGetSegmentFieldName(CTHANDLE Handle);
pTEXT ii_ctdbGetServerName(CTHANDLE Handle);
pTEXT ii_ctdbGetTableExtension(CTHANDLE Handle);
pTEXT ii_ctdbGetTableGroupid(CTHANDLE Handle);
pTEXT ii_ctdbGetTableName(CTHANDLE Handle);
pTEXT ii_ctdbGetTablePassword(CTHANDLE Handle);
pTEXT ii_ctdbGetTablePath(CTHANDLE Handle);
pTEXT ii_ctdbGetUserLogonName(CTHANDLE Handle);
pTEXT ii_ctdbGetUserPassword(CTHANDLE Handle);
pTEXT ii_ctdbSuperGetName(pCTDBSUPER pSuper);
pTEXT ii_ctdb_MakeFilePath(pTEXT Path, pTEXT Name);
pTEXT ii_ctdb_stralloc(VRLEN size);
pTEXT ii_ctdb_strdup(pTEXT str);
pTEXT ii_ctdb_strlastchar(pTEXT str);
pVOID ii_ctdbBlobGetData(pCTBLOB pBlob);
pVOID ii_ctdbGetDatabaseObjptr(CTHANDLE Handle);
pVOID ii_ctdbGetFieldAddress(CTHANDLE Handle, NINT FieldNbr);
pVOID ii_ctdbGetRecordBuffer(CTHANDLE Handle);
pVOID ii_ctdbGetTableObjptr(CTHANDLE Handle);
pVOID ii_ctdbListItem(pCTDBLIST hList, NINT Index);
pVOID ii_ctdb_alloc(VRLEN size, VRLEN count);
pVOID ii_ctdb_free(pVOID ptr);
pVOID ii_ctdb_realloc(pVOID ptr, VRLEN size, VRLEN count, VRLEN newCount);
void ii_ctdbBlobFree(pCTBLOB pBlob);
void ii_ctdbClearBit(pUTEXT pArray, NINT BitNumber);
void ii_ctdbClearError(CTHANDLE Handle);
void ii_ctdbFileNameOnly(pTEXT Name);
void ii_ctdbFlipBit(pUTEXT pArray, NINT BitNumber, CTBOOL flag);
void ii_ctdbFreeDatabase(CTHANDLE Handle);
void ii_ctdbFreeDict(pCTDBDICT pDict);
void ii_ctdbFreeField(CTHANDLE Handle);
void ii_ctdbFreeIndex(CTHANDLE Handle);
void ii_ctdbFreeRecord(CTHANDLE Handle);
void ii_ctdbFreeSegment(CTHANDLE Handle);
void ii_ctdbFreeSession(CTHANDLE Handle);
void ii_ctdbFreeTable(CTHANDLE Handle);
void ii_ctdbSetBit(pUTEXT pArray, NINT BitNumber);
CTDBRET ii_ctdbCloneTable(CTHANDLE tarHandle, pTEXT tarTableName, CTHANDLE srcHandle);

#endif /* ~_CTDBAPIA_H_ */

/* end of ctdbapix.h */


