/*
 *      OFFICIAL NOTIFICATION: the following CONFIDENTIAL and PROPRIETARY 
 * 	property legend shall not be removed from this source code module 
 * 	for any reason.
 *
 *	This program is the CONFIDENTIAL and PROPRIETARY property 
 *	of FairCom(R) Corporation. Any unauthorized use, reproduction or
 *	transfer of this computer program is strictly prohibited. The 
 *      contents of this file may not be disclosed to third parties, copied or
 *      duplicated in any form, in whole or in part, without the prior written
 *      permission of the FairCom(R) Corporation.
 *
 *      Copyright (c) 1992 - 2023 FairCom Corporation.
 *	This is an unpublished work, and is subject to limited distribution and
 *	restricted disclosure only. ALL RIGHTS RESERVED.
 *
 *			RESTRICTED RIGHTS LEGEND
 *	Use, duplication, or disclosure by the Government is subject to
 *	restrictions set forth in subparagraph (c)(1)(ii) of the Rights in
 * 	Technical Data and Computer Software clause at DFARS 252.227-7013, and/or
 *      in similar or successor clauses in the FAR, DOD or NASA FAR Supplement.
 *      Unpublished rights reserved under the Copyright Laws of the United States.
 *	FairCom Corporation, 6300 West Sugar Creek Drive, Columbia, MO 65203.
 *
 *	c-treeACE(tm)	Version 12
 */

#ifndef _CTUTIL_H_
#define _CTUTIL_H_

#include "ctcboptn.h"
#include "ctcbapi.h"
#include "ctcberr.h"
#include "ctcbstdr.h"

#define INTF utlenv.intf

#define XDDEXT ((INTF == INTF_ISCOBOL) ? "iss" : "xdd")
#define XFDEXT ((INTF == INTF_ISCOBOL) ? "iss" : "xfd")

#define SIGN_ACU "ACUCOBOL-GT"
#define SIGN_MBP "MBP COBOL"
#define SIGN_DG  "Data General"
#define SIGN_IBM "IBM"
#define SIGN_MF  "Micro Focus"
#define SIGN_NCR "NCR COBOL"
#define SIGN_REA "Realia COBOL"
#define SIGN_VAX "VAX COBOL"

enum {
	INFO_PARAM=0,
	INFO_TRON,
	INFO_COMPRESS,
	INFO_FILESIZE,
	INFO_FULL
};

static cpTEXT ctutil_ksegtype[] = {
	"String",
	"Integer",
	"Float",
	"Date",
	"Time",
	"Decimal",
	"Money",
	"Logical",
	"String",
	"Bfloat",
	"LString",
	"ZString",
	"",
	"",
	"Unsigned Binary",
	"Autoincrement",
	"",
	"NumericSTS",
	"NumericSA",
	"Currency",
	"Timestamp",
	"",
	"",
	"",
	"",
	"WString",
	"WZString",
	"GUID",
	"NumericSLB",
	"NumericSLS",
	"",
	"NumericSTB",
	"Null",
	NULL
};

static cpTEXT ctutil_getinterrmsg(NINT num)
{
	NINT i;
	cpTEXT msg;

	for (i=0, msg=NULL; i<sizeof(ctcb_int_error)/sizeof(ctcb_int_error[0]); i++)
	{
		if (num == ctcb_int_error[i].num)
		{
			msg = ctcb_int_error[i].msg;
			break;
		}
	}
	return msg;
}

/*
**	ctutil commands
*/
typedef enum CTUTIL_COMMAND_ID {
	_CTINVALID = -1,
	_CTPROFILE = 0,
	_CTINFO,
	_CTPARAM,
	_CTSETPATH,
	_CTRESETFN,
	_CTTRON,
	_CTCOPY,
	_CTRENAME,
	_CTREMOVE,
	_CTCHECK,
	_CTREBUILD,
	_CTCOMPACT,
	_CTGETIMG,
	_CTMAKEIMG,
	_CTCHECKIMG,
	_CTRBLIMG,
	_CTADDIMG,
	_CTLOAD,
	_CToldLOAD,
	_CTUNLOAD,
	_CToldUNLOAD,
	_CTLOADTEXT,
	_CTUNLOADTEXT,
	_CTMAXSIZE,
	_CTSEGMENT,
	_CTSQLINFO,
	_CTSQLLINK,
	_CTSQLUNLINK,
	_CTSIGN,
	_CTXFD2XDD,
	_CTSQLCHECK,
	_CTSQLIZE,
	_CTMAKE,
	_CTCOMPRESS,
	_CTUNCOMPRESS,
	_CTCRYPTCONF,
	_CTCLONE,
	_CTDDF2XDD,
	_CTUPGRADE,
	_CTFILECOPY,
	_CTTEST,
	_CTSQLREFRESH,
	_CTFILEID,

	_CTFIX401,
	_CTFIXMAXLEN,
	_CTUNLOAD407,
	_CTADDRTGI,
	_CTFIXDUPSCAN,

	_CTRUN,

	_CTBUTIL,
	_CTBUTIL_STAT = 0,
	_CTBUTIL_CLONE,
	_CTBUTIL_COPY,
	_CTBUTIL_RENAME,
	_CTBUTIL_LOAD,
	_CTBUTIL_SAVE,
	_CTBUTIL_OPTIMIZE,
} CTUTIL_COMMAND_ID;

struct CTUTIL_COMMAND {
	const CTUTIL_COMMAND_ID id;
	pTEXT tag;
	pTEXT oldtag;
	const NINT nparms;
	const NINT nopts;
} static const ctutil_command[] = {
	/* id           tag           oldtag          mandatory,optional parameters */
	{_CTPROFILE,    "-profile",   "_ctprofile",   1,0},
	{_CTINFO,       "-info",      "_ctinfo",      1,2},
	{_CTPARAM,      "-param",     "_ctparam",     1,0},
	{_CTSETPATH,    "-setpath",   "_ctsetpath",   1,0},
	{_CTRESETFN,    "",           "_ctresetfn",   1,0},
	{_CTTRON,       "-tron",      "_cttron",      2,0},
	{_CTCOPY,       "-copy",      "_ctcopy",      2,0},
	{_CTRENAME,     "-rename",    "_ctrename",    2,1},
	{_CTREMOVE,     "-remove",    "_ctremove",    1,0},
	{_CTCHECK,      "-check",     "",             1,2},
	{_CTREBUILD,    "-rebuild",   "_ctrebuild",   1,2},
	{_CTCOMPACT,    "-compact",   "_ctcompact",   1,2},
	{_CTGETIMG,     "-getimg",    "_ctgetimg",    1,0},
	{_CTMAKEIMG,    "-makeimg",   "_ctmakeimg",   2,0},
	{_CTCHECKIMG,   "-checkimg",  "_ctcheckimg",  2,0},
	{_CTRBLIMG,     "-rblimg",    "_ctrblimg",    2,0},
	{_CTADDIMG,     "-addimg",    "",             2,0},
#ifdef ctFeatRTG_TRUNCATE_FILE
	{_CTLOAD,       "-load",      "",             2,5},
#else
	{_CTLOAD,       "-load",      "",             2,4},
#endif
	{_CToldLOAD,    "_ctload",    "_ctload",      3,1},
	{_CTUNLOAD,     "-unload",    "",             2,4},
	{_CToldUNLOAD,  "_ctunload",  "_ctunload",    2,0},
	{_CTLOADTEXT,   "-loadtext",  "_ctloadtext",  3,1},
	{_CTUNLOADTEXT, "-unloadtext","_ctunloadtext",2,0},
	{_CTMAXSIZE,    "-maxsize",   "",             2,0},
	{_CTSEGMENT,    "-segment",   "",             3,0},
	{_CTSQLINFO,    "-sqlinfo",   "",             1,2},
#ifdef ctFeatRTG_SQLLINK_SRVR
	{_CTSQLLINK,    "-sqllink",   "",             2,5},
	{_CTSQLUNLINK,  "-sqlunlink", "",             2,4},
#else
	{_CTSQLLINK,    "-sqllink",   "",             3,4},
	{_CTSQLUNLINK,  "-sqlunlink", "",             3,3},
#endif
	{_CTSIGN,       "-conv",      "-sign",        2,0},
	{_CTXFD2XDD,    "-xfd2xdd",   "",             1,1},
	{_CTSQLCHECK,   "-sqlcheck",  "",             2,2},
#ifdef ctFeatRTG_SQLLINK_SRVR
	{_CTSQLIZE,     "-sqlize",    "",             3,7},
#else
	{_CTSQLIZE,     "-sqlize",    "",             4,6},
#endif

	{_CTMAKE,       "-make",      "",             2,0},
	{_CTCOMPRESS,   "-compress",  "",             1,0},
	{_CTUNCOMPRESS, "-uncompress","",             1,0},
	{_CTCRYPTCONF,  "-cryptconf", "",             2,0},
	{_CTCLONE,      "-clone",     "",             2,0},
	{_CTDDF2XDD,    "-ddf2xdd",   "",             1,1},
	{_CTUPGRADE,    "-upgrade",   "",             1,1},
	{_CTFILECOPY,   "-filecopy",  "",             2,1},
	{_CTTEST,       "-test",      "",             0,1},
#ifdef ctFeatRTG_SQLLINK_SRVR
	{_CTSQLREFRESH, "-sqlrefresh","",             3,6},
#else
	{_CTSQLREFRESH, "-sqlrefresh","",             4,5},
#endif
	{_CTFILEID,    "-fileid",     "",             1,0}
},
ctutil_run = { _CTRUN, "-run", "", 1,0 },
ctbutil_command[] = {
	/* id             tag        mandatory,optional parameters */
	{_CTBUTIL_STAT,     "-stat", "",     1, 0},
	{_CTBUTIL_CLONE,    "-clone", "",    2, 1},
	{_CTBUTIL_COPY,     "-copy", "",     2, 0},
	{_CTBUTIL_RENAME,   "-rename", "",   2, 1},
	{_CTBUTIL_LOAD,     "-load", "",     2, 1},
	{_CTBUTIL_SAVE,     "-save", "",     2, 0},
	{_CTBUTIL_OPTIMIZE, "-optimize", "", 1, 2}
};

#define VALID_NBR_OF_ARGS ( \
	(ctutil_command[cmd].nopts) ? \
		((argc-1) >= ctutil_command[cmd].nparms && \
		(argc-1) <= (ctutil_command[cmd].nparms + ctutil_command[cmd].nopts)) \
	: \
		((argc-1) == ctutil_command[cmd].nparms) \
	)
#define CTBUTIL_VALID_ARGS(nargs, cmd) ctutil_validargs(nargs, &ctbutil_command[cmd])
static TEXT ctutil_validargs(NINT nargs, const struct CTUTIL_COMMAND *command)
{
	TEXT valid = NO;
	if (command->nopts)
		valid = ((nargs) >= command->nparms && (nargs) <= (command->nparms + command->nopts));
	else
		valid = ((nargs) == command->nparms);
	return valid;
}

#define CTUTIL_GETCOMMANDID(argv) ctutil_getcommandid(argv, ctutil_command, rtgSIZEOFARRAY(ctutil_command))
#define CTBUTIL_GETCOMMANDID(argv) ctutil_getcommandid(argv, ctbutil_command, rtgSIZEOFARRAY(ctbutil_command))
static NINT ctutil_getcommandid(pTEXT argv[], const struct CTUTIL_COMMAND command[], const NINT maxcommands)
{
	NINT i;
	NINT cmd;

	for (i=0, cmd=-1; i<maxcommands; i++)
	{
		if (!cbSTRICMP(argv[0], command[i].tag) ||
			!cbSTRICMP(argv[0], command[i].oldtag))
		{
			cmd = command[i].id;
			break;
		}
		else
		if (!cbSTRNICMP(argv[0], command[i].tag, strlen(argv[0])) ||
			!cbSTRNICMP(argv[0], command[i].oldtag, strlen(argv[0]))) {
			if (cmd < 0) {
				cmd = ctutil_command[i].id;
			} else {
				cmd = -1;
				break;
			}
		}
	}

	return(cmd);
}

static VOID ctutil_printerror(NINT logical, NINT ctree, NINT system, cpTEXT errmsg)
{
	if (logical < 0)
		fprintf(stderr, "\nInitialization error.\n");
	else
		fprintf(stderr, "\n%s.\n", ctcb_error[logical]);

	if (ctree < 0 && ctree > CTE_INTERNAL_LAST) {
		if (errmsg)
			fprintf(stderr, "%s\n", errmsg);
	}
	else if (ctree) {
		fprintf(stderr, "c-tree status (%d)(%d)\n", ctree, system);
		if (errmsg && strlen(errmsg)) {
				fprintf(stderr, "%s\n", errmsg);
		} else {
			if ((errmsg = ctutil_getinterrmsg(ctree)) != NULL)
				fprintf(stderr, "%s\n", errmsg);
		}
	}
	else if (system) {
		fprintf(stderr, "system status (%d)\n", system);
		fprintf(stderr, "%s\n", strerror(system));
	}
}

LOCAL NINT ctutil_close(CT_INIT *conn, pCT_FILE ctfile)
{
	NINT retval;

	CT_ERROR err = conn->err; /* save errors */
	retval = ctl_close(conn, ctfile);
	conn->err = err; /* restore errors */

	return retval;
}

NINT ctexec(CT_INIT *conn, NINT argc, ppTEXT argv);
NINT _ctprofile(CT_INIT *conn, pTEXT name);
NINT _ctinfo(CT_INIT *conn, pTEXT name, NINT func, ppTEXT opts);
NINT _ctsetpath(CT_INIT *conn, pTEXT name);
NINT _cttron(CT_INIT *conn, pTEXT name, pTEXT func);
NINT _ctcompress(CT_INIT *conn, NINT argc, ppTEXT argv);
NINT _ctunload(CT_INIT *conn, pTEXT name, pTEXT flat, ppTEXT opts);
#ifdef ctFeatRTG_OBSOLETE_CTUTIL_COMMANDS
NINT _ctoldunload(CT_INIT *conn, pTEXT name, pTEXT flat, NINT admin);
NINT _ctunloadtext(CT_INIT *conn, pTEXT name, pTEXT flat, NINT admin);
#endif
NINT _ctload(CT_INIT *conn, pTEXT name, pTEXT flat, ppTEXT opts);
#ifdef ctFeatRTG_OBSOLETE_CTUTIL_COMMANDS
NINT _ctoldload(CT_INIT *conn, pTEXT name, pTEXT flat, pTEXT mode, pTEXT opt);
NINT _ctloadtext(CT_INIT *conn, pTEXT name, pTEXT flat, pTEXT mode, pTEXT opt);
#endif
NINT _ctsegment(CT_INIT *conn, pTEXT name, pTEXT size, pTEXT segs);
NINT _ctsqlinfo(CT_INIT *conn, pTEXT name, pTEXT xmlfile, pTEXT signconv);
NINT _ctsqllink(CT_INIT *conn, pTEXT filname, pTEXT dbname, pTEXT adminpw, pTEXT *opts);
NINT _ctsqlunlink(CT_INIT *conn, pTEXT filname, pTEXT dbname, pTEXT adminpw, pTEXT *opts);
NINT _ctxfd2xdd(CT_INIT *conn, pTEXT xfdfile, pTEXT rules);
NINT _ctsqlcheck(CT_INIT *conn, pTEXT name, pTEXT xddfile, ppTEXT opts);
NINT _ctddf2xdd(CT_INIT *conn, pTEXT xfddir, pTEXT rules);
NINT _ctsqlize(CT_INIT *conn, pTEXT name, pTEXT xfdfile, pTEXT adminpw, pTEXT dbname, pTEXT *opts, TEXT refresh);
NINT _ctmake(CT_INIT *conn, pTEXT name, pTEXT xfdfile);
NINT _ctcryptconf(CT_INIT *conn, pTEXT cfgfile, pTEXT outfile);
NINT _ctcheck(CT_INIT *conn, pTEXT name, pTEXT *opts);
#ifdef REMOVED_noFeatCOBOL
NINT _ctbugs(CT_INIT *conn);
NINT _ctresetfn(CT_INIT *conn, pTEXT name);
#endif
NINT _cttest(CT_INIT *conn, pTEXT *opts);
NINT _ctfileid(CT_INIT *conn, pTEXT name);

#endif	/* _CTUTIL_H_ */

/* end of ctutil.h */
