/*
 *      OFFICIAL NOTIFICATION: the following CONFIDENTIAL and PROPRIETARY 
 * 	property legend shall not be removed from this source code module 
 * 	for any reason.
 *
 *	This program is the CONFIDENTIAL and PROPRIETARY property 
 *	of FairCom(R) Corporation. Any unauthorized use, reproduction or
 *	transfer of this computer program is strictly prohibited. The 
 *      contents of this file may not be disclosed to third parties, copied or
 *      duplicated in any form, in whole or in part, without the prior written
 *      permission of the FairCom(R) Corporation.
 *
 *      Copyright (c) 2013 - 2023 FairCom Corporation.
 *	This is an unpublished work, and is subject to limited distribution and
 *	restricted disclosure only. ALL RIGHTS RESERVED.
 *
 *			RESTRICTED RIGHTS LEGEND
 *	Use, duplication, or disclosure by the Government is subject to
 *	restrictions set forth in subparagraph (c)(1)(ii) of the Rights in
 * 	Technical Data and Computer Software clause at DFARS 252.227-7013, and/or
 *      in similar or successor clauses in the FAR, DOD or NASA FAR Supplement.
 *      Unpublished rights reserved under the Copyright Laws of the United States.
 *	FairCom Corporation, 6300 West Sugar Creek Drive, Columbia, MO 65203.
 *
 */

#ifndef _FCRCESACTIONQUEUE_HPP_
#define _FCRCESACTIONQUEUE_HPP_

#include "fc_rces.h"
#include "fcrcesaction.hpp"
#include "fcrcesfile.hpp"
#include "fcrcesqueueprov.hpp"
#include "fcrcesconfig.hpp"
#include "fcrceslogger.hpp"
#include "fcrcesreplplan.hpp"

/*^****************************************************************************\
*
*   RCESActionQueue
*   Recon-e-Sense notification action queue class
*
*   Manages the notification actions to be processes in a FIFO mode
*
\******************************************************************************/
class RCESActionQueue
{
	public:
		/* Constructors & destructor */
		RCESActionQueue( int osID, int agentID, pRCESMasterProvider masterProv );
		virtual ~RCESActionQueue();

		/* Public methods */
		int Push( pRCESAction action, int osID = -1, int agentID = -1 );
		int PushAndGet( pRCESAction action, int osID = -1, int agentID = -1 );
		int StartProcess(pRCESAction action);
		pRCESAction Pull();
		int Connect();
		int CleanUnproc( int replPlanID, RCESConsumerType consumerType);
		int GetOSID() { return _osID; };
		int GetAgentID() { return _agentID; };
		int GetTaskID();
		int CheckConnection();

		void SetOSID(int osID) { _osID = osID; };
		void SetAgentID(int agentID) { _agentID = agentID; };

		int SetProgress( int actionID, int progress );
		int SetError( int actionID, int errorCd, const char *errorMsg );
		int CheckAction( int actionID, char *errorMsg, int timeout = RCES_TIMEOUT );
		const char *GetErrorMsg();
		const char *GetUserErrorMsg();
		int GetErrorCode();
		pRCESActionQueueCriteria GetCriteria() { return _criteria; };

		int GetPendingAction( RCESEntityType entityType, int entityPk, int volumeID, const char *filePath, const char *fileName, 
		                      int *pendingActionID, RCESActionType *pendingActionType );
		bool CheckPendingReplAction( int replPlanID, RCESConsumerType consumerType );
		int Unlock();
		int Update( int actionID, RCESActionType newActionType, pFCParamHash newParams );
		int Remove( int actionID );
		int GetAction( int actionID, ppRCESAction action );
		int CheckGroup( pRCESAction action );
		int CancelAction( int actionID, bool checkGroup, bool onlyPending );
		int CleanUncomplete( pRCESMasterProvider masterProv, int agentID = -1 );
		int SetActionContent( int actionID, const char *content, int contentLen );
		int GetActionContent( pRCESAction action );
		pRCESMasterProvider GetMasterProvider() { return _provider->GetMasterProvider(); };

#ifdef NCTREE_FILE_SUPPORT
		int WaitParentPath( int actionID, const char *path, int timeout = RCES_TIMEOUT );
#endif

	private:
		/* Private properties */
		int _in, _out, _avl;
		pRCESQueueProvider _provider;
		int _osID;
		int _agentID;
		pRCESActionQueueCriteria _criteria;
};
/*~****************************************************************************/

/* Class type definitions */
typedef RCESActionQueue *pRCESActionQueue, **ppRCESActionQueue;

#endif /* _FCRCESACTIONQUEUE_HPP_ */