/*
 *      OFFICIAL NOTIFICATION: the following CONFIDENTIAL and PROPRIETARY
 * 	property legend shall not be removed from this source code module
 * 	for any reason.
 *
 *	This program is the CONFIDENTIAL and PROPRIETARY property
 *	of FairCom(R) Corporation. Any unauthorized use, reproduction or
 *	transfer of this computer program is strictly prohibited. The
 *      contents of this file may not be disclosed to third parties, copied or
 *      duplicated in any form, in whole or in part, without the prior written
 *      permission of the FairCom(R) Corporation.
 *
 *      Copyright (c) 2013 - 2023 FairCom Corporation.
 *	This is an unpublished work, and is subject to limited distribution and
 *	restricted disclosure only. ALL RIGHTS RESERVED.
 *
 *			RESTRICTED RIGHTS LEGEND
 *	Use, duplication, or disclosure by the Government is subject to
 *	restrictions set forth in subparagraph (c)(1)(ii) of the Rights in
 * 	Technical Data and Computer Software clause at DFARS 252.227-7013, and/or
 *      in similar or successor clauses in the FAR, DOD or NASA FAR Supplement.
 *      Unpublished rights reserved under the Copyright Laws of the United States.
 *	FairCom Corporation, 6300 West Sugar Creek Drive, Columbia, MO 65203.
 *
 */

#ifndef _FCRCESPUBLICATIONRULE_HPP_
#define _FCRCESPUBLICATIONRULE_HPP_

#include "fc_rces.h"
#include "fcaux.hpp"
#include "fcrcesaux.hpp"

extern "C" {
#include "fcrcesjson.h"
}

/*^****************************************************************************\
*
*   RCESPublicationRule
*   Recon-e-Sense publication rule class
*
\******************************************************************************/
class RCESPublicationRule
{
public:
	/* Constructors & destructor */
	RCESPublicationRule();
	RCESPublicationRule(const char *rule, RCESRuleType type);
	virtual ~RCESPublicationRule();

	/* Public services */

	/* Public methods */
	const char *GetRule() { return _rule; };
	RCESRuleType GetType() { return _type; };

	void SetRule(const char *rule);
	void SetType(RCESRuleType type) { _type = type; };

	bool Matches(const char *name, bool caseSensitive);
	bool Matches(pRCESPublicationRule rule);

private:
	/* Private properties */
	char *_rule;
	char *_upperCaseRule;
	RCESRuleType _type;
	char _upperCaseFileName[RCES_MAX_PATH+1];
	void *_regex;

	/* Private methods */
	bool _checkRegex(const char *name);
};
/*~****************************************************************************/

/* Class type definitions */
typedef RCESPublicationRule *pRCESPublicationRule, **ppRCESPublicationRule;

#endif /* _FCRCESPUBLICATIONRULE_HPP_ */