
----------
**This sample shows how to link a c-tree data files to the c-treeRTG SQL Engine**

**This sample use 2 files:**

- file1 is an indexed file with only one record definition
- filem is an indexed file with multiple record definitions

**This document uses Windows notation for batch files (.bat), use Unix notation (.sh) if testing**
**this on Unix/Linux**

----------
### Section 1: Working with CTUTIL utility

**A) How to create and load two different indexed c-tree data files from the sequential files file1.seq
     and filem.seq**

 - 1 Using a command prompt window go to the <C-tree installation folder>\Driver\ctree.iscobol\tutorials folder

 - 2 Create the file1 file

        ..\..\ctree.cobol\iscobol\ctutil -makeimg file1 00071,00071,001,01,0,003,00000

 - 3 Load data into file1 from a sequential file

        ..\..\ctree.cobol\iscobol\ctutil -load file1 file1.seq A

 - 4 Create the filem file

        ..\..\ctree.cobol\iscobol\ctutil -makeimg filem 00125,00125,001,01,0,004,00000

 - 5 Load data into filem from a sequential file

        ..\..\ctree.cobol\iscobol\ctutil -load filem filem.seq A

 **NOTE:**

        Instead of executing the previous steps you can run create.bat to create the c-tree indexed data files
   
**B) How to link c-tree data files to the c-treeRTG SQL Engine**

 - 1 Modify the ctree.conf file to set your connection settings replacing the provided defaults

 - 2 Link the c-tree data file named file1

        ..\..\ctree.cobol\iscobol\ctutil -c ctree.conf -sqlize file1 file1.iss ctreeSQL -conv=A

 - 3 Link the c-tree data file named filem

        ..\..\ctree.cobol\iscobol\ctutil -c ctree.conf -sqlize filem filem.iss ctreeSQL -conv=A

 **NOTE:**

        Instead of executing the previous steps you can run Link-File1-in-database.bat to link
        the c-tree data file named file1 and run Link-FileM-in-database.bat to link the 
        c-tree data file named filem


**B2) How to link c-tree data files to the c-treeRTG SQL Engine in read-only mode**

 - 1 Modify the ctree.conf file to set your connection settings replacing the provided defaults

 - 2 Link the c-tree data file named file1

        ..\..\ctree.cobol\iscobol\ctutil -c ctree.conf -sqlize file1 file1.iss ctreeSQL -conv=A -public=ro

 - 3 Link the c-tree data file named filem

        ..\..\ctree.cobol\iscobol\ctutil -c ctree.conf -sqlize filem filem.iss ctreeSQL -conv=A -public=ro

 **NOTE:**

        The resulting tables are read-only for all users without administrator privileges.

      
**C) How to remove the link of a c-tree data file from the c-treeRTG SQL Engine**

 - 1 Modify the ctree.conf file to set your connection settings replacing the provided defaults

 - 2 Unlink the c-tree data file named file1
   
        ..\..\ctree.cobol\iscobol\ctutil -c ctree.conf -sqlunlink file1 ctreeSQL

 - 3 Unlink the c-tree data file named filem

        ..\..\ctree.cobol\iscobol\ctutil -c ctree.conf -sqlunlink filem ctreeSQL

----------
### Section 2: Working with isCOBOL 

**A) How to create c-tree data files using a Cobol Program**

 - 1 Using a command prompt window go to the <C-tree installation folder>\Driver\ctree.iscobol\tutorials folder

 - 2 Compile the programs

        iscc -efc *.cbl

 - 3 Start the c-treeRTG SQL Engine

 - 4 Run the PROG_FILE1 program to create file1

        iscrun PROG_FILE1

 - 5 Run the PROG_MULTI program to create filem

        iscrun PROG_MULTI

**B) How to link c-tree data files to the c-treeRTG SQL Engine using the cutil**

 - 1 Repeat the steps of point B) or B2) in Section 1 above.

**B2) How to link c-tree data files to the c-treeRTG SQL Engine during the execution of your cobol program**

 - 1 Create a new configuration file (iscobol.properties)
   
 - 2 Add the following entries in the configuration file

        iscobol.file.index.server=FAIRCOMS
        iscobol.file.index.user=admin
        iscobol.file.index.password=ADMIN
        iscobol.sqlserver.iss=1
        iscobol.sqlserver.isspath=.
        iscobol.sqlserver.database=ctreeSQL
        iscobol.sqlserver.convention=A 

 **NOTE:**

        If you already have a c-treeRTG server use your connection settings 
        instead of the default settings

 - 3 Run the PROG_FILE1 program to create file1

        iscrun -c iscobol.properties PROG_FILE1

 - 4 Run the PROG_MULTI program to create filem

        iscrun -c iscobol.properties PROG_MULTI

 **NOTE:**

        The link of a c-tree data file using a cobol programs works only during the creation 
        of the file (open output cobol statement or ISMIGRATE conversion utility)

