var ffi = require('ffi-napi');
var ref = require('ref-napi');
var isWin = process.platform === "win32";

if (isWin)
        var libName = "./mtclient.dll";
else
        var libName = "./libmtclient";

var ctdb = ffi.Library(libName, {
  'ctdbAllocSession': ['pointer', ['int', ]],
  'ctdbFreeSession': ['void', ['pointer', ]],
  'ctdbLogon': ['int', ['pointer', 'string', 'string', 'string', ]],
  'ctdbLogout': ['int', ['pointer', ]],
  'ctdbGetServerName': ['string', ['pointer', ]],
  'ctdbGetUserLogonName': ['string', ['pointer', ]],
  'ctdbGetUserPassword': ['string', ['pointer', ]],
  'ctdbGetSessionParams': ['int', ['pointer', 'int', ]],
  'ctdbSetSessionParams': ['int', ['pointer', 'int', 'int', ]],
  'ctdbSetSessionSSLParams': ['int', ['pointer', 'int', 'string', ]],
  'ctdbIsSSLActive': ['int', ['pointer', ]],
  'ctdbSetSSL': ['int', ['pointer', 'int', ]],
  'ctdbIsActiveSession': ['int', ['pointer', ]],
  'ctdbGetSessionHandle': ['pointer', ['pointer', ]],
  'ctdbGetError': ['int', ['pointer', ]],
  'ctdbSetError': ['int', ['pointer', 'int', ]],
  'ctdbClearError': ['void', ['pointer', ]],
  'ctdbIsTransActive': ['int', ['pointer', ]],
  'ctdbSyncTransactionState': ['int', ['pointer', ]],
  'ctdbBegin': ['int', ['pointer', ]],
  'ctdbPrepareCommit': ['int', ['pointer', ]],
  'ctdbCommit': ['int', ['pointer', ]],
  'ctdbAbort': ['int', ['pointer', ]],
  'ctdbSetSavePoint': ['int', ['pointer', ]],
  'ctdbSetSingleSavePoint': ['int', ['pointer', ]],
  'ctdbRestoreSavePoint': ['int', ['pointer', 'int', ]],
  'ctdbClearSavePoint': ['int', ['pointer', ]],
  'ctdbGetSessionPath': ['int', ['pointer', 'string', 'long', ]],
  'ctdbSetSessionPath': ['int', ['pointer', 'string', ]],
  'ctdbFirstDatabase': ['int', ['pointer', 'string', 'long', 'string', 'long', ]],
  'ctdbNextDatabase': ['int', ['pointer', 'string', 'long', 'string', 'long', ]],
  'ctdbFindDatabase': ['int', ['pointer', 'string', 'string', 'long', ]],
  'ctdbFindDatabaseByUID': ['int', ['pointer', 'ulong', 'string', 'long', 'string', 'long', ]],
  'ctdbCreateSession': ['int', ['pointer', 'string', 'string', 'string', ]],
  'ctdbGetFirstActiveDatabase': ['pointer', ['pointer', 'pointer', ]],
  'ctdbGetNextActiveDatabase': ['pointer', ['pointer', 'pointer', ]],
  'ctdbFindActiveDatabase': ['pointer', ['pointer', 'string', ]],
  'ctdbFindActiveDatabaseByUID': ['pointer', ['pointer', 'ulong', ]],
  'ctdbSetDefFloatFormat': ['int', ['pointer', 'string', ]],
  'ctdbGetDefFloatFormat': ['string', ['pointer', ]],
  'ctdbSetLogonOnly': ['int', ['pointer', 'int', ]],
  'ctdbGetLogonOnly': ['int', ['pointer', ]],
  'ctdbGetDatabaseCount': ['int', ['pointer', ]],
  'ctdbGetUserTag': ['int', ['pointer', 'pointer', ]],
  'ctdbSetUserTag': ['int', ['pointer', 'pointer', ]],
  'ctdbIsLockActive': ['int', ['pointer', ]],
  'ctdbLock': ['int', ['pointer', 'int', ]],
  'ctdbUnlock': ['int', ['pointer', ]],
  'ctdbGetLockMode': ['int', ['pointer', ]],
  'ctdbSetTransactionIsolation': ['int', ['pointer', 'int', ]],
  'ctdbGetTransactionIsolation': ['int', ['pointer', ]],
  'ctdbSetSessionType': ['int', ['pointer', 'int', ]],
  'ctdbGetSessionType': ['int', ['pointer', ]],
  'ctdbGetLibType': ['ulong', ['pointer', ]],
  'ctdbSetKeepLock': ['int', ['pointer', 'int', ]],
  'ctdbGetKeepLock': ['int', ['pointer', ]],
  'ctdbSetCurrentNodeName': ['int', ['pointer', 'string', ]],
  'ctdbSwitchInstance': ['int', ['pointer', ]],
  'ctdbSetPathPrefix': ['int', ['pointer', 'string', ]],
  'ctdbClearPathPrefix': ['int', ['pointer', ]],
  'ctdbGetPathPrefix': ['string', ['pointer', ]],
  'ctdbGetHandleType': ['int', ['pointer', ]],
  'ctdbSetCallback': ['int', ['pointer', 'int', 'pointer', ]],
  'ctdbGetCallback': ['pointer', ['pointer', 'int', ]],
  'ctdbClearCallback': ['int', ['pointer', 'int', ]],
  'ctdbClearAllCallback': ['int', ['pointer', ]],
  'ctdbSetLocalTag': ['int', ['pointer', 'pointer', ]],
  'ctdbGetLocalTag': ['pointer', ['pointer', ]],
  'ctdbSetFieldCallback': ['int', ['pointer', 'int', 'pointer', ]],
  'ctdbIsSQLServer': ['int', ['pointer', ]],
  'ctdbGetSystemConfig': ['long', ['int', ]],
  'ctdbSetSessionExclusive': ['int', ['pointer', 'int', ]],
  'ctdbIsSessionExclusive': ['int', ['pointer', ]],
  'ctdbGetAttachMode': ['int', ['pointer', ]],
  'ctdbAttachSession': ['int', ['pointer', 'pointer', 'int', 'int', ]],
  'ctdbDetachSession': ['int', ['pointer', ]],
  'ctdbSetConfigurationFile': ['int', ['string', ]],
  'ctdbSetLicenseFile': ['int', ['string', ]],
  'ctdbStartDatabaseEngine': ['int', []],
  'ctdbStopDatabaseEngine': ['void', []],
  'ctdbAcquireSessionId': ['int', []],
  'ctdbReleaseSessionId': ['void', ['int', ]],
  'ctdbGetSessionId': ['int', ['pointer', ]],
  'ctdbSetSessionId': ['void', ['pointer', 'int', ]],
  'ctdbGetTransactionMode': ['int', ['pointer', ]],
  'ctdbSetTransactionMode': ['int', ['pointer', 'int', ]],
  'ctdbGetOperationState': ['int', ['pointer', ]],
  'ctdbSetOperationState': ['int', ['pointer', 'int', 'long', ]],
  'ctdbGetAutoCommit': ['int', ['pointer', ]],
  'ctdbSetAutoCommit': ['int', ['pointer', 'int', ]],
  'ctdbSetSqlCallBack': ['void', ['pointer', 'pointer', ]],
  'ctdbGetCtreeOWNER': ['int', []],
  'ctdbSetCtreeOWNER': ['void', ['int', ]],
  'ctdbLoadCallbackLib': ['int', ['pointer', 'string', 'string', 'int', ]],
  'ctdbUnLoadCallbackLib': ['int', ['pointer', 'int', ]],
  'ctdbBeginImpersonation': ['int', ['pointer', 'int', ]],
  'ctdbEndImpersonation': ['int', ['pointer', ]],
  'ctdbGetProductName': ['int', ['pointer', 'pointer', 'short', ]],
  'ctdbGetProductVersion': ['int', ['pointer', 'pointer', 'short', ]],
  'ctdbGetMaxConnections': ['int', ['pointer', 'pointer', ]],
  'ctdbServerDateTime': ['double', ['pointer', ]],
  'ctdbSetLocalDirectory': ['int', ['string', ]],
  'ctdbSetLogPath': ['int', ['pointer', 'string', ]],
  'ctdbSetStatusLogPath': ['int', ['pointer', 'string', ]],
  'ctdbSetTempPath': ['int', ['pointer', 'string', ]],
  'ctdbGetDatabaseHandle': ['pointer', ['pointer', ]],
  'ctdbAllocDatabase': ['pointer', ['pointer', ]],
  'ctdbFreeDatabase': ['void', ['pointer', ]],
  'ctdbConnect': ['int', ['pointer', 'string', ]],
  'ctdbDisconnect': ['int', ['pointer', ]],
  'ctdbDisconnectAll': ['int', ['pointer', ]],
  'ctdbCreateDatabase': ['int', ['pointer', 'string', 'string', ]],
  'ctdbAddDatabase': ['int', ['pointer', 'string', 'string', ]],
  'ctdbDeleteDatabase': ['int', ['pointer', 'string', ]],
  'ctdbDropDatabase': ['int', ['pointer', 'string', ]],
  'ctdbFirstTable': ['int', ['pointer', 'string', 'long', 'string', 'long', ]],
  'ctdbNextTable': ['int', ['pointer', 'string', 'long', 'string', 'long', ]],
  'ctdbFindTable': ['int', ['pointer', 'string', 'string', 'long', ]],
  'ctdbFindTableByUID': ['int', ['pointer', 'ulong', 'string', 'long', 'string', 'long', ]],
  'ctdbAddTable': ['int', ['pointer', 'string', 'string', ]],
  'ctdbAddTableXtd': ['int', ['pointer', 'string', 'string', 'string', ]],
  'ctdbAddMRTTable': ['int', ['pointer', 'string', 'string', 'uint', ]],
  'ctdbDeleteTable': ['int', ['pointer', 'string', 'string', ]],
  'ctdbDropTable': ['int', ['pointer', 'string', ]],
  'ctdbGetDatabaseUID': ['int', ['pointer', 'string', 'pointer', ]],
  'ctdbGetTableUID': ['int', ['pointer', 'string', 'pointer', ]],
  'ctdbGetDatabaseObjptr': ['pointer', ['pointer', ]],
  'ctdbSetDatabaseObjptr': ['int', ['pointer', 'pointer', ]],
  'ctdbGetFirstActiveTable': ['pointer', ['pointer', 'pointer', ]],
  'ctdbGetNextActiveTable': ['pointer', ['pointer', 'pointer', ]],
  'ctdbFindActiveTable': ['pointer', ['pointer', 'string', ]],
  'ctdbFindActiveTableByUID': ['pointer', ['pointer', 'ulong', ]],
  'ctdbGetActiveDatabaseUID': ['int', ['pointer', 'pointer', ]],
  'ctdbIsActiveDatabase': ['int', ['pointer', ]],
  'ctdbGetDatabasePath': ['string', ['pointer', ]],
  'ctdbGetDatabaseName': ['string', ['pointer', ]],
  'ctdbGetTableCount': ['int', ['pointer', ]],
  'ctdbGetActiveTableByUID': ['pointer', ['pointer', 'ulong', ]],
  'ctdbGetDefaultSqlTableOwner': ['string', ['pointer', ]],
  'ctdbSetDefaultSqlTableOwner': ['int', ['pointer', 'string', ]],
  'ctdbIsSQLDatabase': ['int', ['pointer', ]],
  'ctdbSetDatabaseExclusive': ['int', ['pointer', 'int', ]],
  'ctdbIsDatabaseExclusive': ['int', ['pointer', ]],
  'ctdbCheckSysTablesSQLInfo': ['int', ['pointer', 'pointer', 'int', ]],
  'ctdbGetTableHandle': ['pointer', ['pointer', ]],
  'ctdbAllocTable': ['pointer', ['pointer', ]],
  'ctdbFreeTable': ['void', ['pointer', ]],
  'ctdbIsActiveTable': ['int', ['pointer', ]],
  'ctdbGetTablePath': ['string', ['pointer', ]],
  'ctdbGetTableName': ['string', ['pointer', ]],
  'ctdbGetTableExtension': ['string', ['pointer', ]],
  'ctdbGetTableIndexCount': ['long', ['pointer', ]],
  'ctdbGetTableFieldCount': ['long', ['pointer', ]],
  'ctdbGetTableOpenMode': ['int', ['pointer', ]],
  'ctdbGetTableCreateMode': ['int', ['pointer', ]],
  'ctdbGetTableDefaultDataExtentSize': ['int', ['pointer', ]],
  'ctdbGetTableDefaultIndexExtentSize': ['int', ['pointer', ]],
  'ctdbSetTablePath': ['int', ['pointer', 'string', ]],
  'ctdbSetTableExtension': ['int', ['pointer', 'string', ]],
  'ctdbSetTableDefaultDataExtentSize': ['int', ['pointer', 'int', ]],
  'ctdbSetTableDefaultIndexExtentSize': ['int', ['pointer', 'int', ]],
  'ctdbCreateTable': ['int', ['pointer', 'string', 'int', ]],
  'ctdbCreateMRTTable': ['int', ['pointer', 'string', 'string', 'int', 'string', ]],
  'ctdbGetVTableInfoFromTable': ['int', ['pointer', ]],
  'ctdbAllocVTableInfo': ['pointer', ['pointer', 'ushort', ]],
  'ctdbFreeVTableInfo': ['void', ['pointer', ]],
  'ctdbRenameTable': ['int', ['pointer', 'string', 'string', ]],
  'ctdbMoveTable': ['int', ['pointer', 'string', 'string', 'string', ]],
  'ctdbOpenTable': ['int', ['pointer', 'string', 'int', ]],
  'ctdbOpenTableByUID': ['int', ['pointer', 'ulong', 'int', ]],
  'ctdbCloseTable': ['int', ['pointer', ]],
  'ctdbCloseAll': ['int', ['pointer', ]],
  'ctdbGetTablePassword': ['string', ['pointer', ]],
  'ctdbGetTableGroupid': ['string', ['pointer', ]],
  'ctdbGetIndexExtension': ['string', ['pointer', ]],
  'ctdbGetTablePermission': ['long', ['pointer', ]],
  'ctdbSetTablePassword': ['int', ['pointer', 'string', ]],
  'ctdbSetTableGroupid': ['int', ['pointer', 'string', ]],
  'ctdbSetIndexExtension': ['int', ['pointer', 'string', ]],
  'ctdbSetTablePermission': ['int', ['pointer', 'long', ]],
  'ctdbGetTableObjptr': ['pointer', ['pointer', ]],
  'ctdbSetTableObjptr': ['int', ['pointer', 'pointer', ]],
  'ctdbGetActiveTableUID': ['int', ['pointer', 'pointer', ]],
  'ctdbAlterTable': ['int', ['pointer', 'int', ]],
  'ctdbResetAll': ['int', ['pointer', ]],
  'ctdbHasNullFieldSupport': ['int', ['pointer', ]],
  'ctdbGetTableSuperFile': ['pointer', ['pointer', ]],
  'ctdbSetTableSuperFile': ['int', ['pointer', 'pointer', ]],
  'ctdbUnlockTable': ['int', ['pointer', ]],
  'ctdbGetTableNbr': ['int', ['pointer', ]],
  'ctdbGetTable': ['pointer', ['pointer', 'int', ]],
  'ctdbHasRecbyt': ['int', ['pointer', ]],
  'ctdbHasRowid': ['int', ['pointer', ]],
  'ctdbIsVTable': ['int', ['pointer', ]],
  'ctdbGetVTableNumber': ['uint', ['pointer', ]],
  'ctdbSetMRTTableFilter': ['int', ['pointer', 'string', ]],
  'ctdbGetTablePartitionIndexNbr': ['int', ['pointer', ]],
  'ctdbSetTablePartitionIndexNbr': ['int', ['pointer', 'int', ]],
  'ctdbSetTablePartitionRule': ['int', ['pointer', 'string', ]],
  'ctdbSetMRTTableDefaultIndex': ['int', ['pointer', 'int', 'pointer', 'long', 'pointer', 'long', 'int', ]],
  'ctdbPartAdminByName': ['int', ['pointer', 'string', 'int', 'pointer', ]],
  'ctdbPartAdminByKey': ['int', ['pointer', 'pointer', 'int', 'pointer', ]],
  'ctdbPartAdminByNumber': ['int', ['pointer', 'long', 'int', 'pointer', ]],
  'ctdbSetIdentityField': ['int', ['pointer', 'string', 'longlong', 'longlong', ]],
  'ctdbGetIdentityField': ['string', ['pointer', ]],
  'ctdbGetIdentityFieldDetails': ['string', ['pointer', 'pointer', 'pointer', ]],
  'ctdbGetFirstPartition': ['long', ['pointer', ]],
  'ctdbGetLastPartition': ['long', ['pointer', ]],
  'ctdbGetPadChar': ['int', ['pointer', 'string', 'string', ]],
  'ctdbSetPadChar': ['int', ['pointer', 'int', 'int', ]],
  'ctdbUpdatePadChar': ['int', ['pointer', 'int', 'int', 'int', ]],
  'ctdbUpdateCreateMode': ['int', ['pointer', 'int', ]],
  'ctdbHasDelField': ['int', ['pointer', ]],
  'ctdbGetDatno': ['int', ['pointer', ]],
  'ctdbGetIdxnoByNumber': ['int', ['pointer', 'int', ]],
  'ctdbGetIdxnoByName': ['int', ['pointer', 'string', ]],
  'ctdbRemoveTable': ['int', ['pointer', ]],
  'ctdbGetTableType': ['int', ['pointer', ]],
  'ctdbGetRebuildProgress': ['int', ['pointer', ]],
  'ctdbSystemFilterOn': ['int', ['pointer', 'int', ]],
  'ctdbSystemFilterOff': ['int', ['pointer', 'int', ]],
  'ctdbSetTableKSeg': ['int', ['pointer', 'pointer', ]],
  'ctdbGetTableKSeg': ['int', ['pointer', 'pointer', ]],
  'ctdbGetTableStatus': ['ulong', ['pointer', ]],
  'ctdbAttachTable': ['int', ['pointer', 'int', ]],
  'ctdbAttachTableXtd': ['int', ['pointer', 'int', 'int', 'pointer', 'pointer', ]],
  'ctdbDetachTable': ['int', ['pointer', ]],
  'ctdbGetTableOwner': ['string', ['pointer', ]],
  'ctdbSetTableOwner': ['int', ['pointer', 'string', ]],
  'ctdbRebuildTable': ['int', ['pointer', 'int', ]],
  'ctdbSetCallbackOnRebuild': ['short', ['pointer', 'ushort', ]],
  'ctdbAllocResource': ['pointer', ['pointer', 'ulong', 'ulong', 'string', ]],
  'ctdbFreeResource': ['int', ['pointer', ]],
  'ctdbUnlockResource': ['int', ['pointer', ]],
  'ctdbAddResource': ['int', ['pointer', 'pointer', 'long', ]],
  'ctdbDeleteResource': ['int', ['pointer', ]],
  'ctdbUpdateResource': ['int', ['pointer', 'pointer', 'long', ]],
  'ctdbFirstResource': ['int', ['pointer', 'int', ]],
  'ctdbNextResource': ['int', ['pointer', 'int', ]],
  'ctdbFindResource': ['int', ['pointer', 'ulong', 'ulong', 'int', ]],
  'ctdbFindResourceByName': ['int', ['pointer', 'string', 'int', ]],
  'ctdbIsResourceLocked': ['int', ['pointer', ]],
  'ctdbGetResourceType': ['ulong', ['pointer', ]],
  'ctdbSetResourceType': ['int', ['pointer', 'ulong', ]],
  'ctdbGetResourceNumber': ['ulong', ['pointer', ]],
  'ctdbSetResourceNumber': ['int', ['pointer', 'ulong', ]],
  'ctdbGetResourceName': ['string', ['pointer', ]],
  'ctdbSetResourceName': ['int', ['pointer', 'string', ]],
  'ctdbGetResourceDataLength': ['long', ['pointer', ]],
  'ctdbGetResourceData': ['pointer', ['pointer', ]],
  'ctdbSetResourceData': ['int', ['pointer', 'pointer', 'long', ]],
  'ctdbGetBinaryFlag': ['int', ['pointer', 'int', ]],
  'ctdbSetBinaryFlag': ['int', ['pointer', 'int', 'int', ]],
  'ctdbCloneTable': ['int', ['pointer', 'string', 'pointer', ]],
  'ctdbSetExtensionHint': ['int', ['pointer', 'int', ]],
  'ctdbGetExtensionHint': ['int', ['pointer', ]],
  'ctdbCheckRecordSchemaConversion': ['int', ['pointer', 'pointer', ]],
  'ctdbStartRecordSchemaConversion': ['int', ['pointer', ]],
  'ctdbTableHasCallback': ['int', ['pointer', ]],
  'ctdbGetRecordHandle': ['pointer', ['pointer', ]],
  'ctdbAllocRecord': ['pointer', ['pointer', ]],
  'ctdbDuplicateRecord': ['pointer', ['pointer', ]],
  'ctdbCopyRecordBuffer': ['int', ['pointer', 'pointer', ]],
  'ctdbAssignRecordBuffer': ['int', ['pointer', 'pointer', 'long', ]],
  'ctdbFreeRecord': ['void', ['pointer', ]],
  'ctdbResetRecord': ['int', ['pointer', ]],
  'ctdbFirstRecord': ['int', ['pointer', ]],
  'ctdbLastRecord': ['int', ['pointer', ]],
  'ctdbNextRecord': ['int', ['pointer', ]],
  'ctdbPrevRecord': ['int', ['pointer', ]],
  'ctdbFindTarget': ['int', ['pointer', 'pointer', 'int', ]],
  'ctdbFindRecord': ['int', ['pointer', 'int', ]],
  'ctdbLocateRecord': ['int', ['pointer', 'int', ]],
  'ctdbSetRecordCriteria': ['int', ['pointer', 'int', ]],
  'ctdbUpdateRecordCriteria': ['int', ['pointer', 'int', ]],
  'ctdbGetBestIndex': ['pointer', ['pointer', 'pointer', 'int', ]],
  'ctdbAddLocateCriteria': ['int', ['pointer', 'string', 'string', ]],
  'ctdbClearRecord': ['int', ['pointer', ]],
  'ctdbReadRecord': ['int', ['pointer', ]],
  'ctdbWriteRecord': ['int', ['pointer', ]],
  'ctdbDeleteRecord': ['int', ['pointer', ]],
  'ctdbGetRecordBuffer': ['pointer', ['pointer', ]],
  'ctdbGetRecordLength': ['long', ['pointer', ]],
  'ctdbGetRecordSize': ['long', ['pointer', ]],
  'ctdbIsNewRecord': ['int', ['pointer', ]],
  'ctdbIsEditedRecord': ['int', ['pointer', ]],
  'ctdbSetNewRecord': ['int', ['pointer', 'int', ]],
  'ctdbSetEditedRecord': ['int', ['pointer', 'int', ]],
  'ctdbSetRecordBuffer': ['int', ['pointer', 'pointer', 'long', 'ulong', ]],
  'ctdbIsNullField': ['int', ['pointer', 'int', ]],
  'ctdbGetRecordPos': ['int', ['pointer', 'pointer', ]],
  'ctdbGetRecordKeyPos': ['int', ['pointer', 'pointer', ]],
  'ctdbSetRecordPos': ['int', ['pointer', 'longlong', ]],
  'ctdbSetRecordOffset': ['int', ['pointer', 'longlong', ]],
  'ctdbSeekRecord': ['int', ['pointer', 'longlong', ]],
  'ctdbGetDefaultIndex': ['int', ['pointer', ]],
  'ctdbGetDefaultIndexName': ['string', ['pointer', ]],
  'ctdbSetDefaultIndex': ['int', ['pointer', 'int', ]],
  'ctdbSetDefaultIndexByName': ['int', ['pointer', 'string', ]],
  'ctdbGetFieldNumberByName': ['int', ['pointer', 'string', ]],
  'ctdbGetFieldAsBool': ['int', ['pointer', 'int', 'pointer', ]],
  'ctdbGetFieldAsSigned': ['int', ['pointer', 'int', 'pointer', ]],
  'ctdbGetFieldAsUnsigned': ['int', ['pointer', 'int', 'pointer', ]],
  'ctdbGetFieldAsDate': ['int', ['pointer', 'int', 'pointer', ]],
  'ctdbGetFieldAsTime': ['int', ['pointer', 'int', 'pointer', ]],
  'ctdbGetFieldAsTimeMsec': ['int', ['pointer', 'int', 'pointer', ]],
  'ctdbGetFieldAsMoney': ['int', ['pointer', 'int', 'pointer', ]],
  'ctdbGetFieldAsFloat': ['int', ['pointer', 'int', 'pointer', ]],
  'ctdbGetFieldAsDateTime': ['int', ['pointer', 'int', 'pointer', ]],
  'ctdbGetFieldAsString': ['int', ['pointer', 'int', 'string', 'long', ]],
  'ctdbGetFieldAsJSON': ['int', ['pointer', 'int', 'string', 'long', ]],
  'ctdbGetFieldAsBinary': ['int', ['pointer', 'int', 'pointer', 'long', ]],
  'ctdbGetFieldAsBlob': ['int', ['pointer', 'int', 'pointer', ]],
  'ctdbGetFieldAsBigint': ['int', ['pointer', 'int', 'pointer', ]],
  'ctdbGetFieldAsUnsignedBigint': ['int', ['pointer', 'int', 'pointer', ]],
  'ctdbGetFieldAsCurrency': ['int', ['pointer', 'int', 'pointer', ]],
  'ctdbGetFieldAsNumber': ['int', ['pointer', 'int', 'pointer', ]],
  'ctdbSetFieldAsBool': ['int', ['pointer', 'int', 'int', ]],
  'ctdbSetFieldAsSigned': ['int', ['pointer', 'int', 'long', ]],
  'ctdbSetFieldAsUnsigned': ['int', ['pointer', 'int', 'ulong', ]],
  'ctdbSetFieldAsDate': ['int', ['pointer', 'int', 'ulong', ]],
  'ctdbSetFieldAsTime': ['int', ['pointer', 'int', 'ulong', ]],
  'ctdbSetFieldAsTimeMsec': ['int', ['pointer', 'int', 'ulong', ]],
  'ctdbSetFieldAsMoney': ['int', ['pointer', 'int', 'long', ]],
  'ctdbSetFieldAsFloat': ['int', ['pointer', 'int', 'double', ]],
  'ctdbSetFieldAsDateTime': ['int', ['pointer', 'int', 'double', ]],
  'ctdbSetFieldAsString': ['int', ['pointer', 'int', 'string', ]],
  'ctdbSetFieldAsJSON': ['int', ['pointer', 'int', 'string', ]],
  'ctdbSetFieldAsBinary': ['int', ['pointer', 'int', 'pointer', 'long', ]],
  'ctdbSetFieldAsBlob': ['int', ['pointer', 'int', 'pointer', ]],
  'ctdbSetFieldAsBigint': ['int', ['pointer', 'int', 'longlong', ]],
  'ctdbSetFieldAsUnsignedBigint': ['int', ['pointer', 'int', 'ulonglong', ]],
  'ctdbSetFieldAsCurrency': ['int', ['pointer', 'int', 'longlong', ]],
  'ctdbSetFieldAsNumber': ['int', ['pointer', 'int', 'pointer', ]],
  'ctdbGetRecordCount': ['int', ['pointer', 'pointer', ]],
  'ctdbRecordSetOn': ['int', ['pointer', 'int', ]],
  'ctdbRecordSetOff': ['int', ['pointer', ]],
  'ctdbIsRecordSetOn': ['int', ['pointer', ]],
  'ctdbIsVariableField': ['int', ['pointer', 'int', ]],
  'ctdbGetFieldDataLength': ['long', ['pointer', 'int', ]],
  'ctdbGetFieldSize': ['long', ['pointer', 'int', ]],
  'ctdbGetFieldOffset': ['long', ['pointer', 'int', ]],
  'ctdbGetFieldAddress': ['pointer', ['pointer', 'int', ]],
  'ctdbClearField': ['int', ['pointer', 'int', ]],
  'ctdbLockRecord': ['int', ['pointer', 'int', ]],
  'ctdbUnlockRecord': ['int', ['pointer', ]],
  'ctdbBuildTargetKey': ['int', ['pointer', 'int', 'pointer', 'pointer', ]],
  'ctdbGetFieldData': ['pointer', ['pointer', 'int', ]],
  'ctdbGetRecordNbr': ['int', ['pointer', ]],
  'ctdbGetRecord': ['pointer', ['pointer', 'int', ]],
  'ctdbGetRowid': ['int', ['pointer', 'pointer', ]],
  'ctdbFindRowid': ['int', ['pointer', 'longlong', 'int', ]],
  'ctdbFindKey': ['int', ['pointer', 'pointer', 'int', ]],
  'ctdbRecordBlockingReadOn': ['int', ['pointer', 'long', 'string', ]],
  'ctdbIsRecordBlockingReadOn': ['int', ['pointer', ]],
  'ctdbRecordBlockingReadOff': ['int', ['pointer', ]],
  'ctdbFilterRecord': ['int', ['pointer', 'string', ]],
  'ctdbIsFilteredRecord': ['int', ['pointer', ]],
  'ctdbGetFilter': ['string', ['pointer', ]],
  'ctdbSetFilter': ['int', ['pointer', 'pointer', 'int', ]],
  'ctdbGetFilterType': ['int', ['pointer', ]],
  'ctdbGetRecordLock': ['int', ['pointer', ]],
  'ctdbCompareRecords': ['int', ['pointer', 'pointer', ]],
  'ctdbRecordAtPercentile': ['int', ['pointer', 'int', ]],
  'ctdbRecordPosAtOffset': ['int', ['pointer', 'pointer', ]],
  'ctdbEstimateSpan': ['ulonglong', ['pointer', 'pointer', 'pointer', ]],
  'ctdbRecordRangeOn': ['int', ['pointer', 'int', 'pointer', 'pointer', 'pointer', ]],
  'ctdbRecordRangeXtdOn': ['int', ['pointer', 'int', 'pointer', 'pointer', 'pointer', 'ulong', ]],
  'ctdbRecordRangeOff': ['int', ['pointer', ]],
  'ctdbIsRecordRangeOn': ['int', ['pointer', ]],
  'ctdbSwitchContext': ['int', ['pointer', ]],
  'ctdbBatchLoaded': ['long', ['pointer', ]],
  'ctdbBatchLocked': ['long', ['pointer', ]],
  'ctdbBatchTotal': ['long', ['pointer', ]],
  'ctdbBatchMode': ['ulong', ['pointer', ]],
  'ctdbEndBatch': ['int', ['pointer', ]],
  'ctdbInsertBatch': ['int', ['pointer', ]],
  'ctdbIsBatchActive': ['int', ['pointer', ]],
  'ctdbNextBatch': ['int', ['pointer', ]],
  'ctdbSetBatch': ['int', ['pointer', 'ulong', 'long', 'long', ]],
  'ctdbSetBatchFilter': ['int', ['pointer', 'string', ]],
  'ctdbSetBatchRangeOn': ['int', ['pointer', 'int', 'pointer', 'pointer', 'pointer', ]],
  'ctdbSetBatchRangeOff': ['int', ['pointer', ]],
  'ctdbGetErrorIndex': ['int', ['pointer', ]],
  'ctdbNumberOfKeyEntries': ['long', ['pointer', 'int', ]],
  'ctdbJumpToRecord': ['int', ['pointer', 'long', ]],
  'ctdbGetLastIdentity': ['int', ['pointer', 'pointer', ]],
  'ctdbParseRecordExpr': ['int', ['pointer', 'string', 'pointer', 'pointer', ]],
  'ctdbEvalExprAsSigned': ['int', ['pointer', 'int', 'pointer', ]],
  'ctdbEvalExprAsDate': ['int', ['pointer', 'int', 'pointer', ]],
  'ctdbEvalExprAsTime': ['int', ['pointer', 'int', 'pointer', ]],
  'ctdbEvalExprAsDateTime': ['int', ['pointer', 'int', 'pointer', ]],
  'ctdbEvalExprAsNumber': ['int', ['pointer', 'int', 'pointer', ]],
  'ctdbEvalExprAsString': ['int', ['pointer', 'int', 'string', 'pointer', ]],
  'ctdbAddUserDefFunc': ['int', ['pointer', 'string', 'pointer', 'int', 'pointer', 'short', ]],
  'ctdbGetActiveResultSet': ['pointer', ['pointer', ]],
  'ctdbFTSearchOn': ['int', ['pointer', 'string', 'int', ]],
  'ctdbIsFTSearchOn': ['int', ['pointer', ]],
  'ctdbFTSearchOff': ['int', ['pointer', ]],
  'ctdbGetFTSErrorDetails': ['int', ['pointer', 'pointer', 'pointer', ]],
  'ctdbAddToFieldMask': ['int', ['pointer', 'int', ]],
  'ctdbRemoveFieldMask': ['int', ['pointer', ]],
  'ctdbIsFieldMaskOn': ['int', ['pointer', ]],
  'ctdbGetIndexHandle': ['pointer', ['pointer', ]],
  'ctdbAllocIndex': ['pointer', ['pointer', ]],
  'ctdbFreeIndex': ['void', ['pointer', ]],
  'ctdbAddIndex': ['pointer', ['pointer', 'string', 'int', 'int', 'int', ]],
  'ctdbDelIndex': ['int', ['pointer', 'int', ]],
  'ctdbGetIndex': ['pointer', ['pointer', 'int', ]],
  'ctdbGetIndexNbrByName': ['int', ['pointer', 'string', ]],
  'ctdbGetIndexByName': ['pointer', ['pointer', 'string', ]],
  'ctdbGetIndexByUID': ['pointer', ['pointer', 'ulong', ]],
  'ctdbGetIndexSegmentCount': ['long', ['pointer', ]],
  'ctdbGetIndexKeyLength': ['long', ['pointer', ]],
  'ctdbGetIndexKeyType': ['int', ['pointer', ]],
  'ctdbGetIndexEmptyChar': ['int', ['pointer', ]],
  'ctdbGetIndexDuplicateFlag': ['int', ['pointer', ]],
  'ctdbGetIndexNullFlag': ['int', ['pointer', ]],
  'ctdbGetIndexTemporaryFlag': ['int', ['pointer', ]],
  'ctdbSetIndexKeyType': ['int', ['pointer', 'int', ]],
  'ctdbSetIndexEmptyChar': ['int', ['pointer', 'int', ]],
  'ctdbSetIndexDuplicateFlag': ['int', ['pointer', 'int', ]],
  'ctdbSetIndexNullFlag': ['int', ['pointer', 'int', ]],
  'ctdbSetIndexTemporaryFlag': ['int', ['pointer', 'int', ]],
  'ctdbSetIndexCndxExpr': ['int', ['pointer', 'string', ]],
  'ctdbGetIndexNbr': ['int', ['pointer', 'pointer', ]],
  'ctdbGetIndexUID': ['int', ['pointer', 'string', 'pointer', ]],
  'ctdbSetIndexFilename': ['int', ['pointer', 'string', 'string', ]],
  'ctdbGetIndexFilename': ['string', ['pointer', ]],
  'ctdbGetIdxno': ['int', ['pointer', ]],
  'ctdbSetIndexDistinctKeyCountFlag': ['int', ['pointer', 'int', ]],
  'ctdbGetIndexDistinctKeyCountFlag': ['int', ['pointer', ]],
  'ctdbSetIndexKSeg': ['int', ['pointer', 'pointer', ]],
  'ctdbGetIndexKSeg': ['int', ['pointer', 'pointer', ]],
  'ctdbGetIndexStatus': ['ulong', ['pointer', ]],
  'ctdbGetIndexName': ['string', ['pointer', ]],
  'ctdbSetIndexName': ['int', ['pointer', 'string', ]],
  'ctdbCheckIndexBackgroundLoad': ['int', ['pointer', 'pointer', ]],
  'ctdbAllocFTIDict': ['pointer', ['pointer', ]],
  'ctdbFreeFTIDict': ['void', ['pointer', ]],
  'ctdbGetFTIDictHandle': ['pointer', ['pointer', ]],
  'ctdbSetFTIDictOption': ['int', ['pointer', 'ushort', 'string', 'ulong', ]],
  'ctdbAllocFTI': ['pointer', ['pointer', ]],
  'ctdbFreeFTI': ['void', ['pointer', ]],
  'ctdbGetFTIHandle': ['pointer', ['pointer', ]],
  'ctdbAddFTI': ['pointer', ['pointer', 'string', ]],
  'ctdbAddFTIField': ['int', ['pointer', 'pointer', 'ulong', ]],
  'ctdbAddFTIFieldByName': ['int', ['pointer', 'int', 'string', 'ulong', ]],
  'ctdbGetFTI': ['pointer', ['pointer', 'int', ]],
  'ctdbDelFTI': ['int', ['pointer', 'int', ]],
  'ctdbGetTableFTICount': ['short', ['pointer', ]],
  'ctdbGetFTIStatus': ['ulong', ['pointer', ]],
  'ctdbGetFTIFieldCount': ['int', ['pointer', ]],
  'ctdbGetFTIField': ['pointer', ['pointer', 'int', ]],
  'ctdbGetFTIFieldMode': ['ulong', ['pointer', 'int', ]],
  'ctdbGetFTINbrByName': ['short', ['pointer', 'string', ]],
  'ctdbGetFTIByName': ['pointer', ['pointer', 'string', ]],
  'ctdbSetDefaultFTI': ['int', ['pointer', 'int', ]],
  'ctdbSetFTIOption': ['int', ['pointer', 'ushort', 'string', 'ulong', ]],
  'ctdbGetFTIByUID': ['pointer', ['pointer', 'ulong', ]],
  'ctdbGetFTINbr': ['int', ['pointer', 'pointer', ]],
  'ctdbGetFTIName': ['string', ['pointer', ]],
  'ctdbSetFTICndxExpr': ['int', ['pointer', 'string', ]],
  'ctdbCheckFTIBackgroundLoad': ['int', ['pointer', 'pointer', ]],
  'ctdbStartFTIBackgroundLoad': ['int', ['pointer', ]],
  'ctdbGetSegmentHandle': ['pointer', ['pointer', ]],
  'ctdbAllocSegment': ['pointer', ['pointer', ]],
  'ctdbFreeSegment': ['void', ['pointer', ]],
  'ctdbIsExtSegment': ['int', ['int', ]],
  'ctdbGetSegment': ['pointer', ['pointer', 'int', ]],
  'ctdbGetSegmentField': ['pointer', ['pointer', ]],
  'ctdbGetSegmentPartialField': ['pointer', ['pointer', ]],
  'ctdbGetSegmentFieldName': ['string', ['pointer', ]],
  'ctdbGetSegmentMode': ['int', ['pointer', ]],
  'ctdbGetSegmentLength': ['int', ['pointer', ]],
  'ctdbSetSegmentMode': ['int', ['pointer', 'int', ]],
  'ctdbGetSegmentNbr': ['int', ['pointer', 'pointer', ]],
  'ctdbAddSegment': ['pointer', ['pointer', 'pointer', 'int', ]],
  'ctdbAddSegmentEx': ['pointer', ['pointer', 'int', 'int', 'int', ]],
  'ctdbAddSegmentByNbr': ['pointer', ['pointer', 'int', 'int', 'int', ]],
  'ctdbAddSegmentByName': ['pointer', ['pointer', 'int', 'string', 'int', ]],
  'ctdbInsSegment': ['pointer', ['pointer', 'int', 'pointer', 'int', ]],
  'ctdbInsSegmentByNbr': ['pointer', ['pointer', 'int', 'int', 'int', 'int', ]],
  'ctdbInsSegmentByName': ['pointer', ['pointer', 'int', 'int', 'string', 'int', ]],
  'ctdbInsSegmentEx': ['pointer', ['pointer', 'int', 'int', 'int', 'int', ]],
  'ctdbDelSegment': ['int', ['pointer', 'int', ]],
  'ctdbDelSegmentEx': ['int', ['pointer', ]],
  'ctdbAddRowIdSegment': ['pointer', ['pointer', ]],
  'ctdbAddJSONSegment': ['pointer', ['pointer', 'pointer', 'string', 'int', 'long', ]],
  'ctdbSetKSegDefaults': ['int', ['pointer', ]],
  'ctdbSetSegmentKSeg': ['int', ['pointer', 'pointer', ]],
  'ctdbGetSegmentKSeg': ['int', ['pointer', 'pointer', ]],
  'ctdbGetJSONSegmentProperties': ['int', ['pointer', 'pointer', 'pointer', 'pointer', ]],
  'ctdbGetSegmentStatus': ['ulong', ['pointer', ]],
  'ctdbMoveSegment': ['int', ['pointer', 'int', ]],
  'ctdbSetSegmentField': ['int', ['pointer', 'pointer', ]],
  'ctdbSetJSONSegmentField': ['int', ['pointer', 'pointer', 'string', 'int', 'long', ]],
  'ctdbGetFieldHandle': ['pointer', ['pointer', ]],
  'ctdbAllocField': ['pointer', ['pointer', 'string', 'int', 'long', ]],
  'ctdbFreeField': ['void', ['pointer', ]],
  'ctdbAddField': ['pointer', ['pointer', 'string', 'int', 'long', ]],
  'ctdbInsField': ['pointer', ['pointer', 'int', 'string', 'int', 'long', ]],
  'ctdbInsFieldByName': ['pointer', ['pointer', 'string', 'string', 'int', 'long', ]],
  'ctdbDelField': ['int', ['pointer', 'int', ]],
  'ctdbDelFieldByName': ['int', ['pointer', 'string', ]],
  'ctdbMoveField': ['int', ['pointer', 'int', ]],
  'ctdbGetField': ['pointer', ['pointer', 'int', ]],
  'ctdbGetFieldByName': ['pointer', ['pointer', 'string', ]],
  'ctdbGetFieldNumber': ['int', ['pointer', 'string', ]],
  'ctdbGetFieldProperties': ['int', ['pointer', 'pointer', 'pointer', 'pointer', ]],
  'ctdbSetFieldProperties': ['int', ['pointer', 'string', 'int', 'long', ]],
  'ctdbGetFieldNbr': ['int', ['pointer', ]],
  'ctdbGetFieldName': ['string', ['pointer', ]],
  'ctdbGetFieldLength': ['long', ['pointer', ]],
  'ctdbGetFieldType': ['int', ['pointer', ]],
  'ctdbGetFieldNullFlag': ['int', ['pointer', ]],
  'ctdbGetFieldPrecision': ['int', ['pointer', ]],
  'ctdbGetFieldScale': ['int', ['pointer', ]],
  'ctdbSetFieldNullFlag': ['int', ['pointer', 'int', ]],
  'ctdbSetFieldPrecision': ['int', ['pointer', 'int', ]],
  'ctdbSetFieldScale': ['int', ['pointer', 'int', ]],
  'ctdbSetFieldName': ['int', ['pointer', 'string', ]],
  'ctdbSetFieldLength': ['int', ['pointer', 'long', ]],
  'ctdbSetFieldType': ['int', ['pointer', 'int', ]],
  'ctdbIsFieldNumeric': ['int', ['pointer', ]],
  'ctdbSetFieldDefaultValue': ['int', ['pointer', 'string', 'long', ]],
  'ctdbGetFieldDefaultValue': ['string', ['pointer', 'pointer', ]],
  'ctdbClearFieldDefaultValue': ['int', ['pointer', ]],
  'ctdbClearAllFieldDefaultValue': ['int', ['pointer', ]],
  'ctdbSetFieldDefaultDateTimeType': ['int', ['pointer', 'int', 'int', ]],
  'ctdbIsFieldDefaultValueSet': ['int', ['pointer', ]],
  'ctdbGetFieldDefaultDateType': ['int', ['pointer', ]],
  'ctdbGetFieldDefaultTimeType': ['int', ['pointer', ]],
  'ctdbGetFieldDefaultValueAsBinary': ['int', ['pointer', 'string', 'pointer', ]],
  'ctdbGetFieldStatus': ['ulong', ['pointer', ]],
  'ctdbGetFieldBinaryFlag': ['int', ['pointer', ]],
  'ctdbSetFieldBinaryFlag': ['int', ['pointer', 'int', ]],
  'ctdbAddVirtualField': ['pointer', ['pointer', 'string', 'int', 'long', 'pointer', ]],
  'ctdbSetVirtualFieldClear': ['int', ['pointer', 'pointer', ]],
  'ctdbDateCheck': ['int', ['int', 'int', 'int', ]],
  'ctdbDatePack': ['int', ['pointer', 'int', 'int', 'int', ]],
  'ctdbDateUnpack': ['int', ['ulong', 'pointer', 'pointer', 'pointer', ]],
  'ctdbDateToString': ['int', ['ulong', 'int', 'string', 'long', ]],
  'ctdbStringToDate': ['int', ['string', 'int', 'pointer', ]],
  'ctdbGetDay': ['int', ['ulong', ]],
  'ctdbGetMonth': ['int', ['ulong', ]],
  'ctdbGetYear': ['int', ['ulong', ]],
  'ctdbIsLeapYear': ['int', ['ulong', ]],
  'ctdbDayOfWeek': ['int', ['ulong', ]],
  'ctdbGetDefDateType': ['int', ['pointer', ]],
  'ctdbSetDefDateType': ['int', ['pointer', 'int', ]],
  'ctdbCurrentDate': ['int', ['pointer', ]],
  'ctdbStringFormatToDate': ['int', ['string', 'string', 'pointer', 'ulong', ]],
  'ctdbDateToStringFormat': ['int', ['ulong', 'string', 'string', 'ulong', ]],
  'ctdbStringFormatToTime': ['int', ['string', 'string', 'pointer', ]],
  'ctdbStringFormatToTimeMsec': ['int', ['string', 'string', 'pointer', ]],
  'ctdbTimeToStringFormat': ['int', ['ulong', 'string', 'string', ]],
  'ctdbTimeMsecToStringFormat': ['int', ['ulong', 'string', 'string', ]],
  'ctdbStringFormatToDateTime': ['int', ['string', 'string', 'pointer', 'ulong', ]],
  'ctdbDateTimeToStringFormat': ['int', ['double', 'string', 'string', 'ulong', ]],
  'ctdbTimeCheck': ['int', ['int', 'int', 'int', ]],
  'ctdbTimeCheckMsec': ['int', ['int', 'int', 'int', 'int', ]],
  'ctdbTimePack': ['int', ['pointer', 'int', 'int', 'int', ]],
  'ctdbTimeUnpack': ['int', ['ulong', 'pointer', 'pointer', 'pointer', ]],
  'ctdbTimePackMsec': ['int', ['pointer', 'int', 'int', 'int', 'int', ]],
  'ctdbTimeUnpackMsec': ['int', ['ulong', 'pointer', 'pointer', 'pointer', 'pointer', ]],
  'ctdbTimeToString': ['int', ['ulong', 'int', 'string', 'long', ]],
  'ctdbStringToTime': ['int', ['string', 'int', 'pointer', ]],
  'ctdbTimeMsecToString': ['int', ['ulong', 'int', 'string', 'long', ]],
  'ctdbStringToTimeMsec': ['int', ['string', 'int', 'pointer', ]],
  'ctdbGetHour': ['int', ['ulong', ]],
  'ctdbGetMinute': ['int', ['ulong', ]],
  'ctdbGetSecond': ['int', ['ulong', ]],
  'ctdbGetDefTimeType': ['int', ['pointer', ]],
  'ctdbSetDefTimeType': ['int', ['pointer', 'int', ]],
  'ctdbCurrentTime': ['int', ['pointer', ]],
  'ctdbDateTimePack': ['int', ['pointer', 'int', 'int', 'int', 'int', 'int', 'int', ]],
  'ctdbDateTimeUnpack': ['int', ['double', 'pointer', 'pointer', 'pointer', 'pointer', 'pointer', 'pointer', ]],
  'ctdbDateTimePackMsec': ['int', ['pointer', 'int', 'int', 'int', 'int', 'int', 'int', 'int', ]],
  'ctdbDateTimeUnpackMsec': ['int', ['double', 'pointer', 'pointer', 'pointer', 'pointer', 'pointer', 'pointer', 'pointer', ]],
  'ctdbDateTimeGetDate': ['int', ['double', 'pointer', ]],
  'ctdbDateTimeGetTime': ['int', ['double', 'pointer', ]],
  'ctdbDateTimeGetTimeMsec': ['int', ['double', 'pointer', ]],
  'ctdbDateTimeSetDate': ['int', ['pointer', 'ulong', ]],
  'ctdbDateTimeSetTime': ['int', ['pointer', 'ulong', ]],
  'ctdbDateTimeSetTimeMsec': ['int', ['pointer', 'ulong', ]],
  'ctdbDateTimeToString': ['int', ['double', 'int', 'int', 'string', 'long', ]],
  'ctdbStringToDateTime': ['int', ['string', 'pointer', 'int', 'int', ]],
  'ctdbCurrentDateTime': ['int', ['pointer', ]],
  'ctdbCurrentDateTimeUTC': ['int', ['pointer', ]],
  'ctdbCurrentTimestamp': ['int', ['pointer', ]],
  'ctdbMoneyToLong': ['int', ['long', 'pointer', ]],
  'ctdbLongToMoney': ['int', ['long', 'pointer', ]],
  'ctdbMoneyToFloat': ['int', ['long', 'pointer', ]],
  'ctdbFloatToMoney': ['int', ['double', 'pointer', ]],
  'ctdbMoneyToString': ['int', ['long', 'string', 'long', ]],
  'ctdbStringToMoney': ['int', ['string', 'pointer', ]],
  'ctdbMoneyAdd': ['int', ['long', 'long', 'pointer', ]],
  'ctdbMoneySub': ['int', ['long', 'long', 'pointer', ]],
  'ctdbMoneyMul': ['int', ['long', 'long', 'pointer', ]],
  'ctdbMoneyDiv': ['int', ['long', 'long', 'pointer', ]],
  'ctdbMoneyCmp': ['int', ['long', 'long', ]],
  'ctdbMoneyAbs': ['long', ['long', ]],
  'ctdbBlobAlloc': ['pointer', ['long', ]],
  'ctdbBlobFree': ['void', ['pointer', ]],
  'ctdbBlobGetData': ['pointer', ['pointer', ]],
  'ctdbBlobGetSize': ['long', ['pointer', ]],
  'ctdbBlobSet': ['int', ['pointer', 'pointer', 'long', ]],
  'ctdbBlobCmp': ['int', ['pointer', 'pointer', ]],
  'ctdbBlobClear': ['int', ['pointer', ]],
  'ctdbBigIntToLong': ['int', ['longlong', 'pointer', ]],
  'ctdbLongToBigInt': ['int', ['long', 'pointer', ]],
  'ctdbBigIntToFloat': ['int', ['longlong', 'pointer', ]],
  'ctdbFloatToBigInt': ['int', ['double', 'pointer', ]],
  'ctdbBigIntToString': ['int', ['longlong', 'string', 'int', ]],
  'ctdbUnsignedBigIntToString': ['int', ['ulonglong', 'string', 'int', ]],
  'ctdbStringToBigInt': ['int', ['string', 'pointer', ]],
  'ctdbStringToUnsignedBigInt': ['int', ['string', 'pointer', ]],
  'ctdbMoneyToCurrency': ['int', ['long', 'pointer', ]],
  'ctdbCurrencyToMoney': ['int', ['longlong', 'pointer', ]],
  'ctdbCurrencyToLong': ['int', ['longlong', 'pointer', ]],
  'ctdbLongToCurrency': ['int', ['long', 'pointer', ]],
  'ctdbCurrencyToBigInt': ['int', ['longlong', 'pointer', ]],
  'ctdbBigIntToCurrency': ['int', ['longlong', 'pointer', ]],
  'ctdbCurrencyToFloat': ['int', ['longlong', 'pointer', ]],
  'ctdbFloatToCurrency': ['int', ['double', 'pointer', ]],
  'ctdbCurrencyToString': ['int', ['longlong', 'string', 'long', ]],
  'ctdbStringToCurrency': ['int', ['string', 'pointer', ]],
  'ctdbCurrencyAdd': ['int', ['longlong', 'longlong', 'pointer', ]],
  'ctdbCurrencySub': ['int', ['longlong', 'longlong', 'pointer', ]],
  'ctdbCurrencyMul': ['int', ['longlong', 'longlong', 'pointer', ]],
  'ctdbCurrencyDiv': ['int', ['longlong', 'longlong', 'pointer', ]],
  'ctdbCurrencyCmp': ['int', ['longlong', 'longlong', ]],
  'ctdbCurrencyAbs': ['longlong', ['longlong', ]],
  'ctdbCurrencyRound': ['int', ['pointer', 'int', ]],
  'ctdbMoneyToNumber': ['int', ['long', 'pointer', ]],
  'ctdbNumberToMoney': ['int', ['pointer', 'pointer', ]],
  'ctdbNumberToLong': ['int', ['pointer', 'pointer', ]],
  'ctdbLongToNumber': ['int', ['long', 'pointer', ]],
  'ctdbNumberToBigInt': ['int', ['pointer', 'pointer', ]],
  'ctdbNumberToUnsignedBigInt': ['int', ['pointer', 'pointer', ]],
  'ctdbBigIntToNumber': ['int', ['longlong', 'pointer', ]],
  'ctdbNumberToCurrency': ['int', ['pointer', 'pointer', ]],
  'ctdbCurrencyToNumber': ['int', ['longlong', 'pointer', ]],
  'ctdbNumberToFloat': ['int', ['pointer', 'pointer', ]],
  'ctdbFloatToNumber': ['int', ['double', 'pointer', ]],
  'ctdbNumberToString': ['int', ['pointer', 'string', 'long', ]],
  'ctdbStringToNumber': ['int', ['string', 'pointer', ]],
  'ctdbNumberAdd': ['int', ['pointer', 'pointer', 'pointer', ]],
  'ctdbNumberSub': ['int', ['pointer', 'pointer', 'pointer', ]],
  'ctdbNumberMul': ['int', ['pointer', 'pointer', 'pointer', ]],
  'ctdbNumberDiv': ['int', ['pointer', 'pointer', 'pointer', ]],
  'ctdbNumberZero': ['int', ['pointer', ]],
  'ctdbIsNumberZero': ['int', ['pointer', ]],
  'ctdbNumberCmp': ['int', ['pointer', 'pointer', ]],
  'ctdbNumberAbs': ['int', ['pointer', 'pointer', ]],
  'ctdbNumberNegate': ['int', ['pointer', 'pointer', ]],
  'ctdbNumberCopy': ['int', ['pointer', 'pointer', ]],
  'ctdbNumberRound': ['int', ['pointer', 'int', ]],
  'ctdbNumberGetDecimal': ['int', ['pointer', 'pointer', 'pointer', ]],
  'ctdbGetResultSetHandle': ['pointer', ['pointer', ]],
  'ctdbAllocateResultSet': ['pointer', ['pointer', 'string', ]],
  'ctdbFreeResultSet': ['void', ['pointer', ]],
  'ctdbResultSetOnOff': ['int', ['pointer', 'pointer', 'int', 'int', 'int', ]],
  'ctdbGetResultSetByName': ['pointer', ['pointer', 'string', ]],
  'ctdbGetResultSetCriHandle': ['pointer', ['pointer', ]],
  'ctdbAddCriteria': ['pointer', ['pointer', 'pointer', 'string', 'string', 'int', ]],
  'ctdbRemoveCriteria': ['int', ['pointer', 'pointer', ]],
  'ctdbUpdateCriteria': ['int', ['pointer', 'string', 'string', ]],
  'ctdbSetFieldStringEncoding': ['int', ['pointer', 'string', ]],
  'ctdbGetFieldStringEncoding': ['string', ['pointer', ]],
  'ctdbIsPrimaryServer': ['int', ['pointer', ]],
  'ctdbGetFailOverState': ['int', ['pointer', ]],
  'ctdbResetFailOverState': ['void', ['pointer', ]],
  'ctdbSetCommProtocolOption': ['int', ['int', 'string', ]],
  'ctdbSetClientLibraryOption': ['int', ['int', 'string', ]],
});


for( func in ctdb ) {
  if(func.startsWith("ctdb")) {
    ctdb[func.substring(4)] = ctdb[func]; // add a reference without the ctdb prefix.
  }
}

module.exports = ctdb;
module.exports.CTDBRET_OK = 0;

function extendNullFunction(name, errMsg) {
  var f = module.exports[name];
  module.exports[name] = function(...args) { var ret = f(...args); if (ret == null) throw errMsg; return ret; }
}
function extendOkFunction(name, errMsg) {
  var f = module.exports[name];
  var ok = module.exports.CTDBRET_OK;
  module.exports[name] = function(...args) { var ret = f(...args); if (ret != ok) throw errMsg + ret; return ret; }
}

// This next section adds exception throwing to the most important functions.
// It only adds it for the function references without the ctdb prefix
// This way a user can use the original function if he wants to use the version without
// exception throwing.
extendNullFunction("AllocSession", "could not allocate a new CTDB session.");
extendOkFunction("Logon", "could not logon: ");
extendNullFunction("AllocDatabase", "could not allocate database.");
extendOkFunction("Connect", "could not connect: ");
extendNullFunction("AllocTable", "could not allocate table.");
extendOkFunction("OpenTable", "could not open table: ");
extendOkFunction("CloseTable", "could not close table: ");
extendOkFunction("Logout", "could not logout: ");
extendNullFunction("AddField", "could not add field.");
extendOkFunction("DeleteRecord", "could not relete record: ");
//extendOkFunction("FirstRecord", "could not go to first record: ");

module.exports.CTSESSION_CTDB = 0;
module.exports.CTSESSION_CTREE = 1;
module.exports.CTSESSION_SQL   = 2;
module.exports.CTSESSION_SQLINTERNAL = 3; /* for SQL engine internal use only */
module.exports.CTSESSION_SERVER = 4; /* for SERVER side internal use only */
module.exports.CTSESSION_SRVR_SQLIMP = 5; /* for SERVER side internal use only in SQLIMP logic*/

module.exports.CTOPEN_NORMAL	= 0;
module.exports.CTOPEN_EXCLUSIVE	= 1;
module.exports.CTOPEN_PERMANENT	= 2;
module.exports.CTOPEN_CORRUPT	= 4;
module.exports.CTOPEN_CHECKLOCK	= 8;
module.exports.CTOPEN_CHECKREAD	= 16;
module.exports.CTOPEN_READONLY	= 32;
module.exports.CTOPEN_DATAONLY	= 64;
module.exports.CTOPEN_UNLOCKONCLOSE	= 128;

module.exports.CTCREATE_NORMAL = 0;
module.exports.CTCREATE_PREIMG		= 0x00000001;
module.exports.CTCREATE_TRNLOG		= 0x00000002;
module.exports.CTCREATE_WRITETHRU	= 0x00000004;
module.exports.CTCREATE_CHECKLOCK	= 0x00000008;
module.exports.CTCREATE_VRLEN		= 0x00000010;
module.exports.CTCREATE_NORECBYT	= 0x00000020;
module.exports.CTCREATE_NOROWID	= 0x00000040;
module.exports.CTCREATE_CHECKREAD	= 0x00000080;
module.exports.CTCREATE_HUGEFILE	= 0x00000100;
module.exports.CTCREATE_NODELFLD	= 0x00000200;
module.exports.CTCREATE_NONULFLD	= 0x00000400;
module.exports.CTCREATE_PARTAUTO	= 0x00000800; /* partitioned table */
module.exports.CTCREATE_V8DELFLD	= 0x00001000; /* create the table using sizeof(LONG)(4) bytes delfld size as it was in v9 and previous*/
module.exports.CTCREATE_COMPRESS	= 0x00002000; /* create table using data compression */
module.exports.CTCREATE_NOFLUSH	= 0x00004000; /* for non TRNLOG files, disbale disk flushing */
module.exports.CTCREATE_DYNPARTHOST	= 0x00008000; /* create the table as a dynamic partition host */
module.exports.CTCREATE_FLEXREC	= 0x00010000;  /* use flexible record format */
module.exports.CTCREATE_BLOCKCOMPRESSDAT = 0x00020000; /* create data file with block compression */
module.exports.CTCREATE_BLOCKCOMPRESSIDX = 0x00040000; /* create indexes with block compression */
module.exports.CTCREATE_AUTOMKDIR = 0x00080000;  /* create directories if needed */
module.exports.CTCREATE_NOCLSADD = 0x00100000;

module.exports.END_OF_FILE = 101;

module.exports.CT_STRING = (18 << 3) + 2;
module.exports.CT_FSTRING = (18 << 3);

module.exports.CTDB_CLIOPT_BROADCAST_READ	= 1;
module.exports.CTDB_CLIOPT_BROADCAST_DEBUG	= 2;
module.exports.CTDB_CLIOPT_BROADCAST_PORT = 3;

module.exports.CTDB_COMMOPT_FSSLTCP_SERVER_CERTIFICATE	= 1;
module.exports.CTDB_COMMOPT_FSSLTCP_DEBUG_LOG = 2;
module.exports.CTDB_COMMOPT_WRITES_ALLOWED	= 3;
module.exports.CTDB_COMMOPT_SOCKET_TIMEOUT	= 4;
module.exports.CTDB_COMMOPT_SOCKET_WAIT_INTERVAL = 5;
module.exports.CTDB_COMMOPT_FCTHREADS = 6;
