import ctypes 
import os,sys
import binascii
import datetime
import platform

# __all__ = ['CtreeSql', 'Error']

if sys.version_info < (3,4,0):
    raise Exception("Python version 3.4 and later is required by this module.  You are running version %s.%s.%s." % (str(sys.version_info.major),str(sys.version_info.minor),str(sys.version_info.micro)))

from decimal import Decimal

connectionHandle = ctypes.c_void_p
commandHandle = ctypes.c_void_p
cursorHandle = ctypes.c_void_p
ctsqlret = ctypes.c_int32
ctsqltype = ctypes.c_int16
_integer = ctypes.c_int32
_uinteger = ctypes.c_uint32
_smallint = ctypes.c_int16


shortpl = platform.system()
if shortpl == 'Windows':
    dllPath = "mtclient.dll"
    try:
      _ctdbsdk = ctypes.CDLL(dllPath)
    except Exception as e:
      print("\nError loading DLL at the top of pyctdbsdk.py. [%s]." % (str(e)))
elif shortpl == 'Darwin':
    # MacOS
    libPath = "libmtclient.dylib"
    try:
      _ctdbsdk = ctypes.CDLL(libPath)
    except Exception as e:
      print("\nError loading mtclient lib at the top of pyctdbsdk.py. [%s]." % (str(e)))
else:
    # Linux
    libPath = "libmtclient.so"
    try:
      _ctdbsdk = ctypes.CDLL(libPath)
    except Exception as e:
      print("\nError loading mtclient lib at the top of pyctdbsdk.py. [%s]." % (str(e)))

_ctdbsdk.ctdbAllocSession.restype = ctypes.c_void_p
_ctdbsdk.ctdbAllocSession.argtypes = [ctypes.c_int32, ]
_ctdbsdk.ctdbFreeSession.restype = None
_ctdbsdk.ctdbFreeSession.argtypes = [ctypes.c_void_p, ]
_ctdbsdk.ctdbLogon.restype = ctypes.c_int32
_ctdbsdk.ctdbLogon.argtypes = [ctypes.c_void_p, ctypes.c_char_p, ctypes.c_char_p, ctypes.c_char_p, ]
_ctdbsdk.ctdbLogout.restype = ctypes.c_int32
_ctdbsdk.ctdbLogout.argtypes = [ctypes.c_void_p, ]
_ctdbsdk.ctdbGetServerName.restype = ctypes.c_char_p
_ctdbsdk.ctdbGetServerName.argtypes = [ctypes.c_void_p, ]
_ctdbsdk.ctdbGetUserLogonName.restype = ctypes.c_char_p
_ctdbsdk.ctdbGetUserLogonName.argtypes = [ctypes.c_void_p, ]
_ctdbsdk.ctdbGetUserPassword.restype = ctypes.c_char_p
_ctdbsdk.ctdbGetUserPassword.argtypes = [ctypes.c_void_p, ]
_ctdbsdk.ctdbGetSessionParams.restype = ctypes.c_int32
_ctdbsdk.ctdbGetSessionParams.argtypes = [ctypes.c_void_p, ctypes.c_int32, ]
_ctdbsdk.ctdbSetSessionParams.restype = ctypes.c_int32
_ctdbsdk.ctdbSetSessionParams.argtypes = [ctypes.c_void_p, ctypes.c_int32, ctypes.c_int32, ]
_ctdbsdk.ctdbSetSessionSSLParams.restype = ctypes.c_int32
_ctdbsdk.ctdbSetSessionSSLParams.argtypes = [ctypes.c_void_p, ctypes.c_int32, ctypes.c_char_p, ]
_ctdbsdk.ctdbIsSSLActive.restype = ctypes.c_int32
_ctdbsdk.ctdbIsSSLActive.argtypes = [ctypes.c_void_p, ]
_ctdbsdk.ctdbSetSSL.restype = ctypes.c_int32
_ctdbsdk.ctdbSetSSL.argtypes = [ctypes.c_void_p, ctypes.c_int32, ]
_ctdbsdk.ctdbIsActiveSession.restype = ctypes.c_int32
_ctdbsdk.ctdbIsActiveSession.argtypes = [ctypes.c_void_p, ]
_ctdbsdk.ctdbGetSessionHandle.restype = ctypes.c_void_p
_ctdbsdk.ctdbGetSessionHandle.argtypes = [ctypes.c_void_p, ]
_ctdbsdk.ctdbGetError.restype = ctypes.c_int32
_ctdbsdk.ctdbGetError.argtypes = [ctypes.c_void_p, ]
_ctdbsdk.ctdbSetError.restype = ctypes.c_int32
_ctdbsdk.ctdbSetError.argtypes = [ctypes.c_void_p, ctypes.c_int32, ]
_ctdbsdk.ctdbClearError.restype = None
_ctdbsdk.ctdbClearError.argtypes = [ctypes.c_void_p, ]
_ctdbsdk.ctdbIsTransActive.restype = ctypes.c_int32
_ctdbsdk.ctdbIsTransActive.argtypes = [ctypes.c_void_p, ]
_ctdbsdk.ctdbSyncTransactionState.restype = ctypes.c_int32
_ctdbsdk.ctdbSyncTransactionState.argtypes = [ctypes.c_void_p, ]
_ctdbsdk.ctdbBegin.restype = ctypes.c_int32
_ctdbsdk.ctdbBegin.argtypes = [ctypes.c_void_p, ]
_ctdbsdk.ctdbPrepareCommit.restype = ctypes.c_int32
_ctdbsdk.ctdbPrepareCommit.argtypes = [ctypes.c_void_p, ]
_ctdbsdk.ctdbCommit.restype = ctypes.c_int32
_ctdbsdk.ctdbCommit.argtypes = [ctypes.c_void_p, ]
_ctdbsdk.ctdbAbort.restype = ctypes.c_int32
_ctdbsdk.ctdbAbort.argtypes = [ctypes.c_void_p, ]
_ctdbsdk.ctdbSetSavePoint.restype = ctypes.c_int32
_ctdbsdk.ctdbSetSavePoint.argtypes = [ctypes.c_void_p, ]
_ctdbsdk.ctdbSetSingleSavePoint.restype = ctypes.c_int32
_ctdbsdk.ctdbSetSingleSavePoint.argtypes = [ctypes.c_void_p, ]
_ctdbsdk.ctdbRestoreSavePoint.restype = ctypes.c_int32
_ctdbsdk.ctdbRestoreSavePoint.argtypes = [ctypes.c_void_p, ctypes.c_int32, ]
_ctdbsdk.ctdbClearSavePoint.restype = ctypes.c_int32
_ctdbsdk.ctdbClearSavePoint.argtypes = [ctypes.c_void_p, ]
_ctdbsdk.ctdbGetSessionPath.restype = ctypes.c_int32
_ctdbsdk.ctdbGetSessionPath.argtypes = [ctypes.c_void_p, ctypes.c_char_p, ctypes.c_int32, ]
_ctdbsdk.ctdbSetSessionPath.restype = ctypes.c_int32
_ctdbsdk.ctdbSetSessionPath.argtypes = [ctypes.c_void_p, ctypes.c_char_p, ]
_ctdbsdk.ctdbFirstDatabase.restype = ctypes.c_int32
_ctdbsdk.ctdbFirstDatabase.argtypes = [ctypes.c_void_p, ctypes.c_char_p, ctypes.c_int32, ctypes.c_char_p, ctypes.c_int32, ]
_ctdbsdk.ctdbNextDatabase.restype = ctypes.c_int32
_ctdbsdk.ctdbNextDatabase.argtypes = [ctypes.c_void_p, ctypes.c_char_p, ctypes.c_int32, ctypes.c_char_p, ctypes.c_int32, ]
_ctdbsdk.ctdbFindDatabase.restype = ctypes.c_int32
_ctdbsdk.ctdbFindDatabase.argtypes = [ctypes.c_void_p, ctypes.c_char_p, ctypes.c_char_p, ctypes.c_int32, ]
_ctdbsdk.ctdbFindDatabaseByUID.restype = ctypes.c_int32
_ctdbsdk.ctdbFindDatabaseByUID.argtypes = [ctypes.c_void_p, ctypes.c_uint32, ctypes.c_char_p, ctypes.c_int32, ctypes.c_char_p, ctypes.c_int32, ]
_ctdbsdk.ctdbCreateSession.restype = ctypes.c_int32
_ctdbsdk.ctdbCreateSession.argtypes = [ctypes.c_void_p, ctypes.c_char_p, ctypes.c_char_p, ctypes.c_char_p, ]
_ctdbsdk.ctdbGetFirstActiveDatabase.restype = ctypes.c_void_p
_ctdbsdk.ctdbGetFirstActiveDatabase.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ]
_ctdbsdk.ctdbGetNextActiveDatabase.restype = ctypes.c_void_p
_ctdbsdk.ctdbGetNextActiveDatabase.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ]
_ctdbsdk.ctdbFindActiveDatabase.restype = ctypes.c_void_p
_ctdbsdk.ctdbFindActiveDatabase.argtypes = [ctypes.c_void_p, ctypes.c_char_p, ]
_ctdbsdk.ctdbFindActiveDatabaseByUID.restype = ctypes.c_void_p
_ctdbsdk.ctdbFindActiveDatabaseByUID.argtypes = [ctypes.c_void_p, ctypes.c_uint32, ]
_ctdbsdk.ctdbSetDefFloatFormat.restype = ctypes.c_int32
_ctdbsdk.ctdbSetDefFloatFormat.argtypes = [ctypes.c_void_p, ctypes.c_char_p, ]
_ctdbsdk.ctdbGetDefFloatFormat.restype = ctypes.c_char_p
_ctdbsdk.ctdbGetDefFloatFormat.argtypes = [ctypes.c_void_p, ]
_ctdbsdk.ctdbSetLogonOnly.restype = ctypes.c_int32
_ctdbsdk.ctdbSetLogonOnly.argtypes = [ctypes.c_void_p, ctypes.c_int32, ]
_ctdbsdk.ctdbGetLogonOnly.restype = ctypes.c_int32
_ctdbsdk.ctdbGetLogonOnly.argtypes = [ctypes.c_void_p, ]
_ctdbsdk.ctdbGetDatabaseCount.restype = ctypes.c_int32
_ctdbsdk.ctdbGetDatabaseCount.argtypes = [ctypes.c_void_p, ]
_ctdbsdk.ctdbGetUserTag.restype = ctypes.c_int32
_ctdbsdk.ctdbGetUserTag.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ]
_ctdbsdk.ctdbSetUserTag.restype = ctypes.c_int32
_ctdbsdk.ctdbSetUserTag.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ]
_ctdbsdk.ctdbIsLockActive.restype = ctypes.c_int32
_ctdbsdk.ctdbIsLockActive.argtypes = [ctypes.c_void_p, ]
_ctdbsdk.ctdbLock.restype = ctypes.c_int32
_ctdbsdk.ctdbLock.argtypes = [ctypes.c_void_p, ctypes.c_int32, ]
_ctdbsdk.ctdbUnlock.restype = ctypes.c_int32
_ctdbsdk.ctdbUnlock.argtypes = [ctypes.c_void_p, ]
_ctdbsdk.ctdbGetLockMode.restype = ctypes.c_int32
_ctdbsdk.ctdbGetLockMode.argtypes = [ctypes.c_void_p, ]
_ctdbsdk.ctdbSetTransactionIsolation.restype = ctypes.c_int32
_ctdbsdk.ctdbSetTransactionIsolation.argtypes = [ctypes.c_void_p, ctypes.c_int32, ]
_ctdbsdk.ctdbGetTransactionIsolation.restype = ctypes.c_int32
_ctdbsdk.ctdbGetTransactionIsolation.argtypes = [ctypes.c_void_p, ]
_ctdbsdk.ctdbSetSessionType.restype = ctypes.c_int32
_ctdbsdk.ctdbSetSessionType.argtypes = [ctypes.c_void_p, ctypes.c_int32, ]
_ctdbsdk.ctdbGetSessionType.restype = ctypes.c_int32
_ctdbsdk.ctdbGetSessionType.argtypes = [ctypes.c_void_p, ]
_ctdbsdk.ctdbGetLibType.restype = ctypes.c_uint32
_ctdbsdk.ctdbGetLibType.argtypes = [ctypes.c_void_p, ]
_ctdbsdk.ctdbSetKeepLock.restype = ctypes.c_int32
_ctdbsdk.ctdbSetKeepLock.argtypes = [ctypes.c_void_p, ctypes.c_int32, ]
_ctdbsdk.ctdbGetKeepLock.restype = ctypes.c_int32
_ctdbsdk.ctdbGetKeepLock.argtypes = [ctypes.c_void_p, ]
_ctdbsdk.ctdbSetCurrentNodeName.restype = ctypes.c_int32
_ctdbsdk.ctdbSetCurrentNodeName.argtypes = [ctypes.c_void_p, ctypes.c_char_p, ]
_ctdbsdk.ctdbSwitchInstance.restype = ctypes.c_int32
_ctdbsdk.ctdbSwitchInstance.argtypes = [ctypes.c_void_p, ]
_ctdbsdk.ctdbSetPathPrefix.restype = ctypes.c_int32
_ctdbsdk.ctdbSetPathPrefix.argtypes = [ctypes.c_void_p, ctypes.c_char_p, ]
_ctdbsdk.ctdbClearPathPrefix.restype = ctypes.c_int32
_ctdbsdk.ctdbClearPathPrefix.argtypes = [ctypes.c_void_p, ]
_ctdbsdk.ctdbGetPathPrefix.restype = ctypes.c_char_p
_ctdbsdk.ctdbGetPathPrefix.argtypes = [ctypes.c_void_p, ]
_ctdbsdk.ctdbGetHandleType.restype = ctypes.c_int32
_ctdbsdk.ctdbGetHandleType.argtypes = [ctypes.c_void_p, ]
_ctdbsdk.ctdbSetCallback.restype = ctypes.c_int32
_ctdbsdk.ctdbSetCallback.argtypes = [ctypes.c_void_p, ctypes.c_int32, ctypes.c_void_p, ]
_ctdbsdk.ctdbGetCallback.restype = ctypes.c_void_p
_ctdbsdk.ctdbGetCallback.argtypes = [ctypes.c_void_p, ctypes.c_int32, ]
_ctdbsdk.ctdbClearCallback.restype = ctypes.c_int32
_ctdbsdk.ctdbClearCallback.argtypes = [ctypes.c_void_p, ctypes.c_int32, ]
_ctdbsdk.ctdbClearAllCallback.restype = ctypes.c_int32
_ctdbsdk.ctdbClearAllCallback.argtypes = [ctypes.c_void_p, ]
_ctdbsdk.ctdbSetLocalTag.restype = ctypes.c_int32
_ctdbsdk.ctdbSetLocalTag.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ]
_ctdbsdk.ctdbGetLocalTag.restype = ctypes.c_void_p
_ctdbsdk.ctdbGetLocalTag.argtypes = [ctypes.c_void_p, ]
_ctdbsdk.ctdbSetFieldCallback.restype = ctypes.c_int32
_ctdbsdk.ctdbSetFieldCallback.argtypes = [ctypes.c_void_p, ctypes.c_int32, ctypes.c_void_p, ]
_ctdbsdk.ctdbIsSQLServer.restype = ctypes.c_int32
_ctdbsdk.ctdbIsSQLServer.argtypes = [ctypes.c_void_p, ]
_ctdbsdk.ctdbGetSystemConfig.restype = ctypes.c_int32
_ctdbsdk.ctdbGetSystemConfig.argtypes = [ctypes.c_int32, ]
_ctdbsdk.ctdbSetSessionExclusive.restype = ctypes.c_int32
_ctdbsdk.ctdbSetSessionExclusive.argtypes = [ctypes.c_void_p, ctypes.c_int32, ]
_ctdbsdk.ctdbIsSessionExclusive.restype = ctypes.c_int32
_ctdbsdk.ctdbIsSessionExclusive.argtypes = [ctypes.c_void_p, ]
_ctdbsdk.ctdbGetAttachMode.restype = ctypes.c_int32
_ctdbsdk.ctdbGetAttachMode.argtypes = [ctypes.c_void_p, ]
_ctdbsdk.ctdbAttachSession.restype = ctypes.c_int32
_ctdbsdk.ctdbAttachSession.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_int32, ctypes.c_int32, ]
_ctdbsdk.ctdbDetachSession.restype = ctypes.c_int32
_ctdbsdk.ctdbDetachSession.argtypes = [ctypes.c_void_p, ]
_ctdbsdk.ctdbSetConfigurationFile.restype = ctypes.c_int32
_ctdbsdk.ctdbSetConfigurationFile.argtypes = [ctypes.c_char_p, ]
_ctdbsdk.ctdbSetLicenseFile.restype = ctypes.c_int32
_ctdbsdk.ctdbSetLicenseFile.argtypes = [ctypes.c_char_p, ]
_ctdbsdk.ctdbStartDatabaseEngine.restype = ctypes.c_int32
_ctdbsdk.ctdbStartDatabaseEngine.argtypes = []
_ctdbsdk.ctdbStopDatabaseEngine.restype = None
_ctdbsdk.ctdbStopDatabaseEngine.argtypes = []
_ctdbsdk.ctdbAcquireSessionId.restype = ctypes.c_int32
_ctdbsdk.ctdbAcquireSessionId.argtypes = []
_ctdbsdk.ctdbReleaseSessionId.restype = None
_ctdbsdk.ctdbReleaseSessionId.argtypes = [ctypes.c_int32, ]
_ctdbsdk.ctdbGetSessionId.restype = ctypes.c_int32
_ctdbsdk.ctdbGetSessionId.argtypes = [ctypes.c_void_p, ]
_ctdbsdk.ctdbSetSessionId.restype = None
_ctdbsdk.ctdbSetSessionId.argtypes = [ctypes.c_void_p, ctypes.c_int32, ]
_ctdbsdk.ctdbGetTransactionMode.restype = ctypes.c_int32
_ctdbsdk.ctdbGetTransactionMode.argtypes = [ctypes.c_void_p, ]
_ctdbsdk.ctdbSetTransactionMode.restype = ctypes.c_int32
_ctdbsdk.ctdbSetTransactionMode.argtypes = [ctypes.c_void_p, ctypes.c_int32, ]
_ctdbsdk.ctdbGetOperationState.restype = ctypes.c_int32
_ctdbsdk.ctdbGetOperationState.argtypes = [ctypes.c_void_p, ]
_ctdbsdk.ctdbSetOperationState.restype = ctypes.c_int32
_ctdbsdk.ctdbSetOperationState.argtypes = [ctypes.c_void_p, ctypes.c_int32, ctypes.c_int32, ]
_ctdbsdk.ctdbGetAutoCommit.restype = ctypes.c_int32
_ctdbsdk.ctdbGetAutoCommit.argtypes = [ctypes.c_void_p, ]
_ctdbsdk.ctdbSetAutoCommit.restype = ctypes.c_int32
_ctdbsdk.ctdbSetAutoCommit.argtypes = [ctypes.c_void_p, ctypes.c_int32, ]
_ctdbsdk.ctdbSetSqlCallBack.restype = None
_ctdbsdk.ctdbSetSqlCallBack.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ]
_ctdbsdk.ctdbGetCtreeOWNER.restype = ctypes.c_int32
_ctdbsdk.ctdbGetCtreeOWNER.argtypes = []
_ctdbsdk.ctdbSetCtreeOWNER.restype = None
_ctdbsdk.ctdbSetCtreeOWNER.argtypes = [ctypes.c_int32, ]
_ctdbsdk.ctdbLoadCallbackLib.restype = ctypes.c_int32
_ctdbsdk.ctdbLoadCallbackLib.argtypes = [ctypes.c_void_p, ctypes.c_char_p, ctypes.c_char_p, ctypes.c_int32, ]
_ctdbsdk.ctdbUnLoadCallbackLib.restype = ctypes.c_int32
_ctdbsdk.ctdbUnLoadCallbackLib.argtypes = [ctypes.c_void_p, ctypes.c_int32, ]
_ctdbsdk.ctdbBeginImpersonation.restype = ctypes.c_int32
_ctdbsdk.ctdbBeginImpersonation.argtypes = [ctypes.c_void_p, ctypes.c_int32, ]
_ctdbsdk.ctdbEndImpersonation.restype = ctypes.c_int32
_ctdbsdk.ctdbEndImpersonation.argtypes = [ctypes.c_void_p, ]
_ctdbsdk.ctdbGetProductName.restype = ctypes.c_int32
_ctdbsdk.ctdbGetProductName.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_short, ]
_ctdbsdk.ctdbGetProductVersion.restype = ctypes.c_int32
_ctdbsdk.ctdbGetProductVersion.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_short, ]
_ctdbsdk.ctdbGetMaxConnections.restype = ctypes.c_int32
_ctdbsdk.ctdbGetMaxConnections.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ]
_ctdbsdk.ctdbServerDateTime.restype = ctypes.c_double
_ctdbsdk.ctdbServerDateTime.argtypes = [ctypes.c_void_p, ]
_ctdbsdk.ctdbSetLocalDirectory.restype = ctypes.c_int32
_ctdbsdk.ctdbSetLocalDirectory.argtypes = [ctypes.c_char_p, ]
_ctdbsdk.ctdbSetLogPath.restype = ctypes.c_int32
_ctdbsdk.ctdbSetLogPath.argtypes = [ctypes.c_void_p, ctypes.c_char_p, ]
_ctdbsdk.ctdbSetStatusLogPath.restype = ctypes.c_int32
_ctdbsdk.ctdbSetStatusLogPath.argtypes = [ctypes.c_void_p, ctypes.c_char_p, ]
_ctdbsdk.ctdbSetTempPath.restype = ctypes.c_int32
_ctdbsdk.ctdbSetTempPath.argtypes = [ctypes.c_void_p, ctypes.c_char_p, ]
_ctdbsdk.ctdbGetDatabaseHandle.restype = ctypes.c_void_p
_ctdbsdk.ctdbGetDatabaseHandle.argtypes = [ctypes.c_void_p, ]
_ctdbsdk.ctdbAllocDatabase.restype = ctypes.c_void_p
_ctdbsdk.ctdbAllocDatabase.argtypes = [ctypes.c_void_p, ]
_ctdbsdk.ctdbFreeDatabase.restype = None
_ctdbsdk.ctdbFreeDatabase.argtypes = [ctypes.c_void_p, ]
_ctdbsdk.ctdbConnect.restype = ctypes.c_int32
_ctdbsdk.ctdbConnect.argtypes = [ctypes.c_void_p, ctypes.c_char_p, ]
_ctdbsdk.ctdbDisconnect.restype = ctypes.c_int32
_ctdbsdk.ctdbDisconnect.argtypes = [ctypes.c_void_p, ]
_ctdbsdk.ctdbDisconnectAll.restype = ctypes.c_int32
_ctdbsdk.ctdbDisconnectAll.argtypes = [ctypes.c_void_p, ]
_ctdbsdk.ctdbCreateDatabase.restype = ctypes.c_int32
_ctdbsdk.ctdbCreateDatabase.argtypes = [ctypes.c_void_p, ctypes.c_char_p, ctypes.c_char_p, ]
_ctdbsdk.ctdbAddDatabase.restype = ctypes.c_int32
_ctdbsdk.ctdbAddDatabase.argtypes = [ctypes.c_void_p, ctypes.c_char_p, ctypes.c_char_p, ]
_ctdbsdk.ctdbDeleteDatabase.restype = ctypes.c_int32
_ctdbsdk.ctdbDeleteDatabase.argtypes = [ctypes.c_void_p, ctypes.c_char_p, ]
_ctdbsdk.ctdbDropDatabase.restype = ctypes.c_int32
_ctdbsdk.ctdbDropDatabase.argtypes = [ctypes.c_void_p, ctypes.c_char_p, ]
_ctdbsdk.ctdbFirstTable.restype = ctypes.c_int32
_ctdbsdk.ctdbFirstTable.argtypes = [ctypes.c_void_p, ctypes.c_char_p, ctypes.c_int32, ctypes.c_char_p, ctypes.c_int32, ]
_ctdbsdk.ctdbNextTable.restype = ctypes.c_int32
_ctdbsdk.ctdbNextTable.argtypes = [ctypes.c_void_p, ctypes.c_char_p, ctypes.c_int32, ctypes.c_char_p, ctypes.c_int32, ]
_ctdbsdk.ctdbFindTable.restype = ctypes.c_int32
_ctdbsdk.ctdbFindTable.argtypes = [ctypes.c_void_p, ctypes.c_char_p, ctypes.c_char_p, ctypes.c_int32, ]
_ctdbsdk.ctdbFindTableByUID.restype = ctypes.c_int32
_ctdbsdk.ctdbFindTableByUID.argtypes = [ctypes.c_void_p, ctypes.c_uint32, ctypes.c_char_p, ctypes.c_int32, ctypes.c_char_p, ctypes.c_int32, ]
_ctdbsdk.ctdbAddTable.restype = ctypes.c_int32
_ctdbsdk.ctdbAddTable.argtypes = [ctypes.c_void_p, ctypes.c_char_p, ctypes.c_char_p, ]
_ctdbsdk.ctdbAddTableXtd.restype = ctypes.c_int32
_ctdbsdk.ctdbAddTableXtd.argtypes = [ctypes.c_void_p, ctypes.c_char_p, ctypes.c_char_p, ctypes.c_char_p, ]
_ctdbsdk.ctdbAddMRTTable.restype = ctypes.c_int32
_ctdbsdk.ctdbAddMRTTable.argtypes = [ctypes.c_void_p, ctypes.c_char_p, ctypes.c_char_p, ctypes.c_uint32, ]
_ctdbsdk.ctdbDeleteTable.restype = ctypes.c_int32
_ctdbsdk.ctdbDeleteTable.argtypes = [ctypes.c_void_p, ctypes.c_char_p, ctypes.c_char_p, ]
_ctdbsdk.ctdbDropTable.restype = ctypes.c_int32
_ctdbsdk.ctdbDropTable.argtypes = [ctypes.c_void_p, ctypes.c_char_p, ]
_ctdbsdk.ctdbGetDatabaseUID.restype = ctypes.c_int32
_ctdbsdk.ctdbGetDatabaseUID.argtypes = [ctypes.c_void_p, ctypes.c_char_p, ctypes.c_void_p, ]
_ctdbsdk.ctdbGetTableUID.restype = ctypes.c_int32
_ctdbsdk.ctdbGetTableUID.argtypes = [ctypes.c_void_p, ctypes.c_char_p, ctypes.POINTER(ctypes.c_ulong) ]
_ctdbsdk.ctdbGetDatabaseObjptr.restype = ctypes.c_void_p
_ctdbsdk.ctdbGetDatabaseObjptr.argtypes = [ctypes.c_void_p, ]
_ctdbsdk.ctdbSetDatabaseObjptr.restype = ctypes.c_int32
_ctdbsdk.ctdbSetDatabaseObjptr.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ]
_ctdbsdk.ctdbGetFirstActiveTable.restype = ctypes.c_void_p
_ctdbsdk.ctdbGetFirstActiveTable.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ]
_ctdbsdk.ctdbGetNextActiveTable.restype = ctypes.c_void_p
_ctdbsdk.ctdbGetNextActiveTable.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ]
_ctdbsdk.ctdbFindActiveTable.restype = ctypes.c_void_p
_ctdbsdk.ctdbFindActiveTable.argtypes = [ctypes.c_void_p, ctypes.c_char_p, ]
_ctdbsdk.ctdbFindActiveTableByUID.restype = ctypes.c_void_p
_ctdbsdk.ctdbFindActiveTableByUID.argtypes = [ctypes.c_void_p, ctypes.c_uint32, ]
_ctdbsdk.ctdbGetActiveDatabaseUID.restype = ctypes.c_int32
_ctdbsdk.ctdbGetActiveDatabaseUID.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ]
_ctdbsdk.ctdbIsActiveDatabase.restype = ctypes.c_int32
_ctdbsdk.ctdbIsActiveDatabase.argtypes = [ctypes.c_void_p, ]
_ctdbsdk.ctdbGetDatabasePath.restype = ctypes.c_char_p
_ctdbsdk.ctdbGetDatabasePath.argtypes = [ctypes.c_void_p, ]
_ctdbsdk.ctdbGetDatabaseName.restype = ctypes.c_char_p
_ctdbsdk.ctdbGetDatabaseName.argtypes = [ctypes.c_void_p, ]
_ctdbsdk.ctdbGetTableCount.restype = ctypes.c_int32
_ctdbsdk.ctdbGetTableCount.argtypes = [ctypes.c_void_p, ]
_ctdbsdk.ctdbGetActiveTableByUID.restype = ctypes.c_void_p
_ctdbsdk.ctdbGetActiveTableByUID.argtypes = [ctypes.c_void_p, ctypes.c_uint32, ]
_ctdbsdk.ctdbGetDefaultSqlTableOwner.restype = ctypes.c_char_p
_ctdbsdk.ctdbGetDefaultSqlTableOwner.argtypes = [ctypes.c_void_p, ]
_ctdbsdk.ctdbSetDefaultSqlTableOwner.restype = ctypes.c_int32
_ctdbsdk.ctdbSetDefaultSqlTableOwner.argtypes = [ctypes.c_void_p, ctypes.c_char_p, ]
_ctdbsdk.ctdbIsSQLDatabase.restype = ctypes.c_int32
_ctdbsdk.ctdbIsSQLDatabase.argtypes = [ctypes.c_void_p, ]
_ctdbsdk.ctdbSetDatabaseExclusive.restype = ctypes.c_int32
_ctdbsdk.ctdbSetDatabaseExclusive.argtypes = [ctypes.c_void_p, ctypes.c_int32, ]
_ctdbsdk.ctdbIsDatabaseExclusive.restype = ctypes.c_int32
_ctdbsdk.ctdbIsDatabaseExclusive.argtypes = [ctypes.c_void_p, ]
_ctdbsdk.ctdbCheckSysTablesSQLInfo.restype = ctypes.c_int32
_ctdbsdk.ctdbCheckSysTablesSQLInfo.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_int32, ]
_ctdbsdk.ctdbGetTableHandle.restype = ctypes.c_void_p
_ctdbsdk.ctdbGetTableHandle.argtypes = [ctypes.c_void_p, ]
_ctdbsdk.ctdbAllocTable.restype = ctypes.c_void_p
_ctdbsdk.ctdbAllocTable.argtypes = [ctypes.c_void_p, ]
_ctdbsdk.ctdbFreeTable.restype = None
_ctdbsdk.ctdbFreeTable.argtypes = [ctypes.c_void_p, ]
_ctdbsdk.ctdbIsActiveTable.restype = ctypes.c_int32
_ctdbsdk.ctdbIsActiveTable.argtypes = [ctypes.c_void_p, ]
_ctdbsdk.ctdbGetTablePath.restype = ctypes.c_char_p
_ctdbsdk.ctdbGetTablePath.argtypes = [ctypes.c_void_p, ]
_ctdbsdk.ctdbGetTableName.restype = ctypes.c_char_p
_ctdbsdk.ctdbGetTableName.argtypes = [ctypes.c_void_p, ]
_ctdbsdk.ctdbGetTableExtension.restype = ctypes.c_char_p
_ctdbsdk.ctdbGetTableExtension.argtypes = [ctypes.c_void_p, ]
_ctdbsdk.ctdbGetTableIndexCount.restype = ctypes.c_int32
_ctdbsdk.ctdbGetTableIndexCount.argtypes = [ctypes.c_void_p, ]
_ctdbsdk.ctdbGetTableFieldCount.restype = ctypes.c_int32
_ctdbsdk.ctdbGetTableFieldCount.argtypes = [ctypes.c_void_p, ]
_ctdbsdk.ctdbGetTableOpenMode.restype = ctypes.c_int32
_ctdbsdk.ctdbGetTableOpenMode.argtypes = [ctypes.c_void_p, ]
_ctdbsdk.ctdbGetTableCreateMode.restype = ctypes.c_int32
_ctdbsdk.ctdbGetTableCreateMode.argtypes = [ctypes.c_void_p, ]
_ctdbsdk.ctdbGetTableDefaultDataExtentSize.restype = ctypes.c_int32
_ctdbsdk.ctdbGetTableDefaultDataExtentSize.argtypes = [ctypes.c_void_p, ]
_ctdbsdk.ctdbGetTableDefaultIndexExtentSize.restype = ctypes.c_int32
_ctdbsdk.ctdbGetTableDefaultIndexExtentSize.argtypes = [ctypes.c_void_p, ]
_ctdbsdk.ctdbSetTablePath.restype = ctypes.c_int32
_ctdbsdk.ctdbSetTablePath.argtypes = [ctypes.c_void_p, ctypes.c_char_p, ]
_ctdbsdk.ctdbSetTableExtension.restype = ctypes.c_int32
_ctdbsdk.ctdbSetTableExtension.argtypes = [ctypes.c_void_p, ctypes.c_char_p, ]
_ctdbsdk.ctdbSetTableDefaultDataExtentSize.restype = ctypes.c_int32
_ctdbsdk.ctdbSetTableDefaultDataExtentSize.argtypes = [ctypes.c_void_p, ctypes.c_int32, ]
_ctdbsdk.ctdbSetTableDefaultIndexExtentSize.restype = ctypes.c_int32
_ctdbsdk.ctdbSetTableDefaultIndexExtentSize.argtypes = [ctypes.c_void_p, ctypes.c_int32, ]
_ctdbsdk.ctdbCreateTable.restype = ctypes.c_int32
_ctdbsdk.ctdbCreateTable.argtypes = [ctypes.c_void_p, ctypes.c_char_p, ctypes.c_int32, ]
_ctdbsdk.ctdbCreateMRTTable.restype = ctypes.c_int32
_ctdbsdk.ctdbCreateMRTTable.argtypes = [ctypes.c_void_p, ctypes.c_char_p, ctypes.c_char_p, ctypes.c_int32, ctypes.c_char_p, ]
_ctdbsdk.ctdbGetVTableInfoFromTable.restype = ctypes.c_int32
_ctdbsdk.ctdbGetVTableInfoFromTable.argtypes = [ctypes.c_void_p, ]
_ctdbsdk.ctdbAllocVTableInfo.restype = ctypes.c_void_p
_ctdbsdk.ctdbAllocVTableInfo.argtypes = [ctypes.c_void_p, ctypes.c_ushort, ]
_ctdbsdk.ctdbFreeVTableInfo.restype = None
_ctdbsdk.ctdbFreeVTableInfo.argtypes = [ctypes.c_void_p, ]
_ctdbsdk.ctdbRenameTable.restype = ctypes.c_int32
_ctdbsdk.ctdbRenameTable.argtypes = [ctypes.c_void_p, ctypes.c_char_p, ctypes.c_char_p, ]
_ctdbsdk.ctdbMoveTable.restype = ctypes.c_int32
_ctdbsdk.ctdbMoveTable.argtypes = [ctypes.c_void_p, ctypes.c_char_p, ctypes.c_char_p, ctypes.c_char_p, ]
_ctdbsdk.ctdbOpenTable.restype = ctypes.c_int32
_ctdbsdk.ctdbOpenTable.argtypes = [ctypes.c_void_p, ctypes.c_char_p, ctypes.c_int32, ]
_ctdbsdk.ctdbOpenTableByUID.restype = ctypes.c_int32
_ctdbsdk.ctdbOpenTableByUID.argtypes = [ctypes.c_void_p, ctypes.c_uint32, ctypes.c_int32, ]
_ctdbsdk.ctdbCloseTable.restype = ctypes.c_int32
_ctdbsdk.ctdbCloseTable.argtypes = [ctypes.c_void_p, ]
_ctdbsdk.ctdbCloseAll.restype = ctypes.c_int32
_ctdbsdk.ctdbCloseAll.argtypes = [ctypes.c_void_p, ]
_ctdbsdk.ctdbGetTablePassword.restype = ctypes.c_char_p
_ctdbsdk.ctdbGetTablePassword.argtypes = [ctypes.c_void_p, ]
_ctdbsdk.ctdbGetTableGroupid.restype = ctypes.c_char_p
_ctdbsdk.ctdbGetTableGroupid.argtypes = [ctypes.c_void_p, ]
_ctdbsdk.ctdbGetIndexExtension.restype = ctypes.c_char_p
_ctdbsdk.ctdbGetIndexExtension.argtypes = [ctypes.c_void_p, ]
_ctdbsdk.ctdbGetTablePermission.restype = ctypes.c_int32
_ctdbsdk.ctdbGetTablePermission.argtypes = [ctypes.c_void_p, ]
_ctdbsdk.ctdbSetTablePassword.restype = ctypes.c_int32
_ctdbsdk.ctdbSetTablePassword.argtypes = [ctypes.c_void_p, ctypes.c_char_p, ]
_ctdbsdk.ctdbSetTableGroupid.restype = ctypes.c_int32
_ctdbsdk.ctdbSetTableGroupid.argtypes = [ctypes.c_void_p, ctypes.c_char_p, ]
_ctdbsdk.ctdbSetIndexExtension.restype = ctypes.c_int32
_ctdbsdk.ctdbSetIndexExtension.argtypes = [ctypes.c_void_p, ctypes.c_char_p, ]
_ctdbsdk.ctdbSetTablePermission.restype = ctypes.c_int32
_ctdbsdk.ctdbSetTablePermission.argtypes = [ctypes.c_void_p, ctypes.c_int32, ]
_ctdbsdk.ctdbGetTableObjptr.restype = ctypes.c_void_p
_ctdbsdk.ctdbGetTableObjptr.argtypes = [ctypes.c_void_p, ]
_ctdbsdk.ctdbSetTableObjptr.restype = ctypes.c_int32
_ctdbsdk.ctdbSetTableObjptr.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ]
_ctdbsdk.ctdbGetActiveTableUID.restype = ctypes.c_int32
_ctdbsdk.ctdbGetActiveTableUID.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ]
_ctdbsdk.ctdbAlterTable.restype = ctypes.c_int32
_ctdbsdk.ctdbAlterTable.argtypes = [ctypes.c_void_p, ctypes.c_int32, ]
_ctdbsdk.ctdbResetAll.restype = ctypes.c_int32
_ctdbsdk.ctdbResetAll.argtypes = [ctypes.c_void_p, ]
_ctdbsdk.ctdbHasNullFieldSupport.restype = ctypes.c_int32
_ctdbsdk.ctdbHasNullFieldSupport.argtypes = [ctypes.c_void_p, ]
_ctdbsdk.ctdbGetTableSuperFile.restype = ctypes.c_void_p
_ctdbsdk.ctdbGetTableSuperFile.argtypes = [ctypes.c_void_p, ]
_ctdbsdk.ctdbSetTableSuperFile.restype = ctypes.c_int32
_ctdbsdk.ctdbSetTableSuperFile.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ]
_ctdbsdk.ctdbUnlockTable.restype = ctypes.c_int32
_ctdbsdk.ctdbUnlockTable.argtypes = [ctypes.c_void_p, ]
_ctdbsdk.ctdbGetTableNbr.restype = ctypes.c_int32
_ctdbsdk.ctdbGetTableNbr.argtypes = [ctypes.c_void_p, ]
_ctdbsdk.ctdbGetTable.restype = ctypes.c_void_p
_ctdbsdk.ctdbGetTable.argtypes = [ctypes.c_void_p, ctypes.c_int32, ]
_ctdbsdk.ctdbHasRecbyt.restype = ctypes.c_int32
_ctdbsdk.ctdbHasRecbyt.argtypes = [ctypes.c_void_p, ]
_ctdbsdk.ctdbHasRowid.restype = ctypes.c_int32
_ctdbsdk.ctdbHasRowid.argtypes = [ctypes.c_void_p, ]
_ctdbsdk.ctdbIsVTable.restype = ctypes.c_int32
_ctdbsdk.ctdbIsVTable.argtypes = [ctypes.c_void_p, ]
_ctdbsdk.ctdbGetVTableNumber.restype = ctypes.c_uint32
_ctdbsdk.ctdbGetVTableNumber.argtypes = [ctypes.c_void_p, ]
_ctdbsdk.ctdbSetMRTTableFilter.restype = ctypes.c_int32
_ctdbsdk.ctdbSetMRTTableFilter.argtypes = [ctypes.c_void_p, ctypes.c_char_p, ]
_ctdbsdk.ctdbGetTablePartitionIndexNbr.restype = ctypes.c_int32
_ctdbsdk.ctdbGetTablePartitionIndexNbr.argtypes = [ctypes.c_void_p, ]
_ctdbsdk.ctdbSetTablePartitionIndexNbr.restype = ctypes.c_int32
_ctdbsdk.ctdbSetTablePartitionIndexNbr.argtypes = [ctypes.c_void_p, ctypes.c_int32, ]
_ctdbsdk.ctdbSetTablePartitionRule.restype = ctypes.c_int32
_ctdbsdk.ctdbSetTablePartitionRule.argtypes = [ctypes.c_void_p, ctypes.c_char_p, ]
_ctdbsdk.ctdbSetMRTTableDefaultIndex.restype = ctypes.c_int32
_ctdbsdk.ctdbSetMRTTableDefaultIndex.argtypes = [ctypes.c_void_p, ctypes.c_int32, ctypes.c_void_p, ctypes.c_int32, ctypes.c_void_p, ctypes.c_int32, ctypes.c_int32, ]
_ctdbsdk.ctdbPartAdminByName.restype = ctypes.c_int32
_ctdbsdk.ctdbPartAdminByName.argtypes = [ctypes.c_void_p, ctypes.c_char_p, ctypes.c_int32, ctypes.c_void_p, ]
_ctdbsdk.ctdbPartAdminByKey.restype = ctypes.c_int32
_ctdbsdk.ctdbPartAdminByKey.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_int32, ctypes.c_void_p, ]
_ctdbsdk.ctdbPartAdminByNumber.restype = ctypes.c_int32
_ctdbsdk.ctdbPartAdminByNumber.argtypes = [ctypes.c_void_p, ctypes.c_int32, ctypes.c_int32, ctypes.c_void_p, ]
_ctdbsdk.ctdbSetIdentityField.restype = ctypes.c_int32
_ctdbsdk.ctdbSetIdentityField.argtypes = [ctypes.c_void_p, ctypes.c_char_p, ctypes.c_longlong, ctypes.c_longlong, ]
_ctdbsdk.ctdbGetIdentityField.restype = ctypes.c_char_p
_ctdbsdk.ctdbGetIdentityField.argtypes = [ctypes.c_void_p, ]
_ctdbsdk.ctdbGetIdentityFieldDetails.restype = ctypes.c_char_p
_ctdbsdk.ctdbGetIdentityFieldDetails.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ]
_ctdbsdk.ctdbGetFirstPartition.restype = ctypes.c_int32
_ctdbsdk.ctdbGetFirstPartition.argtypes = [ctypes.c_void_p, ]
_ctdbsdk.ctdbGetLastPartition.restype = ctypes.c_int32
_ctdbsdk.ctdbGetLastPartition.argtypes = [ctypes.c_void_p, ]
_ctdbsdk.ctdbGetPadChar.restype = ctypes.c_int32
_ctdbsdk.ctdbGetPadChar.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_int), ctypes.POINTER(ctypes.c_int) ]
_ctdbsdk.ctdbSetPadChar.restype = ctypes.c_int32
_ctdbsdk.ctdbSetPadChar.argtypes = [ctypes.c_void_p, ctypes.c_int32, ctypes.c_int32, ]
_ctdbsdk.ctdbUpdatePadChar.restype = ctypes.c_int32
_ctdbsdk.ctdbUpdatePadChar.argtypes = [ctypes.c_void_p, ctypes.c_int32, ctypes.c_int32, ctypes.c_int32, ]
_ctdbsdk.ctdbUpdateCreateMode.restype = ctypes.c_int32
_ctdbsdk.ctdbUpdateCreateMode.argtypes = [ctypes.c_void_p, ctypes.c_int32, ]
_ctdbsdk.ctdbHasDelField.restype = ctypes.c_int32
_ctdbsdk.ctdbHasDelField.argtypes = [ctypes.c_void_p, ]
_ctdbsdk.ctdbGetDatno.restype = ctypes.c_int32
_ctdbsdk.ctdbGetDatno.argtypes = [ctypes.c_void_p, ]
_ctdbsdk.ctdbGetIdxnoByNumber.restype = ctypes.c_int32
_ctdbsdk.ctdbGetIdxnoByNumber.argtypes = [ctypes.c_void_p, ctypes.c_int32, ]
_ctdbsdk.ctdbGetIdxnoByName.restype = ctypes.c_int32
_ctdbsdk.ctdbGetIdxnoByName.argtypes = [ctypes.c_void_p, ctypes.c_char_p, ]
_ctdbsdk.ctdbRemoveTable.restype = ctypes.c_int32
_ctdbsdk.ctdbRemoveTable.argtypes = [ctypes.c_void_p, ]
_ctdbsdk.ctdbGetTableType.restype = ctypes.c_int32
_ctdbsdk.ctdbGetTableType.argtypes = [ctypes.c_void_p, ]
_ctdbsdk.ctdbGetRebuildProgress.restype = ctypes.c_int32
_ctdbsdk.ctdbGetRebuildProgress.argtypes = [ctypes.c_void_p, ]
_ctdbsdk.ctdbSystemFilterOn.restype = ctypes.c_int32
_ctdbsdk.ctdbSystemFilterOn.argtypes = [ctypes.c_void_p, ctypes.c_int32, ]
_ctdbsdk.ctdbSystemFilterOff.restype = ctypes.c_int32
_ctdbsdk.ctdbSystemFilterOff.argtypes = [ctypes.c_void_p, ctypes.c_int32, ]
_ctdbsdk.ctdbSetTableKSeg.restype = ctypes.c_int32
_ctdbsdk.ctdbSetTableKSeg.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ]
_ctdbsdk.ctdbGetTableKSeg.restype = ctypes.c_int32
_ctdbsdk.ctdbGetTableKSeg.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ]
_ctdbsdk.ctdbGetTableStatus.restype = ctypes.c_uint32
_ctdbsdk.ctdbGetTableStatus.argtypes = [ctypes.c_void_p, ]
_ctdbsdk.ctdbAttachTable.restype = ctypes.c_int32
_ctdbsdk.ctdbAttachTable.argtypes = [ctypes.c_void_p, ctypes.c_int32, ]
_ctdbsdk.ctdbAttachTableXtd.restype = ctypes.c_int32
_ctdbsdk.ctdbAttachTableXtd.argtypes = [ctypes.c_void_p, ctypes.c_int32, ctypes.c_int32, ctypes.c_void_p, ctypes.c_void_p, ]
_ctdbsdk.ctdbDetachTable.restype = ctypes.c_int32
_ctdbsdk.ctdbDetachTable.argtypes = [ctypes.c_void_p, ]
_ctdbsdk.ctdbGetTableOwner.restype = ctypes.c_char_p
_ctdbsdk.ctdbGetTableOwner.argtypes = [ctypes.c_void_p, ]
_ctdbsdk.ctdbSetTableOwner.restype = ctypes.c_int32
_ctdbsdk.ctdbSetTableOwner.argtypes = [ctypes.c_void_p, ctypes.c_char_p, ]
_ctdbsdk.ctdbRebuildTable.restype = ctypes.c_int32
_ctdbsdk.ctdbRebuildTable.argtypes = [ctypes.c_void_p, ctypes.c_int32, ]
_ctdbsdk.ctdbSetCallbackOnRebuild.restype = ctypes.c_short
_ctdbsdk.ctdbSetCallbackOnRebuild.argtypes = [ctypes.c_void_p, ctypes.c_ushort, ]
_ctdbsdk.ctdbAllocResource.restype = ctypes.c_void_p
_ctdbsdk.ctdbAllocResource.argtypes = [ctypes.c_void_p, ctypes.c_uint32, ctypes.c_uint32, ctypes.c_char_p, ]
_ctdbsdk.ctdbFreeResource.restype = ctypes.c_int32
_ctdbsdk.ctdbFreeResource.argtypes = [ctypes.c_void_p, ]
_ctdbsdk.ctdbUnlockResource.restype = ctypes.c_int32
_ctdbsdk.ctdbUnlockResource.argtypes = [ctypes.c_void_p, ]
_ctdbsdk.ctdbAddResource.restype = ctypes.c_int32
_ctdbsdk.ctdbAddResource.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_int32, ]
_ctdbsdk.ctdbDeleteResource.restype = ctypes.c_int32
_ctdbsdk.ctdbDeleteResource.argtypes = [ctypes.c_void_p, ]
_ctdbsdk.ctdbUpdateResource.restype = ctypes.c_int32
_ctdbsdk.ctdbUpdateResource.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_int32, ]
_ctdbsdk.ctdbFirstResource.restype = ctypes.c_int32
_ctdbsdk.ctdbFirstResource.argtypes = [ctypes.c_void_p, ctypes.c_int32, ]
_ctdbsdk.ctdbNextResource.restype = ctypes.c_int32
_ctdbsdk.ctdbNextResource.argtypes = [ctypes.c_void_p, ctypes.c_int32, ]
_ctdbsdk.ctdbFindResource.restype = ctypes.c_int32
_ctdbsdk.ctdbFindResource.argtypes = [ctypes.c_void_p, ctypes.c_uint32, ctypes.c_uint32, ctypes.c_int32, ]
_ctdbsdk.ctdbFindResourceByName.restype = ctypes.c_int32
_ctdbsdk.ctdbFindResourceByName.argtypes = [ctypes.c_void_p, ctypes.c_char_p, ctypes.c_int32, ]
_ctdbsdk.ctdbIsResourceLocked.restype = ctypes.c_int32
_ctdbsdk.ctdbIsResourceLocked.argtypes = [ctypes.c_void_p, ]
_ctdbsdk.ctdbGetResourceType.restype = ctypes.c_uint32
_ctdbsdk.ctdbGetResourceType.argtypes = [ctypes.c_void_p, ]
_ctdbsdk.ctdbSetResourceType.restype = ctypes.c_int32
_ctdbsdk.ctdbSetResourceType.argtypes = [ctypes.c_void_p, ctypes.c_uint32, ]
_ctdbsdk.ctdbGetResourceNumber.restype = ctypes.c_uint32
_ctdbsdk.ctdbGetResourceNumber.argtypes = [ctypes.c_void_p, ]
_ctdbsdk.ctdbSetResourceNumber.restype = ctypes.c_int32
_ctdbsdk.ctdbSetResourceNumber.argtypes = [ctypes.c_void_p, ctypes.c_uint32, ]
_ctdbsdk.ctdbGetResourceName.restype = ctypes.c_char_p
_ctdbsdk.ctdbGetResourceName.argtypes = [ctypes.c_void_p, ]
_ctdbsdk.ctdbSetResourceName.restype = ctypes.c_int32
_ctdbsdk.ctdbSetResourceName.argtypes = [ctypes.c_void_p, ctypes.c_char_p, ]
_ctdbsdk.ctdbGetResourceDataLength.restype = ctypes.c_int32
_ctdbsdk.ctdbGetResourceDataLength.argtypes = [ctypes.c_void_p, ]
_ctdbsdk.ctdbGetResourceData.restype = ctypes.c_void_p
_ctdbsdk.ctdbGetResourceData.argtypes = [ctypes.c_void_p, ]
_ctdbsdk.ctdbSetResourceData.restype = ctypes.c_int32
_ctdbsdk.ctdbSetResourceData.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_int32, ]
_ctdbsdk.ctdbGetBinaryFlag.restype = ctypes.c_int32
_ctdbsdk.ctdbGetBinaryFlag.argtypes = [ctypes.c_void_p, ctypes.c_int32, ]
_ctdbsdk.ctdbSetBinaryFlag.restype = ctypes.c_int32
_ctdbsdk.ctdbSetBinaryFlag.argtypes = [ctypes.c_void_p, ctypes.c_int32, ctypes.c_int32, ]
_ctdbsdk.ctdbCloneTable.restype = ctypes.c_int32
_ctdbsdk.ctdbCloneTable.argtypes = [ctypes.c_void_p, ctypes.c_char_p, ctypes.c_void_p, ]
_ctdbsdk.ctdbSetExtensionHint.restype = ctypes.c_int32
_ctdbsdk.ctdbSetExtensionHint.argtypes = [ctypes.c_void_p, ctypes.c_int32, ]
_ctdbsdk.ctdbGetExtensionHint.restype = ctypes.c_int32
_ctdbsdk.ctdbGetExtensionHint.argtypes = [ctypes.c_void_p, ]
_ctdbsdk.ctdbCheckRecordSchemaConversion.restype = ctypes.c_int32
_ctdbsdk.ctdbCheckRecordSchemaConversion.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ]
_ctdbsdk.ctdbStartRecordSchemaConversion.restype = ctypes.c_int32
_ctdbsdk.ctdbStartRecordSchemaConversion.argtypes = [ctypes.c_void_p, ]
_ctdbsdk.ctdbTableHasCallback.restype = ctypes.c_int32
_ctdbsdk.ctdbTableHasCallback.argtypes = [ctypes.c_void_p, ]
_ctdbsdk.ctdbGetRecordHandle.restype = ctypes.c_void_p
_ctdbsdk.ctdbGetRecordHandle.argtypes = [ctypes.c_void_p, ]
_ctdbsdk.ctdbAllocRecord.restype = ctypes.c_void_p
_ctdbsdk.ctdbAllocRecord.argtypes = [ctypes.c_void_p, ]
_ctdbsdk.ctdbDuplicateRecord.restype = ctypes.c_void_p
_ctdbsdk.ctdbDuplicateRecord.argtypes = [ctypes.c_void_p, ]
_ctdbsdk.ctdbCopyRecordBuffer.restype = ctypes.c_int32
_ctdbsdk.ctdbCopyRecordBuffer.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ]
_ctdbsdk.ctdbAssignRecordBuffer.restype = ctypes.c_int32
_ctdbsdk.ctdbAssignRecordBuffer.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_int32, ]
_ctdbsdk.ctdbFreeRecord.restype = None
_ctdbsdk.ctdbFreeRecord.argtypes = [ctypes.c_void_p, ]
_ctdbsdk.ctdbResetRecord.restype = ctypes.c_int32
_ctdbsdk.ctdbResetRecord.argtypes = [ctypes.c_void_p, ]
_ctdbsdk.ctdbFirstRecord.restype = ctypes.c_int32
_ctdbsdk.ctdbFirstRecord.argtypes = [ctypes.c_void_p, ]
_ctdbsdk.ctdbLastRecord.restype = ctypes.c_int32
_ctdbsdk.ctdbLastRecord.argtypes = [ctypes.c_void_p, ]
_ctdbsdk.ctdbNextRecord.restype = ctypes.c_int32
_ctdbsdk.ctdbNextRecord.argtypes = [ctypes.c_void_p, ]
_ctdbsdk.ctdbPrevRecord.restype = ctypes.c_int32
_ctdbsdk.ctdbPrevRecord.argtypes = [ctypes.c_void_p, ]
_ctdbsdk.ctdbFindTarget.restype = ctypes.c_int32
_ctdbsdk.ctdbFindTarget.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_int32, ]
_ctdbsdk.ctdbFindRecord.restype = ctypes.c_int32
_ctdbsdk.ctdbFindRecord.argtypes = [ctypes.c_void_p, ctypes.c_int32, ]
_ctdbsdk.ctdbLocateRecord.restype = ctypes.c_int32
_ctdbsdk.ctdbLocateRecord.argtypes = [ctypes.c_void_p, ctypes.c_int32, ]
_ctdbsdk.ctdbSetRecordCriteria.restype = ctypes.c_int32
_ctdbsdk.ctdbSetRecordCriteria.argtypes = [ctypes.c_void_p, ctypes.c_int32, ]
_ctdbsdk.ctdbUpdateRecordCriteria.restype = ctypes.c_int32
_ctdbsdk.ctdbUpdateRecordCriteria.argtypes = [ctypes.c_void_p, ctypes.c_int32, ]
_ctdbsdk.ctdbGetBestIndex.restype = ctypes.c_void_p
_ctdbsdk.ctdbGetBestIndex.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_int32, ]
_ctdbsdk.ctdbAddLocateCriteria.restype = ctypes.c_int32
_ctdbsdk.ctdbAddLocateCriteria.argtypes = [ctypes.c_void_p, ctypes.c_char_p, ctypes.c_char_p, ]
_ctdbsdk.ctdbClearRecord.restype = ctypes.c_int32
_ctdbsdk.ctdbClearRecord.argtypes = [ctypes.c_void_p, ]
_ctdbsdk.ctdbReadRecord.restype = ctypes.c_int32
_ctdbsdk.ctdbReadRecord.argtypes = [ctypes.c_void_p, ]
_ctdbsdk.ctdbWriteRecord.restype = ctypes.c_int32
_ctdbsdk.ctdbWriteRecord.argtypes = [ctypes.c_void_p, ]
_ctdbsdk.ctdbDeleteRecord.restype = ctypes.c_int32
_ctdbsdk.ctdbDeleteRecord.argtypes = [ctypes.c_void_p, ]
_ctdbsdk.ctdbGetRecordBuffer.restype = ctypes.c_void_p
_ctdbsdk.ctdbGetRecordBuffer.argtypes = [ctypes.c_void_p, ]
_ctdbsdk.ctdbGetRecordLength.restype = ctypes.c_int32
_ctdbsdk.ctdbGetRecordLength.argtypes = [ctypes.c_void_p, ]
_ctdbsdk.ctdbGetRecordSize.restype = ctypes.c_int32
_ctdbsdk.ctdbGetRecordSize.argtypes = [ctypes.c_void_p, ]
_ctdbsdk.ctdbIsNewRecord.restype = ctypes.c_int32
_ctdbsdk.ctdbIsNewRecord.argtypes = [ctypes.c_void_p, ]
_ctdbsdk.ctdbIsEditedRecord.restype = ctypes.c_int32
_ctdbsdk.ctdbIsEditedRecord.argtypes = [ctypes.c_void_p, ]
_ctdbsdk.ctdbSetNewRecord.restype = ctypes.c_int32
_ctdbsdk.ctdbSetNewRecord.argtypes = [ctypes.c_void_p, ctypes.c_int32, ]
_ctdbsdk.ctdbSetEditedRecord.restype = ctypes.c_int32
_ctdbsdk.ctdbSetEditedRecord.argtypes = [ctypes.c_void_p, ctypes.c_int32, ]
_ctdbsdk.ctdbSetRecordBuffer.restype = ctypes.c_int32
_ctdbsdk.ctdbSetRecordBuffer.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_int32, ctypes.c_uint32, ]
_ctdbsdk.ctdbIsNullField.restype = ctypes.c_int32
_ctdbsdk.ctdbIsNullField.argtypes = [ctypes.c_void_p, ctypes.c_int32, ]
_ctdbsdk.ctdbGetRecordPos.restype = ctypes.c_int32
_ctdbsdk.ctdbGetRecordPos.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ]
_ctdbsdk.ctdbGetRecordKeyPos.restype = ctypes.c_int32
_ctdbsdk.ctdbGetRecordKeyPos.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ]
_ctdbsdk.ctdbSetRecordPos.restype = ctypes.c_int32
_ctdbsdk.ctdbSetRecordPos.argtypes = [ctypes.c_void_p, ctypes.c_longlong, ]
_ctdbsdk.ctdbSetRecordOffset.restype = ctypes.c_int32
_ctdbsdk.ctdbSetRecordOffset.argtypes = [ctypes.c_void_p, ctypes.c_longlong, ]
_ctdbsdk.ctdbSeekRecord.restype = ctypes.c_int32
_ctdbsdk.ctdbSeekRecord.argtypes = [ctypes.c_void_p, ctypes.c_longlong, ]
_ctdbsdk.ctdbGetDefaultIndex.restype = ctypes.c_int32
_ctdbsdk.ctdbGetDefaultIndex.argtypes = [ctypes.c_void_p, ]
_ctdbsdk.ctdbGetDefaultIndexName.restype = ctypes.c_char_p
_ctdbsdk.ctdbGetDefaultIndexName.argtypes = [ctypes.c_void_p, ]
_ctdbsdk.ctdbSetDefaultIndex.restype = ctypes.c_int32
_ctdbsdk.ctdbSetDefaultIndex.argtypes = [ctypes.c_void_p, ctypes.c_int32, ]
_ctdbsdk.ctdbSetDefaultIndexByName.restype = ctypes.c_int32
_ctdbsdk.ctdbSetDefaultIndexByName.argtypes = [ctypes.c_void_p, ctypes.c_char_p, ]
_ctdbsdk.ctdbGetFieldNumberByName.restype = ctypes.c_int32
_ctdbsdk.ctdbGetFieldNumberByName.argtypes = [ctypes.c_void_p, ctypes.c_char_p, ]
_ctdbsdk.ctdbGetFieldAsBool.restype = ctypes.c_int32
_ctdbsdk.ctdbGetFieldAsBool.argtypes = [ctypes.c_void_p, ctypes.c_int32, ctypes.c_void_p, ]
_ctdbsdk.ctdbGetFieldAsSigned.restype = ctypes.c_int32
_ctdbsdk.ctdbGetFieldAsSigned.argtypes = [ctypes.c_void_p, ctypes.c_int32, ctypes.c_void_p, ]
_ctdbsdk.ctdbGetFieldAsUnsigned.restype = ctypes.c_int32
_ctdbsdk.ctdbGetFieldAsUnsigned.argtypes = [ctypes.c_void_p, ctypes.c_int32, ctypes.c_void_p, ]
_ctdbsdk.ctdbGetFieldAsDate.restype = ctypes.c_int32
_ctdbsdk.ctdbGetFieldAsDate.argtypes = [ctypes.c_void_p, ctypes.c_int32, ctypes.c_void_p, ]
_ctdbsdk.ctdbGetFieldAsTime.restype = ctypes.c_int32
_ctdbsdk.ctdbGetFieldAsTime.argtypes = [ctypes.c_void_p, ctypes.c_int32, ctypes.c_void_p, ]
_ctdbsdk.ctdbGetFieldAsTimeMsec.restype = ctypes.c_int32
_ctdbsdk.ctdbGetFieldAsTimeMsec.argtypes = [ctypes.c_void_p, ctypes.c_int32, ctypes.c_void_p, ]
_ctdbsdk.ctdbGetFieldAsMoney.restype = ctypes.c_int32
_ctdbsdk.ctdbGetFieldAsMoney.argtypes = [ctypes.c_void_p, ctypes.c_int32, ctypes.c_void_p, ]
_ctdbsdk.ctdbGetFieldAsFloat.restype = ctypes.c_int32
_ctdbsdk.ctdbGetFieldAsFloat.argtypes = [ctypes.c_void_p, ctypes.c_int32, ctypes.c_void_p, ]
_ctdbsdk.ctdbGetFieldAsDateTime.restype = ctypes.c_int32
_ctdbsdk.ctdbGetFieldAsDateTime.argtypes = [ctypes.c_void_p, ctypes.c_int32, ctypes.c_void_p, ]
_ctdbsdk.ctdbGetFieldAsString.restype = ctypes.c_int32
_ctdbsdk.ctdbGetFieldAsString.argtypes = [ctypes.c_void_p, ctypes.c_int32, ctypes.c_char_p, ctypes.c_int32, ]
_ctdbsdk.ctdbGetFieldAsJSON.restype = ctypes.c_int32
_ctdbsdk.ctdbGetFieldAsJSON.argtypes = [ctypes.c_void_p, ctypes.c_int32, ctypes.c_char_p, ctypes.c_int32, ]
_ctdbsdk.ctdbGetFieldAsBinary.restype = ctypes.c_int32
_ctdbsdk.ctdbGetFieldAsBinary.argtypes = [ctypes.c_void_p, ctypes.c_int32, ctypes.c_void_p, ctypes.c_int32, ]
_ctdbsdk.ctdbGetFieldAsBlob.restype = ctypes.c_int32
_ctdbsdk.ctdbGetFieldAsBlob.argtypes = [ctypes.c_void_p, ctypes.c_int32, ctypes.c_void_p, ]
_ctdbsdk.ctdbGetFieldAsBigint.restype = ctypes.c_int32
_ctdbsdk.ctdbGetFieldAsBigint.argtypes = [ctypes.c_void_p, ctypes.c_int32, ctypes.c_void_p, ]
_ctdbsdk.ctdbGetFieldAsUnsignedBigint.restype = ctypes.c_int32
_ctdbsdk.ctdbGetFieldAsUnsignedBigint.argtypes = [ctypes.c_void_p, ctypes.c_int32, ctypes.c_void_p, ]
_ctdbsdk.ctdbGetFieldAsCurrency.restype = ctypes.c_int32
_ctdbsdk.ctdbGetFieldAsCurrency.argtypes = [ctypes.c_void_p, ctypes.c_int32, ctypes.c_void_p, ]
_ctdbsdk.ctdbGetFieldAsNumber.restype = ctypes.c_int32
_ctdbsdk.ctdbGetFieldAsNumber.argtypes = [ctypes.c_void_p, ctypes.c_int32, ctypes.c_void_p, ]
_ctdbsdk.ctdbSetFieldAsBool.restype = ctypes.c_int32
_ctdbsdk.ctdbSetFieldAsBool.argtypes = [ctypes.c_void_p, ctypes.c_int32, ctypes.c_int32, ]
_ctdbsdk.ctdbSetFieldAsSigned.restype = ctypes.c_int32
_ctdbsdk.ctdbSetFieldAsSigned.argtypes = [ctypes.c_void_p, ctypes.c_int32, ctypes.c_int32, ]
_ctdbsdk.ctdbSetFieldAsUnsigned.restype = ctypes.c_int32
_ctdbsdk.ctdbSetFieldAsUnsigned.argtypes = [ctypes.c_void_p, ctypes.c_int32, ctypes.c_uint32, ]
_ctdbsdk.ctdbSetFieldAsDate.restype = ctypes.c_int32
_ctdbsdk.ctdbSetFieldAsDate.argtypes = [ctypes.c_void_p, ctypes.c_int32, ctypes.c_uint32, ]
_ctdbsdk.ctdbSetFieldAsTime.restype = ctypes.c_int32
_ctdbsdk.ctdbSetFieldAsTime.argtypes = [ctypes.c_void_p, ctypes.c_int32, ctypes.c_uint32, ]
_ctdbsdk.ctdbSetFieldAsTimeMsec.restype = ctypes.c_int32
_ctdbsdk.ctdbSetFieldAsTimeMsec.argtypes = [ctypes.c_void_p, ctypes.c_int32, ctypes.c_uint32, ]
_ctdbsdk.ctdbSetFieldAsMoney.restype = ctypes.c_int32
_ctdbsdk.ctdbSetFieldAsMoney.argtypes = [ctypes.c_void_p, ctypes.c_int32, ctypes.c_int32, ]
_ctdbsdk.ctdbSetFieldAsFloat.restype = ctypes.c_int32
_ctdbsdk.ctdbSetFieldAsFloat.argtypes = [ctypes.c_void_p, ctypes.c_int32, ctypes.c_double, ]
_ctdbsdk.ctdbSetFieldAsDateTime.restype = ctypes.c_int32
_ctdbsdk.ctdbSetFieldAsDateTime.argtypes = [ctypes.c_void_p, ctypes.c_int32, ctypes.c_double, ]
_ctdbsdk.ctdbSetFieldAsString.restype = ctypes.c_int32
_ctdbsdk.ctdbSetFieldAsString.argtypes = [ctypes.c_void_p, ctypes.c_int32, ctypes.c_char_p, ]
_ctdbsdk.ctdbSetFieldAsJSON.restype = ctypes.c_int32
_ctdbsdk.ctdbSetFieldAsJSON.argtypes = [ctypes.c_void_p, ctypes.c_int32, ctypes.c_char_p, ]
_ctdbsdk.ctdbSetFieldAsBinary.restype = ctypes.c_int32
_ctdbsdk.ctdbSetFieldAsBinary.argtypes = [ctypes.c_void_p, ctypes.c_int32, ctypes.c_void_p, ctypes.c_int32, ]
_ctdbsdk.ctdbSetFieldAsBlob.restype = ctypes.c_int32
_ctdbsdk.ctdbSetFieldAsBlob.argtypes = [ctypes.c_void_p, ctypes.c_int32, ctypes.c_void_p, ]
_ctdbsdk.ctdbSetFieldAsBigint.restype = ctypes.c_int32
_ctdbsdk.ctdbSetFieldAsBigint.argtypes = [ctypes.c_void_p, ctypes.c_int32, ctypes.c_longlong, ]
_ctdbsdk.ctdbSetFieldAsUnsignedBigint.restype = ctypes.c_int32
_ctdbsdk.ctdbSetFieldAsUnsignedBigint.argtypes = [ctypes.c_void_p, ctypes.c_int32, ctypes.c_ulonglong, ]
_ctdbsdk.ctdbSetFieldAsCurrency.restype = ctypes.c_int32
_ctdbsdk.ctdbSetFieldAsCurrency.argtypes = [ctypes.c_void_p, ctypes.c_int32, ctypes.c_longlong, ]
_ctdbsdk.ctdbSetFieldAsNumber.restype = ctypes.c_int32
_ctdbsdk.ctdbSetFieldAsNumber.argtypes = [ctypes.c_void_p, ctypes.c_int32, ctypes.c_void_p, ]
_ctdbsdk.ctdbGetRecordCount.restype = ctypes.c_int32
_ctdbsdk.ctdbGetRecordCount.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ]
_ctdbsdk.ctdbRecordSetOn.restype = ctypes.c_int32
_ctdbsdk.ctdbRecordSetOn.argtypes = [ctypes.c_void_p, ctypes.c_int32, ]
_ctdbsdk.ctdbRecordSetOff.restype = ctypes.c_int32
_ctdbsdk.ctdbRecordSetOff.argtypes = [ctypes.c_void_p, ]
_ctdbsdk.ctdbIsRecordSetOn.restype = ctypes.c_int32
_ctdbsdk.ctdbIsRecordSetOn.argtypes = [ctypes.c_void_p, ]
_ctdbsdk.ctdbIsVariableField.restype = ctypes.c_int32
_ctdbsdk.ctdbIsVariableField.argtypes = [ctypes.c_void_p, ctypes.c_int32, ]
_ctdbsdk.ctdbGetFieldDataLength.restype = ctypes.c_int32
_ctdbsdk.ctdbGetFieldDataLength.argtypes = [ctypes.c_void_p, ctypes.c_int32, ]
_ctdbsdk.ctdbGetFieldSize.restype = ctypes.c_int32
_ctdbsdk.ctdbGetFieldSize.argtypes = [ctypes.c_void_p, ctypes.c_int32, ]
_ctdbsdk.ctdbGetFieldOffset.restype = ctypes.c_int32
_ctdbsdk.ctdbGetFieldOffset.argtypes = [ctypes.c_void_p, ctypes.c_int32, ]
_ctdbsdk.ctdbGetFieldAddress.restype = ctypes.c_void_p
_ctdbsdk.ctdbGetFieldAddress.argtypes = [ctypes.c_void_p, ctypes.c_int32, ]
_ctdbsdk.ctdbClearField.restype = ctypes.c_int32
_ctdbsdk.ctdbClearField.argtypes = [ctypes.c_void_p, ctypes.c_int32, ]
_ctdbsdk.ctdbLockRecord.restype = ctypes.c_int32
_ctdbsdk.ctdbLockRecord.argtypes = [ctypes.c_void_p, ctypes.c_int32, ]
_ctdbsdk.ctdbUnlockRecord.restype = ctypes.c_int32
_ctdbsdk.ctdbUnlockRecord.argtypes = [ctypes.c_void_p, ]
_ctdbsdk.ctdbBuildTargetKey.restype = ctypes.c_int32
_ctdbsdk.ctdbBuildTargetKey.argtypes = [ctypes.c_void_p, ctypes.c_int32, ctypes.c_void_p, ctypes.c_void_p, ]
_ctdbsdk.ctdbGetFieldData.restype = ctypes.c_void_p
_ctdbsdk.ctdbGetFieldData.argtypes = [ctypes.c_void_p, ctypes.c_int32, ]
_ctdbsdk.ctdbGetRecordNbr.restype = ctypes.c_int32
_ctdbsdk.ctdbGetRecordNbr.argtypes = [ctypes.c_void_p, ]
_ctdbsdk.ctdbGetRecord.restype = ctypes.c_void_p
_ctdbsdk.ctdbGetRecord.argtypes = [ctypes.c_void_p, ctypes.c_int32, ]
_ctdbsdk.ctdbGetRowid.restype = ctypes.c_int32
_ctdbsdk.ctdbGetRowid.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ]
_ctdbsdk.ctdbFindRowid.restype = ctypes.c_int32
_ctdbsdk.ctdbFindRowid.argtypes = [ctypes.c_void_p, ctypes.c_longlong, ctypes.c_int32, ]
_ctdbsdk.ctdbFindKey.restype = ctypes.c_int32
_ctdbsdk.ctdbFindKey.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_int32, ]
_ctdbsdk.ctdbRecordBlockingReadOn.restype = ctypes.c_int32
_ctdbsdk.ctdbRecordBlockingReadOn.argtypes = [ctypes.c_void_p, ctypes.c_int32, ctypes.c_char_p, ]
_ctdbsdk.ctdbIsRecordBlockingReadOn.restype = ctypes.c_int32
_ctdbsdk.ctdbIsRecordBlockingReadOn.argtypes = [ctypes.c_void_p, ]
_ctdbsdk.ctdbRecordBlockingReadOff.restype = ctypes.c_int32
_ctdbsdk.ctdbRecordBlockingReadOff.argtypes = [ctypes.c_void_p, ]
_ctdbsdk.ctdbFilterRecord.restype = ctypes.c_int32
_ctdbsdk.ctdbFilterRecord.argtypes = [ctypes.c_void_p, ctypes.c_char_p, ]
_ctdbsdk.ctdbIsFilteredRecord.restype = ctypes.c_int32
_ctdbsdk.ctdbIsFilteredRecord.argtypes = [ctypes.c_void_p, ]
_ctdbsdk.ctdbGetFilter.restype = ctypes.c_char_p
_ctdbsdk.ctdbGetFilter.argtypes = [ctypes.c_void_p, ]
_ctdbsdk.ctdbSetFilter.restype = ctypes.c_int32
_ctdbsdk.ctdbSetFilter.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_int32, ]
_ctdbsdk.ctdbGetFilterType.restype = ctypes.c_int32
_ctdbsdk.ctdbGetFilterType.argtypes = [ctypes.c_void_p, ]
_ctdbsdk.ctdbGetRecordLock.restype = ctypes.c_int32
_ctdbsdk.ctdbGetRecordLock.argtypes = [ctypes.c_void_p, ]
_ctdbsdk.ctdbCompareRecords.restype = ctypes.c_int32
_ctdbsdk.ctdbCompareRecords.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ]
_ctdbsdk.ctdbRecordAtPercentile.restype = ctypes.c_int32
_ctdbsdk.ctdbRecordAtPercentile.argtypes = [ctypes.c_void_p, ctypes.c_int32, ]
_ctdbsdk.ctdbRecordPosAtOffset.restype = ctypes.c_int32
_ctdbsdk.ctdbRecordPosAtOffset.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ]
_ctdbsdk.ctdbEstimateSpan.restype = ctypes.c_ulonglong
_ctdbsdk.ctdbEstimateSpan.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ]
_ctdbsdk.ctdbRecordRangeOn.restype = ctypes.c_int32
_ctdbsdk.ctdbRecordRangeOn.argtypes = [ctypes.c_void_p, ctypes.c_int32, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ]
_ctdbsdk.ctdbRecordRangeXtdOn.restype = ctypes.c_int32
_ctdbsdk.ctdbRecordRangeXtdOn.argtypes = [ctypes.c_void_p, ctypes.c_int32, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint32, ]
_ctdbsdk.ctdbRecordRangeOff.restype = ctypes.c_int32
_ctdbsdk.ctdbRecordRangeOff.argtypes = [ctypes.c_void_p, ]
_ctdbsdk.ctdbIsRecordRangeOn.restype = ctypes.c_int32
_ctdbsdk.ctdbIsRecordRangeOn.argtypes = [ctypes.c_void_p, ]
_ctdbsdk.ctdbSwitchContext.restype = ctypes.c_int32
_ctdbsdk.ctdbSwitchContext.argtypes = [ctypes.c_void_p, ]
_ctdbsdk.ctdbBatchLoaded.restype = ctypes.c_int32
_ctdbsdk.ctdbBatchLoaded.argtypes = [ctypes.c_void_p, ]
_ctdbsdk.ctdbBatchLocked.restype = ctypes.c_int32
_ctdbsdk.ctdbBatchLocked.argtypes = [ctypes.c_void_p, ]
_ctdbsdk.ctdbBatchTotal.restype = ctypes.c_int32
_ctdbsdk.ctdbBatchTotal.argtypes = [ctypes.c_void_p, ]
_ctdbsdk.ctdbBatchMode.restype = ctypes.c_uint32
_ctdbsdk.ctdbBatchMode.argtypes = [ctypes.c_void_p, ]
_ctdbsdk.ctdbEndBatch.restype = ctypes.c_int32
_ctdbsdk.ctdbEndBatch.argtypes = [ctypes.c_void_p, ]
_ctdbsdk.ctdbInsertBatch.restype = ctypes.c_int32
_ctdbsdk.ctdbInsertBatch.argtypes = [ctypes.c_void_p, ]
_ctdbsdk.ctdbIsBatchActive.restype = ctypes.c_int32
_ctdbsdk.ctdbIsBatchActive.argtypes = [ctypes.c_void_p, ]
_ctdbsdk.ctdbNextBatch.restype = ctypes.c_int32
_ctdbsdk.ctdbNextBatch.argtypes = [ctypes.c_void_p, ]
_ctdbsdk.ctdbSetBatch.restype = ctypes.c_int32
_ctdbsdk.ctdbSetBatch.argtypes = [ctypes.c_void_p, ctypes.c_uint32, ctypes.c_int32, ctypes.c_int32, ]
_ctdbsdk.ctdbSetBatchFilter.restype = ctypes.c_int32
_ctdbsdk.ctdbSetBatchFilter.argtypes = [ctypes.c_void_p, ctypes.c_char_p, ]
_ctdbsdk.ctdbSetBatchRangeOn.restype = ctypes.c_int32
_ctdbsdk.ctdbSetBatchRangeOn.argtypes = [ctypes.c_void_p, ctypes.c_int32, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ]
_ctdbsdk.ctdbSetBatchRangeOff.restype = ctypes.c_int32
_ctdbsdk.ctdbSetBatchRangeOff.argtypes = [ctypes.c_void_p, ]
_ctdbsdk.ctdbGetErrorIndex.restype = ctypes.c_int32
_ctdbsdk.ctdbGetErrorIndex.argtypes = [ctypes.c_void_p, ]
_ctdbsdk.ctdbNumberOfKeyEntries.restype = ctypes.c_int32
_ctdbsdk.ctdbNumberOfKeyEntries.argtypes = [ctypes.c_void_p, ctypes.c_int32, ]
_ctdbsdk.ctdbJumpToRecord.restype = ctypes.c_int32
_ctdbsdk.ctdbJumpToRecord.argtypes = [ctypes.c_void_p, ctypes.c_int32, ]
_ctdbsdk.ctdbGetLastIdentity.restype = ctypes.c_int32
_ctdbsdk.ctdbGetLastIdentity.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ]
_ctdbsdk.ctdbParseRecordExpr.restype = ctypes.c_int32
_ctdbsdk.ctdbParseRecordExpr.argtypes = [ctypes.c_void_p, ctypes.c_char_p, ctypes.c_void_p, ctypes.c_void_p, ]
_ctdbsdk.ctdbEvalExprAsSigned.restype = ctypes.c_int32
_ctdbsdk.ctdbEvalExprAsSigned.argtypes = [ctypes.c_void_p, ctypes.c_int32, ctypes.c_void_p, ]
_ctdbsdk.ctdbEvalExprAsDate.restype = ctypes.c_int32
_ctdbsdk.ctdbEvalExprAsDate.argtypes = [ctypes.c_void_p, ctypes.c_int32, ctypes.c_void_p, ]
_ctdbsdk.ctdbEvalExprAsTime.restype = ctypes.c_int32
_ctdbsdk.ctdbEvalExprAsTime.argtypes = [ctypes.c_void_p, ctypes.c_int32, ctypes.c_void_p, ]
_ctdbsdk.ctdbEvalExprAsDateTime.restype = ctypes.c_int32
_ctdbsdk.ctdbEvalExprAsDateTime.argtypes = [ctypes.c_void_p, ctypes.c_int32, ctypes.c_void_p, ]
_ctdbsdk.ctdbEvalExprAsNumber.restype = ctypes.c_int32
_ctdbsdk.ctdbEvalExprAsNumber.argtypes = [ctypes.c_void_p, ctypes.c_int32, ctypes.c_void_p, ]
_ctdbsdk.ctdbEvalExprAsString.restype = ctypes.c_int32
_ctdbsdk.ctdbEvalExprAsString.argtypes = [ctypes.c_void_p, ctypes.c_int32, ctypes.c_char_p, ctypes.c_void_p, ]
_ctdbsdk.ctdbAddUserDefFunc.restype = ctypes.c_int32
_ctdbsdk.ctdbAddUserDefFunc.argtypes = [ctypes.c_void_p, ctypes.c_char_p, ctypes.c_void_p, ctypes.c_int32, ctypes.c_void_p, ctypes.c_short, ]
_ctdbsdk.ctdbGetActiveResultSet.restype = ctypes.c_void_p
_ctdbsdk.ctdbGetActiveResultSet.argtypes = [ctypes.c_void_p, ]
_ctdbsdk.ctdbFTSearchOn.restype = ctypes.c_int32
_ctdbsdk.ctdbFTSearchOn.argtypes = [ctypes.c_void_p, ctypes.c_char_p, ctypes.c_int32, ]
_ctdbsdk.ctdbIsFTSearchOn.restype = ctypes.c_int32
_ctdbsdk.ctdbIsFTSearchOn.argtypes = [ctypes.c_void_p, ]
_ctdbsdk.ctdbFTSearchOff.restype = ctypes.c_int32
_ctdbsdk.ctdbFTSearchOff.argtypes = [ctypes.c_void_p, ]
_ctdbsdk.ctdbGetFTSErrorDetails.restype = ctypes.c_int32
_ctdbsdk.ctdbGetFTSErrorDetails.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ]
_ctdbsdk.ctdbAddToFieldMask.restype = ctypes.c_int32
_ctdbsdk.ctdbAddToFieldMask.argtypes = [ctypes.c_void_p, ctypes.c_int32, ]
_ctdbsdk.ctdbRemoveFieldMask.restype = ctypes.c_int32
_ctdbsdk.ctdbRemoveFieldMask.argtypes = [ctypes.c_void_p, ]
_ctdbsdk.ctdbIsFieldMaskOn.restype = ctypes.c_int32
_ctdbsdk.ctdbIsFieldMaskOn.argtypes = [ctypes.c_void_p, ]
_ctdbsdk.ctdbGetIndexHandle.restype = ctypes.c_void_p
_ctdbsdk.ctdbGetIndexHandle.argtypes = [ctypes.c_void_p, ]
_ctdbsdk.ctdbAllocIndex.restype = ctypes.c_void_p
_ctdbsdk.ctdbAllocIndex.argtypes = [ctypes.c_void_p, ]
_ctdbsdk.ctdbFreeIndex.restype = None
_ctdbsdk.ctdbFreeIndex.argtypes = [ctypes.c_void_p, ]
_ctdbsdk.ctdbAddIndex.restype = ctypes.c_void_p
_ctdbsdk.ctdbAddIndex.argtypes = [ctypes.c_void_p, ctypes.c_char_p, ctypes.c_int32, ctypes.c_int32, ctypes.c_int32, ]
_ctdbsdk.ctdbDelIndex.restype = ctypes.c_int32
_ctdbsdk.ctdbDelIndex.argtypes = [ctypes.c_void_p, ctypes.c_int32, ]
_ctdbsdk.ctdbGetIndex.restype = ctypes.c_void_p
_ctdbsdk.ctdbGetIndex.argtypes = [ctypes.c_void_p, ctypes.c_int32, ]
_ctdbsdk.ctdbGetIndexNbrByName.restype = ctypes.c_int32
_ctdbsdk.ctdbGetIndexNbrByName.argtypes = [ctypes.c_void_p, ctypes.c_char_p, ]
_ctdbsdk.ctdbGetIndexByName.restype = ctypes.c_void_p
_ctdbsdk.ctdbGetIndexByName.argtypes = [ctypes.c_void_p, ctypes.c_char_p, ]
_ctdbsdk.ctdbGetIndexByUID.restype = ctypes.c_void_p
_ctdbsdk.ctdbGetIndexByUID.argtypes = [ctypes.c_void_p, ctypes.c_uint32, ]
_ctdbsdk.ctdbGetIndexSegmentCount.restype = ctypes.c_int32
_ctdbsdk.ctdbGetIndexSegmentCount.argtypes = [ctypes.c_void_p, ]
_ctdbsdk.ctdbGetIndexKeyLength.restype = ctypes.c_int32
_ctdbsdk.ctdbGetIndexKeyLength.argtypes = [ctypes.c_void_p, ]
_ctdbsdk.ctdbGetIndexKeyType.restype = ctypes.c_int32
_ctdbsdk.ctdbGetIndexKeyType.argtypes = [ctypes.c_void_p, ]
_ctdbsdk.ctdbGetIndexEmptyChar.restype = ctypes.c_int32
_ctdbsdk.ctdbGetIndexEmptyChar.argtypes = [ctypes.c_void_p, ]
_ctdbsdk.ctdbGetIndexDuplicateFlag.restype = ctypes.c_int32
_ctdbsdk.ctdbGetIndexDuplicateFlag.argtypes = [ctypes.c_void_p, ]
_ctdbsdk.ctdbGetIndexNullFlag.restype = ctypes.c_int32
_ctdbsdk.ctdbGetIndexNullFlag.argtypes = [ctypes.c_void_p, ]
_ctdbsdk.ctdbGetIndexTemporaryFlag.restype = ctypes.c_int32
_ctdbsdk.ctdbGetIndexTemporaryFlag.argtypes = [ctypes.c_void_p, ]
_ctdbsdk.ctdbSetIndexKeyType.restype = ctypes.c_int32
_ctdbsdk.ctdbSetIndexKeyType.argtypes = [ctypes.c_void_p, ctypes.c_int32, ]
_ctdbsdk.ctdbSetIndexEmptyChar.restype = ctypes.c_int32
_ctdbsdk.ctdbSetIndexEmptyChar.argtypes = [ctypes.c_void_p, ctypes.c_int32, ]
_ctdbsdk.ctdbSetIndexDuplicateFlag.restype = ctypes.c_int32
_ctdbsdk.ctdbSetIndexDuplicateFlag.argtypes = [ctypes.c_void_p, ctypes.c_int32, ]
_ctdbsdk.ctdbSetIndexNullFlag.restype = ctypes.c_int32
_ctdbsdk.ctdbSetIndexNullFlag.argtypes = [ctypes.c_void_p, ctypes.c_int32, ]
_ctdbsdk.ctdbSetIndexTemporaryFlag.restype = ctypes.c_int32
_ctdbsdk.ctdbSetIndexTemporaryFlag.argtypes = [ctypes.c_void_p, ctypes.c_int32, ]
_ctdbsdk.ctdbSetIndexCndxExpr.restype = ctypes.c_int32
_ctdbsdk.ctdbSetIndexCndxExpr.argtypes = [ctypes.c_void_p, ctypes.c_char_p, ]
_ctdbsdk.ctdbGetIndexNbr.restype = ctypes.c_int32
_ctdbsdk.ctdbGetIndexNbr.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ]
_ctdbsdk.ctdbGetIndexUID.restype = ctypes.c_int32
_ctdbsdk.ctdbGetIndexUID.argtypes = [ctypes.c_void_p, ctypes.c_char_p, ctypes.c_void_p, ]
_ctdbsdk.ctdbSetIndexFilename.restype = ctypes.c_int32
_ctdbsdk.ctdbSetIndexFilename.argtypes = [ctypes.c_void_p, ctypes.c_char_p, ctypes.c_char_p, ]
_ctdbsdk.ctdbGetIndexFilename.restype = ctypes.c_char_p
_ctdbsdk.ctdbGetIndexFilename.argtypes = [ctypes.c_void_p, ]
_ctdbsdk.ctdbGetIdxno.restype = ctypes.c_int32
_ctdbsdk.ctdbGetIdxno.argtypes = [ctypes.c_void_p, ]
_ctdbsdk.ctdbSetIndexDistinctKeyCountFlag.restype = ctypes.c_int32
_ctdbsdk.ctdbSetIndexDistinctKeyCountFlag.argtypes = [ctypes.c_void_p, ctypes.c_int32, ]
_ctdbsdk.ctdbGetIndexDistinctKeyCountFlag.restype = ctypes.c_int32
_ctdbsdk.ctdbGetIndexDistinctKeyCountFlag.argtypes = [ctypes.c_void_p, ]
_ctdbsdk.ctdbSetIndexKSeg.restype = ctypes.c_int32
_ctdbsdk.ctdbSetIndexKSeg.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ]
_ctdbsdk.ctdbGetIndexKSeg.restype = ctypes.c_int32
_ctdbsdk.ctdbGetIndexKSeg.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ]
_ctdbsdk.ctdbGetIndexStatus.restype = ctypes.c_uint32
_ctdbsdk.ctdbGetIndexStatus.argtypes = [ctypes.c_void_p, ]
_ctdbsdk.ctdbGetIndexName.restype = ctypes.c_char_p
_ctdbsdk.ctdbGetIndexName.argtypes = [ctypes.c_void_p, ]
_ctdbsdk.ctdbSetIndexName.restype = ctypes.c_int32
_ctdbsdk.ctdbSetIndexName.argtypes = [ctypes.c_void_p, ctypes.c_char_p, ]
_ctdbsdk.ctdbCheckIndexBackgroundLoad.restype = ctypes.c_int32
_ctdbsdk.ctdbCheckIndexBackgroundLoad.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ]
_ctdbsdk.ctdbAllocFTIDict.restype = ctypes.c_void_p
_ctdbsdk.ctdbAllocFTIDict.argtypes = [ctypes.c_void_p, ]
_ctdbsdk.ctdbFreeFTIDict.restype = None
_ctdbsdk.ctdbFreeFTIDict.argtypes = [ctypes.c_void_p, ]
_ctdbsdk.ctdbGetFTIDictHandle.restype = ctypes.c_void_p
_ctdbsdk.ctdbGetFTIDictHandle.argtypes = [ctypes.c_void_p, ]
_ctdbsdk.ctdbSetFTIDictOption.restype = ctypes.c_int32
_ctdbsdk.ctdbSetFTIDictOption.argtypes = [ctypes.c_void_p, ctypes.c_ushort, ctypes.c_char_p, ctypes.c_uint32, ]
_ctdbsdk.ctdbAllocFTI.restype = ctypes.c_void_p
_ctdbsdk.ctdbAllocFTI.argtypes = [ctypes.c_void_p, ]
_ctdbsdk.ctdbFreeFTI.restype = None
_ctdbsdk.ctdbFreeFTI.argtypes = [ctypes.c_void_p, ]
_ctdbsdk.ctdbGetFTIHandle.restype = ctypes.c_void_p
_ctdbsdk.ctdbGetFTIHandle.argtypes = [ctypes.c_void_p, ]
_ctdbsdk.ctdbAddFTI.restype = ctypes.c_void_p
_ctdbsdk.ctdbAddFTI.argtypes = [ctypes.c_void_p, ctypes.c_char_p, ]
_ctdbsdk.ctdbAddFTIField.restype = ctypes.c_int32
_ctdbsdk.ctdbAddFTIField.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint32, ]
_ctdbsdk.ctdbAddFTIFieldByName.restype = ctypes.c_int32
_ctdbsdk.ctdbAddFTIFieldByName.argtypes = [ctypes.c_void_p, ctypes.c_int32, ctypes.c_char_p, ctypes.c_uint32, ]
_ctdbsdk.ctdbGetFTI.restype = ctypes.c_void_p
_ctdbsdk.ctdbGetFTI.argtypes = [ctypes.c_void_p, ctypes.c_int32, ]
_ctdbsdk.ctdbDelFTI.restype = ctypes.c_int32
_ctdbsdk.ctdbDelFTI.argtypes = [ctypes.c_void_p, ctypes.c_int32, ]
_ctdbsdk.ctdbGetTableFTICount.restype = ctypes.c_short
_ctdbsdk.ctdbGetTableFTICount.argtypes = [ctypes.c_void_p, ]
_ctdbsdk.ctdbGetFTIStatus.restype = ctypes.c_uint32
_ctdbsdk.ctdbGetFTIStatus.argtypes = [ctypes.c_void_p, ]
_ctdbsdk.ctdbGetFTIFieldCount.restype = ctypes.c_int32
_ctdbsdk.ctdbGetFTIFieldCount.argtypes = [ctypes.c_void_p, ]
_ctdbsdk.ctdbGetFTIField.restype = ctypes.c_void_p
_ctdbsdk.ctdbGetFTIField.argtypes = [ctypes.c_void_p, ctypes.c_int32, ]
_ctdbsdk.ctdbGetFTIFieldMode.restype = ctypes.c_uint32
_ctdbsdk.ctdbGetFTIFieldMode.argtypes = [ctypes.c_void_p, ctypes.c_int32, ]
_ctdbsdk.ctdbGetFTINbrByName.restype = ctypes.c_short
_ctdbsdk.ctdbGetFTINbrByName.argtypes = [ctypes.c_void_p, ctypes.c_char_p, ]
_ctdbsdk.ctdbGetFTIByName.restype = ctypes.c_void_p
_ctdbsdk.ctdbGetFTIByName.argtypes = [ctypes.c_void_p, ctypes.c_char_p, ]
_ctdbsdk.ctdbSetDefaultFTI.restype = ctypes.c_int32
_ctdbsdk.ctdbSetDefaultFTI.argtypes = [ctypes.c_void_p, ctypes.c_int32, ]
_ctdbsdk.ctdbSetFTIOption.restype = ctypes.c_int32
_ctdbsdk.ctdbSetFTIOption.argtypes = [ctypes.c_void_p, ctypes.c_ushort, ctypes.c_char_p, ctypes.c_uint32, ]
_ctdbsdk.ctdbGetFTIByUID.restype = ctypes.c_void_p
_ctdbsdk.ctdbGetFTIByUID.argtypes = [ctypes.c_void_p, ctypes.c_uint32, ]
_ctdbsdk.ctdbGetFTINbr.restype = ctypes.c_int32
_ctdbsdk.ctdbGetFTINbr.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ]
_ctdbsdk.ctdbGetFTIName.restype = ctypes.c_char_p
_ctdbsdk.ctdbGetFTIName.argtypes = [ctypes.c_void_p, ]
_ctdbsdk.ctdbSetFTICndxExpr.restype = ctypes.c_int32
_ctdbsdk.ctdbSetFTICndxExpr.argtypes = [ctypes.c_void_p, ctypes.c_char_p, ]
_ctdbsdk.ctdbCheckFTIBackgroundLoad.restype = ctypes.c_int32
_ctdbsdk.ctdbCheckFTIBackgroundLoad.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ]
_ctdbsdk.ctdbStartFTIBackgroundLoad.restype = ctypes.c_int32
_ctdbsdk.ctdbStartFTIBackgroundLoad.argtypes = [ctypes.c_void_p, ]
_ctdbsdk.ctdbGetSegmentHandle.restype = ctypes.c_void_p
_ctdbsdk.ctdbGetSegmentHandle.argtypes = [ctypes.c_void_p, ]
_ctdbsdk.ctdbAllocSegment.restype = ctypes.c_void_p
_ctdbsdk.ctdbAllocSegment.argtypes = [ctypes.c_void_p, ]
_ctdbsdk.ctdbFreeSegment.restype = None
_ctdbsdk.ctdbFreeSegment.argtypes = [ctypes.c_void_p, ]
_ctdbsdk.ctdbIsExtSegment.restype = ctypes.c_int32
_ctdbsdk.ctdbIsExtSegment.argtypes = [ctypes.c_int32, ]
_ctdbsdk.ctdbGetSegment.restype = ctypes.c_void_p
_ctdbsdk.ctdbGetSegment.argtypes = [ctypes.c_void_p, ctypes.c_int32, ]
_ctdbsdk.ctdbGetSegmentField.restype = ctypes.c_void_p
_ctdbsdk.ctdbGetSegmentField.argtypes = [ctypes.c_void_p, ]
_ctdbsdk.ctdbGetSegmentPartialField.restype = ctypes.c_void_p
_ctdbsdk.ctdbGetSegmentPartialField.argtypes = [ctypes.c_void_p, ]
_ctdbsdk.ctdbGetSegmentFieldName.restype = ctypes.c_char_p
_ctdbsdk.ctdbGetSegmentFieldName.argtypes = [ctypes.c_void_p, ]
_ctdbsdk.ctdbGetSegmentMode.restype = ctypes.c_int32
_ctdbsdk.ctdbGetSegmentMode.argtypes = [ctypes.c_void_p, ]
_ctdbsdk.ctdbGetSegmentLength.restype = ctypes.c_int32
_ctdbsdk.ctdbGetSegmentLength.argtypes = [ctypes.c_void_p, ]
_ctdbsdk.ctdbSetSegmentMode.restype = ctypes.c_int32
_ctdbsdk.ctdbSetSegmentMode.argtypes = [ctypes.c_void_p, ctypes.c_int32, ]
_ctdbsdk.ctdbGetSegmentNbr.restype = ctypes.c_int32
_ctdbsdk.ctdbGetSegmentNbr.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ]
_ctdbsdk.ctdbAddSegment.restype = ctypes.c_void_p
_ctdbsdk.ctdbAddSegment.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_int32, ]
_ctdbsdk.ctdbAddSegmentEx.restype = ctypes.c_void_p
_ctdbsdk.ctdbAddSegmentEx.argtypes = [ctypes.c_void_p, ctypes.c_int32, ctypes.c_int32, ctypes.c_int32, ]
_ctdbsdk.ctdbAddSegmentByNbr.restype = ctypes.c_void_p
_ctdbsdk.ctdbAddSegmentByNbr.argtypes = [ctypes.c_void_p, ctypes.c_int32, ctypes.c_int32, ctypes.c_int32, ]
_ctdbsdk.ctdbAddSegmentByName.restype = ctypes.c_void_p
_ctdbsdk.ctdbAddSegmentByName.argtypes = [ctypes.c_void_p, ctypes.c_int32, ctypes.c_char_p, ctypes.c_int32, ]
_ctdbsdk.ctdbInsSegment.restype = ctypes.c_void_p
_ctdbsdk.ctdbInsSegment.argtypes = [ctypes.c_void_p, ctypes.c_int32, ctypes.c_void_p, ctypes.c_int32, ]
_ctdbsdk.ctdbInsSegmentByNbr.restype = ctypes.c_void_p
_ctdbsdk.ctdbInsSegmentByNbr.argtypes = [ctypes.c_void_p, ctypes.c_int32, ctypes.c_int32, ctypes.c_int32, ctypes.c_int32, ]
_ctdbsdk.ctdbInsSegmentByName.restype = ctypes.c_void_p
_ctdbsdk.ctdbInsSegmentByName.argtypes = [ctypes.c_void_p, ctypes.c_int32, ctypes.c_int32, ctypes.c_char_p, ctypes.c_int32, ]
_ctdbsdk.ctdbInsSegmentEx.restype = ctypes.c_void_p
_ctdbsdk.ctdbInsSegmentEx.argtypes = [ctypes.c_void_p, ctypes.c_int32, ctypes.c_int32, ctypes.c_int32, ctypes.c_int32, ]
_ctdbsdk.ctdbDelSegment.restype = ctypes.c_int32
_ctdbsdk.ctdbDelSegment.argtypes = [ctypes.c_void_p, ctypes.c_int32, ]
_ctdbsdk.ctdbDelSegmentEx.restype = ctypes.c_int32
_ctdbsdk.ctdbDelSegmentEx.argtypes = [ctypes.c_void_p, ]
_ctdbsdk.ctdbAddRowIdSegment.restype = ctypes.c_void_p
_ctdbsdk.ctdbAddRowIdSegment.argtypes = [ctypes.c_void_p, ]
_ctdbsdk.ctdbAddJSONSegment.restype = ctypes.c_void_p
_ctdbsdk.ctdbAddJSONSegment.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_char_p, ctypes.c_int32, ctypes.c_int32, ]
_ctdbsdk.ctdbSetKSegDefaults.restype = ctypes.c_int32
_ctdbsdk.ctdbSetKSegDefaults.argtypes = [ctypes.c_void_p, ]
_ctdbsdk.ctdbSetSegmentKSeg.restype = ctypes.c_int32
_ctdbsdk.ctdbSetSegmentKSeg.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ]
_ctdbsdk.ctdbGetSegmentKSeg.restype = ctypes.c_int32
_ctdbsdk.ctdbGetSegmentKSeg.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ]
_ctdbsdk.ctdbGetJSONSegmentProperties.restype = ctypes.c_int32
_ctdbsdk.ctdbGetJSONSegmentProperties.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ]
_ctdbsdk.ctdbGetSegmentStatus.restype = ctypes.c_uint32
_ctdbsdk.ctdbGetSegmentStatus.argtypes = [ctypes.c_void_p, ]
_ctdbsdk.ctdbMoveSegment.restype = ctypes.c_int32
_ctdbsdk.ctdbMoveSegment.argtypes = [ctypes.c_void_p, ctypes.c_int32, ]
_ctdbsdk.ctdbSetSegmentField.restype = ctypes.c_int32
_ctdbsdk.ctdbSetSegmentField.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ]
_ctdbsdk.ctdbSetJSONSegmentField.restype = ctypes.c_int32
_ctdbsdk.ctdbSetJSONSegmentField.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_char_p, ctypes.c_int32, ctypes.c_int32, ]
_ctdbsdk.ctdbGetFieldHandle.restype = ctypes.c_void_p
_ctdbsdk.ctdbGetFieldHandle.argtypes = [ctypes.c_void_p, ]
_ctdbsdk.ctdbAllocField.restype = ctypes.c_void_p
_ctdbsdk.ctdbAllocField.argtypes = [ctypes.c_void_p, ctypes.c_char_p, ctypes.c_int32, ctypes.c_int32, ]
_ctdbsdk.ctdbFreeField.restype = None
_ctdbsdk.ctdbFreeField.argtypes = [ctypes.c_void_p, ]
_ctdbsdk.ctdbAddField.restype = ctypes.c_void_p
_ctdbsdk.ctdbAddField.argtypes = [ctypes.c_void_p, ctypes.c_char_p, ctypes.c_int32, ctypes.c_int32, ]
_ctdbsdk.ctdbInsField.restype = ctypes.c_void_p
_ctdbsdk.ctdbInsField.argtypes = [ctypes.c_void_p, ctypes.c_int32, ctypes.c_char_p, ctypes.c_int32, ctypes.c_int32, ]
_ctdbsdk.ctdbInsFieldByName.restype = ctypes.c_void_p
_ctdbsdk.ctdbInsFieldByName.argtypes = [ctypes.c_void_p, ctypes.c_char_p, ctypes.c_char_p, ctypes.c_int32, ctypes.c_int32, ]
_ctdbsdk.ctdbDelField.restype = ctypes.c_int32
_ctdbsdk.ctdbDelField.argtypes = [ctypes.c_void_p, ctypes.c_int32, ]
_ctdbsdk.ctdbDelFieldByName.restype = ctypes.c_int32
_ctdbsdk.ctdbDelFieldByName.argtypes = [ctypes.c_void_p, ctypes.c_char_p, ]
_ctdbsdk.ctdbMoveField.restype = ctypes.c_int32
_ctdbsdk.ctdbMoveField.argtypes = [ctypes.c_void_p, ctypes.c_int32, ]
_ctdbsdk.ctdbGetField.restype = ctypes.c_void_p
_ctdbsdk.ctdbGetField.argtypes = [ctypes.c_void_p, ctypes.c_int32, ]
_ctdbsdk.ctdbGetFieldByName.restype = ctypes.c_void_p
_ctdbsdk.ctdbGetFieldByName.argtypes = [ctypes.c_void_p, ctypes.c_char_p, ]
_ctdbsdk.ctdbGetFieldNumber.restype = ctypes.c_int32
_ctdbsdk.ctdbGetFieldNumber.argtypes = [ctypes.c_void_p, ctypes.c_char_p, ]
_ctdbsdk.ctdbGetFieldProperties.restype = ctypes.c_int32
_ctdbsdk.ctdbGetFieldProperties.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ]
_ctdbsdk.ctdbSetFieldProperties.restype = ctypes.c_int32
_ctdbsdk.ctdbSetFieldProperties.argtypes = [ctypes.c_void_p, ctypes.c_char_p, ctypes.c_int32, ctypes.c_int32, ]
_ctdbsdk.ctdbGetFieldNbr.restype = ctypes.c_int32
_ctdbsdk.ctdbGetFieldNbr.argtypes = [ctypes.c_void_p, ]
_ctdbsdk.ctdbGetFieldName.restype = ctypes.c_char_p
_ctdbsdk.ctdbGetFieldName.argtypes = [ctypes.c_void_p, ]
_ctdbsdk.ctdbGetFieldLength.restype = ctypes.c_int32
_ctdbsdk.ctdbGetFieldLength.argtypes = [ctypes.c_void_p, ]
_ctdbsdk.ctdbGetFieldType.restype = ctypes.c_int32
_ctdbsdk.ctdbGetFieldType.argtypes = [ctypes.c_void_p, ]
_ctdbsdk.ctdbGetFieldNullFlag.restype = ctypes.c_int32
_ctdbsdk.ctdbGetFieldNullFlag.argtypes = [ctypes.c_void_p, ]
_ctdbsdk.ctdbGetFieldPrecision.restype = ctypes.c_int32
_ctdbsdk.ctdbGetFieldPrecision.argtypes = [ctypes.c_void_p, ]
_ctdbsdk.ctdbGetFieldScale.restype = ctypes.c_int32
_ctdbsdk.ctdbGetFieldScale.argtypes = [ctypes.c_void_p, ]
_ctdbsdk.ctdbSetFieldNullFlag.restype = ctypes.c_int32
_ctdbsdk.ctdbSetFieldNullFlag.argtypes = [ctypes.c_void_p, ctypes.c_int32, ]
_ctdbsdk.ctdbSetFieldPrecision.restype = ctypes.c_int32
_ctdbsdk.ctdbSetFieldPrecision.argtypes = [ctypes.c_void_p, ctypes.c_int32, ]
_ctdbsdk.ctdbSetFieldScale.restype = ctypes.c_int32
_ctdbsdk.ctdbSetFieldScale.argtypes = [ctypes.c_void_p, ctypes.c_int32, ]
_ctdbsdk.ctdbSetFieldName.restype = ctypes.c_int32
_ctdbsdk.ctdbSetFieldName.argtypes = [ctypes.c_void_p, ctypes.c_char_p, ]
_ctdbsdk.ctdbSetFieldLength.restype = ctypes.c_int32
_ctdbsdk.ctdbSetFieldLength.argtypes = [ctypes.c_void_p, ctypes.c_int32, ]
_ctdbsdk.ctdbSetFieldType.restype = ctypes.c_int32
_ctdbsdk.ctdbSetFieldType.argtypes = [ctypes.c_void_p, ctypes.c_int32, ]
_ctdbsdk.ctdbIsFieldNumeric.restype = ctypes.c_int32
_ctdbsdk.ctdbIsFieldNumeric.argtypes = [ctypes.c_void_p, ]
_ctdbsdk.ctdbSetFieldDefaultValue.restype = ctypes.c_int32
_ctdbsdk.ctdbSetFieldDefaultValue.argtypes = [ctypes.c_void_p, ctypes.c_char_p, ctypes.c_int32, ]
_ctdbsdk.ctdbGetFieldDefaultValue.restype = ctypes.c_char_p
_ctdbsdk.ctdbGetFieldDefaultValue.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ]
_ctdbsdk.ctdbClearFieldDefaultValue.restype = ctypes.c_int32
_ctdbsdk.ctdbClearFieldDefaultValue.argtypes = [ctypes.c_void_p, ]
_ctdbsdk.ctdbClearAllFieldDefaultValue.restype = ctypes.c_int32
_ctdbsdk.ctdbClearAllFieldDefaultValue.argtypes = [ctypes.c_void_p, ]
_ctdbsdk.ctdbSetFieldDefaultDateTimeType.restype = ctypes.c_int32
_ctdbsdk.ctdbSetFieldDefaultDateTimeType.argtypes = [ctypes.c_void_p, ctypes.c_int32, ctypes.c_int32, ]
_ctdbsdk.ctdbIsFieldDefaultValueSet.restype = ctypes.c_int32
_ctdbsdk.ctdbIsFieldDefaultValueSet.argtypes = [ctypes.c_void_p, ]
_ctdbsdk.ctdbGetFieldDefaultDateType.restype = ctypes.c_int32
_ctdbsdk.ctdbGetFieldDefaultDateType.argtypes = [ctypes.c_void_p, ]
_ctdbsdk.ctdbGetFieldDefaultTimeType.restype = ctypes.c_int32
_ctdbsdk.ctdbGetFieldDefaultTimeType.argtypes = [ctypes.c_void_p, ]
_ctdbsdk.ctdbGetFieldDefaultValueAsBinary.restype = ctypes.c_int32
_ctdbsdk.ctdbGetFieldDefaultValueAsBinary.argtypes = [ctypes.c_void_p, ctypes.c_char_p, ctypes.c_void_p, ]
_ctdbsdk.ctdbGetFieldStatus.restype = ctypes.c_uint32
_ctdbsdk.ctdbGetFieldStatus.argtypes = [ctypes.c_void_p, ]
_ctdbsdk.ctdbGetFieldBinaryFlag.restype = ctypes.c_int32
_ctdbsdk.ctdbGetFieldBinaryFlag.argtypes = [ctypes.c_void_p, ]
_ctdbsdk.ctdbSetFieldBinaryFlag.restype = ctypes.c_int32
_ctdbsdk.ctdbSetFieldBinaryFlag.argtypes = [ctypes.c_void_p, ctypes.c_int32, ]
_ctdbsdk.ctdbAddVirtualField.restype = ctypes.c_void_p
_ctdbsdk.ctdbAddVirtualField.argtypes = [ctypes.c_void_p, ctypes.c_char_p, ctypes.c_int32, ctypes.c_int32, ctypes.c_void_p, ]
_ctdbsdk.ctdbSetVirtualFieldClear.restype = ctypes.c_int32
_ctdbsdk.ctdbSetVirtualFieldClear.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ]
_ctdbsdk.ctdbDateCheck.restype = ctypes.c_int32
_ctdbsdk.ctdbDateCheck.argtypes = [ctypes.c_int32, ctypes.c_int32, ctypes.c_int32, ]
_ctdbsdk.ctdbDatePack.restype = ctypes.c_int32
_ctdbsdk.ctdbDatePack.argtypes = [ctypes.c_void_p, ctypes.c_int32, ctypes.c_int32, ctypes.c_int32, ]
_ctdbsdk.ctdbDateUnpack.restype = ctypes.c_int32
_ctdbsdk.ctdbDateUnpack.argtypes = [ctypes.c_uint32, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ]
_ctdbsdk.ctdbDateToString.restype = ctypes.c_int32
_ctdbsdk.ctdbDateToString.argtypes = [ctypes.c_uint32, ctypes.c_int32, ctypes.c_char_p, ctypes.c_int32, ]
_ctdbsdk.ctdbStringToDate.restype = ctypes.c_int32
_ctdbsdk.ctdbStringToDate.argtypes = [ctypes.c_char_p, ctypes.c_int32, ctypes.c_void_p, ]
_ctdbsdk.ctdbGetDay.restype = ctypes.c_int32
_ctdbsdk.ctdbGetDay.argtypes = [ctypes.c_uint32, ]
_ctdbsdk.ctdbGetMonth.restype = ctypes.c_int32
_ctdbsdk.ctdbGetMonth.argtypes = [ctypes.c_uint32, ]
_ctdbsdk.ctdbGetYear.restype = ctypes.c_int32
_ctdbsdk.ctdbGetYear.argtypes = [ctypes.c_uint32, ]
_ctdbsdk.ctdbIsLeapYear.restype = ctypes.c_int32
_ctdbsdk.ctdbIsLeapYear.argtypes = [ctypes.c_uint32, ]
_ctdbsdk.ctdbDayOfWeek.restype = ctypes.c_int32
_ctdbsdk.ctdbDayOfWeek.argtypes = [ctypes.c_uint32, ]
_ctdbsdk.ctdbGetDefDateType.restype = ctypes.c_int32
_ctdbsdk.ctdbGetDefDateType.argtypes = [ctypes.c_void_p, ]
_ctdbsdk.ctdbSetDefDateType.restype = ctypes.c_int32
_ctdbsdk.ctdbSetDefDateType.argtypes = [ctypes.c_void_p, ctypes.c_int32, ]
_ctdbsdk.ctdbCurrentDate.restype = ctypes.c_int32
_ctdbsdk.ctdbCurrentDate.argtypes = [ctypes.c_void_p, ]
_ctdbsdk.ctdbStringFormatToDate.restype = ctypes.c_int32
_ctdbsdk.ctdbStringFormatToDate.argtypes = [ctypes.c_char_p, ctypes.c_char_p, ctypes.c_void_p, ctypes.c_uint32, ]
_ctdbsdk.ctdbDateToStringFormat.restype = ctypes.c_int32
_ctdbsdk.ctdbDateToStringFormat.argtypes = [ctypes.c_uint32, ctypes.c_char_p, ctypes.c_char_p, ctypes.c_uint32, ]
_ctdbsdk.ctdbStringFormatToTime.restype = ctypes.c_int32
_ctdbsdk.ctdbStringFormatToTime.argtypes = [ctypes.c_char_p, ctypes.c_char_p, ctypes.c_void_p, ]
_ctdbsdk.ctdbStringFormatToTimeMsec.restype = ctypes.c_int32
_ctdbsdk.ctdbStringFormatToTimeMsec.argtypes = [ctypes.c_char_p, ctypes.c_char_p, ctypes.c_void_p, ]
_ctdbsdk.ctdbTimeToStringFormat.restype = ctypes.c_int32
_ctdbsdk.ctdbTimeToStringFormat.argtypes = [ctypes.c_uint32, ctypes.c_char_p, ctypes.c_char_p, ]
_ctdbsdk.ctdbTimeMsecToStringFormat.restype = ctypes.c_int32
_ctdbsdk.ctdbTimeMsecToStringFormat.argtypes = [ctypes.c_uint32, ctypes.c_char_p, ctypes.c_char_p, ]
_ctdbsdk.ctdbStringFormatToDateTime.restype = ctypes.c_int32
_ctdbsdk.ctdbStringFormatToDateTime.argtypes = [ctypes.c_char_p, ctypes.c_char_p, ctypes.c_void_p, ctypes.c_uint32, ]
_ctdbsdk.ctdbDateTimeToStringFormat.restype = ctypes.c_int32
_ctdbsdk.ctdbDateTimeToStringFormat.argtypes = [ctypes.c_double, ctypes.c_char_p, ctypes.c_char_p, ctypes.c_uint32, ]
_ctdbsdk.ctdbTimeCheck.restype = ctypes.c_int32
_ctdbsdk.ctdbTimeCheck.argtypes = [ctypes.c_int32, ctypes.c_int32, ctypes.c_int32, ]
_ctdbsdk.ctdbTimeCheckMsec.restype = ctypes.c_int32
_ctdbsdk.ctdbTimeCheckMsec.argtypes = [ctypes.c_int32, ctypes.c_int32, ctypes.c_int32, ctypes.c_int32, ]
_ctdbsdk.ctdbTimePack.restype = ctypes.c_int32
_ctdbsdk.ctdbTimePack.argtypes = [ctypes.c_void_p, ctypes.c_int32, ctypes.c_int32, ctypes.c_int32, ]
_ctdbsdk.ctdbTimeUnpack.restype = ctypes.c_int32
_ctdbsdk.ctdbTimeUnpack.argtypes = [ctypes.c_uint32, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ]
_ctdbsdk.ctdbTimePackMsec.restype = ctypes.c_int32
_ctdbsdk.ctdbTimePackMsec.argtypes = [ctypes.c_void_p, ctypes.c_int32, ctypes.c_int32, ctypes.c_int32, ctypes.c_int32, ]
_ctdbsdk.ctdbTimeUnpackMsec.restype = ctypes.c_int32
_ctdbsdk.ctdbTimeUnpackMsec.argtypes = [ctypes.c_uint32, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ]
_ctdbsdk.ctdbTimeToString.restype = ctypes.c_int32
_ctdbsdk.ctdbTimeToString.argtypes = [ctypes.c_uint32, ctypes.c_int32, ctypes.c_char_p, ctypes.c_int32, ]
_ctdbsdk.ctdbStringToTime.restype = ctypes.c_int32
_ctdbsdk.ctdbStringToTime.argtypes = [ctypes.c_char_p, ctypes.c_int32, ctypes.c_void_p, ]
_ctdbsdk.ctdbTimeMsecToString.restype = ctypes.c_int32
_ctdbsdk.ctdbTimeMsecToString.argtypes = [ctypes.c_uint32, ctypes.c_int32, ctypes.c_char_p, ctypes.c_int32, ]
_ctdbsdk.ctdbStringToTimeMsec.restype = ctypes.c_int32
_ctdbsdk.ctdbStringToTimeMsec.argtypes = [ctypes.c_char_p, ctypes.c_int32, ctypes.c_void_p, ]
_ctdbsdk.ctdbGetHour.restype = ctypes.c_int32
_ctdbsdk.ctdbGetHour.argtypes = [ctypes.c_uint32, ]
_ctdbsdk.ctdbGetMinute.restype = ctypes.c_int32
_ctdbsdk.ctdbGetMinute.argtypes = [ctypes.c_uint32, ]
_ctdbsdk.ctdbGetSecond.restype = ctypes.c_int32
_ctdbsdk.ctdbGetSecond.argtypes = [ctypes.c_uint32, ]
_ctdbsdk.ctdbGetDefTimeType.restype = ctypes.c_int32
_ctdbsdk.ctdbGetDefTimeType.argtypes = [ctypes.c_void_p, ]
_ctdbsdk.ctdbSetDefTimeType.restype = ctypes.c_int32
_ctdbsdk.ctdbSetDefTimeType.argtypes = [ctypes.c_void_p, ctypes.c_int32, ]
_ctdbsdk.ctdbCurrentTime.restype = ctypes.c_int32
_ctdbsdk.ctdbCurrentTime.argtypes = [ctypes.c_void_p, ]
_ctdbsdk.ctdbDateTimePack.restype = ctypes.c_int32
_ctdbsdk.ctdbDateTimePack.argtypes = [ctypes.c_void_p, ctypes.c_int32, ctypes.c_int32, ctypes.c_int32, ctypes.c_int32, ctypes.c_int32, ctypes.c_int32, ]
_ctdbsdk.ctdbDateTimeUnpack.restype = ctypes.c_int32
_ctdbsdk.ctdbDateTimeUnpack.argtypes = [ctypes.c_double, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ]
_ctdbsdk.ctdbDateTimePackMsec.restype = ctypes.c_int32
_ctdbsdk.ctdbDateTimePackMsec.argtypes = [ctypes.c_void_p, ctypes.c_int32, ctypes.c_int32, ctypes.c_int32, ctypes.c_int32, ctypes.c_int32, ctypes.c_int32, ctypes.c_int32, ]
_ctdbsdk.ctdbDateTimeUnpackMsec.restype = ctypes.c_int32
_ctdbsdk.ctdbDateTimeUnpackMsec.argtypes = [ctypes.c_double, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ]
_ctdbsdk.ctdbDateTimeGetDate.restype = ctypes.c_int32
_ctdbsdk.ctdbDateTimeGetDate.argtypes = [ctypes.c_double, ctypes.c_void_p, ]
_ctdbsdk.ctdbDateTimeGetTime.restype = ctypes.c_int32
_ctdbsdk.ctdbDateTimeGetTime.argtypes = [ctypes.c_double, ctypes.c_void_p, ]
_ctdbsdk.ctdbDateTimeGetTimeMsec.restype = ctypes.c_int32
_ctdbsdk.ctdbDateTimeGetTimeMsec.argtypes = [ctypes.c_double, ctypes.c_void_p, ]
_ctdbsdk.ctdbDateTimeSetDate.restype = ctypes.c_int32
_ctdbsdk.ctdbDateTimeSetDate.argtypes = [ctypes.c_void_p, ctypes.c_uint32, ]
_ctdbsdk.ctdbDateTimeSetTime.restype = ctypes.c_int32
_ctdbsdk.ctdbDateTimeSetTime.argtypes = [ctypes.c_void_p, ctypes.c_uint32, ]
_ctdbsdk.ctdbDateTimeSetTimeMsec.restype = ctypes.c_int32
_ctdbsdk.ctdbDateTimeSetTimeMsec.argtypes = [ctypes.c_void_p, ctypes.c_uint32, ]
_ctdbsdk.ctdbDateTimeToString.restype = ctypes.c_int32
_ctdbsdk.ctdbDateTimeToString.argtypes = [ctypes.c_double, ctypes.c_int32, ctypes.c_int32, ctypes.c_char_p, ctypes.c_int32, ]
_ctdbsdk.ctdbStringToDateTime.restype = ctypes.c_int32
_ctdbsdk.ctdbStringToDateTime.argtypes = [ctypes.c_char_p, ctypes.c_void_p, ctypes.c_int32, ctypes.c_int32, ]
_ctdbsdk.ctdbCurrentDateTime.restype = ctypes.c_int32
_ctdbsdk.ctdbCurrentDateTime.argtypes = [ctypes.c_void_p, ]
_ctdbsdk.ctdbCurrentDateTimeUTC.restype = ctypes.c_int32
_ctdbsdk.ctdbCurrentDateTimeUTC.argtypes = [ctypes.c_void_p, ]
_ctdbsdk.ctdbCurrentTimestamp.restype = ctypes.c_int32
_ctdbsdk.ctdbCurrentTimestamp.argtypes = [ctypes.c_void_p, ]
_ctdbsdk.ctdbMoneyToLong.restype = ctypes.c_int32
_ctdbsdk.ctdbMoneyToLong.argtypes = [ctypes.c_int32, ctypes.c_void_p, ]
_ctdbsdk.ctdbLongToMoney.restype = ctypes.c_int32
_ctdbsdk.ctdbLongToMoney.argtypes = [ctypes.c_int32, ctypes.c_void_p, ]
_ctdbsdk.ctdbMoneyToFloat.restype = ctypes.c_int32
_ctdbsdk.ctdbMoneyToFloat.argtypes = [ctypes.c_int32, ctypes.c_void_p, ]
_ctdbsdk.ctdbFloatToMoney.restype = ctypes.c_int32
_ctdbsdk.ctdbFloatToMoney.argtypes = [ctypes.c_double, ctypes.c_void_p, ]
_ctdbsdk.ctdbMoneyToString.restype = ctypes.c_int32
_ctdbsdk.ctdbMoneyToString.argtypes = [ctypes.c_int32, ctypes.c_char_p, ctypes.c_int32, ]
_ctdbsdk.ctdbStringToMoney.restype = ctypes.c_int32
_ctdbsdk.ctdbStringToMoney.argtypes = [ctypes.c_char_p, ctypes.c_void_p, ]
_ctdbsdk.ctdbMoneyAdd.restype = ctypes.c_int32
_ctdbsdk.ctdbMoneyAdd.argtypes = [ctypes.c_int32, ctypes.c_int32, ctypes.c_void_p, ]
_ctdbsdk.ctdbMoneySub.restype = ctypes.c_int32
_ctdbsdk.ctdbMoneySub.argtypes = [ctypes.c_int32, ctypes.c_int32, ctypes.c_void_p, ]
_ctdbsdk.ctdbMoneyMul.restype = ctypes.c_int32
_ctdbsdk.ctdbMoneyMul.argtypes = [ctypes.c_int32, ctypes.c_int32, ctypes.c_void_p, ]
_ctdbsdk.ctdbMoneyDiv.restype = ctypes.c_int32
_ctdbsdk.ctdbMoneyDiv.argtypes = [ctypes.c_int32, ctypes.c_int32, ctypes.c_void_p, ]
_ctdbsdk.ctdbMoneyCmp.restype = ctypes.c_int32
_ctdbsdk.ctdbMoneyCmp.argtypes = [ctypes.c_int32, ctypes.c_int32, ]
_ctdbsdk.ctdbMoneyAbs.restype = ctypes.c_int32
_ctdbsdk.ctdbMoneyAbs.argtypes = [ctypes.c_int32, ]
_ctdbsdk.ctdbBlobAlloc.restype = ctypes.c_void_p
_ctdbsdk.ctdbBlobAlloc.argtypes = [ctypes.c_int32, ]
_ctdbsdk.ctdbBlobFree.restype = None
_ctdbsdk.ctdbBlobFree.argtypes = [ctypes.c_void_p, ]
_ctdbsdk.ctdbBlobGetData.restype = ctypes.c_void_p
_ctdbsdk.ctdbBlobGetData.argtypes = [ctypes.c_void_p, ]
_ctdbsdk.ctdbBlobGetSize.restype = ctypes.c_int32
_ctdbsdk.ctdbBlobGetSize.argtypes = [ctypes.c_void_p, ]
_ctdbsdk.ctdbBlobSet.restype = ctypes.c_int32
_ctdbsdk.ctdbBlobSet.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_int32, ]
_ctdbsdk.ctdbBlobCmp.restype = ctypes.c_int32
_ctdbsdk.ctdbBlobCmp.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ]
_ctdbsdk.ctdbBlobClear.restype = ctypes.c_int32
_ctdbsdk.ctdbBlobClear.argtypes = [ctypes.c_void_p, ]
_ctdbsdk.ctdbBigIntToLong.restype = ctypes.c_int32
_ctdbsdk.ctdbBigIntToLong.argtypes = [ctypes.c_longlong, ctypes.c_void_p, ]
_ctdbsdk.ctdbLongToBigInt.restype = ctypes.c_int32
_ctdbsdk.ctdbLongToBigInt.argtypes = [ctypes.c_int32, ctypes.c_void_p, ]
_ctdbsdk.ctdbBigIntToFloat.restype = ctypes.c_int32
_ctdbsdk.ctdbBigIntToFloat.argtypes = [ctypes.c_longlong, ctypes.c_void_p, ]
_ctdbsdk.ctdbFloatToBigInt.restype = ctypes.c_int32
_ctdbsdk.ctdbFloatToBigInt.argtypes = [ctypes.c_double, ctypes.c_void_p, ]
_ctdbsdk.ctdbBigIntToString.restype = ctypes.c_int32
_ctdbsdk.ctdbBigIntToString.argtypes = [ctypes.c_longlong, ctypes.c_char_p, ctypes.c_int32, ]
_ctdbsdk.ctdbUnsignedBigIntToString.restype = ctypes.c_int32
_ctdbsdk.ctdbUnsignedBigIntToString.argtypes = [ctypes.c_ulonglong, ctypes.c_char_p, ctypes.c_int32, ]
_ctdbsdk.ctdbStringToBigInt.restype = ctypes.c_int32
_ctdbsdk.ctdbStringToBigInt.argtypes = [ctypes.c_char_p, ctypes.c_void_p, ]
_ctdbsdk.ctdbStringToUnsignedBigInt.restype = ctypes.c_int32
_ctdbsdk.ctdbStringToUnsignedBigInt.argtypes = [ctypes.c_char_p, ctypes.c_void_p, ]
_ctdbsdk.ctdbMoneyToCurrency.restype = ctypes.c_int32
_ctdbsdk.ctdbMoneyToCurrency.argtypes = [ctypes.c_int32, ctypes.c_void_p, ]
_ctdbsdk.ctdbCurrencyToMoney.restype = ctypes.c_int32
_ctdbsdk.ctdbCurrencyToMoney.argtypes = [ctypes.c_longlong, ctypes.c_void_p, ]
_ctdbsdk.ctdbCurrencyToLong.restype = ctypes.c_int32
_ctdbsdk.ctdbCurrencyToLong.argtypes = [ctypes.c_longlong, ctypes.c_void_p, ]
_ctdbsdk.ctdbLongToCurrency.restype = ctypes.c_int32
_ctdbsdk.ctdbLongToCurrency.argtypes = [ctypes.c_int32, ctypes.c_void_p, ]
_ctdbsdk.ctdbCurrencyToBigInt.restype = ctypes.c_int32
_ctdbsdk.ctdbCurrencyToBigInt.argtypes = [ctypes.c_longlong, ctypes.c_void_p, ]
_ctdbsdk.ctdbBigIntToCurrency.restype = ctypes.c_int32
_ctdbsdk.ctdbBigIntToCurrency.argtypes = [ctypes.c_longlong, ctypes.c_void_p, ]
_ctdbsdk.ctdbCurrencyToFloat.restype = ctypes.c_int32
_ctdbsdk.ctdbCurrencyToFloat.argtypes = [ctypes.c_longlong, ctypes.c_void_p, ]
_ctdbsdk.ctdbFloatToCurrency.restype = ctypes.c_int32
_ctdbsdk.ctdbFloatToCurrency.argtypes = [ctypes.c_double, ctypes.c_void_p, ]
_ctdbsdk.ctdbCurrencyToString.restype = ctypes.c_int32
_ctdbsdk.ctdbCurrencyToString.argtypes = [ctypes.c_longlong, ctypes.c_char_p, ctypes.c_int32, ]
_ctdbsdk.ctdbStringToCurrency.restype = ctypes.c_int32
_ctdbsdk.ctdbStringToCurrency.argtypes = [ctypes.c_char_p, ctypes.c_void_p, ]
_ctdbsdk.ctdbCurrencyAdd.restype = ctypes.c_int32
_ctdbsdk.ctdbCurrencyAdd.argtypes = [ctypes.c_longlong, ctypes.c_longlong, ctypes.c_void_p, ]
_ctdbsdk.ctdbCurrencySub.restype = ctypes.c_int32
_ctdbsdk.ctdbCurrencySub.argtypes = [ctypes.c_longlong, ctypes.c_longlong, ctypes.c_void_p, ]
_ctdbsdk.ctdbCurrencyMul.restype = ctypes.c_int32
_ctdbsdk.ctdbCurrencyMul.argtypes = [ctypes.c_longlong, ctypes.c_longlong, ctypes.c_void_p, ]
_ctdbsdk.ctdbCurrencyDiv.restype = ctypes.c_int32
_ctdbsdk.ctdbCurrencyDiv.argtypes = [ctypes.c_longlong, ctypes.c_longlong, ctypes.c_void_p, ]
_ctdbsdk.ctdbCurrencyCmp.restype = ctypes.c_int32
_ctdbsdk.ctdbCurrencyCmp.argtypes = [ctypes.c_longlong, ctypes.c_longlong, ]
_ctdbsdk.ctdbCurrencyAbs.restype = ctypes.c_longlong
_ctdbsdk.ctdbCurrencyAbs.argtypes = [ctypes.c_longlong, ]
_ctdbsdk.ctdbCurrencyRound.restype = ctypes.c_int32
_ctdbsdk.ctdbCurrencyRound.argtypes = [ctypes.c_void_p, ctypes.c_int32, ]
_ctdbsdk.ctdbMoneyToNumber.restype = ctypes.c_int32
_ctdbsdk.ctdbMoneyToNumber.argtypes = [ctypes.c_int32, ctypes.c_void_p, ]
_ctdbsdk.ctdbNumberToMoney.restype = ctypes.c_int32
_ctdbsdk.ctdbNumberToMoney.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ]
_ctdbsdk.ctdbNumberToLong.restype = ctypes.c_int32
_ctdbsdk.ctdbNumberToLong.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ]
_ctdbsdk.ctdbLongToNumber.restype = ctypes.c_int32
_ctdbsdk.ctdbLongToNumber.argtypes = [ctypes.c_int32, ctypes.c_void_p, ]
_ctdbsdk.ctdbNumberToBigInt.restype = ctypes.c_int32
_ctdbsdk.ctdbNumberToBigInt.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ]
_ctdbsdk.ctdbNumberToUnsignedBigInt.restype = ctypes.c_int32
_ctdbsdk.ctdbNumberToUnsignedBigInt.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ]
_ctdbsdk.ctdbBigIntToNumber.restype = ctypes.c_int32
_ctdbsdk.ctdbBigIntToNumber.argtypes = [ctypes.c_longlong, ctypes.c_void_p, ]
_ctdbsdk.ctdbNumberToCurrency.restype = ctypes.c_int32
_ctdbsdk.ctdbNumberToCurrency.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ]
_ctdbsdk.ctdbCurrencyToNumber.restype = ctypes.c_int32
_ctdbsdk.ctdbCurrencyToNumber.argtypes = [ctypes.c_longlong, ctypes.c_void_p, ]
_ctdbsdk.ctdbNumberToFloat.restype = ctypes.c_int32
_ctdbsdk.ctdbNumberToFloat.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ]
_ctdbsdk.ctdbFloatToNumber.restype = ctypes.c_int32
_ctdbsdk.ctdbFloatToNumber.argtypes = [ctypes.c_double, ctypes.c_void_p, ]
_ctdbsdk.ctdbNumberToString.restype = ctypes.c_int32
_ctdbsdk.ctdbNumberToString.argtypes = [ctypes.c_void_p, ctypes.c_char_p, ctypes.c_int32, ]
_ctdbsdk.ctdbStringToNumber.restype = ctypes.c_int32
_ctdbsdk.ctdbStringToNumber.argtypes = [ctypes.c_char_p, ctypes.c_void_p, ]
_ctdbsdk.ctdbNumberAdd.restype = ctypes.c_int32
_ctdbsdk.ctdbNumberAdd.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ]
_ctdbsdk.ctdbNumberSub.restype = ctypes.c_int32
_ctdbsdk.ctdbNumberSub.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ]
_ctdbsdk.ctdbNumberMul.restype = ctypes.c_int32
_ctdbsdk.ctdbNumberMul.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ]
_ctdbsdk.ctdbNumberDiv.restype = ctypes.c_int32
_ctdbsdk.ctdbNumberDiv.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ]
_ctdbsdk.ctdbNumberZero.restype = ctypes.c_int32
_ctdbsdk.ctdbNumberZero.argtypes = [ctypes.c_void_p, ]
_ctdbsdk.ctdbIsNumberZero.restype = ctypes.c_int32
_ctdbsdk.ctdbIsNumberZero.argtypes = [ctypes.c_void_p, ]
_ctdbsdk.ctdbNumberCmp.restype = ctypes.c_int32
_ctdbsdk.ctdbNumberCmp.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ]
_ctdbsdk.ctdbNumberAbs.restype = ctypes.c_int32
_ctdbsdk.ctdbNumberAbs.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ]
_ctdbsdk.ctdbNumberNegate.restype = ctypes.c_int32
_ctdbsdk.ctdbNumberNegate.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ]
_ctdbsdk.ctdbNumberCopy.restype = ctypes.c_int32
_ctdbsdk.ctdbNumberCopy.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ]
_ctdbsdk.ctdbNumberRound.restype = ctypes.c_int32
_ctdbsdk.ctdbNumberRound.argtypes = [ctypes.c_void_p, ctypes.c_int32, ]
_ctdbsdk.ctdbNumberGetDecimal.restype = ctypes.c_int32
_ctdbsdk.ctdbNumberGetDecimal.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ]
_ctdbsdk.ctdbGetResultSetHandle.restype = ctypes.c_void_p
_ctdbsdk.ctdbGetResultSetHandle.argtypes = [ctypes.c_void_p, ]
_ctdbsdk.ctdbAllocateResultSet.restype = ctypes.c_void_p
_ctdbsdk.ctdbAllocateResultSet.argtypes = [ctypes.c_void_p, ctypes.c_char_p, ]
_ctdbsdk.ctdbFreeResultSet.restype = None
_ctdbsdk.ctdbFreeResultSet.argtypes = [ctypes.c_void_p, ]
_ctdbsdk.ctdbResultSetOnOff.restype = ctypes.c_int32
_ctdbsdk.ctdbResultSetOnOff.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_int32, ctypes.c_int32, ctypes.c_int32, ]
_ctdbsdk.ctdbGetResultSetByName.restype = ctypes.c_void_p
_ctdbsdk.ctdbGetResultSetByName.argtypes = [ctypes.c_void_p, ctypes.c_char_p, ]
_ctdbsdk.ctdbGetResultSetCriHandle.restype = ctypes.c_void_p
_ctdbsdk.ctdbGetResultSetCriHandle.argtypes = [ctypes.c_void_p, ]
_ctdbsdk.ctdbAddCriteria.restype = ctypes.c_void_p
_ctdbsdk.ctdbAddCriteria.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_char_p, ctypes.c_char_p, ctypes.c_int32, ]
_ctdbsdk.ctdbRemoveCriteria.restype = ctypes.c_int32
_ctdbsdk.ctdbRemoveCriteria.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ]
_ctdbsdk.ctdbUpdateCriteria.restype = ctypes.c_int32
_ctdbsdk.ctdbUpdateCriteria.argtypes = [ctypes.c_void_p, ctypes.c_char_p, ctypes.c_char_p, ]
_ctdbsdk.ctdbSetClientLibraryOption.restype = ctypes.c_int32
_ctdbsdk.ctdbSetClientLibraryOption.argtypes = [ctypes.c_int32, ctypes.c_void_p,]
_ctdbsdk.ctdbSetCommProtocolOption.restype = ctypes.c_int32
_ctdbsdk.ctdbSetCommProtocolOption.argtypes = [ctypes.c_int32, ctypes.c_void_p,]
_ctdbsdk.ctdbGetFailOverState.restype = ctypes.c_int32
_ctdbsdk.ctdbGetFailOverState.argtypes = [ctypes.c_void_p, ]
_ctdbsdk.ctdbResetFailOverState.restype = None
_ctdbsdk.ctdbResetFailOverState.argtypes = [ctypes.c_void_p, ]
_ctdbsdk.ctdbIsPrimaryServer.restype = ctypes.c_int32
_ctdbsdk.ctdbIsPrimaryServer.argtypes = [ctypes.c_void_p, ]

