#!/bin/sh
OS=`uname`
JAVA=`which java`
ARCH=`$JAVA -cp lib/FairCom.Helper.jar FairCom.Helper.Classes.javarch`
PSQL_INST=/usr/local/psql

AddToPath()
{
   if [ "$OS" = "AIX" ]; then
      export LIBPATH=$1:$LIBPATH
   else
      export LD_LIBRARY_PATH=$1:$LD_LIBRARY_PATH
   fi
}

if [ "$?" != 0 ]; then
   echo Java not found
   exit 1
fi

AddToPath .

if [ "$ARCH" = "32" ]; then
   echo 32bit
   AddToPath $PSQL_INST/lib
   if [ -d "../../driver/ctree.cobol.32bit" ]; then
      AddToPath ../../driver/ctree.cobol.32bit/extfh
   else
      AddToPath ../../driver/ctree.cobol/extfh
   fi
   if [ -n "$COBDIR" ] && [ -f $COBDIR/lib/libcobcrtn.so ]; then
      echo Preloading...
      if [ "$OS" = "AIX" ]; then
         LDR_PRELOAD=$COBDIR/lib/libcobcrtn.so:$COBDIR/lib/libcobmisc.so:$COBDIR/lib/libcobrts.so java -jar RTGMigrate.jar 
      else
         LD_PRELOAD=$COBDIR/lib/libcobcrtn.so:$COBDIR/lib/libcobmisc.so:$COBDIR/lib/libcobrts.so java -jar RTGMigrate.jar 
      fi
   else
      java -jar RTGMigrate.jar
   fi
else
   echo 64bit
   AddToPath $PSQL_INST/lib64
   if [ -d "../../driver/ctree.cobol.32bit" ]; then
      AddToPath ../../driver/ctree.cobol/extfh
   else
      echo This RTG package is not compatible with your Java architecture
      exit 1
   fi
   if [ -n "$COBDIR" ] && [ -f $COBDIR/lib/libcobcrtn64.so ] ; then
      echo Preloading...
      if [ "$OS" = "AIX" ]; then
         LDR_PRELOAD64=$COBDIR/lib/libcobcrtn64.so:$COBDIR/lib/libcobmisc64.so:$COBDIR/lib/libcobrts64.so java -jar RTGMigrate.jar
      else
         LD_PRELOAD=$COBDIR/lib/libcobcrtn64.so:$COBDIR/lib/libcobmisc64.so:$COBDIR/lib/libcobrts64.so java -jar RTGMigrate.jar
      fi
   else
      java -jar RTGMigrate.jar
   fi
fi
