#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "iscobolc.h"

#ifdef  __cplusplus
extern "C" {
#endif
# define MAX_MSG_LEN 512

/*
 * Some structure useful to be passed to isCOBOL program
 */

typedef struct {
  int   NUM_ARGUMENT;
  union {
     char ARGUMENTS[9][61];
     char USER_TEXT[61];
  } ;
} input_type;

typedef struct {
  char DATA[61];
  char DATA1[9];
} output_type;


/*
 * Main program
 */
int main(int argc, char* arvv[])
{
  char         PARAM   [7] = "";
  input_type   PARAM_INPUT;
  output_type  PARAM_OUTPUT;

  long crc;	  
  char errmsg[MAX_MSG_LEN + 1];
  char *cobargv[3];
  int cobargl[3];
  int cobargc;
  int  optc=2;
  char *optv[] = {   "-Xmx256m" , "-Discobol.exception_message=2" };
  void *ejvm = 0;

  errmsg[MAX_MSG_LEN] = '\0';


  isCobolInit (optc , optv, ejvm);

  memset(&PARAM_INPUT, 0 , sizeof(PARAM_INPUT));
  memset(&PARAM_OUTPUT, 0, sizeof(PARAM_OUTPUT));
  
  printf("\n");
  printf("Calling isCOBOL from C\n");
  printf("############################################\n");

/* 
 * Input Parameter set
 */
  strcpy(PARAM   , "TEST");
  strcpy(PARAM_INPUT.ARGUMENTS[0], "TEST ARGUMENT 1");
  strcpy(PARAM_INPUT.ARGUMENTS[1], "TEST ARGUMENT 2");
  PARAM_INPUT.NUM_ARGUMENT  = 2;


  cobargv[0] = PARAM;
  cobargv[1] = &PARAM_INPUT;
  cobargv[2] = &PARAM_OUTPUT;
  cobargl[0] = sizeof ( PARAM );
  cobargl[1] = sizeof ( PARAM_INPUT );
  cobargl[2] = sizeof ( PARAM_OUTPUT);
  cobargc = 3;
     
   if (isCobolCall ("called", cobargc, cobargv, cobargl, &crc) != ISCOBOLC_SUCCESS) {
          isCobolError (errmsg, MAX_MSG_LEN);
          fprintf (stderr, "[%s]\n", errmsg);
    }
  
  
  printf("return-code=%d \n", crc);
  printf("value back from Cobol\n");
  printf("Out: %s\nOut-1: %s\n\n", PARAM_OUTPUT.DATA, PARAM_OUTPUT.DATA1); 

  isCobolTidy();

  return 0;
}

#ifdef  __cplusplus
  }
#endif
