      *> Copyright (c) 2005 - 2024 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.

       PROGRAM-ID. obj-file.
             
       CONFIGURATION SECTION.
       REPOSITORY.
      * Define the class java.io.File in repository to use it
           class JFile as "java.io.File".

       WORKING-STORAGE SECTION.
      *Define an object reference for JFile in order to invoke its
      *non-static methods 
       77  obj-file    object reference JFile.
       77  wrk-sep     pic x any length.
       77  wrk-name    pic x any length.
       

       PROCEDURE DIVISION.
       main.
      * Read the value of separator and pathSeparator fields
           set wrk-sep to JFile:>pathSeparator.
           display "Path separator character: " wrk-sep.
           set wrk-sep to JFile:>separator.
           display "Separator character: " wrk-sep.
           
      * Invoke the static method createTempFile() then invoke the getCanonicalPath()
      * method on the resulting File instance. Set the instance to null when done.
      * Since the invoked methods throw an Exception, a try/catch block is required.
           try
              set obj-file to JFile:>createTempFile('___', '.tmp', null)
              set wrk-name to obj-file:>getCanonicalPath()
           catch exception
              exception-object:>printStackTrace() 
              stop run
           end-try.  
           display "Created temp file: " wrk-name.
           set obj-file to null.
           
      * Create a new intance of File and invoke the methods exists() and
      * isDirectory(). Set the instance to null when done.
           set obj-file to JFile:>new(wrk-name).
           if obj-file:>exists()
              display wrk-name " exists"
           else
              display wrk-name " does not exists"
           end-if.
           if obj-file:>isDirectory()
              display wrk-name " is a directory"
           else
              display wrk-name " is not a directory"
           end-if.
           set obj-file to null.
           
      *End of sample
           goback.