import com.iscobol.rts.*;
import com.iscobol.java.StopRunAsException;

//When the cobol program is compiled with the -cp option,
//import classes from com.iscobol.types_n.*
//otherwise import classes from com.iscobol.types.*
import com.iscobol.types.*;
//import com.iscobol.types_n.*;

public class main {
    
    public static void main(String[] args) {

        System.out.println("Inside JAVA PROGRAM 'main'");

        /* create the instance of the bridge program */
        linkMYPROG myLink = new linkMYPROG();

        /* set value of the variables to be passed to the cobol program */
        myLink.lnkP1.set("hello");
        myLink.lnkDesc.set("desc");
        myLink.lnkNum.set(1.78);
        myLink.lnkPrice.set(77);
        myLink.lnkTel.at(1).set("occurs1");
        myLink.lnkTel.at(2).set("occurs2");
        myLink.lnkTel.at(3).set("occurs3");

        int rc = 0;
        try {
           System.out.println("Calling cobol program 'MYPROG'");
           /* invoke the cobol program */
           rc = myLink.run();
        } catch (IscobolRuntimeException ex1) {
    		System.out.println("error on COBOL program: " + ex1.getMessage());
        } catch (StopRunAsException ex2) {
            System.out.println("executed STOP RUN from cobol!");
        }

        System.out.println(" ");
        System.out.println("Returned inside JAVA PROGRAM");

        System.out.println(" ");
        System.out.println("Value received from cobol program");

        System.out.println("return-code = " + rc);
        System.out.println("lnkP1 =[" + myLink.lnkP1.toString() + "]");
        System.out.println("lnkDesc =[" + myLink.lnkDesc.toString() + "]");
        System.out.println("lnkNum =[" + myLink.lnkNum.tofloat() + "]");
        System.out.println("lnkPrice =[" + myLink.lnkPrice.toint() + "]");
        System.out.println("lnkTel(1) =[" + myLink.lnkTel.at(1).toString() + "]");
        System.out.println("lnkTel(2) =[" + myLink.lnkTel.at(2).toString() + "]");
        System.out.println("lnkTel(3) =[" + myLink.lnkTel.at(3).toString() + "]");

        System.out.println(" ");
        System.out.println("End of test");
    }
}
