      *> Copyright (c) 2005 - 2024 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.

       PROGRAM-ID. ISMENU.
       configuration section.
       special-names.   

       INPUT-OUTPUT SECTION.
       FILE-CONTROL.
           copy "prog.sl".
           COPY "prog.sl" replacing ==prog== by ==prog-from==.
           COPY "prog.sl" replacing ==prog== by ==prog-to==.
           copy "users.sl".
       DATA DIVISION.
       FILE SECTION.
           COPY "prog.fd".
           COPY "prog.fd" replacing ==prog== by ==prog-from==.
           COPY "prog.fd" replacing ==prog== by ==prog-to==.
           copy "users.fd".

       WORKING-STORAGE SECTION.
      
       copy "common.wrk".
       copy "color.wrk".

       77  status-prog          pic xx.
       77  status-users         pic xx.

       01  screen-value.
           05 s-user            pic x(20).
           05 s-lbl-user        pic x(50).
           05 s-menu-level      pic x(10).
           05 s-prog-id         pic x(15).
           05 s-prog-type       pic 9.
              88 s-non-exe      value 1.
              88 s-graph        value 2.
              88 s-crt          value 3.
           05 s-call-metod      pic 9.
              88 s-call         value 1.
              88 s-call-thread  value 2.
              88 s-call-run     value 3.
           05 s-s-descr         pic x(30).
           05 s-l-descr         pic x(100).

       01  screen-copy-value.
           05 s-from-user       pic x(20).
           05 s-to-user         pic x(20).

       78  id-ef-user           value 100.
       78  id-ef-menu-level     value 101.
       78  id-ef-prog-id        value 102.
       78  id-ef-s-descr        value 103.
       78  id-ef-l-descr        value 104.

       78  id-ef-from-user      value 200.
       78  id-ef-to-user        value 201.

       01                       pic 9.
           88 all-ok            value 1 false zero.

       77  choice               pic x.
       77  wrk-menu-level       pic x(10).
       77  wrk-user             pic x(20).
       77  e-call-metod         pic 9.
       77  e-type-program       pic 9 value 1.

       01  prog-id-owner        pic x(15).
           88 veryant-prog-id   value "menu"
                                      "data"
                                      "iscustomer"
                                      "isproduct"
                                      "adminfunc"
                                      "ismenu"
                                      "isuser"
                                      "Headerdet"
                                      "isinvoice"
                                      "isinvoicelist"
                                      "character"
                                      "ischarprog"
                                      "otherfunc"
                                      "ismenu"
                                      "isuser"
                                      "iscallrun"
                                      "isresetfile"
                                      "reports"
                                      "isprintprod"
                                      .

       77  h-copy-menu handle of window.
 
       screen section.

       01  mask-main.
           05 label
              foreground-color RGB 78-lbl-menu-foreground-color
              background-color RGB 78-lbl-menu-background-color
              right
              col 31
              line 1
              lines 2 
              size 80
              height-in-cells
              width-in-cells
              . 
           05 frame 
              raised
              line 3 
              col 31
              lines 25 cells
              size 80 cells
              .
           05 Label, 
              COL 32
              LINE 4
              TITLE R"User"
              transparent
               .
           05 Label, 
              COL 32
              LINE 6
              TITLE R"Menu_Level"
              transparent
              .
           05 Label
              COL 32
              LINE 8
              TITLE R"Program_Id"
              transparent
               .
           05 Label
              COL 32
              LINE 10.5
              TITLE R"Program_Tipe"
              transparent
              .
           05 Label
              COL 32
              LINE 13
              TITLE R"Call_Type"
              transparent
              .
           05 Label
              col 32
              line 15
              title R"Short_Description"
              transparent
              .
           05 Label
              col 32
              line 17
              title r"Long_Description"
              transparent
              .
           05 ef-user Entry-Field
              COL 50 
              LINE 4
              SIZE 20
              max-text 10
              id id-ef-user
              VALUE s-user
              border-width (0, 0, 2, 0)
              border-color rgb 78-ef-border-color
              after AFT-EF-USER
              .
           05 lbl-user label
              COL 74 
              LINE 4
              SIZE 30
              title s-lbl-user
              transparent
              .
           05 ef-menu-level Entry-Field
              COL 50 
              LINE 6
              SIZE 20
              max-text 10
              id id-ef-menu-level
              VALUE s-menu-level
              format-string "##-##-##-##-##"
              border-width (0, 0, 2, 0)
              border-color rgb 78-ef-border-color
              after AFT-EF-MENU-LEVEL
              .
           05 push-button, 
              title R"Copy_levels_from_another_user"
              title-position 2
              COL 90
              LINE 4
              lines 3 cells
              SIZE 20 cells
              multiline 
              flat
              background-color     78-pb-background-color
              foreground-color     78-pb-foreground-color
              disabled-background-color 
                                   rgb 78-pb-disabled-background-color
              disabled-foreground-color 
                                   rgb 78-pb-disabled-foreground-color

              rollover-foreground-color 
                                   rgb 78-pb-rollover-foreground-color
              exception-value  3000
              .
           05 ef-prog-id Entry-Field, 
              COL 50
              LINE 8
              SIZE 60 cells
              VALUE s-prog-id
              lower
              id id-ef-prog-id
              border-width (0, 0, 2, 0)
              border-color rgb 78-ef-border-color
              .
           05 rb-type-non-exe radio-button, 
              title R"Non_execitable"
              title-position 2
              COL 50
              LINE 10
              lines 2 cells
              SIZE 20 cells 
              group 1
              group-value 1
              bitmap-handle h-bmpapp
              bitmap-width 22
              bitmap-number 1
              exception-value  2001
              enabled e-type-program
              VALUE s-prog-type
              .
           05 rb-type-graph radio-button, 
              title R"Graphical_program"
              title-position 2
              COL 70
              LINE 10
              lines 2 cells
              SIZE 20 cells 
              group 1
              group-value 2
              bitmap-handle h-bmpapp
              bitmap-width 22
              bitmap-number 2
              exception-value  2002
              enabled e-type-program
              VALUE s-prog-type
              transparent
              .
           05 rb-type-crt radio-button, 
              title R"Crt_program"
              title-position 2
              COL 90
              LINE 10
              lines 2 cells
              SIZE 20 cells 
              group 1
              group-value 3
              bitmap-handle h-bmpapp
              bitmap-width 22
              bitmap-number 4
              exception-value  2003
              enabled e-type-program
              VALUE s-prog-type
              transparent
              .
           05 rb-call radio-button, 
              title R"Call"
              COL 50
              LINE 12.6
              lines 2 cells
              SIZE 20 cells 
              group 2
              group-value 1
              enabled e-call-metod
              VALUE s-call-metod
              transparent
              .
           05 rb-call-thread radio-button, 
              title R"Call_Thread"
              COL 70
              LINE 12.6
              lines 2 cells
              SIZE 20 cells 
              group 2
              group-value 2
              enabled e-call-metod
              VALUE s-call-metod
              transparent
              .
           05 rb-call-run radio-button, 
              title R"Call_Run"
              COL 90
              LINE 12.6
              lines 2 cells
              SIZE 20 cells 
              group 2
              group-value 3
              enabled e-call-metod
              VALUE s-call-metod
              transparent
              .
           05 ef-s-descr Entry-Field, 
              COL 50
              LINE 15
              SIZE 60 cells
              VALUE s-s-descr
              id id-ef-s-descr
              border-width (0, 0, 2, 0)
              border-color rgb 78-ef-border-color
              .
           05 ef-l-descr Entry-Field, 
              COL 50
              LINE 17
              lines 10
              SIZE 60 cells
              VALUE s-l-descr
              id id-ef-l-descr
              multiline
              use-return
              secure
              border-width (0, 0, 2, 0)
              border-color rgb 78-ef-border-color
              .

       01  mask-copy.
           05 Label
              COL 2
              LINE 2
              TITLE R"Copy_from_user"
              transparent
              .
           05 Label
              COL 2
              LINE 4
              TITLE R"Copy_to_user"
              transparent
              .
           05 ef-from-user Entry-Field, 
              COL 20
              LINE 2
              SIZE 20
              VALUE s-from-user
              max-text 20
              id id-ef-from-user
              border-width (0, 0, 2, 0)
              border-color rgb 78-ef-border-color
              .
           05 ef-to-user Entry-Field
              COL 20
              LINE 4
              SIZE 20
              max-text 20
              VALUE s-to-user
              id id-ef-to-user
              border-width (0, 0, 2, 0)
              border-color rgb 78-ef-border-color
              .
           05 Push-Button
              col 10 
              line 7
              lines 2.2 
              cells
              size 20 cells
              bitmap-handle h-tools
              bitmap-width 16
              bitmap-number 78-n-pb-save
              bitmap-rollover 78-n-pb-save-rollover
              exception-value 2001
              title R"Copy_menu"
              title-position 2
              self-act
              flat
              background-color     78-pb-background-color
              foreground-color     78-pb-foreground-color
              disabled-background-color 
                                   rgb 78-pb-disabled-background-color
              disabled-foreground-color 
                                   rgb 78-pb-disabled-foreground-color

              rollover-foreground-color 
                                   rgb 78-pb-rollover-foreground-color
              .
           05 Push-Button
              col + 1.2
              line 7
              lines 2.2 cells
              size 14 cells
              bitmap-width 16
              bitmap-handle h-tools
              bitmap-number 78-n-pb-delete
              bitmap-rollover 78-n-pb-delete-rollover
              exception-value 27
              title-position 2
              title R"Cancel"
              self-act
              flat
              background-color 78-pb-background-color
              foreground-color 78-pb-foreground-color
              disabled-background-color 
                                   rgb 78-pb-disabled-background-color
              disabled-foreground-color 
                                   rgb 78-pb-disabled-foreground-color

              rollover-foreground-color 
                                   rgb 78-pb-rollover-foreground-color
              .

           copy "standard-mask-tool.scr".

       PROCEDURE DIVISION.
       DECLARATIVES.
       PROG-ERR section.
           use after standard error procedure on prog.
           perform ERROR-FILE
           .
       USER-ERR section.
           use after standard error procedure on users.
           perform ERROR-FILE
           .
       END DECLARATIVES.
       
       MAIN.

           if not user-super
              display message box R"For_Super_user_only!"
              goback
           end-if.

           perform OPEN-FILES.

           initialize screen-value.

           display independent graphical window
                   title R"isCOBOL_Application_Menu_Item"
                   lines 27
                   size 111
                   control font h-font
                   background-low
                   handle h-sta
                   visible 0
                   system menu
                   link to thread
                   gradient-color-1 rgb 78-gradient-color-1
                   gradient-color-2 rgb 78-gradient-color-2
                   .

           call "ISTOOLTIP"
           cancel "ISTOOLTIP"

           display tool-bar 
                   lines 2.5 
                   control font h-font 
                   handle h-tool 
                   upon h-sta

           display mask-main upon h-sta
           display mask-tool upon h-tool
           
           modify h-sta visible 1

           perform until key-status = 27
              accept mask-main
                 on exception continue
              end-accept
              perform AFTER-ACCEPT
              move 4 to accept-control
           end-perform

           perform EXIT-PRG.

           goback
           .

       AFTER-ACCEPT.
           evaluate key-status
           when 78-exe-new
                initialize Prog-r of prog
                set prog-non-exec of prog   to true
                perform DISPLAY-SCREEN
           when 78-exe-save
                perform SAVE-RECORD
           when 78-exe-delete
                perform DELETE-RECORD
                initialize Prog-r of prog
                set prog-non-exec of prog   to true
                perform DISPLAY-SCREEN
           when 78-exe-first
                perform READ-FIRST
                perform DISPLAY-SCREEN
           when 78-exe-prev
                perform READ-PREV
                perform DISPLAY-SCREEN
           when 78-exe-next
                perform READ-NEXT
                perform DISPLAY-SCREEN
           when 78-exe-last
                perform READ-LAST
                perform DISPLAY-SCREEN
           when 78-exe-zoom
                PERFORM ZOOM-PARAGRAPH
           when w-event
                evaluate event-type
                when cmd-close
                     move 27 to key-status
                end-evaluate
           when 3000
                perform COPY-MENU
           when 2001
           when 2003
                move 0                to e-call-metod
                modify rb-call        enabled e-call-metod
                modify rb-call-thread enabled e-call-metod
                modify rb-call-run    enabled e-call-metod
           when 2002
                move 1                to e-call-metod
                modify rb-call        enabled e-call-metod
                modify rb-call-thread enabled e-call-metod
                modify rb-call-run    enabled e-call-metod
           
           end-evaluate.

       DELETE-RECORD.
           display message box 
                          R"Are_you_sure_to_delete_the_selected_record?"
                   type mb-yes-no
                   default mb-no
                   giving choice
           if choice = mb-yes
              inquire ef-menu-level  value s-menu-level
              move s-menu-level   to Prog-menu-level of prog
              delete Prog record
                 invalid
                    continue
              end-delete
           end-if.

       SAVE-RECORD.
           set all-ok  to true
           perform CONTROL-ALL

           if all-ok
              move s-user       to prog-users-id of prog
              move s-menu-level to prog-menu-level of prog
              move s-prog-id    to prog-id of prog
              move s-s-descr    to prog-s-desc of prog
              move s-l-descr    to prog-l-desc of prog

              evaluate true
              when s-non-exe
                   set prog-non-exec of prog         to true
                   set prog-call of prog             to true
              when s-graph
                   set prog-graph-prog of prog       to true
                   evaluate true
                   when s-call
                        set prog-call of prog        to true
                   when s-call-run
                        set prog-call-run of prog    to true
                   when s-call-thread
                        set prog-call-thread of prog to true
                   end-evaluate
              when s-crt
                   set prog-crt-prog of prog         to true
                   set prog-call of prog             to true
              end-evaluate

              rewrite Prog-r of prog
                 invalid
                    write Prog-r of prog
              end-rewrite
           end-if.
 
       CONTROL-ALL.
   
           inquire ef-user         value s-user
           inquire ef-menu-level   value s-menu-level
           inquire ef-prog-id      value s-prog-id.
           inquire ef-s-descr      value s-s-descr.
           inquire ef-l-descr      value s-l-descr.

           move id-ef-user         to control-id
           perform CONTROL-USER.

           if all-ok
              if s-menu-level = space
                 display message box R"Menu_Level_is_mandatory!"
                 move id-ef-menu-level   to control-id
                 set all-ok              to false
              end-if
           end-if. 
           
          
           if all-ok
              if s-prog-id = space
                 display message box R"Program_id_is_mandatory!"
                 move id-ef-prog-id  to control-id
                 set all-ok          to false
              end-if 
           end-if. 
          
           if all-ok
              if s-s-descr = space
                 display message box R"Short_Description_is_mandatory!"
                 move id-ef-s-descr   to control-id
                 set all-ok           to false
              end-if 
           end-if. 

       READ-FIRST.
           move low-value  to prog-key of prog
           start Prog key not < Prog-key of prog
              invalid
                 perform RECORD-NOT-FOUND
                 initialize Prog-r of prog
              not invalid
                read Prog next no lock
                   at end
                      perform RECORD-NOT-FOUND
                      initialize Prog-r of prog
                end-read
           end-start.
 
       READ-LAST.
           move high-value  to prog-key of prog
           start Prog key not > Prog-key
              invalid
                 perform RECORD-NOT-FOUND
                 initialize Prog-r of prog
              not invalid
                read Prog previous no lock
                   at end
                      perform RECORD-NOT-FOUND
                      initialize Prog-r of prog
                end-read
           end-start.
 
       READ-PREV.
           inquire ef-menu-level VALUE s-menu-level.
           if s-menu-level = space
              perform READ-LAST
           else
              move s-menu-level  to Prog-id of prog
              read Prog no lock
                invalid
                   start Prog key not < Prog-key
                      invalid
                         initialize Prog-r of prog
                   end-start
              end-read
              read Prog previous no lock
                at end
                   perform RECORD-NOT-FOUND
              end-read
           end-if.

       READ-NEXT.
           inquire ef-menu-level VALUE s-menu-level.
           if s-menu-level = space
              perform READ-FIRST
           else
              move s-menu-level  to Prog-id of prog
              read Prog no lock
                invalid
                   start Prog key not > Prog-key
                      invalid
                         initialize Prog-r of prog
                   end-start
              end-read
              read Prog next no lock
                at end
                   perform RECORD-NOT-FOUND
              end-read
           end-if.
 
 
       RECORD-NOT-FOUND.
           display message box R"Record_not_found".
 
       DISPLAY-SCREEN.

           move prog-users-id of prog to s-user
                                         users-id
           read Users no lock
              invalid
                 move space     to users-name
           end-read
           move users-name      to s-lbl-user 
           move prog-menu-level of prog to s-menu-level
           move prog-id of prog         to s-prog-id
                                   prog-id-owner

           move prog-s-desc of prog     to s-s-descr
           move prog-l-desc of prog     to s-l-descr
           
           evaluate true
           when prog-non-exec of prog
                set s-non-exe  to true
                move 0         to e-call-metod
           when prog-graph-prog of prog
                set s-graph    to true
                move 1         to e-call-metod
           when prog-crt-prog of prog
                set s-crt      to true
                move 0         to e-call-metod
           end-evaluate
           

           if veryant-prog-id and s-user = r"default_std_user"
              move 0           to e-type-program
                                  e-call-metod
           else 
              move 1           to e-type-program
           end-if
           
           evaluate true
           when prog-call of prog
                set s-call          to true
           when prog-call-run of prog
                set s-call-run      to true
           when prog-call-thread of prog
                set s-call-thread   to true
           end-evaluate

           display mask-main.
 
       OPEN-FILES.
           open I-O   Prog.
           open Input Users.

       EXIT-PRG.
           perform DESTROY-RESOURCE
           perform CLOSE-FILE
           .

       CLOSE-FILE.
           close Prog.
           close Users.

       DESTROY-RESOURCE.
           modify h-sta visible 0
           destroy mask-main mask-tool h-tool 
                   h-sta 
           .

       AFT-EF-USER.
           evaluate key-status
           when 78-exe-new
           when 78-exe-first
           when 78-exe-prev
           when 78-exe-next
           when 78-exe-last
           when 78-exe-zoom
           when 3000
           when 96
                continue
           when other
                perform CONTROL-USER
           end-evaluate.

       AFT-EF-menu-level.
           if key-status = 13
              perform LOAD-RECORD
           end-if.

       LOAD-RECORD.
           move s-user       to prog-users-id of prog
           move s-menu-level to Prog-menu-level of prog
           read Prog no lock
              invalid
                 perform RECORD-NOT-FOUND
              not invalid
                 perform DISPLAY-SCREEN
           end-read.

       CONTROL-USER.
           set all-ok  to true
           move s-user to users-id

           read Users no lock
              invalid
                 move space        to users-name
                 display message box R"Wrong_User_id"
                 move id-ef-user   to control-id
                 set all-ok        to false
           end-read

           move users-name   to s-lbl-user
           modify lbl-user   title s-lbl-user

           if not all-ok
              move 4  to accept-control
           end-if.

       ZOOM-PARAGRAPH.
           evaluate control-id
           when id-ef-user
                call "ZUSER" using wrk-user
                cancel "ZUSER"
                if wrk-user not = space
                   move wrk-user   to s-user
                   modify ef-user value s-user
                   perform CONTROL-USER
                end-if
           when id-ef-menu-level
                call "ZPROG" using s-user
                                   wrk-menu-level
                cancel "ZPROG"
                if wrk-menu-level not = space
                   move wrk-menu-level to s-menu-level
                   perform LOAD-RECORD
                end-if
           end-evaluate.

       COPY-MENU.
           display floating graphical window
                   system menu 
                   title R"isCOBOL_Application_Change_Password"
                   lines 10 size 51
                   control font h-font
                   visible 1
                   handle h-copy-menu
                   gradient-color-1 rgb 78-gradient-color-1
                   gradient-color-2 rgb 78-gradient-color-2
                   .
           
           initialize screen-copy-value.
           
           display mask-copy
           
           perform until key-status = 27
              accept mask-copy
                 on exception 
                    continue
              end-accept
              evaluate key-status 
              when 2001
                   perform SAVE-COPY-MENU
              when w-event
                   evaluate event-type
                   when cmd-close
                        move 27 to key-status
                   end-evaluate
              end-evaluate
              move 4 to accept-control
           end-perform.
           
           destroy h-copy-menu
           move zero to key-status.
       
       SAVE-COPY-MENU.
           set all-ok  to true
           move s-from-user  to users-id
           read Users no lock
              invalid
                 move space           to users-name
                 display message box R"Wrong_User_id"
                 move id-ef-from-user to control-id
                 set all-ok           to false
           end-read

           if all-ok
              move s-to-user  to users-id
              read Users no lock
                 invalid
                    move space           to users-name
                    display message box R"Wrong_User_id"
                    move id-ef-to-user to control-id
                    set all-ok           to false
              end-read
           end-if

           if all-ok
              open INPUT prog-from
              open I-O prog-to
              
              move low-value to prog-key of prog-from
              move s-from-user  to prog-users-id of prog-from
              
              start Prog-from key not < Prog-key of prog-from
                 invalid
                    continue
                 not invalid
                    perform until 1 = 2
                       read PROG-FROM next no lock
                          at end
                             exit perform
                       end-read
                       if s-from-user not = prog-users-id of prog-from
                          exit perform
                       end-if
                       move prog-r of prog-from   to prog-r of prog-to
                       move s-to-user to prog-users-id of prog-to
                       write prog-r of prog-to
                          invalid
                             rewrite prog-r of prog-to
                       end-write
                    end-perform
              end-start
              close PROG-FROM
              close PROG-TO
              move 27  to key-status
           end-if.

           copy "dec-file.prd".