*> Copyright (c) 2005 - 2024 Veryant. Users of isCOBOL
*> may freely modify and redistribute this program.
 identification division.
 class-id. CHARTJPANEL as "CHARTJPANEL" inherits jpanel.
 configuration section.
 repository.
   class jpanel                 as "javax.swing.JPanel"
   class borderlayout           as "java.awt.BorderLayout"
   class chartfactory           as "org.jfree.chart.ChartFactory"
   class chartpanel             as "org.jfree.chart.ChartPanel"
   class jfreechart             as "org.jfree.chart.JFreeChart"
   class plotorientation        as "org.jfree.chart.plot.PlotOrientation"
   class jstring                as "java.lang.String"
   class jnumber                as "double"
   class jbool                  as "boolean"
   class PiePlot3D              as "org.jfree.chart.plot.PiePlot3D"
   class pieDataset             as "org.jfree.data.general.DefaultPieDataset"
   class barDataset             as "org.jfree.data.category.DefaultCategoryDataset"
   class lineSeries             as "org.jfree.data.xy.XYSeries"
   class lineSeriesCollection   as "org.jfree.data.xy.XYSeriesCollection"
   .

 identification division.
 object.

 working-storage section.
 77 pie-char-dataset            object reference pieDataset.
 77 bar-char-dataset            object reference barDataset.
 77 line-char-series-collection object reference lineSeriesCollection .
 77 line-char-series            object reference lineSeries.

 procedure division.
 
 identification division.
 method-id. new as "new".
 procedure division.
 MAIN.
   invoke super "new" using borderlayout:>new.
 end method.

*>Pie chart methods
 identification division.
 method-id. createDataSetPieChart as "createDataSetPieChart".
 working-storage section.
 linkage section.

 procedure division.
 main.
   set pie-char-dataset to pieDataset:>new
 end method.

 identification division.
 method-id. valDataSetPieChart as "valDataSetPieChart".
 working-storage section.
 linkage section.
 77 chartDescription        object reference jstring.
 77 chartValue              object reference jnumber.

 procedure division using chartDescription
                          chartValue
                          .
 main.
      pie-char-dataset:>setValue(chartDescription 
                                 chartValue)
 end method.

identification division.
 method-id. createAndAddPieChart as "createAndAddPieChart".
 working-storage section.
 77 freechart             object reference jfreechart.
 77 cpanel                object reference chartpanel.
 77 tmpFloat              object reference "float".
 77 wPiePlot3D            object reference PiePlot3D.

 linkage section.

 procedure division.
 MAIN.
    self:>removeAll.
    set tmpFloat to 0.50

    set wPiePlot3D to PiePlot3D:>new(pie-char-dataset)
        wPiePlot3D:>setForegroundAlpha(tmpFloat)
    set freechart to jfreechart:>new(wPiePlot3D)
    set cpanel to chartpanel:>new(freechart).
    self:>add (cpanel BorderLayout:>CENTER)

 end method.

*>Bar chart methods
 identification division.
 method-id. createDataSetBarChart as "createDataSetBarChart".
 working-storage section.
 linkage section.

 procedure division.
 main.
   set bar-char-dataset to barDataset:>new
 end method.

 identification division.
 method-id. valDataSetBarChart as "valDataSetBarChart".
 working-storage section.
 linkage section.
 77 chartDescription        object reference jstring.
 77 chartCategory           object reference jstring.
 77 chartValue              object reference jnumber.

 procedure division using chartDescription
                          chartCategory
                          chartValue
                          .
 main.
    bar-char-dataset:>setValue(chartValue
                               chartDescription 
                               chartCategory)
 end method.

identification division.
 method-id. createAndAddBarChart as "createAndAddBarChart".
 working-storage section.
 77 freechart             object reference jfreechart.
 77 cpanel                object reference chartpanel.
 linkage section.
 77 l-title               object reference jstring.
 77 l-categoryAxisLabel   object reference jstring.
 77 l-valueAxisLabel      object reference jstring.
 77 l-orientation         object reference plotorientation.
 77 l-legend              object reference jbool.
 77 l-tooltips            object reference jbool.
 77 l-urls                object reference jbool.
 
 procedure division using l-title 
                          l-categoryAxisLabel 
                          l-valueAxisLabel 
                          l-orientation 
                          l-legend
                          l-tooltips 
                          l-urls.
 MAIN.
    self:>removeAll.
    set freechart to ChartFactory:>createBarChart(l-title, l-categoryAxisLabel, l-valueAxisLabel, 
                                                  bar-char-dataset, l-orientation , l-legend, 
                                                  l-tooltips, l-urls).
    set cpanel to chartpanel:>new(freechart).
    self:>add(cpanel borderlayout:>CENTER).
 end method.
 
*>Line chart methods
*>*******************
 identification division.
 method-id. createSeriesCollectionLineChart as "createSeriesCollectionLineChart".
 working-storage section.
 linkage section.

 procedure division.
 main.
   set line-char-series-collection to lineSeriesCollection :>new
 end method.

 identification division.
 method-id. createSeriesLineChart as "createSeriesLineChart".
 working-storage section.
 linkage section.

 procedure division.
 main.
   set line-char-series to lineSeries:>new("Series 1" as string)
 end method.

 identification division.
 method-id. valSeriesLineChart as "valSeriesLineChart".
 working-storage section.
 linkage section.
 77 chartPosition           object reference jnumber.
 77 chartValue              object reference jnumber.

 procedure division using chartPosition
                          chartValue
                          .
 main.
    line-char-series:>add(chartPosition 
                          chartValue).
 end method.
 
 identification division.
 method-id. addSeriesLineChart as "addSeriesLineChart".
 working-storage section.
 linkage section.

 procedure division.
 main.
   line-char-series-collection:>addSeries(line-char-series).
 end method.

 identification division.
 method-id. removeSeriesLineChart as "removeSeriesLineChart".
 working-storage section.
 linkage section.

 procedure division.
 main.
    line-char-series-collection:>removeSeries(line-char-series).
 end method.

identification division.
 method-id. createAndAddBarChart as "createAndAddLineChart".
 working-storage section.
 77 freechart             object reference jfreechart.
 77 cpanel                object reference chartpanel.
 linkage section.
 77 l-orientation         object reference plotorientation.
 77 l-legend              object reference jbool.
 77 l-tooltips            object reference jbool.
 77 l-urls                object reference jbool.
 
 procedure division using l-orientation 
                          l-legend
                          l-tooltips 
                          l-urls.
 MAIN.
    self:>removeAll.
    set freechart to ChartFactory:>createXYLineChart(null
                                                     null
                                                     null
                                                     line-char-series-collection, 
                                                     l-orientation,
                                                     l-legend,
                                                     l-tooltips, 
                                                     l-urls).
    set cpanel to chartpanel:>new(freechart).
    self:>add(cpanel borderlayout:>CENTER).
 end method.
 
 end object.
 end class.

 