      *> Copyright (c) 2005 - 2024 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.

       PROGRAM-ID. CUST_FONT.

       configuration section.

       input-output section.
       file-control.

       file section.

       working-storage section.
       copy "iscobol.def".
       copy "isfonts.def".

       77  custom-font             pic x any length.
       77  custom-font-name        pic x any length.
       77  custom-font-size        pic x any length.

       77  env-code                pic 9.

       77                          pic 9 value 0.
           88 errors               value 1 false 0.

       LINKAGE SECTION.
       77  control-font   handle of font.

       procedure division using control-font.
       MAIN.
           set errors  to false.
           call "C$GETRUNENV" giving env-code

           accept custom-font 
                             from environment "issamples.custom_font"
           if custom-font not = space
              unstring custom-font delimited by "-"
                                into custom-font-name
                                     custom-font-size
              initialize wfont-data
              move custom-font-name  to wfont-name
              move custom-font-size  to wfont-size
           else
              if env-code = runenv-web-client
                 initialize wfont-data
                 move "Tahoma" to wfont-name
                 move 8        to wfont-size
              else
                 initialize wfont-data
                 call "J$GETFROMLAF" using jget-laf-font
                                           "Label.font"
                                           wfont-data
              end-if
           end-if.

           call "W$FONT" using wfont-get-font 
                               control-font 
                               wfont-data
                        giving return-code
           if return-code not = 1
              set errors  to true
           end-if

           if errors
              set control-font  to default-font
           end-if.