      *> Copyright (c) 2005 - 2024 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.

       PROGRAM-ID. display-of.

       WORKING-STORAGE SECTION.
       copy "isgui.def".
       copy "isfonts.def".
       copy "iscrt.def".
       copy "iscobol.def".   
       copy "isresize.def".
       77  crt-status              special-names crt status pic 9(5).
       77  hWin                    handle of window.
       77  control-font            handle of font.
       77  close-win               pic 9 value 0.
       77  n-string                pic n(10).

       77  input-pic-x             pic x(10) value space.
       77  input-pic-n             pic n(10) value space.
       77  output-pic-x            pic x(10) value space.
       77  output-pic-n            pic n(10) value space.

       SCREEN SECTION.
       01  Mask.
           03 label
              line                 2
              col                  2
              title                "Input a string in this pic X(10):" 
              .
           03 ef-val-pic-x
              entry-field
              line                 4
              col                  2
              size                 12 
              value                input-pic-x
              max-text             10
              .
           03 push-button
              line                 4
              col                  + 2
              size                 16
              title                "NATIONAL-OF"
              exception-value      11
              self-act
              .
           03 lbl-pic-n
              label
              line                 4
              col                  + 2
              size                 15
              title                output-pic-n 
              .

           03 label
              line                 8
              col                  2
              title                "Input a string in this pic N(10):" 
              .
           03 ef-val-pic-x
              entry-field
              line                 10
              col                  2
              size                 12 
              value                input-pic-n
              max-text             10
              .
           03 push-button
              line                 10
              col                  + 2
              size                 16
              title                "DISPLAY-OF"
              exception-value      12
              self-act
              .
           03 lbl-pic-x
              label
              line                 10
              col                  + 2
              title                output-pic-x 
              size                 15
              .
           03 Pb-exit  
              push-button
              line                 20
              col                  62 
              size                 8 cells
              title                "Exit" 
              exception-value      27
              .

       PROCEDURE DIVISION.
       MAIN.

           call "CUST_FONT" using control-font
              on exception
                 set control-font to default-font
           end-call
           display standard graphical window
                   background-low  
                   resizable 
                   layout-manager lm-zoom
                   line 2
                   col 65
                   title  "DISPLAY-OF and NATIONAL-OF Functions"
                   lines 21 
                   min-lines 21 
                   size 70 
                   min-size 70
                   control font control-font
                   handle hWin 
                   event  WIN-EVT

           display Mask

           perform until crt-status = 27 or close-win = 1
              accept  Mask 
                 on exception 
                    evaluate crt-status
                    when 11 
                         perform NATIONAL-OF-FUNCTION
                    when 12 
                         perform DISPLAY-OF-FUNCTION
                    end-evaluate
              end-accept
              move 4   to accept-control
           end-perform

           destroy Mask
           destroy hWin
           destroy control-font

           goback
           .

       WIN-EVT.
           evaluate event-type
           when cmd-close
                move 1 to close-win
           when msg-close
                move EVENT-ACTION-FAIL-TERMINATE  to EVENT-ACTION 
                move 1 to close-win
           end-evaluate
           .

       NATIONAL-OF-FUNCTION.
           move function national-of(input-pic-x) to output-pic-n 
           modify lbl-pic-n title output-pic-n
           .

       DISPLAY-OF-FUNCTION.
           move function display-of(input-pic-n)  to output-pic-x
           modify lbl-pic-x title output-pic-x 
           .
