      *> Copyright (c) 2005 - 2024 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.

       PROGRAM-ID. list-paged.

       CONFIGURATION SECTION.

       INPUT-OUTPUT SECTION.
       FILE-CONTROL.
       select FILE1 assign to "ISS-PLIST"
           |class "com.iscobol.io.DynamicJIsam"
           organization indexed
           access dynamic
           record    key an-cod
           alternate key an-name with duplicates
           status file-status
           .
     
       FILE SECTION.
       FD  FILE1.
       01  an-rec.
           03 an-cod               pic 9(9).
           03 an-name              pic x(40).
           03 an-zip               pic 9(5).
           03 an-date              pic 9(8).
           03 an-amount            pic 9(12)v9(6).

       WORKING-STORAGE SECTION.
       copy "isgui.def".
       copy "isfonts.def".
       copy "iscrt.def".
       copy "iscobol.def".   
       copy "isresize.def".

       77  fileprefix              pic x any length.

       77  crt-status              special-names crt status pic 9(5).
       77  hMain                   handle of window.
       77  hWin                    handle of window.
       77  close-win               pic 9    value 0.

       77  cont                    pic 9(2) value 0.

       77  base-sorg-path          pic x(20). 
       77  command                 pic x(100).

       77  item-name               pic x(50).

       77  state-flag              pic x.
           88  reading-forwards    value "f".
           88  reading-backwards   value "b".
           88  at-start            value "s".
           88  at-end              value "e".

       77  file-status             pic xx. 
       77  lineslist               pic 99 value 15.
       77  number-reads-needed     pic 99.

       01  lsp-rec.
           03 lsp-cod              pic z(8)9.
           03 lsp-name             pic x(40).
           03 lsp-zip              pic x(5).
           03 lsp-date             pic 99/99/9999.
           03 lsp-amount           pic zzz.zzz.zzz.zz9,99.

       01  dateGMA                 pic 9(8).

       77  an-cod-bk               pic 9(9).

       77  title-list              pic x(170).
       77  title-paged-list        pic x(170).
       77  control-font            handle of font.

       77  idx                     pic 9(3).

       SCREEN SECTION.
       01  Mask.
           03 label 
              title               "Code"
              line                 2
              size                 12
              col                  5
              .
           03 label 
              title                "Name"
              line                 2
              size                 6
              col                  19
              .
           03 label
              title                "Zip"
              line                 2
              size                 3
              col                  33
              .
           03 label 
              title                "Date"
              line                 2
              size                 8
              col                  41
              .
           03 label 
              title                "Price"
              line                 2
              size                 8
              col                  55
              .
           03 lsp 
              list-box 
              paged
              line                 4
              col                  2
              lines                lineslist 
              size                 68 cells
              display-columns      (1, 11, 31, 37, 50)
              data-columns         (1, 10, 50, 55, 65)
              alignment            ("C", "L", "L", "C", "C" )
              separation           (0, 0, 0, 0)
              dividers             (1, 1, 1, 1)
              notify-dblclick
              row-background-color-pattern = (-16777215, -14675438)
              event                LSP-EVT
              .
           03 push-button
              line                 20
              col                  2
              size                 20 cells
              title                "View &Source [F2]"
              exception-value      2
              .
           03 push-button
              line                 20 
              col                  62 
              size                 8 cells
              title                "Exit" 
              exception-value      27
              .

       PROCEDURE DIVISION.
       MAIN.
           accept base-sorg-path from environment "home_source".
           call  "C$GETENV" USING "user.home"
                                  fileprefix.

           string fileprefix delimited by trailing space
                  x"0A"    delimited by size
                  "."      delimited by size
                  into fileprefix
           set environment "file.prefix" to fileprefix.

           call "CUST_FONT" using control-font
              on exception
                 set control-font to default-font
           end-call

           set environment "file.errors_ok" to "1".
           open input FILE1
           set environment "file.errors_ok" to "0".
           if file-status = "35"
              perform CREATE-FILE
              open input FILE1
           end-if

           display standard graphical window
                   background-low  
                   resizable 
                   layout-manager lm-zoom
                   line 2
                   col 65
                   title  "PAGED LIST-BOX Control"
                   lines 21 
                   min-lines 21
                   size 70 
                   min-size 70
                   handle hWin
                   event  WIN-EVT
                   control font control-font

           display mask

           set reading-forwards to true
           modify LSP , mass-update = 1
           perform GET-NEXT-ITEM lineslist times
           modify LSP, mass-update = 0

           perform until crt-status = 27 or close-win = 1
              accept  mask
                 on exception
                    continue
              end-accept
              if crt-status = 2
                 perform VIEW-SORG
              end-if
              move  4  to accept-control
           end-perform 

           destroy mask
           destroy hMain
           destroy control-font
           close FILE1
           goback
           .

       LSP-EVT.
           evaluate event-type
           when ntf-pl-next
                perform LSP-NTF-PL-NEXT
           when ntf-pl-prev
                perform LSP-NTF-PL-PREV
           when ntf-pl-nextpage
                perform LSP-NTF-PL-NEXTPAGE
           when ntf-pl-prevpage
                perform LSP-NTF-PL-PREVPAGE
           when ntf-pl-first
                perform LSP-NTF-PL-FIRST
           when ntf-pl-last
                perform LSP-NTF-PL-LAST
           when ntf-pl-search
                perform LSP-NTF-PL-SEARCH
           when cmd-dblclick
                perform SHOW-SELECTED-ITEM
           end-evaluate.

       LSP-NTF-PL-NEXT.
           perform GET-NEXT-ITEM.

       LSP-NTF-PL-PREV.
           perform GET-PREV-ITEM.

       LSP-NTF-PL-NEXTPAGE.
           modify lsp, mass-update = 1
           perform GET-NEXT-ITEM lineslist times
           modify lsp, mass-update = 0
           .

       LSP-NTF-PL-PREVPAGE.
           modify lsp, mass-update = 1
           perform GET-PREV-ITEM lineslist times
           modify lsp, mass-update = 0
           .

       LSP-NTF-PL-FIRST.
           move low-values to an-cod
           start FILE1, key not < an-cod
              invalid key
                 exit paragraph
           end-start
           set reading-forwards to true
           modify lsp, mass-update = 1, reset-list = 1
           perform GET-NEXT-ITEM lineslist times
           modify lsp, mass-update = 0
           .

       LSP-NTF-PL-LAST.
           move high-values to an-cod
           start FILE1, key not > an-cod
              invalid key    
                 exit paragraph
           end-start
           set reading-backwards to true
           modify lsp, mass-update = 1, reset-list = 1
           perform GET-PREV-ITEM lineslist times
           modify lsp, mass-update = 0
           .

       LSP-NTF-PL-SEARCH.
           inquire lsp, search-text in an-cod
           start FILE1 key not < an-cod
              invalid key
                 perform LSP-NTF-PL-LAST
                 exit paragraph
           end-start
           set reading-forwards to true
           modify lsp, mass-update = 1
           perform GET-NEXT-ITEM lineslist times
           modify lsp, mass-update = 0
           if at-end
                 perform LSP-NTF-PL-LAST
           end-if
           .

       GET-NEXT-ITEM.
           evaluate true
           when at-start
                move low-values to an-cod
                start FILE1, key not < an-cod
                   invalid key      
                      exit paragraph
                end-start
                add 1 to lineslist giving number-reads-needed
           when at-end
                exit paragraph
           when reading-backwards
                move lineslist to number-reads-needed
           when reading-forwards
                move 1 to number-reads-needed
           end-evaluate.

           perform number-reads-needed times
              read FILE1 next record
                 at end     
                    set at-end to true
                    exit paragraph
              end-read
           end-perform

           perform ADD-ROW.

           set reading-forwards to true.

       GET-PREV-ITEM.
           evaluate true
           when at-end
                move high-values to an-cod
                start FILE1, key not > an-cod
                   invalid key
                      exit paragraph
                end-start
                add 1 to lineslist giving number-reads-needed
           when at-start
                exit paragraph
           when reading-forwards
                move lineslist to number-reads-needed
           when reading-backwards
                move 1 to number-reads-needed
           end-evaluate.

           perform number-reads-needed times
              read FILE1 previous record
                 at end     
                    set at-start to true
                    exit paragraph
              end-read
           end-perform

           modify lsp, insertion-index = 1
           perform ADD-ROW.

           set reading-backwards to true.

       ADD-ROW.
           move an-cod       to lsp-cod
           move an-name      to lsp-name
           move an-zip       to lsp-zip
           move an-date(1:4) to dateGMA(5:4)
           move an-date(5:2) to dateGMA(3:2)
           move an-date(7:2) to dateGMA(1:2)
           move dateGMA      to lsp-date
           move an-amount    to lsp-amount 
           modify lsp, item-to-add = lsp-rec
           .

       SHOW-SELECTED-ITEM.
           move an-cod to an-cod-bk.
           modify  LSP query-index event-data-1
           inquire LSp item-value lsp-rec
           move lsp-cod   to an-cod
           read FILE1 key is an-cod
           display message box "You've chosen " an-name
           move an-cod-bk to an-cod.
           read FILE1 key is an-cod
           .

       CREATE-FILE.
           open output FILE1
           initialize an-rec
           perform 1000 times 
              add 1 to an-cod
              move "name" to an-name
              move an-cod to an-name(6:)
              move 20141231 to an-date
              move 2500 to an-amount 
              write an-rec
           end-perform
           close FILE1
           .

       WIN-EVT.
           evaluate event-type
           when cmd-close
                move 1 to close-win
           when msg-close
                move event-action-fail-terminate  to event-action 
                move 1 to close-win
           end-evaluate
           .

       VIEW-SORG.
           initialize command
           string base-sorg-path      delimited by trailing space
                  "s-gui"             delimited by space
                  "/LIST-PAGED.cbl"   delimited by size
                  into command.

           call run "TEXTVIEWER"  using command.
           