      *> Copyright (c) 2005 - 2024 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.

       PROGRAM-ID. tree-view-std.

       WORKING-STORAGE SECTION.
       copy "isgui.def".
       copy "isfonts.def".
       copy "iscrt.def".
       copy "iscobol.def".   
       copy "isresize.def".
       77  crt-status                 special-names crt status pic 9(5).
       77  hWin                       handle of window.
       77  close-win                  pic 9 value 0.
       77  control-font               handle of font.
       77  base-sorg-path             pic x(20). 
       77  command                    pic x(100).

       77  item-name                  pic x(50).
       77  cont                       pic 99.
       77  tv-item                    unsigned-int.
       77  tv-item-parent             unsigned-int.
       77  tv-item-child              unsigned-int.

       78  78-sel-mode-single         value "Single".
       78  78-sel-mode-single-inter   value "Single Interval".
       78  78-sel-mode-mult-inter     value "Multiple Intervals".

       77  cb-search                  pic 9 value 0.
       77  cb-selection               pic 9 value 0.
       77  e-selection                pic 9 value zero.
       77  cbselmode-value            pic x(20) 
                                         value 78-sel-mode-mult-inter.
       77  tv-selection               pic 9(3) value zero.
       77  tv-sel                     pic x any length.

       01  tab-album.
      ***
           03 filler pic x(30) value "Next Time You See Her".
           03 filler pic x(20) value "Eric Clapton".
           03 filler pic x(15) value "Blues".
      ***
           03 filler pic x(30) value "Bad Love".
           03 filler pic x(20) value "Eric Clapton".
           03 filler pic x(15) value "Blues rock".
      ***
           03 filler pic x(30) value "Foo Foo".
           03 filler pic x(20) value "Santana".
           03 filler pic x(15) value "Latin Rock".
      ***
           03 filler pic x(30) value "Lightning in the sky".
           03 filler pic x(20) value "Santana".
           03 filler pic x(15) value "Latin Rock".
      ***
           03 filler pic x(30) value "Maria Maria".
           03 filler pic x(20) value "Santana".
           03 filler pic x(15) value "Latin Rock".
      ***
           03 filler pic x(30) value "Oye como va".
           03 filler pic x(20) value "Santana".
           03 filler pic x(15) value "Latin Rock".
      ***
           03 filler pic x(30) value "Help!".
           03 filler pic x(20) value "Beatles".
           03 filler pic x(15) value "Pop".
      ***
           03 filler pic x(30) value "Let It Be".
           03 filler pic x(20) value "Beatles".
           03 filler pic x(15) value "Pop".
      ***
           03 filler pic x(30) value "Yellow Submarine".
           03 filler pic x(20) value "Beatles".
           03 filler pic x(15) value "Pop".
      ***
           03 filler pic x(30) value "Yesterday".
           03 filler pic x(20) value "Beatles".
           03 filler pic x(15) value "Pop".
      ***
           03 filler pic x(30) value "Angie".
           03 filler pic x(20) value "The Rolling Stones".
           03 filler pic x(15) value "Rock".
      ***
           03 filler pic x(30) value "Rain Fall Down".
           03 filler pic x(20) value "The Rolling Stones".
           03 filler pic x(15) value "Rock".
      ***
           03 filler pic x(30) value "Satisfaction".
           03 filler pic x(20) value "The Rolling Stones".
           03 filler pic x(15) value "Rock".
      ***
           03 filler pic x(30) value "Start Me Up".
           03 filler pic x(20) value "The Rolling Stones".
           03 filler pic x(15) value "Rock".
      ***
           03 filler pic x(30) value "Albachiara".
           03 filler pic x(20) value "Vasco Rossi".
           03 filler pic x(15) value "Rock".
      ***
           03 filler pic x(30) value "Tango".
           03 filler pic x(20) value "Vasco Rossi".
           03 filler pic x(15) value "Rock".
      ***
           03 filler pic x(30) value "C'e' chi dice no". 
           03 filler pic x(20) value "Vasco Rossi".
           03 filler pic x(15) value "Rock".
      ***
           03 filler pic x(30) value "Bollicine".
           03 filler pic x(20) value "Vasco Rossi".
           03 filler pic x(15) value "Rock".
      ***
           03 filler pic x(30) value "After Midnight".
           03 filler pic x(20) value "Eric Clapton".
           03 filler pic x(15) value "Rock/Pop".
      ***
           03 filler pic x(30) value "Money for Nothing".
           03 filler pic x(20) value "Eric Clapton".
           03 filler pic x(15) value "Rock/Pop".

       01  tab-album-red     redefines tab-album.
           03 ta-item        occurs 20.
              05 ta-title    pic x(30).
              05 ta-Artist   pic x(20).
              05 ta-genre    pic x(15).

       77  old-ta-Artist   pic x(20).
       77  old-ta-genre    pic x(15).

       SCREEN SECTION.
       01  Mask.
           03 label
              line                 2
              lines                2
              col                  2
              size                 70 cells
              title                "User can press CTRL + F on the treev
      -                            "iew to activate the automatic search
      -                            " feature"
              . 
           03 Tv1 
              tree-view
              flat
              buttons 
              lines-at-root
              line                 4
              col                  2
              lines                15 
              size                 40 cells
              show-sel-always
              selection-background-color rgb x#6883AE
              selection-foreground-color rgb x#FFFFFF
              event                TV-EVT
              hint "Press CTRL+F to activate the search panel"
              .
           03 cb-src
              check-box
              title "Show search panel"
              col 45
              line 4
              value cb-search
              event CHECK-SEARCH
              .
           03 frame 
              col 44
              line 6
              lines 9.5
              size 26
              engraved
              full-height 
              .
           03 cb-sel
              check-box
              title "Selection"
              col 45
              line 7
              value cb-selection
              event CHECK-SELECTION
              .
           03 label
              col 45
              line 9
              title "Mode:"
              .
           03 cbselmode
              combo-box
              drop-list
              unsorted
              line 11 
              col 45
              size 20
              lines 4
              enabled e-selection
              value cbselmode-value
              notify-selchange
              event CBSELMODE-EV
              .
           03 push-button
              title                "Inquire Selected elements"
              line                 13
              col                  45
              size                 22
              exception-value      102
              .
           03 label
              line                 16
              col                  45 
              size                 15 cells 
              title                "You've chosen: "
              .
           03 Lb1 
              label
              line                 17
              col                  45 
              size                 20 cells
              .     
           03 label
              line                 18
              col                  45 
              size                 15 cells 
              title                "Using: "
              .
           03 Lb2 
              label
              line                 18
              col                  51 
              size                 8 cells
              .
           03 push-button
              line                 20 
              col                  2 
              size                 20 cells
              title                "View &Source [F2]"
              exception-value      2
              .
           03 Pb-exit  
              push-button
              line                 20 
              col                  62 
              size                 8 cells
              title                "Exit" 
              exception-value      27
              .

       PROCEDURE DIVISION.
       MAIN.
           accept base-sorg-path from environment "home_source".
           call "CUST_FONT" using control-font
              on exception
                 set control-font to default-font
           end-call
           display standard graphical window
                   background-low  
                   resizable 
                   layout-manager lm-zoom
                   line 2
                   col 65
                   title  "TREE-VIEW Control"
                   control font control-font
                   lines 21 
                   min-lines 21
                   size 70 
                   min-size 70
                   handle hWin
                   event  WIN-EVT

           display Mask

           modify cbselmode item-to-add(78-sel-mode-single, 
                                        78-sel-mode-single-inter, 
                                        78-sel-mode-mult-inter)
           move 78-sel-mode-single to cbselmode-value
           modify cbselmode value cbselmode-value

           perform LOAD-TREE
              
           perform until crt-status = 27 or close-win = 1
              accept  Mask
                 on exception 
                    continue
              end-accept
              evaluate crt-status 
              when 2
                   perform VIEW-SORG
              when 102
                  inquire tv1 items-selected tv-sel
                  display message "Item selected: "
                                  tv-sel
              end-evaluate
              move 4   to accept-control
           end-perform

           destroy Mask
           destroy hWin
           destroy control-font
           goback
           .

       LOAD-TREE.
           modify tv1 mass-update 1
           move low-value to old-ta-genre
           move low-value to old-ta-Artist
           perform varying cont from 1 by 1 until cont > 20
              if ta-genre(cont) not = old-ta-genre
                 perform ADD-TREE-PARENT
              else
                 if ta-Artist(cont) not = old-ta-Artist
                    perform ADD-TREE-CHILD
                 else
                    perform ADD-TREE-CHILD-CHILD
                 end-if
              end-if
           end-perform
           modify tv1 mass-update 0
           .

       ADD-TREE-PARENT.
           move ta-genre(cont)  to old-ta-genre
           modify Tv1 parent null 
                      item-to-add ta-genre(cont) giving tv-item-parent
                      has-children 1 
                      item-foreground-color rgb x#6883AE
           perform ADD-TREE-CHILD
           .

       ADD-TREE-CHILD.
           move ta-Artist(cont) to old-ta-Artist
           modify Tv1 parent tv-item-parent
                      item-to-add ta-Artist(cont) giving tv-item-child
                      has-children 1
                      item-foreground-color rgb x#6A98C6
           perform ADD-TREE-CHILD-CHILD
           .

       ADD-TREE-CHILD-CHILD.
           modify Tv1 parent tv-item-child  
                      item-to-add ta-title(cont) giving tv-item
                      has-children 0
                      item-foreground-color rgb x#354C5C 
           if cont < 7
              modify Tv1 ensure-visible = tv-item
           end-if.
           .

       TV-EVT.
           evaluate event-type 
           when msg-tv-dblclick 
                inquire TV1(event-data-2) item-text item-name
                display message item-name
           when msg-tv-selchange
                inquire TV1(event-data-2) item-text item-name
                modify LB1 title item-name
                evaluate event-data-1
                when tvflag-mouse    
                     modify LB2 title "mouse"
                when tvflag-keyboard 
                     modify LB2 title "keyboard"
                end-evaluate
           end-evaluate
           .

       WIN-EVT.
           evaluate event-type
           when cmd-close
                move 1 to close-win
           when msg-close
                move event-action-fail-terminate  to event-action 
                move 1 to close-win
           end-evaluate
           .

       CHECK-SEARCH.
           evaluate event-type
           when cmd-clicked
                if cb-search = 0
                   move 1 to cb-search
                else
                   move 0 to cb-search 
                end-if
                modify Tv1 search-panel cb-search
           end-evaluate
           .

       CHECK-SELECTION.
           evaluate event-type
           when cmd-clicked
                if cb-selection = 0
                   move 1 to cb-selection
                              e-selection
                else
                   move 0 to cb-selection
                              e-selection 
                end-if
                modify cbselmode enabled e-selection
                perform UPDATE-TREEVIEW-SELECTION
           end-evaluate
           .

       CBSELMODE-EV.
           evaluate event-type
           when ntf-selchange
                inquire cbselmode value cbselmode-value
                perform UPDATE-TREEVIEW-SELECTION
           end-evaluate
           .

       UPDATE-TREEVIEW-SELECTION.
           if cb-selection = 1
              evaluate cbselmode-value  
              when 78-sel-mode-single
                   move tvsm-single-selection           to tv-selection
              when 78-sel-mode-single-inter
                   move tvsm-single-interval-selection  to tv-selection
              when 78-sel-mode-mult-inter
                   move tvsm-multiple-interval-selection
                                                        to tv-selection
              end-evaluate
           else
              move 0  to tv-selection
           end-if
           modify Tv1 selection-mode tv-selection
           .

       VIEW-SORG.
           initialize command
           string base-sorg-path         delimited by trailing space
                  "s-gui"                delimited by space
                  "/TREE-VIEW-STD.cbl"   delimited by size
                                         into command.

           call run "TEXTVIEWER"  using command.
