      *> Copyright (c) 2005 - 2024 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.

       PROGRAM-ID.    GRADIENT.
       
       WORKING-STORAGE SECTION.
       copy "iscrt.def".
       copy "isgui.def".
       copy "isfonts.def".
       copy "iscobol.def".   
       copy "isresize.def".
       77  crt-status      special-names crt status pic 9(5).
       77  hWin            usage handle of window.
       77  close-win       pic 9 value 0.
       77  control-font    handle of font.

       77  color-1-hex     pic x(6).  
       77  color-1         pic s9(9).

       77  color-2-hex     pic x(6).  
       77  color-2         pic s9(9).

       01  wrk-color-hex.
           03  wrk-hex-r   pic xx.
           03  wrk-hex-g   pic xx.
           03  wrk-hex-b   pic xx.
       77  wrk-color       pic s9(9).

       01  wrk-buffer-rgb.
           03  wrk-r       pic 999.
           03  wrk-g       pic 999.
           03  wrk-b       pic 999.

       77  orientation     pic x any length.
       77  w-orientation   pic 9.

       77  c               pic 9.

       77   w-digit        pic x.
           88 is-hex-digit values "0", "1", "2", "3", "4", "5", "6", 
                                  "7", "8", "9", "A", "B", "C", "D", 
                                  "E", "F".

       SCREEN SECTION.
       01  Mask.
           03 label
              line                 3
              col                  3
              size                 16 cells
              title                "Select color one:"
              transparent
              .
           03 ef-color-1
              entry-field
              line                 3
              col                  18
              size                 25 cells
              value                color-1-hex
              upper 
              max-text             6
              notify-change
              event                EV-EF-COLOR-1
              .
           03 label
              line                 6
              col                  3
              size                 16 cells
              title                "Select color two:"
              transparent
              .
           03 ef-color-2
              entry-field
              line                 6
              col                  18
              size                 25 cells
              value                color-2-hex
              upper 
              max-text             6
              notify-change
              event                EV-EF-COLOR-2
              .
           03 label
              line                 9
              col                  3
              size                 16 cells
              title                "Orientation:"
              transparent
              .
           03 cb-orientation 
              combo-box 
              unsorted
              drop-list 
              color                513
              line                 9
              col                  18 
              size                 25 cells
              value                orientation
              .
           03 push-button
              line                 12 
              col                  18 
              size                 25 cells
              title                "Change Gradient" 
              exception-value      1
              .
           03 Pb-exit  
              push-button
              line                 20 
              col                  62 
              size                 8 cells
              title                "Exit" 
              exception-value      27
              .

       PROCEDURE DIVISION.
       MAIN.
       
           move "FFFFFF" to color-1-hex
                            wrk-color-hex
           perform CALCULATE-COLOR
           move wrk-color  to color-1
           
           move "6D8AD6" to color-2-hex
                            wrk-color-hex
           perform CALCULATE-COLOR
           move wrk-color  to color-2
           
           move "north to south"         to orientation
           move gradient-north-to-south  to w-orientation

           call "CUST_FONT" using control-font
              on exception
                 set control-font to default-font
           end-call
           display standard graphical window
                   background-low  
                   resizable 
                   layout-manager lm-zoom
                   line 2
                   col 65
                   title  "GRADIENT COLOR"
                   control font control-font
                   gradient-color-1 color-1
                   gradient-color-2 color-2
                   gradient-orientation w-orientation
                   lines 21 
                   min-lines 21
                   size 70 
                   min-size 70
                   handle hWin
                   event  WIN-EVT

           display Mask

           modify cb-orientation 
                   item-to-add ("north to south"
                                "northeast to southwest"
                                "east to west"
                                "southeast to northwest"
                                "south to north"
                                "southwest to northeast"
                                "west to east"
                                "northwest to southeast")

           perform until crt-status = 27 or close-win = 1
              accept  Mask 
                 on exception 
                    continue
              end-accept
              if crt-status = 1
                 perform CHANGE-GRADIENT
              end-if
              move 4   to accept-control
           end-perform.

           destroy Mask
           destroy hWin
           destroy control-font
           goback
           .

       CHANGE-GRADIENT.
           evaluate orientation
           when "north to south"
                move gradient-north-to-south         to w-orientation
           when "northeast to southwest"
                move gradient-northeast-to-southwest to w-orientation
           when "east to west"
                move gradient-east-to-west           to w-orientation
           when "southeast to northwest"
                move gradient-southeast-to-northwest to w-orientation
           when "south to north"
                move gradient-south-to-north         to w-orientation
           when "southwest to northeast"
                move gradient-southwest-to-northeast to w-orientation
           when "west to east"
                move gradient-west-to-east           to w-orientation
           when "northwest to southeast"
                move gradient-northwest-to-southeast to w-orientation
           end-evaluate.

           move color-1-hex  to wrk-color-hex
           perform CALCULATE-COLOR
           move wrk-color  to color-1

           move color-2-hex  to wrk-color-hex
           perform CALCULATE-COLOR
           move wrk-color  to color-2.
           
           modify hwin gradient-color-1 color-1
                       gradient-color-2 color-2
                       gradient-orientation w-orientation
           .

       CALCULATE-COLOR.
           move function hex2dec(wrk-hex-r) to wrk-r.
           move function hex2dec(wrk-hex-g) to wrk-g.
           move function hex2dec(wrk-hex-b) to wrk-b.

           compute wrk-color = (wrk-r  * 65536 + 
                                wrk-g  * 256   + 
                                wrk-b) * -1
           .

       WIN-EVT.
           evaluate event-type
           when cmd-close
                move 1 to close-win
           when msg-close
                move event-action-fail-terminate  to event-action 
                move 1 to close-win
           end-evaluate
           .

       EV-EF-COLOR-1.
           if event-type = ntf-changed
              inquire ef-color-1 value color-1-hex
              initialize c
              inspect color-1-hex tallying c 
                           for characters before initial trailing space
              move color-1-hex(c:1) to w-digit
              if not is-hex-digit
                 move spaces to color-1-hex(c:1)
                 modify ef-color-1 value color-1-hex
                                   cursor c
              end-if
              set event-action to event-action-continue
           end-if
           .

       EV-EF-COLOR-2.
           if event-type = ntf-changed
              inquire ef-color-2 value color-2-hex
              initialize c
              inspect color-2-hex tallying c 
                           for characters before initial trailing space
              move color-2-hex(c:1) to w-digit
              if not is-hex-digit
                 move spaces to color-2-hex(c:1)
                 modify ef-color-2 value color-2-hex
                                   cursor c
              end-if
              set event-action to event-action-continue
           end-if
           .
