      *> Copyright (c) 2005 - 2024 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.

       PROGRAM-ID. WFONT.   

       WORKING-STORAGE SECTION.
       copy "iscrt.def".
       copy "isgui.def".
       copy "isfonts.def".
       copy "iscobol.def".   
       copy "isresize.def".
       77  crt-status              special-names crt status pic 9(5).
       77  hWin                    handle of window.
       77  control-font            handle of font.
       77  close-win               pic 9 value 0.
                                        
       77  wfont-status            pic s99.
       77  h-font                  handle of font.

       77  lb-attibute-title       pic x(50).

       SCREEN SECTION.
       01  Mask.
           03  label 
               line                2 
               col                 2
               title               "Font:"
               .
           03  lb-fontname
               label 
               line                2
               col                 + 2    
               .
           03  label 
               line                4 
               col                 2
               title               "Size:"
               .
           03  lb-fontsize
               label 
               line                4 
               col                 + 2
               .

           03  label 
               line                6 
               col                 2
               title               "Attribute:"
               .
           03  lb-attibute
               label 
               line                6 
               col                 + 2   
               .
           03  label 
               line                8 
               col                 2 
               title               "type some text below:"
               .
           03  ef-test
               entry-field 
               multiline
               use-return
               line                + 2 
               col                 2   
               size                68 cells
               lines               9  cells
               .
           03  push-button
               line                20
               col                 3 
               size                15 cells
               title               "Change Font"
               exception-value     100
               .
           03  Pb-exit  
               push-button
               line                20
               col                 62
               size                8 cells
               title               "Exit" 
               exception-value     27
               .

       PROCEDURE DIVISION.
       INI.
           accept h-font from standard object "SMALL-FONT".

           call "CUST_FONT" using control-font
              on exception
                 set control-font to default-font
           end-call
           display standard graphical window
                   background-low  
                   resizable 
                   layout-manager lm-zoom
                   line 2
                   col 65
                   title  "W$FONT Routine"
                   lines 21 
                   min-lines 21
                   size 70 
                   min-size 70
                   control font control-font  
                   handle hWin 
                   event  WIN-EVT

           display Mask

           perform DESCRIBE-FONT

           perform until crt-status = 27 or close-win = 1
              accept  Mask
                 on exception
                    continue
              end-accept
              if crt-status = 100
                 perform CHANGE-FONT
              end-if
              move 4   to accept-control
           end-perform

           destroy Mask
           destroy hWin
           destroy h-font
           destroy control-font
           goback
           .
           
       DESCRIBE-FONT.
           initialize wfont-data.
           call "W$FONT" using wfont-describe-font
                               h-font
                               wfont-data
           modify lb-fontname title wfont-name
           modify lb-fontsize title wfont-size

           initialize lb-attibute-title
           if wfont-bold
              move "Bold" to lb-attibute-title
           end-if
                     
           if wfont-italic
              if lb-attibute-title = space
                 move "Italic"  to lb-attibute-title
              else
                 string lb-attibute-title delimited by trailing space
                        ", Italic"    delimited by size
                        into lb-attibute-title
              end-if
           end-if

           if wfont-underline
              if lb-attibute-title = space
                 move "Underline"  to lb-attibute-title
              else
                 string lb-attibute-title delimited by trailing space
                     ", Underline" delimited by size
                     into lb-attibute-title
              end-if
           end-if

           if wfont-strikeout
              if lb-attibute-title = space
                 move "Strikeout"  to lb-attibute-title
              else
                 string lb-attibute-title delimited by trailing space
                        ", Strikeout" delimited by size
                        into lb-attibute-title
              end-if
           end-if

           modify lb-attibute lb-attibute-title
           .

       CHANGE-FONT.
           if function handle-type (h-font) = handle-of-font
              destroy h-font
           end-if

           initialize wfont-data
           call "W$FONT" using wfont-choose-font
                               h-font
                               wfont-data

           call "W$FONT" using wfont-get-font
                               h-font
                               wfont-data

           perform DESCRIBE-FONT
           modify ef-test font h-font
           .


       WIN-EVT.
           evaluate event-type
           when cmd-close
                move 1 to close-win
           when msg-close
                move event-action-fail-terminate  to event-action 
                move 1 to close-win
           end-evaluate
           .
