      *> Copyright (c) 2005 - 2024 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.
       program-id. print-sql-data.

       configuration section.
       repository.

           class JRXmlLoader          
                 as "net.sf.jasperreports.engine.xml.JRXmlLoader"
           class CompileManager       
                 as "net.sf.jasperreports.engine.JasperCompileManager"
           class JasperDesign         
                 as "net.sf.jasperreports.engine.design.JasperDesign"
           class JasperReport         
                 as "net.sf.jasperreports.engine.JasperReport"
           class JasperFillManager    
                 as "net.sf.jasperreports.engine.JasperFillManager"
           class JasperPrint          
                 as "net.sf.jasperreports.engine.JasperPrint"
           class JasperExportManager  
                 as "net.sf.jasperreports.engine.JasperExportManager"
           class JasperPrintManager   
                 as "net.sf.jasperreports.engine.JasperPrintManager"
           class JRCsvDataSource      
                 as "net.sf.jasperreports.engine.data.JRCsvDataSource"
           class JRViewer             
                 as "net.sf.jasperreports.view.JasperViewer"
           class jf                   as "java.io.File"
           class vstring              as "java.lang.String[]"
           class HashMap              as "java.util.HashMap"
           class Map                  as "java.util.Map"
           class javaint              as "java.lang.Integer"
           class JavaSqlConnection    as "java.sql.Connection"
           class iscobolrtsEsqlRuntime as "com.iscobol.rts.EsqlRuntime"
           .

       working-storage section.
       copy  "SQLCA".
       77  myJasperDesign      object reference JasperDesign.
       77  myJasperReport      object reference JasperReport.
       77  myJasperPrint       object reference JasperPrint.
       77  myJRCsvDataSource   object reference JRCsvDataSource.
       77  coloumnname         object reference vstring.
       77  parameters          object reference Map.
       77  fromvalue           object reference javaint.
       77  tovalue             object reference javaint.
       77  MyJavaSqlConnection object reference JavaSqlConnection.

       77  wrk-date            pic 9(8).
       77  wrk-time            pic 9(8).

       77  report-name         pic x any length.
       77  pdf-name            pic x any length.
       77  logo-name           pic x any length.

       77  DBNAME              pic x any length value "ctreeSQL".
       77  USERID              pic x any length value "admin".
       77  PASSWD              pic x any length value "ADMIN".

       linkage section.
           copy "PRINT-SQL.lnk".

       procedure division using kind-of-print 
                                link-from
                                link-to.
 
       main.

           accept wrk-date from century-date
           accept wrk-time from time
           accept report-name from environment "report_source_path"
           string report-name        delimited by size
                  "reportSQL.jrxml"  delimited by size
                  into report-name

           accept pdf-name from environment "output_path"
           string pdf-name        delimited by size
                  "reportSQL_"    delimited by size
                  wrk-date        delimited by size
                  "_"             delimited by size
                  wrk-time        delimited by size
                  ".pdf"          delimited by size
                  into pdf-name

           accept logo-name from environment "resources_path"
           string logo-name          delimited by size
                  "VeryantLogo.gif"  delimited by size
                  into logo-name

      *> Open the connection with the DB
           perform CONNECT-DB

           try
      *>   choose the report
              set myJasperDesign 
                     to JRXmlLoader:>load (jf:>new(report-name)) 
              set myJasperReport 
                     to CompileManager:>compileReport(myJasperDesign) 
                                                         as JasperReport

      *>   Set the parameters
              set parameters to HashMap:>new
              set fromvalue to javaint:>new ( link-from as int )
              set tovalue   to javaint:>new ( link-to as int )

              parameters:>put("fromcode" as string , fromvalue)
              parameters:>put("tocode" as string , tovalue)
              parameters:>put("logo-path" as string, 
                              logo-name as string)

      *>   Fill the report
              set myJasperPrint 
                  to JasperFillManager:>fillReport (myJasperReport,
                                                    parameters, 
                                                    MyJavaSqlConnection) 
                                                as JasperPrint
 
              evaluate true
              when to-pdf
      *>   Create PDF from report
                   JasperExportManager:>exportReportToPdfFile
                                             (myJasperPrint, pdf-name);

              when to-printer
      *>   Print the report
                   JasperPrintManager:>printReport (myJasperPrint, true);
              when to-preview
      *>   Preview the report
                   JRViewer:>viewReport(myJasperPrint);
              end-evaluate

           catch exception
              exception-object:>printStackTrace
              stop run
           end-try

      *>   close the DB connection
           perform DISCONNECT-DB.

           if to-pdf
              call "C$EASYOPEN" using pdf-name
                                      1
           end-if

           goback
           .  

       CONNECT-DB.

           set environment "jdbc.driver" to "ctree.jdbc.ctreeDriver".
           set environment "jdbc.url"  to "jdbc:ctree:6597@localhost:".

           EXEC SQL CONNECT TO :DBNAME AS Conn 
                          USER :USERID  
                         USING :PASSWD
           END-EXEC     

           if SQLCODE not = 0
              display message 
                     "Error:" 
                     x"0D0A"
                     "SQLCODE is " SQLCODE
                     x"0D0A"
                     "Message is <" SQLERRMC ">"
              stop run
           end-if

           set MyJavaSqlConnection 
                       to iscobolrtsEsqlRuntime:>getCurrConnection.
     
     
       DISCONNECT-DB.
           EXEC SQL
              DISCONNECT CURRENT
           END-EXEC
           .
