      *> Copyright (c) 2005 - 2024 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.

       PROGRAM-ID. menu.

       WORKING-STORAGE SECTION.
       copy "isfonts.def".
       copy "isgui.def".
       copy "iscrt.def".

       77  key-status is special-names crt status pic 999.
       77  pgm-to-call          pic x(30).
       77  h-main               handle of window.
       77  num-of-call          pic 9(3).
       77  choice               pic 9.
       77  h-logo               pic s9(9) comp-4.

       SCREEN SECTION.
       01  s1.
           03 logo 
              bitmap
              line                 2.5
              col                  20
              lines                5 cells
              size                 40 cells
              bitmap-handle        h-logo
              bitmap-scale         2
              .
           03 push-button
              exception-value      1
              self-act
              title                "Customer"
              line                 2
              col                  3
              hint                 "F1"
              size                 15
              lines                2
              css-icon             "fa-user-secret"
              title-position       2
              .
           03 push-button
              exception-value      2
              self-act
              title                "State"
              line                 4
              col                  3
              hint                 "F2"
              size                 15
              lines                2
              css-icon             "fa-flag"
              title-position       2
              .
           03 push-button
              exception-value      27
              self-act
              title                "Exit"
              line                 6
              col                  3
              hint                 "ESC"
              size                 15
              lines                2
              css-icon             "fa-times"
              title-position       2
              .

       PROCEDURE DIVISION.
       MAIN.

           perform LOAD-BMP.

           display standard graphical window
                   background-low  
                   title  "Application menu"
                   cell size is entry-field font 
                   size 60
                   lines 8
                   control font small-font
                   handle h-main
                   .

           display s1.

           perform until key-status = 27
              accept s1
                 on exception 
                    continue 
              end-accept
              evaluate key-status
              when 1
                   move "CUSTOMER" to pgm-to-call
                   perform CALL-PROGRAM
              when 2
                   move "STATE"    to pgm-to-call
                   perform CALL-PROGRAM
              end-evaluate
           end-perform.
           
           perform CLOSE-PROGRAM
           .

       CALL-PROGRAM.
           modify h-main visible 0
           call "BRIDGE" using pgm-to-call
           modify h-main visible 1
           cancel pgm-to-call
           .

       CLOSE-PROGRAM.
           destroy s1
           destroy h-main
           call "W$BITMAP" using wbitmap-destroy 
                                 h-logo
           goback.
       
       LOAD-BMP.
           copy resource "../resources/veryant.png".
           call "W$BITMAP" using wbitmap-load 
                                 "Veryant.png"
                          giving h-logo.
