/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.jdbc;

import com.veryant.jdbc.OdbcConnection;
import com.veryant.jdbc.PicoDbApi;
import java.sql.SQLException;

public class OdbcStatement {
    private int hStmt = 0;
    private PicoDbApi odbcApi;
    private OdbcConnection odbcCon;

    public OdbcStatement(PicoDbApi api, OdbcConnection con) throws SQLException {
        this.odbcApi = api;
        this.odbcCon = con;
        this.hStmt = this.odbcApi.SQLAllocStmt(this.odbcCon);
    }

    public synchronized int getHSTMT() {
        return this.hStmt;
    }

    public synchronized void drop() throws SQLException {
        if (this.hStmt != 0 && !this.odbcCon.isClosed()) {
            this.odbcApi.SQLFreeStmt(this, (short)1);
        }
        this.hStmt = 0;
    }

    public synchronized void close() throws SQLException {
        if (this.hStmt != 0 && !this.odbcCon.isClosed()) {
            this.odbcApi.SQLFreeStmt(this, (short)0);
        }
    }

    public synchronized boolean isDropped() {
        return this.hStmt == 0;
    }

    public void finalize() {
        try {
            this.drop();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public synchronized String toString() {
        return super.toString() + ", hStmt=" + this.hStmt;
    }
}

