/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.clientlstnr;

import com.iscobol.clientlstnr.ManageTray;
import com.iscobol.gui.client.Client;
import com.iscobol.gui.client.swing.GuiFactoryImpl;
import com.iscobol.rmi.RemoteRegistry;
import com.iscobol.rts.Config;
import com.iscobol.rts.RuntimeProperties;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.StringTokenizer;
import java.util.Vector;

public class ClientListener {
    public static final int DEFAULT_DISPLAY = 10998;
    public static final int DEFAULT_PORT = 10999;
    private static final byte[] ENTER = new byte[]{10};
    private final int iscobolASPort;
    private final String iscobolASHost;
    private final String iscobolASRemoteConfig;

    private ClientListener(String hostName, int portNumber, String remoteConfig) {
        this.iscobolASPort = portNumber;
        this.iscobolASHost = hostName;
        this.iscobolASRemoteConfig = remoteConfig;
    }

    private void startIscobolPrg(final Socket s, final String prgname, final String[] argv, String[][] isenv) throws IOException {
        if (RemoteRegistry.getSharedRegistry() == null) {
            RemoteRegistry.setSharedRegistry(new RemoteRegistry());
        }
        GuiFactoryImpl gf = new GuiFactoryImpl(s.getInputStream(), s.getOutputStream(), 0, ENTER);
        final Client isclient = new Client(isenv, gf);
        Thread runner = new Thread(){

            @Override
            public void run() {
                try {
                    int numargv = 3;
                    if (ClientListener.this.iscobolASPort != 0) {
                        numargv = 5;
                    }
                    if (ClientListener.this.iscobolASRemoteConfig != null) {
                        numargv = 7;
                    }
                    if (argv != null) {
                        numargv += argv.length;
                    }
                    String[] ARGS = new String[numargv];
                    int i = 0;
                    if (ClientListener.this.iscobolASPort != 0) {
                        ARGS[i++] = "-port";
                        ARGS[i++] = "" + ClientListener.this.iscobolASPort;
                    }
                    if (ClientListener.this.iscobolASRemoteConfig != null) {
                        ARGS[i++] = "-c";
                        ARGS[i++] = ClientListener.this.iscobolASRemoteConfig;
                    }
                    ARGS[i++] = "-hostname";
                    ARGS[i++] = ClientListener.this.iscobolASHost;
                    ARGS[i++] = prgname;
                    if (argv != null && argv.length > 0) {
                        int j = 0;
                        while (j < argv.length) {
                            ARGS[i++] = new String(argv[j++]);
                        }
                    }
                    Client.clinit();
                    isclient.init(ARGS);
                    s.close();
                }
                catch (Exception ee) {
                    ee.printStackTrace();
                }
            }
        };
        runner.start();
    }

    private static void init(String hostName, int portNumber, int displayPort, String remoteConfig, boolean reuseAddress) {
        new ManageTray(hostName, portNumber, displayPort);
        ServerSocket ss = null;
        try {
            ss = new ServerSocket(displayPort);
            ss.setReuseAddress(reuseAddress);
        }
        catch (IOException _ex) {
            System.out.println("Exception " + _ex);
            System.exit(3);
        }
        while (true) {
            try {
                while (true) {
                    String str;
                    int dataLen;
                    int protoLen;
                    Socket s = ss.accept();
                    hostName = s.getInetAddress().getHostAddress();
                    InputStream is = s.getInputStream();
                    OutputStream os = s.getOutputStream();
                    BufferedReader inp = new BufferedReader(new InputStreamReader(is));
                    System.err.println("Connected");
                    byte[] xHeader = new byte[12];
                    is.read(xHeader, 0, xHeader.length);
                    if (xHeader[0] == 66) {
                        protoLen = (xHeader[6] & 0xFF) << 8 + (xHeader[7] & 0xFF);
                        dataLen = (xHeader[8] & 0xFF) << 8 + (xHeader[9] & 0xFF);
                    } else {
                        protoLen = (xHeader[7] & 0xFF) << 8 + (xHeader[6] & 0xFF);
                        dataLen = (xHeader[9] & 0xFF) << 8 + (xHeader[6] & 0xFF);
                    }
                    for (int size = (protoLen + 3 & 0xFFFFFFFC) + (dataLen + 3 & 0xFFFFFFFC); size > 0; --size) {
                        is.read(xHeader, 0, 1);
                    }
                    Vector<String> env = new Vector<String>();
                    while ((str = inp.readLine()) != null && str.length() != 0) {
                        env.addElement(str);
                    }
                    os.write(10);
                    int nElement = env.size() - 1;
                    String commandLine = (String)env.elementAt(nElement);
                    env.removeElementAt(nElement);
                    StringTokenizer st = new StringTokenizer(commandLine);
                    String[] isargv = new String[st.countTokens() - 1];
                    String prgname = st.nextToken();
                    int i = 0;
                    while (st.hasMoreElements()) {
                        isargv[i] = st.nextToken();
                        ++i;
                    }
                    String[][] isenv = new String[nElement][2];
                    int i2 = 0;
                    while (i2 < nElement) {
                        String line = (String)env.elementAt(i2);
                        int equal = line.indexOf(61);
                        if (equal < 0) continue;
                        isenv[i2][0] = line.substring(0, equal).toLowerCase();
                        isenv[i2++][1] = line.substring(equal + 1);
                    }
                    new ClientListener(hostName, portNumber, remoteConfig).startIscobolPrg(s, prgname, isargv, isenv);
                }
            }
            catch (IOException _ex) {
                System.out.println(_ex);
                continue;
            }
            break;
        }
    }

    private static void copyright() {
        String eol = System.getProperty("line.separator", "\n");
        String javaInfo = System.getProperty("java.version") + " " + System.getProperty("java.vendor");
        String fullVersionNumber = RuntimeProperties.getFullVersionNumber();
        String productCopyright = RuntimeProperties.getProductCopyright();
        System.out.println(fullVersionNumber + eol + productCopyright + eol + eol + "Java version:    " + javaInfo + eol + "                 " + System.getProperty("java.home"));
        System.exit(0);
    }

    public static void usage() {
        System.out.println("usage: <command> [options] [-displayport d|-X] [-port n] -hostname host");
    }

    public static void main(String[] args) {
        int portNumber = Config.getProperty("iscobol.port", 10999);
        int displayPort = Config.getProperty("iscobol.displayport", 10998);
        String hostName = Config.getProperty("iscobol.hostname", "localhost");
        String remoteConfig = Config.getProperty("iscobol.remote_conf", null);
        boolean reuseAddress = false;
        if (args.length > 0 && args[0].equalsIgnoreCase("-v")) {
            ClientListener.copyright();
            System.exit(0);
        }
        try {
            for (int i = 0; i < args.length; ++i) {
                if (args[i].equalsIgnoreCase("-port")) {
                    portNumber = Integer.parseInt(args[++i]);
                    continue;
                }
                if (args[i].equalsIgnoreCase("-hostname")) {
                    hostName = args[++i];
                    continue;
                }
                if (args[i].equalsIgnoreCase("-X")) {
                    displayPort = 6000;
                    continue;
                }
                if (args[i].equalsIgnoreCase("-displayport")) {
                    displayPort = Integer.parseInt(args[++i]);
                    continue;
                }
                if (args[i].equalsIgnoreCase("-help")) {
                    ClientListener.usage();
                    System.exit(0);
                    continue;
                }
                if (args[i].equalsIgnoreCase("-force")) {
                    reuseAddress = true;
                    continue;
                }
                if (args[i].equalsIgnoreCase("-c")) {
                    if (++i < args.length) {
                        remoteConfig = args[i];
                        continue;
                    }
                    System.out.println("Command line error: " + args[i]);
                    ClientListener.usage();
                    System.exit(0);
                    continue;
                }
                System.out.println("Command line error: " + args[i]);
                ClientListener.usage();
                System.exit(0);
            }
        }
        catch (Exception e) {
            System.out.println("Command line error");
            ClientListener.usage();
            System.exit(0);
        }
        String msg = "Starting client listener on hostname: " + hostName + ", on display port: " + displayPort + ", AS port: " + portNumber;
        System.out.println(msg);
        ClientListener.init(hostName, portNumber, displayPort, remoteConfig, reuseAddress);
    }
}

