/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.compiler.CopyGen;
import com.iscobol.rts.Config;
import java.beans.Introspector;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;

public class AXCompiler {
    public static final String eol = System.getProperty("line.separator", "\n");
    private static final Class JCOM_ACTIVEX_OBJECT = AXCompiler.getClass("com.jniwrapper.win32.com.types.CoClass");

    public static void main(String[] args) throws Exception {
        int returnCode;
        int mod;
        int i;
        String usage = "usage: AXCompiler [-jj] activexclass axlistenerclass cominterfaceclass";
        Config.markNoIscobolRuntimeThread();
        if (args.length < 3) {
            System.err.println("usage: AXCompiler [-jj] activexclass axlistenerclass cominterfaceclass");
            System.exit(-1);
        }
        boolean jjOpt = false;
        int I2 = 0;
        if (args[0].equalsIgnoreCase("-jj")) {
            if (args.length < 4) {
                System.err.println("usage: AXCompiler [-jj] activexclass axlistenerclass cominterfaceclass");
                System.exit(-1);
            }
            jjOpt = true;
            I2 = 1;
        }
        Hashtable<String, Property> propTable = new Hashtable<String, Property>();
        Class activex = AXCompiler.getClass(args[I2]);
        if (!JCOM_ACTIVEX_OBJECT.isAssignableFrom(activex)) {
            System.err.println("class '" + activex.getName() + "' doesn't extend " + JCOM_ACTIVEX_OBJECT.getName());
            System.exit(-2);
        }
        Class eventlistener = AXCompiler.getClass(args[I2 + 1]);
        Class cominterface = null;
        cominterface = AXCompiler.getClass(args[I2 + 2]);
        String name = activex.getName();
        int idx = name.lastIndexOf(46);
        if (idx >= 0) {
            name = name.substring(idx + 1);
        }
        String evtname = name + "Event";
        String listname = name + "Listener";
        String contname = name + "Container";
        String binfoname = contname + "BeanInfo";
        String eventlistenerServerName = eventlistener.getName();
        idx = eventlistenerServerName.lastIndexOf(46);
        if (idx >= 0) {
            String pkg = eventlistenerServerName.substring(0, idx + 1) + "server";
            eventlistenerServerName = pkg + eventlistenerServerName.substring(idx) + "Server";
        } else {
            eventlistenerServerName = "server." + eventlistenerServerName + "Server";
        }
        PrintStream beanInfoOut = new PrintStream(new FileOutputStream(binfoname + ".java"));
        StringBuffer beanInfoEvtDesc = new StringBuffer();
        beanInfoEvtDesc.append("   public EventSetDescriptor[] getEventSetDescriptors() {" + eol);
        beanInfoEvtDesc.append("   try {" + eol);
        beanInfoEvtDesc.append("      return new EventSetDescriptor[] {  new EventSetDescriptor(\"" + name + "\"," + eol);
        beanInfoEvtDesc.append("              " + listname + ".class," + eol);
        beanInfoEvtDesc.append("              new MethodDescriptor[] {" + eol);
        beanInfoOut.println("import java.beans.*;");
        beanInfoOut.println("import com.iscobol.gui.ActiveXEvent;");
        beanInfoOut.println("public class " + binfoname + " extends SimpleBeanInfo implements BeanInfo {");
        beanInfoOut.println("   private static MethodDescriptor getMethodDesc(String methName, String[] paramDesc) throws Exception {");
        beanInfoOut.println("      ParameterDescriptor[] params = new ParameterDescriptor[paramDesc.length];");
        beanInfoOut.println("      for(int i = 0; i < paramDesc.length; i++) {");
        beanInfoOut.println("         params[i] = new ParameterDescriptor();");
        beanInfoOut.println("         params[i].setShortDescription(paramDesc[i]);");
        beanInfoOut.println("      }");
        beanInfoOut.println("      return new MethodDescriptor(");
        beanInfoOut.println("         " + listname + ".class.getMethod(methName, new Class[] { ActiveXEvent.class } ), params);");
        beanInfoOut.println("   }");
        beanInfoOut.println();
        beanInfoOut.println("public PropertyDescriptor[] getPropertyDescriptors() {");
        beanInfoOut.println("   try {");
        beanInfoOut.println("      PropertyDescriptor[] Return = new PropertyDescriptor[] {");
        PrintStream axListenerOut = new PrintStream(new FileOutputStream(listname + ".java"));
        axListenerOut.println("import java.util.EventListener;");
        axListenerOut.println("import com.iscobol.gui.ActiveXEvent;");
        axListenerOut.println("public interface " + listname + " extends EventListener {");
        PrintStream oleContainerOut = new PrintStream(new FileOutputStream(contname + ".java"));
        oleContainerOut.println("import com.jniwrapper.win32.com.IClassFactory;");
        oleContainerOut.println("import com.jniwrapper.win32.com.ComFunctions;");
        oleContainerOut.println("import com.jniwrapper.win32.com.CoInit;");
        oleContainerOut.println("import com.jniwrapper.win32.com.server.IClassFactoryServer;");
        oleContainerOut.println("import com.jniwrapper.win32.com.server.CoClassMetaInfo;");
        oleContainerOut.println("import com.jniwrapper.win32.com.types.IID;");
        oleContainerOut.println("import com.jniwrapper.win32.com.types.ClsCtx;");
        oleContainerOut.println("import com.jniwrapper.win32.com.impl.IClassFactory2Impl;");
        oleContainerOut.println("import com.jniwrapper.win32.automation.IDispatch;");
        oleContainerOut.println("import com.jniwrapper.win32.automation.OleMessageLoop;");
        oleContainerOut.println("import com.jniwrapper.win32.automation.OleContainer;");
        oleContainerOut.println("import com.jniwrapper.win32.automation.server.IDispatchVTBL;");
        oleContainerOut.println("import com.jniwrapper.win32.automation.impl.IDispatchImpl;");
        oleContainerOut.println("import com.jniwrapper.win32.automation.types.BStr;");
        oleContainerOut.println("import com.jniwrapper.win32.ole.IConnectionPoint;");
        oleContainerOut.println("import com.jniwrapper.win32.ole.impl.IConnectionPointContainerImpl;");
        oleContainerOut.println("import com.jniwrapper.win32.ole.impl.IOleObjectImpl;");
        oleContainerOut.println("import com.jniwrapper.win32.ole.types.OleVerbs;");
        oleContainerOut.println("import com.jniwrapper.Pointer;");
        oleContainerOut.println("import com.iscobol.gui.ActiveXEvent;");
        oleContainerOut.println("import com.iscobol.gui.ActiveXContainer;");
        oleContainerOut.println("import java.util.Enumeration;");
        oleContainerOut.println("import java.util.Vector;");
        oleContainerOut.println("import java.lang.reflect.Proxy;");
        oleContainerOut.println("import java.lang.reflect.Method;");
        oleContainerOut.println("import java.lang.reflect.InvocationHandler;");
        oleContainerOut.println("public class " + contname + " extends OleContainer implements ActiveXContainer {");
        oleContainerOut.println("   static { javax.swing.JPopupMenu.setDefaultLightWeightPopupEnabled(false); }");
        oleContainerOut.println();
        oleContainerOut.println("   public static class " + evtname + " extends " + eventlistenerServerName + " {");
        oleContainerOut.println("      private Vector axListeners = new Vector();");
        oleContainerOut.println("      private Object source;");
        oleContainerOut.println("      private boolean isWaiting;");
        oleContainerOut.println("      private Thread ct;");
        oleContainerOut.println("      public " + evtname + "(CoClassMetaInfo info) {");
        oleContainerOut.println("         super(info);");
        oleContainerOut.println("      }");
        oleContainerOut.println("      synchronized void setWaiting(boolean w) {");
        oleContainerOut.println("         isWaiting = w;");
        oleContainerOut.println("         ct = w ? Thread.currentThread() : null;");
        oleContainerOut.println("      }");
        oleContainerOut.println("      synchronized boolean isWaiting(Thread t) {");
        oleContainerOut.println("         return isWaiting && ct != t;");
        oleContainerOut.println("      }");
        oleContainerOut.println("      public void addActiveXListener(" + listname + " l) {");
        oleContainerOut.println("         axListeners.addElement(l);");
        oleContainerOut.println("      }");
        oleContainerOut.println("      public void removeActiveXListener(" + listname + " l) {");
        oleContainerOut.println("         axListeners.removeElement(l);");
        oleContainerOut.println("      }");
        Method[] ms = eventlistener.getDeclaredMethods();
        Hashtable<String, Integer> ht = new Hashtable<String, Integer>();
        for (i = 0; i < ms.length; ++i) {
            String methName;
            mod = ms[i].getModifiers();
            if (!Modifier.isPublic(mod)) continue;
            oleContainerOut.print("      public ");
            Integer prog = (Integer)ht.get(ms[i].getName());
            if (prog != null) {
                methName = ms[i].getName() + prog;
                ht.put(ms[i].getName(), new Integer(prog + 1));
            } else {
                methName = ms[i].getName();
                ht.put(ms[i].getName(), new Integer(2));
            }
            beanInfoEvtDesc.append("                 getMethodDesc(\"" + methName + "\",new String[] {");
            axListenerOut.println("   public void " + methName + "(ActiveXEvent evt);");
            Class<?> returnType = ms[i].getReturnType();
            if (returnType.isArray()) {
                oleContainerOut.print(AXCompiler.getArrayName(returnType));
            } else {
                oleContainerOut.print(AXCompiler.getClassName(returnType));
            }
            oleContainerOut.print(" " + ms[i].getName() + "(");
            Class[] parameterTypes = ms[i].getParameterTypes();
            for (int j = 0; j < parameterTypes.length; ++j) {
                String parname = parameterTypes[j].isArray() ? AXCompiler.getArrayName(parameterTypes[j]) : AXCompiler.getClassName(parameterTypes[j]);
                idx = parname.lastIndexOf(46);
                String shortparname = idx >= 0 ? parname.substring(idx + 1) : parname;
                beanInfoEvtDesc.append("\"" + shortparname + "\"");
                oleContainerOut.print(parname + " arg" + (j + 1));
                if (j >= parameterTypes.length - 1) continue;
                oleContainerOut.print(", ");
                beanInfoEvtDesc.append(",");
            }
            oleContainerOut.print(")");
            beanInfoEvtDesc.append("} )," + eol);
            Class<?>[] exceptionTypes = ms[i].getExceptionTypes();
            if (exceptionTypes.length > 0) {
                oleContainerOut.print(" throws ");
                for (int ii = 0; ii < exceptionTypes.length; ++ii) {
                    oleContainerOut.print(exceptionTypes[ii].getName());
                    if (ii >= exceptionTypes.length - 1) continue;
                    oleContainerOut.print(", ");
                }
            }
            oleContainerOut.println(" {");
            oleContainerOut.println("         if(!isWaiting(null)) {");
            oleContainerOut.print("            ActiveXEvent evt = new ActiveXEvent(source,");
            oleContainerOut.print(AXCompiler.getParametersCode(parameterTypes));
            oleContainerOut.println(");");
            oleContainerOut.println("            setWaiting(true);");
            oleContainerOut.println("            for(Enumeration e = axListeners.elements();e.hasMoreElements();)");
            oleContainerOut.println("               ((" + listname + ")e.nextElement())." + methName + "(evt);");
            oleContainerOut.println("            setWaiting(false);");
            oleContainerOut.println("         }");
            oleContainerOut.println("      }");
        }
        beanInfoEvtDesc.deleteCharAt(beanInfoEvtDesc.length() - 1);
        beanInfoEvtDesc.append("}," + eol);
        beanInfoEvtDesc.append("                 " + contname + ".class.getMethod(\"add" + listname + "\", new Class[] { " + listname + ".class })," + eol);
        beanInfoEvtDesc.append("                 " + contname + ".class.getMethod(\"remove" + listname + "\", new Class[] { " + listname + ".class })) };" + eol);
        beanInfoEvtDesc.append("         } catch(Exception ex) {" + eol);
        beanInfoEvtDesc.append("            ex.printStackTrace(); return new EventSetDescriptor[0];" + eol);
        beanInfoEvtDesc.append("         }" + eol);
        beanInfoEvtDesc.append("   }");
        oleContainerOut.println("   }");
        oleContainerOut.println();
        oleContainerOut.println("   private " + evtname + " axEventListener;");
        oleContainerOut.println("   private " + cominterface.getName() + " activex;");
        oleContainerOut.println("   private boolean isDisplayable;");
        oleContainerOut.println("   public " + contname + "() {");
        oleContainerOut.println("      this(null);");
        oleContainerOut.println("   }");
        oleContainerOut.println("   public " + contname + "(String license) {");
        oleContainerOut.println("      try {");
        oleContainerOut.println("         invokeAndWait(this, getClass().getMethod(\"_init\", new Class[] { String.class }), new Object[] { license });");
        oleContainerOut.println("      } catch(Exception ex) {");
        oleContainerOut.println("         ex.printStackTrace();");
        oleContainerOut.println("      }");
        oleContainerOut.println("   }");
        oleContainerOut.println("   public void _init(String license) {");
        oleContainerOut.println("      try {");
        oleContainerOut.println("         if(license == null) {");
        oleContainerOut.println("            createObject(" + activex.getName() + ".CLASS_ID);");
        oleContainerOut.println("         } else {");
        oleContainerOut.println("            ComFunctions.coInitializeEx(CoInit.APARTMENTTHREADED);");
        oleContainerOut.println("            IClassFactory2Impl cf2i = new IClassFactory2Impl();");
        oleContainerOut.println("            ComFunctions.coGetClassObject(" + activex.getName() + ".CLASS_ID, ");
        oleContainerOut.println("                       ClsCtx.INPROC_SERVER, new Pointer.Void(), cf2i);");
        oleContainerOut.println("            IOleObjectImpl oleObj = new IOleObjectImpl();");
        oleContainerOut.println("            cf2i.createInstanceLic(null, null, oleObj.getIID(),");
        oleContainerOut.println("                       new BStr(license), oleObj);");
        oleContainerOut.println("            insertObject(oleObj);");
        oleContainerOut.println("         }");
        oleContainerOut.println("         final " + cominterface.getName() + " orig = (" + cominterface.getName() + ") " + activex.getName() + ".queryInterface(getOleObject());");
        oleContainerOut.println("         activex = (" + cominterface.getName() + ") Proxy.newProxyInstance(" + contname + ".class.getClassLoader(),new Class[] { " + cominterface.getName() + ".class }, new InvocationHandler() {");
        oleContainerOut.println("            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {");
        oleContainerOut.println("               if (method.getDeclaringClass() == Object.class)  {");
        oleContainerOut.println("                  String methodName = method.getName();");
        oleContainerOut.println("                  if (methodName.equals(\"hashCode\"))  { return proxyHashCode(proxy); }");
        oleContainerOut.println("                  else if (methodName.equals(\"equals\")) { return proxyEquals(proxy, args[0]); }");
        oleContainerOut.println("                  else if (methodName.equals(\"toString\")) { return proxyToString(proxy); }");
        oleContainerOut.println("                  return nullValueOf(method.getReturnType());");
        oleContainerOut.println("                } else {");
        oleContainerOut.println("                  if(method.getReturnType() == void.class || axEventListener.isWaiting(Thread.currentThread())) {");
        oleContainerOut.println("                     invokeLater(orig, method, args);");
        oleContainerOut.println("                     return null;");
        oleContainerOut.println("                  } else {");
        oleContainerOut.println("                    return invokeAndWait(orig, method, args);");
        oleContainerOut.println("                  }");
        oleContainerOut.println("                }");
        oleContainerOut.println("             }");
        oleContainerOut.println("          } );");
        oleContainerOut.println("         IClassFactoryServer server = new IClassFactoryServer(" + evtname + ".class);");
        oleContainerOut.println("         server.registerInterface(IDispatch.class, new IDispatchVTBL(server));");
        oleContainerOut.println("         server.registerInterface(" + eventlistener.getName() + ".class, new IDispatchVTBL(server));");
        oleContainerOut.println("         server.setDefaultInterface(IDispatch.class);");
        oleContainerOut.println("         IClassFactory classFactory = server.createIClassFactory();");
        oleContainerOut.println("         IDispatchImpl _handler = new IDispatchImpl();");
        oleContainerOut.println("         classFactory.createInstance(null, _handler.getIID(), _handler);");
        oleContainerOut.println("         IConnectionPointContainerImpl connectionPointContainer = new IConnectionPointContainerImpl(getOleObject());");
        oleContainerOut.println("         IConnectionPoint connectionPoint = connectionPointContainer.findConnectionPoint(new IID(" + eventlistener.getName() + ".INTERFACE_IDENTIFIER));");
        oleContainerOut.println("         connectionPoint.advise(_handler);");
        oleContainerOut.println("         axEventListener = (" + evtname + ") server.getInstances().pop();");
        oleContainerOut.println("         axEventListener.source = this;");
        oleContainerOut.println("      } catch(Exception ex) { ex.printStackTrace(); }");
        oleContainerOut.println("   }");
        oleContainerOut.println("   public void add" + listname + "(" + listname + " l) {");
        oleContainerOut.println("      axEventListener.addActiveXListener(l);");
        oleContainerOut.println("   }");
        oleContainerOut.println("   public void remove" + listname + "(" + listname + " l) {");
        oleContainerOut.println("      axEventListener.removeActiveXListener(l);");
        oleContainerOut.println("   }");
        oleContainerOut.println("   private Integer proxyHashCode(Object proxy)  {");
        oleContainerOut.println("      return new Integer(System.identityHashCode(proxy));");
        oleContainerOut.println("   }");
        oleContainerOut.println("   private Boolean proxyEquals(Object proxy, Object other)  {");
        oleContainerOut.println("      return (proxy == other ? Boolean.TRUE : Boolean.FALSE);");
        oleContainerOut.println("   }");
        oleContainerOut.println("   private String proxyToString(Object proxy)  {");
        oleContainerOut.println("      return proxy.getClass().getName() + '@' + Integer.toHexString(proxy.hashCode());");
        oleContainerOut.println("   }");
        oleContainerOut.println("   private final static Character char_0 = new Character((char)0);");
        oleContainerOut.println("   private final static Byte byte_0 = new Byte((byte)0);");
        oleContainerOut.println("   private final static Object nullValueOf(Class rt) {");
        oleContainerOut.println("      if (!rt.isPrimitive()) { return null; }");
        oleContainerOut.println("      else if (rt == void.class) { return null; }");
        oleContainerOut.println("      else if (rt == boolean.class) { return Boolean.FALSE; }");
        oleContainerOut.println("      else if (rt == char.class) { return char_0; }");
        oleContainerOut.println("      else { return byte_0; }");
        oleContainerOut.println("   }");
        oleContainerOut.println("   private static void invokeLater(final Object o, final Method m, final Object[] args) {");
        oleContainerOut.println("      OleMessageLoop.invokeLater(new Runnable() {");
        oleContainerOut.println("         public void run() {");
        oleContainerOut.println("            try {");
        oleContainerOut.println("               m.invoke(o, args);");
        oleContainerOut.println("            } catch(Exception ex) {");
        oleContainerOut.println("               ex.printStackTrace();");
        oleContainerOut.println("            }");
        oleContainerOut.println("         }");
        oleContainerOut.println("      });");
        oleContainerOut.println("   }");
        oleContainerOut.println("   private static Object invokeAndWait(final Object o, final Method m, final Object[] args) {");
        oleContainerOut.println("      final Object[] Return = new Object[1];");
        oleContainerOut.println("      try {");
        oleContainerOut.println("         OleMessageLoop.invokeAndWait(new Runnable() {");
        oleContainerOut.println("            public void run() {");
        oleContainerOut.println("               try {");
        oleContainerOut.println("                  Return[0] = m.invoke(o, args);");
        oleContainerOut.println("               } catch(Exception ex2) {");
        oleContainerOut.println("                  ex2.printStackTrace();");
        oleContainerOut.println("               }");
        oleContainerOut.println("            }");
        oleContainerOut.println("         });");
        oleContainerOut.println("      } catch(Exception ex1) {");
        oleContainerOut.println("         ex1.printStackTrace();");
        oleContainerOut.println("      }");
        oleContainerOut.println("      return Return[0];");
        oleContainerOut.println("   }");
        oleContainerOut.println("   public " + cominterface.getName() + " getActiveX() {");
        oleContainerOut.println("      return activex;");
        oleContainerOut.println("   }");
        oleContainerOut.println("   public void initActiveX() {");
        oleContainerOut.println("      if(!isDisplayable) {");
        oleContainerOut.println("         doVerb(OleVerbs.SHOW);");
        oleContainerOut.println("         isDisplayable = true;");
        oleContainerOut.println("      }");
        oleContainerOut.println("   }");
        oleContainerOut.println("   public void destroyActiveX() {");
        oleContainerOut.println("      destroyObject();");
        oleContainerOut.println("      isDisplayable = false;");
        oleContainerOut.println("   }");
        oleContainerOut.println("   public boolean isEventDispatchThread() {");
        oleContainerOut.println("      return OleMessageLoop.get(Thread.currentThread()) != null;");
        oleContainerOut.println("   }");
        ms = cominterface.getDeclaredMethods();
        for (i = 0; i < ms.length; ++i) {
            Property prop;
            String propName;
            mod = ms[i].getModifiers();
            if (!Modifier.isPublic(mod) || Modifier.isStatic(mod)) continue;
            oleContainerOut.print("   public ");
            Class<?> returnType = ms[i].getReturnType();
            if (returnType.isArray()) {
                oleContainerOut.print(AXCompiler.getArrayName(returnType));
            } else {
                oleContainerOut.print(AXCompiler.getClassName(returnType));
            }
            String mName = ms[i].getName();
            String mName1 = AXCompiler.firstCharUpper(mName);
            oleContainerOut.print(" " + mName1 + "(");
            Class<?>[] pt = ms[i].getParameterTypes();
            Class<?> rt = ms[i].getReturnType();
            if (mName.startsWith("set") && pt.length == 1) {
                propName = mName.substring(3);
                prop = (Property)propTable.get(propName);
                if (prop != null) {
                    prop.writeMethod = mName1;
                    if (pt[0] != prop.type) {
                        prop.readMethod = null;
                    }
                } else {
                    propTable.put(propName, new Property(null, mName1, pt[0]));
                }
            } else if (mName.startsWith("get") && pt.length == 0 && rt != Void.TYPE) {
                propName = mName.substring(3);
                prop = (Property)propTable.get(propName);
                if (prop != null) {
                    if (rt == prop.type) {
                        prop.readMethod = mName1;
                    }
                } else {
                    propTable.put(propName, new Property(mName1, null, rt));
                }
            } else if (mName.startsWith("is") && pt.length == 0 && rt != Void.TYPE) {
                propName = mName.substring(2);
                prop = (Property)propTable.get(propName);
                if (prop != null) {
                    if (rt == prop.type) {
                        prop.readMethod = mName1;
                    }
                } else {
                    propTable.put(propName, new Property(mName1, null, rt));
                }
            }
            Class<?>[] parameterTypes = ms[i].getParameterTypes();
            for (int j = 0; j < parameterTypes.length; ++j) {
                if (parameterTypes[j].isArray()) {
                    oleContainerOut.print(AXCompiler.getArrayName(parameterTypes[j]));
                } else {
                    oleContainerOut.print(AXCompiler.getClassName(parameterTypes[j]));
                }
                oleContainerOut.print(" arg" + (j + 1));
                if (j >= parameterTypes.length - 1) continue;
                oleContainerOut.print(", ");
            }
            oleContainerOut.print(")");
            Class<?>[] exceptionTypes = ms[i].getExceptionTypes();
            if (exceptionTypes.length > 0) {
                oleContainerOut.print(" throws ");
                for (int ii = 0; ii < exceptionTypes.length; ++ii) {
                    oleContainerOut.print(exceptionTypes[ii].getName());
                    if (ii >= exceptionTypes.length - 1) continue;
                    oleContainerOut.print(", ");
                }
            }
            oleContainerOut.println(" {");
            oleContainerOut.print("      ");
            if (!returnType.getName().equals("void")) {
                oleContainerOut.print("return ");
            }
            oleContainerOut.print("activex." + ms[i].getName() + "(");
            for (int j = 0; j < parameterTypes.length; ++j) {
                oleContainerOut.print("arg" + (j + 1));
                if (j >= parameterTypes.length - 1) continue;
                oleContainerOut.print(",");
            }
            oleContainerOut.println(");");
            oleContainerOut.println("   }");
        }
        axListenerOut.println("}");
        oleContainerOut.println("}");
        Enumeration keys = propTable.keys();
        while (keys.hasMoreElements()) {
            String k = (String)keys.nextElement();
            Property p = (Property)propTable.get(k);
            beanInfoOut.println("         new PropertyDescriptor(\"" + Introspector.decapitalize(k) + "\", " + contname + ".class, " + (p.readMethod != null ? "\"" + p.readMethod + "\"" : "null") + ", " + (p.writeMethod != null ? "\"" + p.writeMethod + "\"" : "null") + "),");
        }
        beanInfoOut.println("         new PropertyDescriptor(\"activex\"," + contname + ".class,\"getActiveX\",null)");
        beanInfoOut.println("         };");
        beanInfoOut.println("         return Return;");
        beanInfoOut.println("      } catch(IntrospectionException ie) {");
        beanInfoOut.println("         ie.printStackTrace();");
        beanInfoOut.println("         return null;");
        beanInfoOut.println("      }");
        beanInfoOut.println("   }");
        beanInfoOut.println();
        beanInfoOut.println(beanInfoEvtDesc);
        beanInfoOut.println("}");
        beanInfoOut.close();
        axListenerOut.close();
        if (jjOpt) {
            System.out.println("Generated " + listname + ".java");
        }
        oleContainerOut.close();
        if (jjOpt) {
            System.out.println("Generated " + contname + ".java");
        }
        if (jjOpt) {
            System.out.println("Generated " + binfoname + ".java");
        }
        if ((returnCode = AXCompiler.doCompile(listname + ".java", contname + ".java", binfoname + ".java")) == 0) {
            System.out.println("Generated " + listname + ".class");
            System.out.println("Generated " + contname + ".class");
            System.out.println("Generated " + binfoname + ".class");
            if (!jjOpt) {
                new File(evtname + ".java").delete();
            }
            if (!jjOpt) {
                new File(listname + ".java").delete();
            }
            if (!jjOpt) {
                new File(contname + ".java").delete();
            }
            CopyGen.main(new String[]{contname});
        }
    }

    private static String firstCharUpper(String s) {
        StringBuffer Return2 = new StringBuffer(s);
        Return2.setCharAt(0, Character.toUpperCase(s.charAt(0)));
        return Return2.toString();
    }

    private static int doCompile(String listname, String contname, String binfoname) {
        int Return2;
        String javac = Config.getProperty(".compiler.javac", null);
        if (javac == null) {
            JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
            if (compiler != null) {
                StandardJavaFileManager manager = compiler.getStandardFileManager(null, null, null);
                ArrayList<JavaFileObject> compilationUnits = new ArrayList<JavaFileObject>();
                PrintWriter pw = new PrintWriter(System.err);
                for (JavaFileObject javaFileObject : manager.getJavaFileObjects(new File(listname), new File(contname), new File(binfoname))) {
                    compilationUnits.add(javaFileObject);
                }
                JavaCompiler.CompilationTask task = compiler.getTask(pw, manager, null, new ArrayList<String>(), null, compilationUnits);
                Return2 = task.call() != false ? 0 : -1;
            } else {
                int Return22 = -1;
            }
        } else {
            String[] cmdLine = new String[]{javac, "-classpath", System.getProperty("java.class.path", "."), listname, contname, binfoname};
            try {
                final Process p = Runtime.getRuntime().exec(cmdLine);
                new Thread(){

                    @Override
                    public void run() {
                        BufferedReader in = new BufferedReader(new InputStreamReader(p.getErrorStream()));
                        try {
                            String s;
                            while ((s = in.readLine()) != null) {
                                System.err.println(s);
                            }
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                }.start();
                Return2 = p.waitFor();
            }
            catch (Exception ex) {
                System.err.println(ex);
                Return2 = -1;
            }
        }
        return Return2;
    }

    private static boolean getBooleanCode(Class c, StringBuffer Return2, int idx) {
        if (c == Boolean.TYPE) {
            Return2.append("new Boolean(arg" + idx + ")");
            return true;
        }
        return false;
    }

    private static boolean getByteCode(Class c, StringBuffer Return2, int idx) {
        if (c == Byte.TYPE) {
            Return2.append("new Byte(arg" + idx + ")");
            return true;
        }
        return false;
    }

    private static boolean getShortCode(Class c, StringBuffer Return2, int idx) {
        if (c == Short.TYPE) {
            Return2.append("new Short(arg" + idx + ")");
            return true;
        }
        return false;
    }

    private static boolean getIntCode(Class c, StringBuffer Return2, int idx) {
        if (c == Integer.TYPE) {
            Return2.append("new Integer(arg" + idx + ")");
            return true;
        }
        return false;
    }

    private static boolean getLongCode(Class c, StringBuffer Return2, int idx) {
        if (c == Long.TYPE) {
            Return2.append("new Long(arg" + idx + ")");
            return true;
        }
        return false;
    }

    private static boolean getFloatCode(Class c, StringBuffer Return2, int idx) {
        if (c == Float.TYPE) {
            Return2.append("new Float(arg" + idx + ")");
            return true;
        }
        return false;
    }

    private static boolean getDoubleCode(Class c, StringBuffer Return2, int idx) {
        if (c == Double.TYPE) {
            Return2.append("new Double(arg" + idx + ")");
            return true;
        }
        return false;
    }

    private static boolean getCharCode(Class c, StringBuffer Return2, int idx) {
        if (c == Character.TYPE) {
            Return2.append("new Character(arg" + idx + ")");
            return true;
        }
        return false;
    }

    private static String getParametersCode(Class[] ps) {
        if (ps == null || ps.length == 0) {
            return "null";
        }
        StringBuffer Return2 = new StringBuffer("new Object[] { ");
        for (int i = 0; i < ps.length; ++i) {
            if (!(AXCompiler.getBooleanCode(ps[i], Return2, i + 1) || AXCompiler.getByteCode(ps[i], Return2, i + 1) || AXCompiler.getShortCode(ps[i], Return2, i + 1) || AXCompiler.getIntCode(ps[i], Return2, i + 1) || AXCompiler.getLongCode(ps[i], Return2, i + 1) || AXCompiler.getFloatCode(ps[i], Return2, i + 1) || AXCompiler.getDoubleCode(ps[i], Return2, i + 1) || AXCompiler.getCharCode(ps[i], Return2, i + 1))) {
                Return2.append("arg" + (i + 1));
            }
            if (i >= ps.length - 1) continue;
            Return2.append(",");
        }
        Return2.append("}");
        return Return2.toString();
    }

    private static String getClassName(Class cls) {
        return cls.getName().replace('$', '.');
    }

    private static Class getClass(String name) {
        try {
            return Class.forName(name);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            throw new RuntimeException(ex.getMessage());
        }
    }

    private static String getArrayName(Class array) {
        String arrayName = "";
        int dimensions = 0;
        Class<?> cls = array;
        while (cls.isArray()) {
            cls = cls.getComponentType();
            ++dimensions;
        }
        arrayName = AXCompiler.getClassName(cls);
        for (int jj = 0; jj < dimensions; ++jj) {
            arrayName = arrayName + "[]";
        }
        return arrayName;
    }

    private static class Property {
        String readMethod;
        String writeMethod;
        Class type;

        Property(String r, String w, Class t) {
            this.readMethod = r;
            this.writeMethod = w;
            this.type = t;
        }
    }
}

