/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.compiler.Block;
import com.iscobol.compiler.CobolToken;
import com.iscobol.compiler.Compute;
import com.iscobol.compiler.EndOfProgramException;
import com.iscobol.compiler.Errors;
import com.iscobol.compiler.ErrorsNumbers;
import com.iscobol.compiler.Expression;
import com.iscobol.compiler.GeneralErrorException;
import com.iscobol.compiler.GetVarOpts;
import com.iscobol.compiler.OnSizeError;
import com.iscobol.compiler.OnSizeErrorProvider;
import com.iscobol.compiler.Pcc;
import com.iscobol.compiler.Token;
import com.iscobol.compiler.TokenList;
import com.iscobol.compiler.TokenManager;
import com.iscobol.compiler.UnexpectedTokenException;
import com.iscobol.compiler.VariableDeclaration;
import com.iscobol.compiler.VariableName;
import com.iscobol.compiler.VariableNameList;
import com.iscobol.compiler.Verb;

public class Add
extends Verb
implements CobolToken,
ErrorsNumbers,
OnSizeErrorProvider {
    private TokenList numList = new TokenList();
    private VariableNameList varList = new VariableNameList();
    private VariableNameList varToList = new VariableNameList();
    private VariableNameList varGiving = new VariableNameList();
    private boolean corresponding;
    private boolean corrRounded;
    private boolean giving;
    private OnSizeError ose;

    public Add(Token kw, Block par, Pcc p, TokenManager t, Errors err) throws GeneralErrorException, EndOfProgramException {
        super(kw, par, p, t, err);
        Token tk = this.tm.getToken();
        if (tk.getToknum() == 381 || tk.getToknum() == 380) {
            this.addCorr(tk, kw, par, p, t, err);
        } else {
            this.addTo(tk, kw, par, p, t, err);
        }
    }

    private void addTo(Token tk, Token kw, Block par, Pcc p, TokenManager t, Errors err) throws GeneralErrorException, EndOfProgramException {
        VariableName v;
        VariableName varTo = null;
        Token tokenTo = null;
        block12: while (true) {
            switch (tk.getToknum()) {
                case 10001: {
                    if (!tk.isNull()) break block12;
                    tk.setZero();
                }
                case 10002: 
                case 10017: {
                    this.numList.addItem(tk);
                    varTo = null;
                    break;
                }
                case 10009: {
                    this.tm.ungetToken();
                    varTo = VariableName.getAny(this.tm, this.error, this.parent, this.pc, new GetVarOpts(this, 2));
                    if (varTo != null && varTo.isNumeric() && !varTo.isEdited()) {
                        this.varList.addItem(varTo);
                        break;
                    }
                    throw new GeneralErrorException(109, 4, tk, tk.getWord(), this.error);
                }
                case 702: {
                    if (varTo != null) {
                        varTo.rounded = true;
                        break block12;
                    }
                    throw new UnexpectedTokenException(tk, this.error);
                }
                default: {
                    break block12;
                }
            }
            tk = this.tm.getToken();
        }
        if (tk.getToknum() == 773) {
            block13: while (true) {
                tk = this.tm.getToken();
                switch (tk.getToknum()) {
                    case 702: {
                        if (varTo != null) {
                            varTo.rounded = true;
                            continue block13;
                        }
                        throw new UnexpectedTokenException(tk, this.error);
                    }
                    case 10001: {
                        if (!tk.isNull()) break block13;
                        tk.setZero();
                    }
                    case 10002: 
                    case 10017: {
                        if (tokenTo != null) {
                            throw new UnexpectedTokenException(tk, this.error);
                        }
                        tokenTo = tk;
                        this.numList.addItem(tokenTo);
                        varTo = null;
                        continue block13;
                    }
                    case 10009: {
                        this.tm.ungetToken();
                        varTo = VariableName.getAny(this.tm, this.error, this.parent, this.pc, new GetVarOpts(this, 2));
                        if (varTo != null && varTo.isNumeric() && !varTo.isEdited()) {
                            this.varToList.addItem(varTo);
                            continue block13;
                        }
                        throw new GeneralErrorException(109, 4, tk, tk.getWord(), this.error);
                    }
                }
                break;
            }
        }
        if (tk.getToknum() == 505) {
            this.giving = true;
            tk = this.tm.getToken();
            if (tk.getToknum() == 10009) {
                while (tk.getToknum() == 10009) {
                    this.tm.ungetToken();
                    varTo = VariableName.getAny(this.tm, this.error, this.parent, this.pc, new GetVarOpts(this, 1));
                    if (varTo == null || !varTo.isNumeric()) {
                        throw new GeneralErrorException(109, 4, tk, tk.getWord(), this.error);
                    }
                    this.varGiving.addItem(varTo);
                    tk = this.tm.getToken();
                    if (tk.getToknum() != 702) continue;
                    varTo.rounded = true;
                    tk = this.tm.getToken();
                }
                if (this.varToList.getItemNum() == 1) {
                    this.varList.addItem(this.varToList.getFirst());
                    this.varToList.deleteCurrent();
                } else if (this.varToList.getItemNum() != 0) {
                    throw new GeneralErrorException(11, 4, this.keyWord, this.keyWord.getWord(), this.error);
                }
            } else {
                throw new GeneralErrorException(17, 4, tk, tk.getWord(), this.error);
            }
            v = this.varToList.getFirst();
            while (v != null) {
                v.setPropTypeGet();
                v = this.varToList.getNext();
            }
        } else if (tokenTo != null) {
            throw new GeneralErrorException(17, 4, tokenTo, tokenTo.getWord(), this.error);
        }
        if (this.varToList.getItemNum() == 0 && this.varGiving.getItemNum() == 0) {
            this.varToList.addItem(this.varList.getLast());
            this.varList.deleteCurrent();
        }
        if (this.varGiving.getItemNum() == 0 && varTo == null || this.varList.getItemNum() + this.numList.getItemNum() < 1) {
            throw new GeneralErrorException(11, 4, this.keyWord, this.keyWord.getWord(), this.error);
        }
        v = this.varList.getFirst();
        while (v != null) {
            v.setPropTypeGet();
            v = this.varList.getNext();
        }
        if (this.varGiving.getItemNum() == 0) {
            v = this.varToList.getFirst();
            while (v != null) {
                v.checkPropTypeSetGet();
                v = this.varToList.getNext();
            }
        }
        this.tm.ungetToken();
        this.ose = new OnSizeError(kw, par, this, p, t, err);
        tk = this.tm.getToken();
        if (tk.getToknum() != 424) {
            this.tm.ungetToken();
        } else {
            this.endStmt = true;
        }
    }

    private void addCorr(Token tk, Token kw, Block par, Pcc p, TokenManager t, Errors err) throws GeneralErrorException, EndOfProgramException {
        VariableName var;
        this.corresponding = true;
        tk = this.tm.getToken();
        switch (tk.getToknum()) {
            case 10009: {
                this.tm.ungetToken();
                var = VariableName.get(this.tm, this.error, this.pc);
                if (var != null) {
                    if (var.isSetGetProperty()) {
                        throw new GeneralErrorException(75, 4, var.getNameToken(), var.getNameToken().getWord(), this.error);
                    }
                    this.varList.addItem(var);
                    var.getVarDecl().setUsedAll();
                    break;
                }
                throw new GeneralErrorException(11, 4, tk, tk.getWord(), this.error);
            }
            default: {
                throw new GeneralErrorException(11, 4, tk, tk.getWord(), this.error);
            }
        }
        tk = this.tm.getToken();
        if (tk.getToknum() != 773) {
            throw new GeneralErrorException(11, 4, tk, tk.getWord(), this.error);
        }
        tk = this.tm.getToken();
        switch (tk.getToknum()) {
            case 10009: {
                this.tm.ungetToken();
                var = VariableName.get(this.tm, this.error, this.pc);
                if (var != null) {
                    if (var.isSetGetProperty()) {
                        throw new GeneralErrorException(75, 4, var.getNameToken(), var.getNameToken().getWord(), this.error);
                    }
                    this.varToList.addItem(var);
                    var.getVarDecl().setUsedAll();
                    break;
                }
                throw new GeneralErrorException(11, 4, tk, tk.getWord(), this.error);
            }
            default: {
                throw new GeneralErrorException(11, 4, tk, tk.getWord(), this.error);
            }
        }
        tk = this.tm.getToken();
        switch (tk.getToknum()) {
            case 702: {
                var.rounded = true;
                this.corrRounded = true;
                break;
            }
            default: {
                this.tm.ungetToken();
            }
        }
        this.ose = new OnSizeError(kw, par, this, p, t, err);
        tk = this.tm.getToken();
        if (tk.getToknum() != 424) {
            this.tm.ungetToken();
        } else {
            this.endStmt = true;
        }
    }

    @Override
    public void check() throws GeneralErrorException {
    }

    private String getInitialEvaluation(boolean couldBeNativeInt) {
        StringBuffer Return2 = new StringBuffer();
        if (this.varList.getItemNum() > 0) {
            VariableName vn = this.varList.getFirst();
            if (couldBeNativeInt) {
                int i;
                Return2.append(vn.getCode());
                if (vn.isNumericVar()) {
                    Return2.append(".num().lnUnscValue");
                }
                int n = this.varList.getItemNum();
                for (i = 1; i < n; ++i) {
                    vn = this.varList.getAt(i);
                    Return2.append(" + ");
                    Return2.append(vn.getCode());
                    if (!vn.isNumericVar()) continue;
                    Return2.append(".num().lnUnscValue");
                }
                n = this.numList.getItemNum();
                for (i = 0; i < n; ++i) {
                    Return2.append(" + ");
                    Return2.append(Expression.toNum(this.numList.getAt(i)));
                }
            } else {
                Return2.append(Compute.getCobolNumCode(vn));
                vn = this.varList.getNext();
                while (vn != null) {
                    Return2.append(".add(");
                    Return2.append(Compute.getCobolNumCode(vn));
                    Return2.append(")");
                    vn = this.varList.getNext();
                }
                Token tk = this.numList.getFirst();
                while (tk != null) {
                    Return2.append(".add(");
                    Return2.append(this.getCodeLiteral(tk));
                    Return2.append(".num())");
                    tk = this.numList.getNext();
                }
            }
        } else if (couldBeNativeInt) {
            Return2.append(Expression.toNum(this.numList.getFirst()));
            int n = this.numList.getItemNum();
            for (int i = 1; i < n; ++i) {
                Return2.append(" + ");
                Return2.append(Expression.toNum(this.numList.getAt(i)));
            }
        } else {
            Return2.append(this.getCodeLiteral(this.numList.getFirst()));
            Return2.append(".num()");
            Token tk = this.numList.getNext();
            while (tk != null) {
                Return2.append(".add(");
                Return2.append(this.getCodeLiteral(tk));
                Return2.append(".num())");
                tk = this.numList.getNext();
            }
        }
        return Return2.toString();
    }

    boolean isOptimizable() {
        VariableDeclaration vd;
        if (!this.ose.hasBlocks() && this.varGiving.getItemNum() == 0 && (this.varList.getItemNum() == 0 && this.numList.getItemNum() == 1 && this.numList.getFirst().getToknum() == 10002 || this.varList.getItemNum() == 1 && this.numList.getItemNum() == 0 && (vd = this.varList.getFirst().getVarDecl()).isInteger() && vd.getLogicLen() <= 18)) {
            VariableName vn = this.varToList.getFirst();
            while (vn != null) {
                vd = vn.getVarDecl();
                if (vn.rounded && vd.getPNumber() != 0 || !vd.isInteger() || vd.getLogicLen() > 18) {
                    return false;
                }
                vn = this.varToList.getNext();
            }
            return true;
        }
        return false;
    }

    @Override
    void getCodeCorrEach(StringBuffer Return2, String fromVar, VariableDeclaration fvd, String toVar, VariableDeclaration tvd) {
        Return2.append(toVar);
        Return2.append(".set(");
        Return2.append(fromVar);
        Return2.append(".num().add(");
        Return2.append(toVar);
        Return2.append(".num()),");
        Return2.append(this.corrRounded);
        if (this.ose.hasBlocks()) {
            Return2.append(",true)|");
        } else {
            Return2.append(",false);");
        }
    }

    private boolean canUseNoClone() {
        int n = this.varList.getItemNum();
        for (int i = 0; i < n; ++i) {
            VariableDeclaration vd1 = this.varList.getAt(i).getVarDecl();
            if (vd1.getDimension() == 0) continue;
            for (int j = i + 1; j < n; ++j) {
                VariableDeclaration vd2 = this.varList.getAt(j).getVarDecl();
                if (vd1 != vd2) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public String getCode() {
        StringBuffer Return2 = new StringBuffer();
        if (this.corresponding) {
            this.getCodeDebug(Return2);
            Return2.append(this.ose.getCodeBefore());
            this.getCodeCorresponding(Return2, this.varList.getFirst(), this.varToList.getFirst(), true);
            if (this.ose.hasBlocks()) {
                Return2.setLength(Return2.length() - 1);
            } else {
                Return2.append(eol);
            }
            Return2.append(this.ose.getCode());
        } else if (this.isOptimizable()) {
            VariableName vf = this.varList.getFirst();
            Token tk = this.numList.getFirst();
            this.getCodeDebug(Return2);
            VariableName vn = this.varToList.getFirst();
            while (vn != null) {
                Return2.append(this.parent.getIndent());
                Return2.append(vn.getCode(true));
                Return2.append(".addToMe(");
                if (tk != null) {
                    Return2.append(tk.getAsLong());
                } else {
                    Return2.append(vf.getCode(vn.getVarDecl() != vf.getVarDecl()));
                    Return2.append(".tolong()");
                }
                Return2.append(");");
                Return2.append(eol);
                vn = this.varToList.getNext();
            }
        } else {
            VariableName vn;
            String initEval;
            int i;
            boolean noClone = this.canUseNoClone();
            VariableNameList vlDest = this.varGiving.getItemNum() > 0 ? this.varGiving : this.varToList;
            boolean couldBeNativeInt = true;
            int n = this.varList.getItemNum();
            for (i = 0; i < n && couldBeNativeInt; couldBeNativeInt &= Expression.couldBeNativeInt(this.varList.getAt(i).getVarDecl()), ++i) {
            }
            if (couldBeNativeInt) {
                Token tk;
                n = this.numList.getItemNum();
                for (i = 0; i < n && couldBeNativeInt; couldBeNativeInt &= Expression.couldBeNativeInt(tk), ++i) {
                    tk = this.numList.getAt(i);
                }
            }
            if (vlDest.getItemNum() > 1) {
                initEval = "add$" + Add.getUniqueId();
                Return2.append(this.parent.getIndent());
                if (couldBeNativeInt) {
                    Return2.append("long ");
                } else {
                    Return2.append("CobolNum ");
                }
                Return2.append(initEval);
                Return2.append("=");
                Return2.append(this.getInitialEvaluation(couldBeNativeInt));
                Return2.append(";");
                Return2.append(eol);
            } else {
                initEval = this.getInitialEvaluation(couldBeNativeInt);
            }
            Return2.append(this.parent.getIndent());
            this.getCodeDebug(Return2);
            VariableNameList vlDestPrim = new VariableNameList();
            int i2 = 0;
            while (i2 < vlDest.getItemNum()) {
                vn = vlDest.getAt(i2);
                if (vn.isPrimitive()) {
                    vlDestPrim.addItem(vn);
                    vlDest.deleteCurrent();
                    continue;
                }
                ++i2;
            }
            n = vlDestPrim.getItemNum();
            for (i2 = 0; i2 < n; ++i2) {
                String val;
                vn = vlDestPrim.getAt(i2);
                Return2.append(vn.getCode());
                String t = vn.getType().getName(true);
                Return2.append(" = ");
                if (this.giving) {
                    if (couldBeNativeInt) {
                        Return2.append(Compute.addCast(t, initEval));
                    } else {
                        Return2.append(Compute.getConversionMethod(t, initEval));
                    }
                } else if (Expression.couldBeNativeInt(vn.getVarDecl())) {
                    if (couldBeNativeInt) {
                        val = initEval + " + " + vn.getCode();
                        Return2.append(Compute.addCast(t, val));
                    } else {
                        Return2.append(Compute.getConversionMethod(t, initEval + ".add(CobolNum.noo((long) " + vn.getCode() + ", 0))"));
                    }
                } else if (couldBeNativeInt) {
                    val = initEval + " + ";
                    val = vn.isNumericVar() ? val + vn.getCode(noClone) + ".tolong()" : val + vn.getCode(noClone);
                    Return2.append(Compute.addCast(t, val));
                } else {
                    val = initEval + ".add(";
                    val = vn.isNumericVar() ? val + vn.getCode(noClone) + ".num())" : val + "CobolNum.noo((double) " + vn.getCode(noClone) + "))";
                    Return2.append(Compute.getConversionMethod(t, val));
                }
                Return2.append(";");
                if (i2 >= n - 1) continue;
                Return2.append(eol);
                Return2.append(this.parent.getIndent());
            }
            n = vlDest.getItemNum();
            if (n > 0) {
                if (vlDestPrim.getItemNum() > 0) {
                    Return2.append(eol);
                    Return2.append(this.parent.getIndent());
                }
                Return2.append(this.ose.getCodeBefore());
                for (i2 = 0; i2 < n; ++i2) {
                    vn = vlDest.getAt(i2);
                    Return2.append(vn.getCode(noClone));
                    Return2.append(".set(");
                    if (this.giving) {
                        Return2.append(initEval);
                        if (couldBeNativeInt) {
                            Return2.append(",0");
                        }
                    } else {
                        if (couldBeNativeInt) {
                            Return2.append("CobolNum.noo(");
                            Return2.append(initEval);
                            Return2.append(",0)");
                        } else {
                            Return2.append(initEval);
                        }
                        Return2.append(".add(");
                        Return2.append(vn.getCode(noClone));
                        Return2.append(".num())");
                    }
                    Return2.append(",");
                    Return2.append(vn.rounded);
                    Return2.append(",");
                    Return2.append(this.ose.hasBlocks());
                    Return2.append(")");
                    if (i2 >= n - 1) break;
                    Return2.append(this.ose.hasBlocks() ? "|" : ";");
                }
                Return2.append(this.ose.getCode());
            }
        }
        Return2.append(eol);
        this.getCodeDebugEnd(Return2);
        return Return2.toString();
    }

    public TokenList getNumList() {
        return this.numList;
    }

    public VariableNameList getVarList() {
        return this.varList;
    }

    public VariableNameList getVarToList() {
        return this.varToList;
    }

    public VariableNameList getVarGiving() {
        return this.varGiving;
    }

    public boolean isCorresponding() {
        return this.corresponding;
    }

    @Override
    public OnSizeError getOnSizeError() {
        return this.ose;
    }
}

