/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.compiler.Accept;
import com.iscobol.compiler.Add;
import com.iscobol.compiler.Alter;
import com.iscobol.compiler.Assert;
import com.iscobol.compiler.BlockException;
import com.iscobol.compiler.Call;
import com.iscobol.compiler.Cancel;
import com.iscobol.compiler.Chain;
import com.iscobol.compiler.Close;
import com.iscobol.compiler.CobolMethod;
import com.iscobol.compiler.CobolToken;
import com.iscobol.compiler.Commit;
import com.iscobol.compiler.Compute;
import com.iscobol.compiler.Continue;
import com.iscobol.compiler.DeferredBlock;
import com.iscobol.compiler.Delete;
import com.iscobol.compiler.Destroy;
import com.iscobol.compiler.Display;
import com.iscobol.compiler.Divide;
import com.iscobol.compiler.EndOfProgramException;
import com.iscobol.compiler.Entry;
import com.iscobol.compiler.Errors;
import com.iscobol.compiler.ErrorsNumbers;
import com.iscobol.compiler.Evaluate;
import com.iscobol.compiler.EvaluateSuObject;
import com.iscobol.compiler.Examine;
import com.iscobol.compiler.Exec;
import com.iscobol.compiler.Exhibit;
import com.iscobol.compiler.Exit;
import com.iscobol.compiler.GeneralErrorException;
import com.iscobol.compiler.Generate;
import com.iscobol.compiler.Goback;
import com.iscobol.compiler.Goto;
import com.iscobol.compiler.If;
import com.iscobol.compiler.Initialize;
import com.iscobol.compiler.Initiate;
import com.iscobol.compiler.InlineInvoke;
import com.iscobol.compiler.Inquire;
import com.iscobol.compiler.Inspect;
import com.iscobol.compiler.Invoke;
import com.iscobol.compiler.Json;
import com.iscobol.compiler.Modify;
import com.iscobol.compiler.Move;
import com.iscobol.compiler.Multiply;
import com.iscobol.compiler.MyClass;
import com.iscobol.compiler.NextSentence;
import com.iscobol.compiler.NextSentenceBlock;
import com.iscobol.compiler.Note;
import com.iscobol.compiler.On;
import com.iscobol.compiler.Open;
import com.iscobol.compiler.Paragraph;
import com.iscobol.compiler.Pcc;
import com.iscobol.compiler.Perform;
import com.iscobol.compiler.Raise;
import com.iscobol.compiler.Read;
import com.iscobol.compiler.Receive;
import com.iscobol.compiler.Release;
import com.iscobol.compiler.Resume;
import com.iscobol.compiler.Return;
import com.iscobol.compiler.Rewrite;
import com.iscobol.compiler.Rollback;
import com.iscobol.compiler.Search;
import com.iscobol.compiler.Send;
import com.iscobol.compiler.Service;
import com.iscobol.compiler.Set;
import com.iscobol.compiler.Sort;
import com.iscobol.compiler.Start;
import com.iscobol.compiler.Stop;
import com.iscobol.compiler.Strings;
import com.iscobol.compiler.Subtract;
import com.iscobol.compiler.Suppress;
import com.iscobol.compiler.Synchronized;
import com.iscobol.compiler.Terminate;
import com.iscobol.compiler.Token;
import com.iscobol.compiler.TokenManager;
import com.iscobol.compiler.Transform;
import com.iscobol.compiler.Try;
import com.iscobol.compiler.Unlock;
import com.iscobol.compiler.Unstring;
import com.iscobol.compiler.Use;
import com.iscobol.compiler.VariableDeclaration;
import com.iscobol.compiler.VariableName;
import com.iscobol.compiler.VariableNameList;
import com.iscobol.compiler.Verb;
import com.iscobol.compiler.VerbList;
import com.iscobol.compiler.Wait;
import com.iscobol.compiler.Write;
import com.iscobol.compiler.Xml;
import com.iscobol.compiler.Yield;
import com.iscobol.interfaces.compiler.IBlock;
import com.iscobol.interfaces.compiler.VerbNotifier;
import com.iscobol.interfaces.compiler.VerbNotifierExt;
import java.util.Vector;

public class Block
implements CobolToken,
ErrorsNumbers,
IBlock {
    static final int TYPE_NORMAL = 0;
    static final int TYPE_ON_EXCEPTION = 1;
    static final int TYPE_NOT_ON_EXCEPTION = 2;
    static final int TYPE_ON_SIZE_ERROR = 3;
    static final int TYPE_NOT_ON_SIZE_ERROR = 4;
    static final int TYPE_AT_END = 5;
    static final int TYPE_NOT_AT_END = 6;
    static final int TYPE_INVALID_KEY = 7;
    static final int TYPE_NOT_INVALID_KEY = 8;
    static final int TYPE_ON_OVERFLOW = 9;
    static final int TYPE_NOT_ON_OVERFLOW = 10;
    static final int TYPE_END_OF_PAGE = 11;
    static final int TYPE_NOT_END_OF_PAGE = 12;
    private static final String EXCEPT_NAME = "ex$";
    static final String spc = "                                                                                ";
    private static int prog;
    private TokenManager tm;
    private Errors error;
    private Pcc pc;
    private String exceptName = null;
    private Vector catchBlocks = new Vector();
    private VariableNameList raising;
    private Vector children = new Vector();
    private String name;
    private boolean loop;
    private boolean paragraphBlock;
    private int blockType;
    private boolean endRequired;
    VerbList verbs = new VerbList();
    Paragraph parent;
    Verb parentVerb;
    EvaluateSuObject parentSuObj;
    private Block pb;
    private NextSentenceBlock ns;
    int nesting;
    final boolean nextSentAllowed;
    final boolean debug;
    final boolean pt0_2;

    public Block(Block b, Paragraph par, Verb parentVerb, Pcc p, TokenManager t, Errors err, int nest) throws GeneralErrorException, EndOfProgramException {
        this(par, parentVerb, p, t, err);
        this.pb = b;
        this.parse(nest);
    }

    public Block(Paragraph par, Verb parentVerb, Pcc p, TokenManager t, Errors err) throws GeneralErrorException, EndOfProgramException {
        this.pc = p;
        this.tm = t;
        this.error = err;
        this.parent = par;
        this.parentVerb = parentVerb;
        if (this.parentVerb != null) {
            this.parentVerb.nestedBlocks.addElement(this);
        }
        this.pc.addBlock(this);
        if (this.pb != null) {
            this.pb.children.addElement(this);
        }
        this.nextSentAllowed = this.pc.getOption("-cm") != null || this.pc.getOption("-cr") != null || this.pc.getOption("-ca") != null;
        this.debug = this.pc.getOption("-d") != null;
        this.pt0_2 = this.pc.getOption("-pt0") != null || this.pc.getOption("-pt2") != null;
    }

    public Block(Block b, Paragraph par, Verb parentVerb, Pcc p, TokenManager t, Errors err, int nest, int blockType) throws GeneralErrorException, EndOfProgramException {
        this(par, parentVerb, p, t, err);
        this.pb = b;
        this.blockType = blockType;
        if (this.pb.getBlockType() != 0) {
            switch (blockType) {
                case 0: {
                    break;
                }
                case 1: {
                    if (this.pb.getBlockType() != 2) break;
                    this.endRequired = true;
                    break;
                }
                case 2: {
                    if (this.pb.getBlockType() != 1) break;
                    this.endRequired = true;
                    break;
                }
                case 3: {
                    if (this.pb.getBlockType() != 4) break;
                    this.endRequired = true;
                    break;
                }
                case 4: {
                    if (this.pb.getBlockType() != 3) break;
                    this.endRequired = true;
                    break;
                }
                case 5: {
                    if (this.pb.getBlockType() != 6) break;
                    this.endRequired = true;
                    break;
                }
                case 6: {
                    if (this.pb.getBlockType() != 5) break;
                    this.endRequired = true;
                    break;
                }
                case 7: {
                    if (this.pb.getBlockType() != 8) break;
                    this.endRequired = true;
                    break;
                }
                case 8: {
                    if (this.pb.getBlockType() != 7) break;
                    this.endRequired = true;
                    break;
                }
                case 9: {
                    if (this.pb.getBlockType() != 10) break;
                    this.endRequired = true;
                    break;
                }
                case 10: {
                    if (this.pb.getBlockType() != 9) break;
                    this.endRequired = true;
                    break;
                }
                case 11: {
                    if (this.pb.getBlockType() != 12) break;
                    this.endRequired = true;
                    break;
                }
                case 12: {
                    if (this.pb.getBlockType() != 11) break;
                    this.endRequired = true;
                }
            }
        }
        this.parse(nest);
    }

    public Block(Block b, Paragraph par, Verb parentVerb, Pcc p, TokenManager t, Errors err, int nest, boolean testAfter) throws GeneralErrorException, EndOfProgramException {
        this(b, par, parentVerb, p, t, err, nest);
        this.loop = true;
        if (testAfter) {
            this.name = "blk$" + prog++;
        }
    }

    public String getIndent() {
        int nSpaces = 6 + this.nesting * 3;
        if (nSpaces < spc.length()) {
            return spc.substring(0, nSpaces);
        }
        return spc;
    }

    public int getBlockType() {
        return this.blockType;
    }

    private void verbsAddItem(Verb v) throws EndOfProgramException, GeneralErrorException {
        if (this.ns != null) {
            this.verbs.addItem(this.ns);
        }
        this.verbs.addItem(v);
        VerbNotifier vn = Pcc.getVerbNotifier();
        if (vn != null) {
            boolean go = true;
            if (vn instanceof VerbNotifierExt) {
                go = ((VerbNotifierExt)vn).foundVerb(v);
            }
            if (go) {
                this.tm.ungetToken();
                if (!vn.foundVerb(v.getKeyWord(), this.tm.getToken(), this.tm.getLastRemovedToken())) {
                    throw new EndOfProgramException();
                }
            }
        }
    }

    public Block[] getCatchBlocks() {
        Block[] Return2 = new Block[this.catchBlocks.size()];
        this.catchBlocks.toArray(Return2);
        return Return2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void parse(int nest) throws GeneralErrorException, EndOfProgramException {
        Token lastToken;
        block251: {
            lastToken = null;
            boolean resync = false;
            this.nesting = nest;
            block225: while (true) {
                Token tk;
                try {
                    tk = this.tm.getToken();
                }
                catch (EndOfProgramException e) {
                    break block251;
                }
                if (tk.getToknum() != 10009 && tk.getToknum() != 10002 && tk.getToknum() != 10018) {
                    lastToken = tk;
                    switch (tk.getToknum()) {
                        case 590: {
                            resync = false;
                            try {
                                this.verbsAddItem(new Move(tk, this, this.pc, this.tm, this.error));
                            }
                            catch (GeneralErrorException e) {
                                resync = true;
                            }
                            continue block225;
                        }
                        case 408: {
                            resync = false;
                            try {
                                this.verbsAddItem(new Display(tk, this, this.pc, this.tm, this.error));
                            }
                            catch (GeneralErrorException e) {
                                resync = true;
                            }
                            continue block225;
                        }
                        case 475: {
                            resync = false;
                            try {
                                this.verbsAddItem(new Exhibit(tk, this, this.pc, this.tm, this.error));
                            }
                            catch (GeneralErrorException e) {
                                resync = true;
                            }
                            continue block225;
                        }
                        case 402: {
                            resync = false;
                            try {
                                this.verbsAddItem(new Destroy(tk, this, this.pc, this.tm, this.error));
                            }
                            catch (GeneralErrorException e) {
                                resync = true;
                            }
                            continue block225;
                        }
                        case 524: {
                            resync = false;
                            try {
                                this.verbsAddItem(new If(tk, this, this.pc, this.tm, this.error));
                            }
                            catch (GeneralErrorException e) {
                                resync = true;
                                if (this.pc.getOption("-lfo") == null) continue block225;
                                while (tk != null && tk.getToknum() != 10006 && tk != null && tk.getToknum() != -102) {
                                    tk = this.tm.getToken();
                                }
                                resync = false;
                            }
                            continue block225;
                        }
                        case 467: {
                            resync = false;
                            try {
                                this.verbsAddItem(new Evaluate(tk, this, this.pc, this.tm, this.error));
                            }
                            catch (GeneralErrorException e) {
                                resync = true;
                            }
                            continue block225;
                        }
                        case 743: {
                            resync = false;
                            try {
                                this.verbsAddItem(new Stop(tk, this, this.pc, this.tm, this.error));
                            }
                            catch (GeneralErrorException e) {
                                resync = true;
                            }
                            continue block225;
                        }
                        case 503: {
                            resync = false;
                            try {
                                this.verbsAddItem(new Goto(tk, this, this.pc, this.tm, this.error));
                            }
                            catch (GeneralErrorException e) {
                                resync = true;
                            }
                            continue block225;
                        }
                        case 504: {
                            resync = false;
                            try {
                                this.verbsAddItem(new Goback(tk, this, this.pc, this.tm, this.error));
                            }
                            catch (GeneralErrorException e) {
                                resync = true;
                            }
                            continue block225;
                        }
                        case 476: {
                            resync = false;
                            try {
                                Exit exit = new Exit(tk, this, this.pc, this.tm, this.error);
                                if (!this.debug && exit.isExitPlain()) continue block225;
                                this.verbsAddItem(exit);
                            }
                            catch (GeneralErrorException e) {
                                resync = true;
                            }
                            continue block225;
                        }
                        case 632: {
                            resync = false;
                            try {
                                this.verbsAddItem(new Perform(tk, this, this.pc, this.tm, this.error));
                            }
                            catch (GeneralErrorException e) {
                                resync = true;
                            }
                            continue block225;
                        }
                        case 613: {
                            resync = false;
                            try {
                                this.verbsAddItem(new On(tk, this, this.pc, this.tm, this.error));
                            }
                            catch (GeneralErrorException e) {
                                resync = true;
                            }
                            continue block225;
                        }
                        case 544: {
                            resync = false;
                            try {
                                this.verbsAddItem(new Invoke(tk, this, this.pc, this.tm, this.error));
                            }
                            catch (GeneralErrorException e) {
                                resync = true;
                            }
                            continue block225;
                        }
                        case 313: {
                            resync = false;
                            try {
                                this.verbsAddItem(new Call(tk, this, this.pc, this.tm, this.error));
                            }
                            catch (GeneralErrorException e) {
                                resync = true;
                            }
                            continue block225;
                        }
                        case 314: {
                            resync = false;
                            try {
                                this.verbsAddItem(new Cancel(tk, this, this.pc, this.tm, this.error));
                            }
                            catch (GeneralErrorException e) {
                                resync = true;
                            }
                            continue block225;
                        }
                        case 321: {
                            resync = false;
                            try {
                                this.verbsAddItem(new Chain(tk, this, this.pc, this.tm, this.error));
                            }
                            catch (GeneralErrorException e) {
                                resync = true;
                            }
                            continue block225;
                        }
                        case 615: {
                            resync = false;
                            try {
                                this.verbsAddItem(new Open(tk, this, this.pc, this.tm, this.error));
                            }
                            catch (GeneralErrorException e) {
                                resync = true;
                            }
                            continue block225;
                        }
                        case 332: {
                            resync = false;
                            try {
                                this.verbsAddItem(new Close(tk, this, this.pc, this.tm, this.error));
                            }
                            catch (GeneralErrorException e) {
                                resync = true;
                            }
                            continue block225;
                        }
                        case 816: {
                            resync = false;
                            try {
                                this.verbsAddItem(new Write(tk, this, this.pc, this.tm, this.error));
                            }
                            catch (GeneralErrorException e) {
                                resync = true;
                            }
                            continue block225;
                        }
                        case 699: {
                            resync = false;
                            try {
                                this.verbsAddItem(new Rewrite(tk, this, this.pc, this.tm, this.error));
                            }
                            catch (GeneralErrorException e) {
                                resync = true;
                            }
                            continue block225;
                        }
                        case 666: {
                            resync = false;
                            try {
                                this.verbsAddItem(new Read(tk, this, this.pc, this.tm, this.error));
                            }
                            catch (GeneralErrorException e) {
                                resync = true;
                            }
                            continue block225;
                        }
                        case 741: {
                            resync = false;
                            try {
                                this.verbsAddItem(new Start(tk, this, this.pc, this.tm, this.error));
                            }
                            catch (GeneralErrorException e) {
                                resync = true;
                            }
                            continue block225;
                        }
                        case 397: {
                            resync = false;
                            try {
                                this.verbsAddItem(new Delete(tk, this, this.pc, this.tm, this.error));
                            }
                            catch (GeneralErrorException e) {
                                resync = true;
                            }
                            continue block225;
                        }
                        case 786: {
                            resync = false;
                            try {
                                this.verbsAddItem(new Unlock(tk, this, this.pc, this.tm, this.error));
                            }
                            catch (GeneralErrorException e) {
                                resync = true;
                            }
                            continue block225;
                        }
                        case 701: {
                            resync = false;
                            try {
                                this.verbsAddItem(new Rollback(tk, this, this.pc, this.tm, this.error));
                            }
                            catch (GeneralErrorException e) {
                                resync = true;
                            }
                            continue block225;
                        }
                        case 341: {
                            resync = false;
                            try {
                                this.verbsAddItem(new Commit(tk, this, this.pc, this.tm, this.error));
                            }
                            catch (GeneralErrorException e) {
                                resync = true;
                            }
                            continue block225;
                        }
                        case 581: 
                        case 732: {
                            resync = false;
                            try {
                                this.verbsAddItem(new Sort(tk, this, this.pc, this.tm, this.error));
                            }
                            catch (GeneralErrorException e) {
                                resync = true;
                            }
                            continue block225;
                        }
                        case 678: {
                            resync = false;
                            try {
                                this.verbsAddItem(new Release(tk, this, this.pc, this.tm, this.error));
                            }
                            catch (GeneralErrorException e) {
                                resync = true;
                            }
                            continue block225;
                        }
                        case 693: {
                            resync = false;
                            try {
                                this.verbsAddItem(new Return(tk, this, this.pc, this.tm, this.error));
                            }
                            catch (GeneralErrorException e) {
                                resync = true;
                            }
                            continue block225;
                        }
                        case 713: {
                            resync = false;
                            try {
                                this.verbsAddItem(new Send(tk, this, this.pc, this.tm, this.error));
                            }
                            catch (GeneralErrorException e) {
                                resync = true;
                            }
                            continue block225;
                        }
                        case 669: {
                            resync = false;
                            try {
                                this.verbsAddItem(new Receive(tk, this, this.pc, this.tm, this.error));
                            }
                            catch (GeneralErrorException e) {
                                resync = true;
                            }
                            continue block225;
                        }
                        case 809: {
                            resync = false;
                            try {
                                this.verbsAddItem(new Wait(tk, this, this.pc, this.tm, this.error));
                            }
                            catch (GeneralErrorException e) {
                                resync = true;
                            }
                            continue block225;
                        }
                        case 752: {
                            resync = false;
                            try {
                                this.verbsAddItem(new Synchronized(tk, this, this.pc, this.tm, this.error));
                            }
                            catch (GeneralErrorException e) {
                                resync = true;
                            }
                            continue block225;
                        }
                        case 457: {
                            resync = false;
                            try {
                                this.verbsAddItem(new Entry(tk, this, this.pc, this.tm, this.error));
                            }
                            catch (GeneralErrorException e) {
                                resync = true;
                            }
                            continue block225;
                        }
                        case 779: {
                            resync = false;
                            try {
                                this.verbsAddItem(new Try(tk, this, this.pc, this.tm, this.error));
                            }
                            catch (GeneralErrorException e) {
                                resync = true;
                            }
                            continue block225;
                        }
                        case 662: {
                            resync = false;
                            try {
                                this.verbsAddItem(new Raise(tk, this, this.pc, this.tm, this.error));
                            }
                            catch (GeneralErrorException e) {
                                resync = true;
                            }
                            continue block225;
                        }
                        case 282: {
                            resync = false;
                            try {
                                this.verbsAddItem(new Assert(tk, this, this.pc, this.tm, this.error));
                            }
                            catch (GeneralErrorException e) {
                                resync = true;
                            }
                            continue block225;
                        }
                        case 798: {
                            if (!this.pc.inDeclaratives) {
                                this.error.print(15, 4, tk, "<" + tk.getWord() + ">");
                            }
                            resync = false;
                            try {
                                this.verbsAddItem(new Use(tk, this, this.pc, this.tm, this.error));
                            }
                            catch (GeneralErrorException e) {
                                resync = true;
                            }
                            continue block225;
                        }
                        case 692: {
                            if (!this.pc.inDeclaratives) {
                                this.error.print(15, 4, tk, "<" + tk.getWord() + ">");
                            }
                            resync = false;
                            try {
                                this.verbsAddItem(new Resume(tk, this, this.pc, this.tm, this.error));
                            }
                            catch (GeneralErrorException e) {
                                resync = true;
                            }
                            continue block225;
                        }
                        case 10006: {
                            if (resync) {
                                resync = false;
                            }
                            if (this.nesting != 0) {
                                this.tm.ungetToken();
                                this.pc.popBlock();
                                return;
                            }
                            if (this.ns == null) continue block225;
                            this.verbsAddItem(this.ns.getEnd());
                            this.ns = null;
                            continue block225;
                        }
                        case 422: {
                            if (this.pc instanceof CobolMethod) {
                                this.tm.ungetToken();
                                this.pc.popBlock();
                                return;
                            }
                            if (!this.pc.inDeclaratives) {
                                Token oldTk = tk;
                                tk = this.tm.getToken();
                                if (tk != null && tk.getToknum() != 653) {
                                    this.tm.ungetToken();
                                    tk = oldTk;
                                    this.error.print(15, 4, tk, "<" + tk.getWord() + ">");
                                    continue block225;
                                }
                                tk = this.tm.getToken();
                                if (tk != null && (tk.getToknum() == 10009 || tk.getToknum() == 10001)) {
                                    tk = this.tm.getToken();
                                }
                                if (tk == null || tk.getToknum() == 10006) continue block225;
                                this.tm.ungetToken();
                                continue block225;
                            }
                            this.pc.popBlock();
                            return;
                        }
                        case 315: 
                        case 417: 
                        case 423: 
                        case 424: 
                        case 425: 
                        case 426: 
                        case 427: 
                        case 428: 
                        case 429: 
                        case 430: 
                        case 431: 
                        case 433: 
                        case 434: 
                        case 435: 
                        case 436: 
                        case 437: 
                        case 438: 
                        case 440: 
                        case 441: 
                        case 442: 
                        case 443: 
                        case 444: 
                        case 445: 
                        case 446: 
                        case 447: 
                        case 448: 
                        case 449: 
                        case 450: 
                        case 451: 
                        case 452: 
                        case 453: 
                        case 454: 
                        case 455: 
                        case 488: 
                        case 598: 
                        case 622: 
                        case 810: {
                            if (resync) {
                                resync = false;
                            }
                            if (this.nesting != 0) {
                                this.tm.ungetToken();
                                this.pc.popBlock();
                                return;
                            }
                            this.error.print(45, 4, tk, "<" + tk.getWord() + ">");
                        }
                        case 372: {
                            resync = false;
                            try {
                                this.verbsAddItem(new Continue(tk, this, this.pc, this.tm, this.error));
                            }
                            catch (GeneralErrorException e) {
                                resync = true;
                            }
                            continue block225;
                        }
                        case 258: {
                            resync = false;
                            try {
                                this.verbsAddItem(new Add(tk, this, this.pc, this.tm, this.error));
                            }
                            catch (GeneralErrorException e) {
                                resync = true;
                            }
                            continue block225;
                        }
                        case 746: {
                            resync = false;
                            try {
                                this.verbsAddItem(new Subtract(tk, this, this.pc, this.tm, this.error));
                            }
                            catch (GeneralErrorException e) {
                                resync = true;
                            }
                            continue block225;
                        }
                        case 272: {
                            resync = false;
                            try {
                                this.verbsAddItem(new Alter(tk, this, this.pc, this.tm, this.error));
                            }
                            catch (GeneralErrorException e) {
                                resync = true;
                            }
                            continue block225;
                        }
                        case 592: {
                            resync = false;
                            try {
                                this.verbsAddItem(new Multiply(tk, this, this.pc, this.tm, this.error));
                            }
                            catch (GeneralErrorException e) {
                                resync = true;
                            }
                            continue block225;
                        }
                        case 409: {
                            resync = false;
                            try {
                                this.verbsAddItem(new Divide(tk, this, this.pc, this.tm, this.error));
                            }
                            catch (GeneralErrorException e) {
                                resync = true;
                            }
                            continue block225;
                        }
                        case 366: {
                            resync = false;
                            try {
                                this.verbsAddItem(new Compute(tk, this, this.pc, this.tm, this.error));
                            }
                            catch (GeneralErrorException e) {
                                resync = true;
                            }
                            continue block225;
                        }
                        case 532: {
                            resync = false;
                            try {
                                this.verbsAddItem(new Initialize(tk, this, this.pc, this.tm, this.error));
                            }
                            catch (GeneralErrorException e) {
                                resync = true;
                            }
                            continue block225;
                        }
                        case 744: {
                            resync = false;
                            try {
                                this.verbsAddItem(new Strings(tk, this, this.pc, this.tm, this.error));
                            }
                            catch (GeneralErrorException e) {
                                resync = true;
                            }
                            continue block225;
                        }
                        case 790: {
                            resync = false;
                            try {
                                this.verbsAddItem(new Unstring(tk, this, this.pc, this.tm, this.error));
                            }
                            catch (GeneralErrorException e) {
                                resync = true;
                            }
                            continue block225;
                        }
                        case 537: {
                            resync = false;
                            try {
                                this.verbsAddItem(new Inspect(tk, this, this.pc, this.tm, this.error));
                            }
                            catch (GeneralErrorException e) {
                                resync = true;
                            }
                            continue block225;
                        }
                        case 470: {
                            resync = false;
                            try {
                                this.verbsAddItem(new Examine(tk, this, this.pc, this.tm, this.error));
                            }
                            catch (GeneralErrorException e) {
                                resync = true;
                            }
                            continue block225;
                        }
                        case 778: {
                            resync = false;
                            try {
                                this.verbsAddItem(new Transform(tk, this, this.pc, this.tm, this.error));
                            }
                            catch (GeneralErrorException e) {
                                resync = true;
                            }
                            continue block225;
                        }
                        case 667: 
                        case 689: {
                            resync = false;
                            tk = this.tm.getToken();
                            if (tk.getWord().equals("TRACE")) {
                                try {
                                    this.verbsAddItem(new Continue(tk, this, this.pc, this.tm, this.error));
                                }
                                catch (GeneralErrorException e) {
                                    resync = true;
                                }
                                continue block225;
                            }
                            this.error.print(15, 4, tk, "<" + tk.getWord() + ">");
                            continue block225;
                        }
                        case 708: {
                            resync = false;
                            try {
                                this.verbsAddItem(new Search(tk, this, this.pc, this.tm, this.error));
                            }
                            catch (GeneralErrorException e) {
                                resync = true;
                            }
                            continue block225;
                        }
                        case 719: {
                            resync = false;
                            try {
                                this.verbsAddItem(new Set(tk, this, this.pc, this.tm, this.error));
                            }
                            catch (GeneralErrorException e) {
                                resync = true;
                            }
                            continue block225;
                        }
                        case 256: {
                            resync = false;
                            try {
                                this.verbsAddItem(new Accept(tk, this, this.pc, this.tm, this.error));
                            }
                            catch (GeneralErrorException e) {
                                resync = true;
                            }
                            continue block225;
                        }
                        case 589: {
                            resync = false;
                            try {
                                this.verbsAddItem(new Modify(tk, this, this.pc, this.tm, this.error));
                            }
                            catch (GeneralErrorException e) {
                                resync = true;
                            }
                            continue block225;
                        }
                        case 536: {
                            resync = false;
                            try {
                                this.verbsAddItem(new Inquire(tk, this, this.pc, this.tm, this.error));
                            }
                            catch (GeneralErrorException e) {
                                resync = true;
                            }
                            continue block225;
                        }
                        case 819: {
                            resync = false;
                            try {
                                this.verbsAddItem(new Yield(tk, this, this.pc, this.tm, this.error));
                            }
                            catch (GeneralErrorException e) {
                                resync = true;
                            }
                            continue block225;
                        }
                        case 599: {
                            resync = false;
                            try {
                                this.verbsAddItem(new Note(tk, this, this.pc, this.tm, this.error));
                            }
                            catch (GeneralErrorException e) {
                                resync = true;
                            }
                            continue block225;
                        }
                        case 474: {
                            resync = false;
                            try {
                                this.verbsAddItem(new Exec(tk, this, this.pc, this.tm, this.error));
                            }
                            catch (GeneralErrorException e) {
                                resync = true;
                            }
                            continue block225;
                        }
                        case 718: {
                            resync = false;
                            try {
                                this.verbsAddItem(new Service(tk, this, this.pc, this.tm, this.error));
                            }
                            catch (GeneralErrorException e) {
                                resync = true;
                            }
                            continue block225;
                        }
                        case 33: 
                        case 595: {
                            if (this.nextSentAllowed) {
                                if (this.tm.getToken().getToknum() == 714) {
                                    resync = false;
                                    this.verbsAddItem(new NextSentence(tk, this, this.pc, this.tm, this.error));
                                    continue block225;
                                }
                                this.tm.ungetToken();
                            }
                        }
                        case 533: {
                            resync = false;
                            try {
                                this.verbsAddItem(new Initiate(tk, this, this.pc, this.tm, this.error));
                            }
                            catch (GeneralErrorException e) {
                                resync = true;
                            }
                            continue block225;
                        }
                        case 759: {
                            resync = false;
                            try {
                                this.verbsAddItem(new Terminate(tk, this, this.pc, this.tm, this.error));
                            }
                            catch (GeneralErrorException e) {
                                resync = true;
                            }
                            continue block225;
                        }
                        case 501: {
                            resync = false;
                            try {
                                this.verbsAddItem(new Generate(tk, this, this.pc, this.tm, this.error));
                            }
                            catch (GeneralErrorException e) {
                                resync = true;
                            }
                            continue block225;
                        }
                        case 748: {
                            resync = false;
                            try {
                                this.verbsAddItem(new Suppress(tk, this, this.pc, this.tm, this.error));
                            }
                            catch (GeneralErrorException e) {
                                resync = true;
                            }
                            continue block225;
                        }
                        case 818: {
                            resync = false;
                            try {
                                this.verbsAddItem(new Xml(tk, this, this.pc, this.tm, this.error));
                            }
                            catch (GeneralErrorException e) {
                                resync = true;
                            }
                            continue block225;
                        }
                        case 546: {
                            resync = false;
                            try {
                                this.verbsAddItem(new Json(tk, this, this.pc, this.tm, this.error));
                            }
                            catch (GeneralErrorException e) {
                                resync = true;
                            }
                            continue block225;
                        }
                        case 521: 
                        case 522: {
                            throw new GeneralErrorException(19, 4, tk, "", this.error);
                        }
                        case 1: {
                            resync = false;
                            continue block225;
                        }
                    }
                    if (resync) continue;
                    this.error.print(15, 4, tk, "<" + tk.getWord() + ">");
                    continue;
                }
                if (tk.getToknum() == 10009 || tk.getToknum() == 10018) {
                    VariableName nameObj = null;
                    if (tk.getToknum() == 10009) {
                        Token tk1 = this.tm.getToken();
                        this.tm.ungetToken();
                        if (tk1.getToknum() == 10018) {
                            this.tm.ungetToken();
                            nameObj = VariableName.getAny(this.tm, this.error, this, this.pc);
                        } else if (tk1.getToknum() == 40) {
                            TokenManager.Marker mk = this.tm.getMarker();
                            this.tm.setMarker(mk);
                            this.tm.ungetToken();
                            boolean ie = this.error.ignoreErrors;
                            try {
                                this.error.ignoreErrors = true;
                                nameObj = VariableName.getAny(this.tm, this.error, this, this.pc);
                            }
                            catch (GeneralErrorException e) {
                                this.tm.rewindToMarker(mk);
                            }
                            catch (EndOfProgramException e) {
                                this.tm.rewindToMarker(mk);
                            }
                            finally {
                                this.error.ignoreErrors = ie;
                            }
                        }
                    } else {
                        this.tm.ungetToken();
                        nameObj = VariableName.getAny(this.tm, this.error, this, this.pc);
                    }
                    if (nameObj != null) {
                        VariableDeclaration vd = nameObj.getVarDecl();
                        if (vd instanceof InlineInvoke) {
                            Invoke invk = ((InlineInvoke)vd).getInvoke();
                            invk.unsetInLine();
                            this.verbsAddItem(invk);
                        } else {
                            this.error.print(81, 4, tk, vd.name.getWord());
                        }
                        lastToken = tk;
                        continue;
                    }
                }
                if (!resync) break;
            }
            this.tm.ungetToken();
        }
        if (lastToken != null) {
            switch (lastToken.getToknum()) {
                case 476: {
                    this.error.print(188, 3, lastToken, "");
                    break;
                }
                case 10006: {
                    break;
                }
                default: {
                    this.error.print(13, 4, lastToken, "");
                }
            }
        }
        this.pc.popBlock();
    }

    public static void resetCounters() {
        prog = 0;
    }

    public void check() {
        Verb v = this.verbs.getFirst();
        while (v != null) {
            try {
                v.check();
            }
            catch (GeneralErrorException generalErrorException) {
                // empty catch block
            }
            v = this.verbs.getNext();
        }
        if (!(!this.endRequired || this.parentVerb == null || this.parentVerb.endStmt || this.parentVerb instanceof Invoke && ((Invoke)this.parentVerb).lambdaExpr)) {
            this.error.print(154, 3, this.parentVerb.getKeyWord(), Block.getEndKeyWord(this.parentVerb.getKeyWord().getToknum()));
        }
    }

    private static String getEndKeyWord(int toknum) {
        switch (toknum) {
            case 256: {
                return "END-ACCEPT";
            }
            case 258: {
                return "END-ADD";
            }
            case 313: {
                return "END-CALL";
            }
            case 321: {
                return "END-CHAIN";
            }
            case 366: {
                return "END-COMPUTE";
            }
            case 397: {
                return "END-DELETE";
            }
            case 408: {
                return "END-DISPLAY";
            }
            case 409: {
                return "END-DIVIDE";
            }
            case 467: {
                return "END-EVALUATE";
            }
            case 474: {
                return "END-EXEC";
            }
            case 524: {
                return "END-IF";
            }
            case 544: {
                return "END-INVOKE";
            }
            case 546: {
                return "END-JSON";
            }
            case 589: {
                return "END-MODIFY";
            }
            case 590: {
                return "END-MOVE";
            }
            case 592: {
                return "END-MULTIPLY";
            }
            case 632: {
                return "END-PERFORM";
            }
            case 666: {
                return "END-READ";
            }
            case 669: {
                return "END-RECEIVE";
            }
            case 693: {
                return "END-RETURN";
            }
            case 699: {
                return "END-REWRITE";
            }
            case 708: {
                return "END-SEARCH";
            }
            case 719: {
                return "END-SET";
            }
            case 741: {
                return "END-START";
            }
            case 744: {
                return "END-STRING";
            }
            case 746: {
                return "END-SUBTRACT";
            }
            case 752: {
                return "END-SYNCHRONIZED";
            }
            case 779: {
                return "END-TRY";
            }
            case 790: {
                return "END-UNSTRING";
            }
            case 809: {
                return "END-WAIT";
            }
            case 816: {
                return "END-WRITE";
            }
            case 818: {
                return "END-XML";
            }
        }
        return "END-";
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean getNotClosedCode(StringBuffer Return2) {
        if (this.name != null) {
            Return2.append(this.name + ":");
        }
        Return2.append("{" + eol);
        if (this.isExceptionBlock()) {
            Return2.append(this.getIndent());
            Return2.append(Verb.getExceptionObject(this.pc.capitalizeNames));
            Return2.append(" = ");
            Return2.append(this.getParentExceptName());
            Return2.append(";");
            Return2.append(eol);
        }
        int deferredMethodId = 0;
        if (this.parentSuObj != null && this.parentSuObj.getDeferredMethodId() != 0) {
            deferredMethodId = this.parentSuObj.getDeferredMethodId();
        } else if (this.parentVerb != null) {
            deferredMethodId = this.parentVerb.getDeferredMethodId();
        } else if (this.verbs.getFirst() != null) {
            deferredMethodId = this.verbs.getFirst().getDeferredMethodId();
        }
        int index = 0;
        Verb v = this.verbs.getFirst();
        while (v != null) {
            if (this.parent.getParagraphCodeLimit() > 0) {
                if (v.getDeferredMethodId() != deferredMethodId) {
                    if (!(v instanceof NextSentenceBlock)) {
                        DeferredBlock db = this.parent.getDeferredBlock(v.getDeferredMethodId());
                        db.setVerbs(this.verbs, index);
                        this.parent.deferredBlockList.add(db);
                        Return2.append(db.getCallCode(deferredMethodId, this.debug, this.pt0_2) + eol);
                        return false;
                    }
                    Return2.append(v.getCode());
                } else {
                    DeferredBlock.setNextSentenceDeferredMethodName(v, this.getParent(), deferredMethodId);
                    Return2.append(v.getCode());
                }
            } else {
                Return2.append(this.tm.getCommentCode(v.getKeyWord(), this.getIndent()));
                Return2.append(v.getCode());
            }
            v = this.verbs.getNext();
            ++index;
        }
        return true;
    }

    public String getCode() {
        StringBuffer Return2 = new StringBuffer();
        this.getNotClosedCode(Return2);
        if (this.nesting == 0) {
            Return2.append(this.getIndent());
            Return2.append("return 0;");
            Return2.append(eol);
        }
        --this.nesting;
        Return2.append(this.getIndent() + "}");
        ++this.nesting;
        return Return2.toString();
    }

    public String getExitPerformCycle() {
        if (this.loop) {
            if (this.name == null) {
                return "if (true) continue;";
            }
            return "if (true) break " + this.name + ";";
        }
        if (this.pb == null) {
            return "if (true) continue;";
        }
        return this.pb.getExitPerformCycle();
    }

    @Override
    public String getExceptName() {
        if (this.exceptName == null) {
            this.exceptName = EXCEPT_NAME + this.nesting;
        }
        return this.exceptName;
    }

    public String getParentExceptName() {
        return EXCEPT_NAME + (this.nesting - 1);
    }

    @Override
    public boolean isExceptionBlock() {
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this.verbs == null || this.verbs.getItemNum() == 0;
    }

    @Override
    public boolean isParagraphBlock() {
        return this.paragraphBlock;
    }

    public void setParagraphBlock(boolean paragraphBlock) {
        this.paragraphBlock = paragraphBlock;
    }

    public boolean isCaughtExcpt(MyClass ex) {
        for (int i = 0; i < this.catchBlocks.size(); ++i) {
            BlockException be = (BlockException)this.catchBlocks.elementAt(i);
            if (be.excpt.isAssignableFrom(ex)) {
                be.someoneRaises = true;
                return true;
            }
            if (!be.excpt.isAssignableTo(ex)) continue;
            be.someoneRaises = true;
        }
        if (this.raising != null) {
            VariableName vn = this.raising.getFirst();
            while (vn != null) {
                if (vn.getType().isAssignableFrom(ex)) {
                    return true;
                }
                vn = this.raising.getNext();
            }
        }
        if (this.pb != null) {
            return this.pb.isCaughtExcpt(ex);
        }
        return false;
    }

    public void setCatchBlock(BlockException be) {
        this.catchBlocks.addElement(be);
    }

    public void setRaising(VariableNameList r) {
        this.raising = r;
    }

    public NextSentenceBlock getNextSentenceBlock(Token tk) {
        if (this.pb == null) {
            if (this.ns == null) {
                this.ns = new NextSentenceBlock(tk, this, this.pc, this.tm, this.error);
            }
            return this.ns;
        }
        return this.pb.getNextSentenceBlock(tk);
    }

    @Override
    public VerbList getVerbs() {
        return this.verbs;
    }

    @Override
    public Paragraph getParent() {
        return this.parent;
    }

    @Override
    public Verb getParentVerb() {
        return this.parentVerb;
    }
}

