/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.compiler.CobolToken;
import com.iscobol.compiler.EndOfProgramException;
import com.iscobol.compiler.Errors;
import com.iscobol.compiler.ErrorsNumbers;
import com.iscobol.compiler.GeneralErrorException;
import com.iscobol.compiler.Pcc;
import com.iscobol.compiler.Repository;
import com.iscobol.compiler.SpecialNames;
import com.iscobol.compiler.Token;
import com.iscobol.compiler.TokenManager;
import com.iscobol.compiler.UnexpectedTokenException;
import com.iscobol.interfaces.compiler.IConfigurationSection;

public class ConfigurationSection
implements CobolToken,
ErrorsNumbers,
IConfigurationSection {
    TokenManager tm;
    Errors error;
    SpecialNames specNames;
    Repository repository;
    Pcc pc;
    private Token programCollatingSeq;
    private Token firstToken;
    private boolean debuggingMode;

    public ConfigurationSection(Pcc pc, TokenManager t, Errors err, Token firstToken) throws GeneralErrorException, EndOfProgramException {
        this.pc = pc;
        this.firstToken = firstToken;
        boolean goOn = true;
        this.error = err;
        this.tm = t;
        Token tk = this.tm.getToken();
        if (tk.getToknum() == 709) {
            if (this.tm.getToken().getToknum() != 10006) {
                this.error.print(188, 3, tk, "'.'");
                this.tm.ungetToken();
            }
            block15: while (goOn && (tk = this.tm.getToken()).getToknum() != 535 && tk.getToknum() != 388 && tk.getToknum() != 651 && tk.getToknum() != 521 && tk.getToknum() != 522) {
                switch (tk.getToknum()) {
                    case 735: {
                        this.sourceComputer(tk);
                        continue block15;
                    }
                    case 607: {
                        if (this.tm.getToken().getToknum() != 10006) {
                            this.error.print(188, 3, tk, "'.'");
                            this.tm.ungetToken();
                        }
                        if ((tk = this.tm.getToken()).getToknum() == 738 || tk.getToknum() == 686 || tk.getToknum() == 326 || tk.getToknum() == 535 || tk.getToknum() == 388 || tk.getToknum() == 651 || tk.getToknum() == 521 || tk.getToknum() == 522) {
                            this.tm.ungetToken();
                            continue block15;
                        }
                        if (tk.getToknum() == 735) {
                            this.sourceComputer(tk);
                            continue block15;
                        }
                        while (tk.getToknum() != 10006) {
                            switch (tk.getToknum()) {
                                case 653: {
                                    if (this.programCollatingSeq != null) {
                                        throw new UnexpectedTokenException(tk, this.error);
                                    }
                                    tk = this.tm.getToken();
                                    if (tk.getToknum() == 335) {
                                        tk = this.tm.getToken();
                                        if (tk.getToknum() == 716) {
                                            if (pc.isInterfaceChild()) {
                                                throw new GeneralErrorException(246, 4, tk, tk.getWord(), this.error);
                                            }
                                            this.collSequence();
                                            break;
                                        }
                                        throw new UnexpectedTokenException(tk, this.error);
                                    }
                                    if (tk.getToknum() == 716) {
                                        this.collSequence();
                                        break;
                                    }
                                    throw new UnexpectedTokenException(tk, this.error);
                                }
                                case 335: {
                                    if (this.programCollatingSeq != null) {
                                        throw new UnexpectedTokenException(tk, this.error);
                                    }
                                    tk = this.tm.getToken();
                                    if (tk.getToknum() == 716) {
                                        this.collSequence();
                                        break;
                                    }
                                    throw new UnexpectedTokenException(tk, this.error);
                                }
                                case 716: {
                                    if (this.programCollatingSeq != null) {
                                        throw new UnexpectedTokenException(tk, this.error);
                                    }
                                    this.collSequence();
                                }
                            }
                            tk = this.tm.getToken();
                        }
                        continue block15;
                    }
                    case 738: {
                        if (this.specNames != null) {
                            throw new GeneralErrorException(225, 4, tk, tk.getWord(), this.error);
                        }
                        try {
                            this.specNames = new SpecialNames(pc, t, this.error, this.programCollatingSeq, tk);
                        }
                        catch (GeneralErrorException e) {
                            this.tm.skipToDot();
                        }
                        continue block15;
                    }
                    case 326: 
                    case 686: {
                        try {
                            this.repository = new Repository(pc, t, this.error, tk);
                        }
                        catch (GeneralErrorException e) {
                            this.tm.skipToDot();
                        }
                        continue block15;
                    }
                }
                goOn = false;
            }
        } else {
            throw new UnexpectedTokenException(tk, err);
        }
        this.tm.ungetToken();
    }

    private void sourceComputer(Token tk) throws GeneralErrorException, EndOfProgramException {
        if (this.tm.getToken().getToknum() != 10006) {
            this.error.print(188, 3, tk, "'.'");
            this.tm.ungetToken();
        }
        tk = this.tm.getToken();
        block5: while (true) {
            switch (tk.getToknum()) {
                case 326: 
                case 388: 
                case 521: 
                case 522: 
                case 535: 
                case 607: 
                case 651: 
                case 686: 
                case 738: {
                    this.tm.ungetToken();
                    break block5;
                }
                case 10006: {
                    break block5;
                }
                case 813: {
                    tk = this.tm.getToken();
                    if (tk.getWord().equals("DEBUGGING")) {
                        tk = this.tm.getToken();
                        if (tk.getToknum() == 587) {
                            this.debuggingMode = true;
                            this.tm.debuggingMode = true;
                        } else {
                            this.tm.ungetToken();
                        }
                    } else {
                        this.tm.ungetToken();
                    }
                }
                default: {
                    tk = this.tm.getToken();
                    continue block5;
                }
            }
            break;
        }
    }

    private void collSequence() throws GeneralErrorException, EndOfProgramException {
        Token tk = this.tm.getToken();
        if (tk.getToknum() == 545) {
            tk = this.tm.getToken();
        }
        if (tk.getToknum() != 10009) {
            throw new GeneralErrorException(17, 4, tk, tk.getWord(), this.error);
        }
        this.programCollatingSeq = tk;
    }

    @Override
    public SpecialNames getSpecialNames() {
        return this.specNames;
    }

    @Override
    public Token getProgramCollatingSeq() {
        return this.programCollatingSeq;
    }

    public void check(Pcc pc) {
        if (this.programCollatingSeq != null && (this.specNames == null || this.specNames.getAlphabet(this.programCollatingSeq) == null)) {
            this.error.print(25, 4, this.programCollatingSeq, "ALPHABET " + this.programCollatingSeq.getWord());
        }
        try {
            if (this.specNames != null) {
                this.specNames.check(pc);
            }
        }
        catch (GeneralErrorException generalErrorException) {
            // empty catch block
        }
    }

    public String getCode(StringBuffer dynPart) {
        StringBuffer Return2 = new StringBuffer();
        if (this.specNames != null) {
            Return2.append(this.specNames.getCode(dynPart));
        }
        return Return2.toString();
    }

    @Override
    public Token getFirstToken() {
        return this.firstToken;
    }

    @Override
    public Repository getRepository() {
        return this.repository;
    }

    public boolean isDebuggingMode() {
        return this.debuggingMode;
    }
}

