/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.compiler.Block;
import com.iscobol.compiler.Continue;
import com.iscobol.compiler.Entry;
import com.iscobol.compiler.Evaluate;
import com.iscobol.compiler.EvaluateSuObject;
import com.iscobol.compiler.If;
import com.iscobol.compiler.NextSentence;
import com.iscobol.compiler.NextSentenceBlock;
import com.iscobol.compiler.Paragraph;
import com.iscobol.compiler.Search;
import com.iscobol.compiler.Verb;
import com.iscobol.compiler.VerbList;
import java.util.Vector;

public class ParagraphCodeAnalyzer {
    public static final int EXIT_PERFORM = -1;
    public static final int EXIT_PERFORM_CYCLE = -2;
    public static final int END_NEXT_SENTENCE = -3;
    public static final int EXIT_PARAGRAPH = -4;
    private int limit;
    private Vector blocks = new Vector();
    private int deferredMethodId;
    private boolean debug;

    private ParagraphCodeAnalyzer(int limit, boolean debug, Block block) {
        if (limit <= 0) {
            throw new IllegalArgumentException("" + limit);
        }
        this.limit = limit;
        this.debug = debug;
        MyBlock mb = new MyBlock(0);
        this.blocks.addElement(mb);
        this.init(block, mb, null, -1);
    }

    public static int[] analyze(int limit, boolean debug, Paragraph paragraph) {
        ParagraphCodeAnalyzer analyzer = new ParagraphCodeAnalyzer(limit, debug, paragraph.getBlock());
        return analyzer.analyze();
    }

    void init(Block block, MyBlock mb, MyVerb parentVerb, int blockId) {
        VerbList verbs = block.getVerbs();
        NextSentenceBlock nsb = null;
        Verb v = verbs.getFirst();
        while (v != null) {
            block5: {
                block6: {
                    block4: {
                        if (!(v instanceof NextSentenceBlock)) break block4;
                        if (nsb != null) break block5;
                        nsb = (NextSentenceBlock)v;
                        break block6;
                    }
                    if (v instanceof NextSentenceBlock.End) {
                        nsb = null;
                    }
                }
                MyVerb mv = new MyVerb(v, parentVerb, blockId);
                mb.verbs.addElement(mv);
                Block[] nestedBlocks = v.getNestedBlocks();
                int nestedBlockId = 0;
                for (int i = 0; i < nestedBlocks.length; ++i) {
                    this.init(nestedBlocks[i], mb, mv, nestedBlockId);
                    if (nestedBlocks[i].isEmpty()) continue;
                    ++nestedBlockId;
                }
                NextSentence ns = v instanceof If ? ((If)v).getNextSentence() : (v instanceof Search ? ((Search)v).getNextSentence() : null);
                if (ns != null) {
                    MyVerb mv2 = new MyVerb(ns, mv, nestedBlocks.length);
                    mb.verbs.addElement(mv2);
                }
            }
            v = verbs.getNext();
        }
    }

    int[] analyze() {
        for (int i = 0; i < this.blocks.size(); ++i) {
            boolean analyzeAgain;
            MyBlock mb = (MyBlock)this.blocks.elementAt(i);
            if (mb.ok || !(analyzeAgain = this.analyze0(mb))) continue;
            i = -1;
        }
        int[] Return2 = new int[this.blocks.size()];
        for (int i = 0; i < this.blocks.size(); ++i) {
            Return2[i] = ((MyBlock)this.blocks.elementAt(i)).deferredMethodId;
        }
        return Return2;
    }

    boolean analyze0(MyBlock mb) {
        NextSentenceBlock nsb = null;
        int firstBlockId = mb.verbs.size() > 0 ? ((MyVerb)mb.verbs.elementAt(0)).blockId : -1;
        int i = 0;
        int count = 0;
        while (i < mb.verbs.size()) {
            block21: {
                MyVerb element;
                block23: {
                    block22: {
                        block20: {
                            element = (MyVerb)mb.verbs.elementAt(i);
                            if (!(element.verb instanceof Entry)) break block20;
                            count = -1;
                            break block21;
                        }
                        if (!(element.verb instanceof NextSentenceBlock)) break block22;
                        --count;
                        if (nsb != null) break block21;
                        nsb = (NextSentenceBlock)element.verb;
                        break block23;
                    }
                    if (element.verb instanceof NextSentenceBlock.End) {
                        nsb = null;
                        --count;
                    } else if (!this.debug && element.verb instanceof Continue) {
                        --count;
                    }
                }
                MyVerb parent = element.parent;
                int id = element.blockId;
                if (count == this.limit) {
                    ++this.deferredMethodId;
                    if (parent != null) {
                        boolean evaluateHandling;
                        MyVerb tmp;
                        MyBlock mb2 = new MyBlock(this.deferredMethodId);
                        for (int j = i - 1; j >= 0 && (tmp = (MyVerb)mb.verbs.elementAt(j)).isDescendantOf(parent, id); --j) {
                            mb2.verbs.add(0, tmp);
                            tmp.verb.setDeferredMethodId(this.deferredMethodId);
                            mb.verbs.removeElementAt(j);
                            --i;
                        }
                        boolean bl = evaluateHandling = parent.verb instanceof Evaluate && id > firstBlockId && id > 0;
                        if (evaluateHandling) {
                            Evaluate ev = (Evaluate)parent.verb;
                            id = -1;
                            VerbList evObjects = ev.getObjectSet();
                            boolean found = false;
                            Verb obj = evObjects.getFirst();
                            while (obj != null) {
                                if (!found) {
                                    boolean bl2 = found = ((EvaluateSuObject)obj).getBlock() == element.verb.getParent();
                                    if (found) {
                                        int currIdx = evObjects.getCurrentIndex();
                                        Verb v = evObjects.getPrevious();
                                        while (v != null) {
                                            EvaluateSuObject o = (EvaluateSuObject)v;
                                            if (o.block != null && !o.block.isEmpty()) break;
                                            v.setDeferredMethodId(this.deferredMethodId);
                                            v = evObjects.getPrevious();
                                        }
                                        evObjects.getAt(currIdx);
                                    }
                                }
                                if (found) {
                                    obj.setDeferredMethodId(this.deferredMethodId);
                                }
                                obj = evObjects.getNext();
                            }
                        }
                        while (i < mb.verbs.size() && (tmp = (MyVerb)mb.verbs.elementAt(i)).isDescendantOf(parent, id)) {
                            mb2.verbs.addElement(tmp);
                            tmp.verb.setDeferredMethodId(this.deferredMethodId);
                            mb.verbs.removeElementAt(i);
                        }
                        if (!evaluateHandling) {
                            for (i = 0; i < mb2.verbs.size(); ++i) {
                                MyVerb mv = (MyVerb)mb2.verbs.elementAt(i);
                                if (mv.parent != parent) continue;
                                mv.parent = null;
                            }
                        }
                        this.blocks.addElement(mb2);
                        if (mb.verbs.size() <= this.limit) {
                            mb.ok = true;
                        }
                        if (mb2.verbs.size() <= this.limit) {
                            mb2.ok = true;
                        }
                        return true;
                    }
                    MyBlock mb2 = new MyBlock(this.deferredMethodId);
                    int j = i;
                    while (j < mb.verbs.size()) {
                        MyVerb tmp = (MyVerb)mb.verbs.elementAt(j);
                        mb2.verbs.addElement(tmp);
                        tmp.verb.setDeferredMethodId(this.deferredMethodId);
                        mb.verbs.removeElementAt(j);
                    }
                    this.blocks.addElement(mb2);
                    mb.ok = true;
                    if (mb2.verbs.size() <= this.limit) {
                        mb2.ok = true;
                    }
                    return true;
                }
            }
            ++i;
            ++count;
        }
        mb.ok = true;
        return false;
    }

    public int[] getBlockSizes() {
        int[] Return2 = new int[this.blocks.size()];
        for (int i = 0; i < this.blocks.size(); ++i) {
            Return2[i] = ((MyBlock)this.blocks.elementAt(i)).verbs.size();
        }
        return Return2;
    }

    private class MyVerb {
        private Verb verb;
        private MyVerb parent;
        private int blockId;

        private MyVerb(Verb v, MyVerb p, int id) {
            this.verb = v;
            this.parent = p;
            this.blockId = id;
        }

        public String toString() {
            if (this.verb.getKeyWord() != null) {
                return this.verb.getKeyWord().getFLN() + ": " + this.verb.getKeyWord().getWord() + " [" + this.verb.getDeferredMethodId() + "]";
            }
            return this.verb.getClass().getName() + " [" + this.verb.getDeferredMethodId() + "]";
        }

        boolean isDescendantOf(MyVerb v, int id) {
            if (this.parent == null) {
                return false;
            }
            if (this.parent == v) {
                return id == -1 || id == this.blockId;
            }
            return this.parent.isDescendantOf(v, id);
        }
    }

    private class MyBlock {
        private Vector verbs = new Vector();
        private boolean ok;
        private int deferredMethodId;

        MyBlock(int id) {
            this.deferredMethodId = id;
        }
    }
}

