/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.compiler.Alphabet;
import com.iscobol.compiler.Block;
import com.iscobol.compiler.CobolToken;
import com.iscobol.compiler.Condition;
import com.iscobol.compiler.EndOfProgramException;
import com.iscobol.compiler.Errors;
import com.iscobol.compiler.ErrorsNumbers;
import com.iscobol.compiler.ExpectedFoundException;
import com.iscobol.compiler.Expression;
import com.iscobol.compiler.GeneralErrorException;
import com.iscobol.compiler.IllegalConditionException;
import com.iscobol.compiler.NextSentence;
import com.iscobol.compiler.Pcc;
import com.iscobol.compiler.Token;
import com.iscobol.compiler.TokenManager;
import com.iscobol.compiler.UndefinedException;
import com.iscobol.compiler.UnexpectedTokenException;
import com.iscobol.compiler.VariableDeclaration;
import com.iscobol.compiler.VariableName;
import com.iscobol.compiler.VariableNameList;
import com.iscobol.compiler.Verb;
import com.iscobol.compiler.VerbList;

public class Search
extends Verb
implements CobolToken,
ErrorsNumbers {
    VariableName table;
    VariableName indexItem;
    VariableName indexItem2;
    Block atEndBlock;
    VerbList whenConds = new VerbList();
    VerbList allConds = new VerbList();
    VariableDeclaration tableVd;
    boolean binary;
    Block allBlock;
    private Token nextSentence;
    private NextSentence ns;

    public Search(Token kw, Block par, Pcc p, TokenManager t, Errors err) throws GeneralErrorException, EndOfProgramException {
        super(kw, par, p, t, err);
        Token tk = this.tm.getToken();
        if (tk.getToknum() != 10009) {
            throw new GeneralErrorException(17, 4, tk, tk.getWord(), this.error);
        }
        this.tm.ungetToken();
        this.table = VariableName.get(this.tm, this.error);
        this.tableVd = this.pc.getVar(this.table, false);
        if (this.tableVd == null) {
            throw new UndefinedException(this.table.getNameToken(), this.error, this.table.getName());
        }
        this.tableVd.setUsed();
        VariableNameList indexes = this.tableVd.getIndexes();
        if (!this.tableVd.occursClause || indexes == null) {
            throw new GeneralErrorException(11, 4, tk, tk.getWord(), this.error);
        }
        if (this.table.getDimension() > 0) {
            throw new GeneralErrorException(11, 4, tk, tk.getWord(), this.error);
        }
        if (tk.isAll()) {
            if (this.tableVd.ascOccursKey == null && this.tableVd.descOccursKey == null) {
                throw new GeneralErrorException(11, 4, tk, tk.getWord(), this.error);
            }
            this.indexItem = indexes.getFirst();
            this.binarySearch(this.tm.getToken());
        } else {
            this.search(this.tm.getToken());
        }
        tk = this.tm.getToken();
        if (tk.getToknum() != 445) {
            this.tm.ungetToken();
        } else if (this.nextSentence != null) {
            this.ns = new NextSentence(this.nextSentence, par, this.pc, this.tm, this.error);
        }
    }

    private void search(Token tk) throws GeneralErrorException, EndOfProgramException {
        if (tk.getToknum() == 807) {
            tk = this.tm.getToken();
            if (tk.getToknum() == 10009) {
                this.tm.ungetToken();
                this.indexItem = VariableName.get(this.tm, this.error, this.pc);
                if (!this.indexItem.getVarDecl().isInteger()) {
                    throw new GeneralErrorException(46, 4, tk, tk.getWord(), this.error);
                }
            } else {
                throw new GeneralErrorException(17, 4, tk, tk.getWord(), this.error);
            }
            tk = this.tm.getToken();
        }
        boolean found = false;
        VariableNameList indexes = this.tableVd.getIndexes();
        if (this.indexItem != null) {
            VariableName vn = indexes.getFirst();
            while (vn != null) {
                if (vn.getName().equalsIgnoreCase(this.indexItem.getName())) {
                    found = true;
                    break;
                }
                vn = indexes.getNext();
            }
            if (!found) {
                this.indexItem2 = this.indexItem;
                this.indexItem = indexes.getFirst();
            }
        } else {
            this.indexItem = indexes.getFirst();
            this.indexItem.getVarDecl().setUsed();
        }
        if (tk.getToknum() == 284 && (tk = this.tm.getToken()).getToknum() != 422) {
            throw new ExpectedFoundException(tk, this.error, "'END'");
        }
        if (tk.getToknum() == 422) {
            this.atEndBlock = new Block(this.parent, this.parent.parent, (Verb)this, this.pc, this.tm, this.error, this.parent.nesting + 1, 5);
            tk = this.tm.getToken();
        }
        if (tk.getToknum() != 810) {
            throw new ExpectedFoundException(tk, this.error, "'WHEN'");
        }
        while (tk.getToknum() == 810) {
            this.whenConds.addItem(new SearchWhenPhrase(this.keyWord, this.parent, this.pc, this.tm, this.error));
            tk = this.tm.getToken();
        }
        this.tm.ungetToken();
    }

    private void binarySearch(Token tk) throws GeneralErrorException, EndOfProgramException {
        this.binary = true;
        if (tk.getToknum() == 284 && (tk = this.tm.getToken()).getToknum() != 422) {
            throw new ExpectedFoundException(tk, this.error, "'END'");
        }
        if (tk.getToknum() == 422) {
            this.atEndBlock = new Block(this.parent, this.parent.parent, (Verb)this, this.pc, this.tm, this.error, this.parent.nesting + 1, 5);
            tk = this.tm.getToken();
        }
        if (tk.getToknum() != 810) {
            throw new ExpectedFoundException(tk, this.error, "'WHEN'");
        }
        this.allConds.addItem(new SearchAllCond(this.keyWord, this.parent, this.pc, this.tm, this.error));
        tk = this.tm.getToken();
        while (tk.getToknum() == 274) {
            this.allConds.addItem(new SearchAllCond(this.keyWord, this.parent, this.pc, this.tm, this.error));
            tk = this.tm.getToken();
        }
        if (tk.getToknum() == 595) {
            this.nextSentence = tk;
            tk = this.tm.getToken();
            if (tk.getToknum() != 714) {
                throw new ExpectedFoundException(tk, this.error, "SENTENCE");
            }
            tk = this.tm.getToken();
            if (tk.getToknum() != 10006 && tk.getToknum() != 445) {
                throw new ExpectedFoundException(tk, this.error, "END-SEARCH|.");
            }
            this.tm.ungetToken();
        } else {
            this.tm.ungetToken();
            this.allBlock = new Block(this.parent, this.parent.parent, this, this.pc, this.tm, this.error, this.parent.nesting + 1);
        }
    }

    @Override
    public void check() throws GeneralErrorException {
        if (this.binary) {
            Verb v = this.allConds.getFirst();
            while (v != null) {
                v.check();
                v = this.allConds.getNext();
            }
        } else {
            Verb v = this.whenConds.getFirst();
            while (v != null) {
                v.check();
                v = this.whenConds.getNext();
            }
        }
    }

    @Override
    public String getCode() {
        StringBuffer Return2 = new StringBuffer();
        Return2.append(this.parent.getIndent());
        this.getCodeDebug(Return2);
        if (this.binary) {
            Return2.append(this.getCodeBinary());
        } else {
            Return2.append(this.getCodeSequential());
        }
        this.getCodeDebugEnd(Return2);
        return Return2.toString();
    }

    private String getCodeBinary() {
        int j;
        boolean sqljOpt;
        StringBuffer Return2 = new StringBuffer();
        int uId = Search.getUniqueId();
        String searchObject = "search$comp" + uId;
        Return2.append("CobolVar.SearchComparator " + searchObject + " = ");
        boolean bl = sqljOpt = this.pc.getOption("-sqlj") != null;
        if (sqljOpt) {
            Return2.append("new CobolVar.SearchComparator() { public int compareTo() {");
        } else {
            Return2.append("() -> {");
        }
        Return2.append(eol);
        int i = 1;
        Verb v = this.allConds.getFirst();
        while (v != null) {
            for (j = 0; j <= i; ++j) {
                Return2.append("   ");
            }
            Return2.append(v.getCode());
            v = this.allConds.getNext();
            ++i;
        }
        Return2.append(this.parent.getIndent() + "   ");
        for (int j2 = 0; j2 < i; ++j2) {
            Return2.append("   ");
        }
        Return2.append("return 0;" + eol);
        i = this.allConds.getItemNum();
        SearchAllCond c = (SearchAllCond)this.allConds.getLast();
        while (c != null) {
            Return2.append(this.parent.getIndent() + "   ");
            for (j = 0; j < i; ++j) {
                Return2.append("   ");
            }
            Return2.append("else " + c.getCodeAfter());
            if (c.isAscKey) {
                Return2.append("return 1;" + eol);
            } else {
                Return2.append("return -1;" + eol);
            }
            Return2.append(this.parent.getIndent() + "   ");
            for (j = 0; j < i; ++j) {
                Return2.append("   ");
            }
            Return2.append("else ");
            if (c.isAscKey) {
                Return2.append("return -1;" + eol);
            } else {
                Return2.append("return 1;" + eol);
            }
            c = (SearchAllCond)this.allConds.getPrevious();
            --i;
        }
        Return2.append(this.parent.getIndent());
        if (sqljOpt) {
            Return2.append("}");
        }
        Return2.append("};" + eol);
        Return2.append(this.parent.getIndent() + "if(CobolVar.searchAll(");
        if (this.tableVd.isDepending()) {
            Return2.append(this.tableVd.getDepending().getCode() + ".toint() , " + this.indexItem.getCode());
        } else {
            int dimIdx = 0;
            VariableDeclaration v2 = this.tableVd.parent;
            while (v2 != null) {
                if (v2.occursMin > 0) {
                    ++dimIdx;
                }
                v2 = v2.parent;
            }
            Return2.append(this.tableVd.getQualUnivoqueName()).append(".getDimensions()[" + dimIdx + "] , ");
            Return2.append(this.indexItem.getCode());
        }
        Return2.append(" , " + searchObject + "))");
        if (this.allBlock != null) {
            Return2.append(this.allBlock.getCode());
        } else if (this.ns != null) {
            Return2.append("{");
            Return2.append(this.ns.getCode());
            Return2.append("}");
        } else {
            Return2.append(" ;");
        }
        if (this.atEndBlock != null) {
            Return2.append(" else ");
            Return2.append(this.atEndBlock.getCode() + eol);
        }
        return Return2.toString();
    }

    private String getCodeSequential() {
        boolean sqljOpt;
        StringBuffer Return2 = new StringBuffer();
        int uId = Search.getUniqueId();
        String searchObject = "search$comp" + uId;
        Return2.append("CobolVar.SearchEvaluator " + searchObject + " = ");
        boolean bl = sqljOpt = this.pc.getOption("-sqlj") != null;
        if (sqljOpt) {
            Return2.append("new CobolVar.SearchEvaluator() { public int evaluate() {");
        } else {
            Return2.append("() -> {");
        }
        Return2.append(eol);
        int i = 1;
        SearchWhenPhrase v = (SearchWhenPhrase)this.whenConds.getFirst();
        while (v != null) {
            Return2.append(this.parent.getIndent() + "      if(");
            Return2.append(v.cond.getCode() + ") return " + i + ";" + eol);
            v = (SearchWhenPhrase)this.whenConds.getNext();
            ++i;
        }
        Return2.append(this.parent.getIndent() + "      return -1;" + eol);
        Return2.append(this.parent.getIndent());
        if (sqljOpt) {
            Return2.append("}");
        }
        Return2.append("};" + eol);
        String retVal = "search$retval" + uId;
        Return2.append(this.parent.getIndent() + "int " + retVal + " = ");
        if (this.tableVd.isDepending()) {
            Return2.append("CobolVar.search(" + this.tableVd.getDepending().getCode() + ".toint() , ");
        } else {
            int dimIdx = 0;
            VariableDeclaration v2 = this.tableVd.parent;
            while (v2 != null) {
                if (v2.occursMin > 0) {
                    ++dimIdx;
                }
                v2 = v2.parent;
            }
            Return2.append("CobolVar.search(");
            Return2.append(this.tableVd.getQualUnivoqueName());
            Return2.append(".getDimensions()[" + dimIdx + "] , ");
        }
        Return2.append(this.indexItem.getCode() + " , ");
        if (this.indexItem2 != null) {
            Return2.append(this.indexItem2.getCode());
        } else {
            Return2.append("null");
        }
        Return2.append(" , " + searchObject + ");" + eol);
        i = 1;
        SearchWhenPhrase v3 = (SearchWhenPhrase)this.whenConds.getFirst();
        while (v3 != null) {
            if (i == 1) {
                Return2.append(this.parent.getIndent());
            } else {
                Return2.append(" else ");
            }
            Return2.append("if(" + retVal + " == " + i + ")");
            if (v3.whenBlock != null) {
                Return2.append(v3.whenBlock.getCode());
            } else if (this.ns != null) {
                Return2.append("{");
                Return2.append(this.ns.getCode());
                Return2.append("}");
            } else {
                Return2.append(" ; ");
            }
            v3 = (SearchWhenPhrase)this.whenConds.getNext();
            ++i;
        }
        if (this.atEndBlock != null) {
            Return2.append(" else ");
            Return2.append(this.atEndBlock.getCode());
        }
        Return2.append(eol);
        return Return2.toString();
    }

    public boolean isBinary() {
        return this.binary;
    }

    public VariableName getTable() {
        return this.table;
    }

    public VariableDeclaration getTableDeclaration() {
        return this.tableVd;
    }

    public VerbList getAllConds() {
        return this.allConds;
    }

    public VerbList getWhenConds() {
        return this.whenConds;
    }

    public VariableName getIndexItem1() {
        return this.indexItem;
    }

    public VariableName getIndexItem2() {
        return this.indexItem2;
    }

    public Block getAtEndBlock() {
        return this.atEndBlock;
    }

    public Block getAllBlock() {
        return this.allBlock;
    }

    public NextSentence getNextSentence() {
        return this.ns;
    }

    public class SearchAllCond
    extends Verb
    implements CobolToken,
    ErrorsNumbers {
        VariableName tblItem;
        boolean isCond;
        boolean isAscKey;
        Expression value;

        public SearchAllCond(Token kw, Block par, Pcc p, TokenManager t, Errors err) throws GeneralErrorException, EndOfProgramException {
            super(kw, par, p, t, err);
            this.tblItem = null;
            this.isCond = false;
            this.isAscKey = true;
            Token tk = this.tm.getToken();
            if (tk.getToknum() != 10009) {
                throw new GeneralErrorException(17, 4, tk, tk.getWord(), this.error);
            }
            this.tm.ungetToken();
            TokenManager.Marker mk = this.tm.getMarker();
            this.tm.setMarker(mk);
            VariableName tblItemSave = null;
            this.tblItem = VariableName.get(this.tm, this.error, this.pc);
            if (this.tblItem.getVarDecl().level == 88) {
                this.check(this.tblItem.getVarDecl().parent, true);
                this.isCond = true;
            } else {
                if (!this.check(this.tblItem.getVarDecl(), false)) {
                    tblItemSave = this.tblItem;
                    this.tblItem = null;
                    this.tm.rewindToMarker(mk);
                    this.value = new Expression(new int[]{0}, this.keyWord, this.parent, this.pc, this.tm, this.error);
                }
                if ((tk = this.tm.getToken()).getToknum() == 545) {
                    tk = this.tm.getToken();
                }
                if (tk.getToknum() == 462) {
                    tk = this.tm.getToken();
                    if (tk.getToknum() == 773) {
                        tk = this.tm.getToken();
                    }
                } else if (tk.getToknum() == 61 || tk.getToknum() == 463) {
                    tk = this.tm.getToken();
                } else {
                    throw new UnexpectedTokenException(tk, this.error);
                }
                this.tm.ungetToken();
                if (this.tblItem == null) {
                    if (tk.getToknum() != 10009) {
                        throw new GeneralErrorException(11, 4, tblItemSave.getNameToken(), tblItemSave.getName() + " not a KEY for " + Search.this.table.getName(), this.error);
                    }
                    this.tblItem = VariableName.get(this.tm, this.error, this.pc);
                    this.check(this.tblItem.getVarDecl(), true);
                } else {
                    this.value = new Expression(new int[]{0}, this.keyWord, this.parent, this.pc, this.tm, this.error);
                }
            }
        }

        @Override
        public void check() throws GeneralErrorException {
            if (this.value != null) {
                this.value.check();
            }
        }

        private boolean check(VariableDeclaration item, boolean throwExc) throws GeneralErrorException {
            VariableName vn;
            VariableNameList ascKey = Search.this.tableVd.ascOccursKey;
            VariableNameList descKey = Search.this.tableVd.descOccursKey;
            boolean found = false;
            if (ascKey != null) {
                vn = ascKey.getFirst();
                while (vn != null) {
                    if (vn.getName().equalsIgnoreCase(item.getName())) {
                        found = true;
                        break;
                    }
                    vn = ascKey.getNext();
                }
            }
            if (!found && descKey != null) {
                vn = descKey.getFirst();
                while (vn != null) {
                    if (vn.getName().equalsIgnoreCase(item.getName())) {
                        found = true;
                        this.isAscKey = false;
                        break;
                    }
                    vn = descKey.getNext();
                }
            }
            if (!found && throwExc) {
                throw new GeneralErrorException(11, 4, item.name, item.getName() + " not a KEY for " + Search.this.table.getName(), this.error);
            }
            return found;
        }

        @Override
        public String getCode() {
            return this.getCode(false);
        }

        private String getCode(boolean great) {
            StringBuffer Return2 = new StringBuffer();
            Alphabet cs = this.pc.getProgramCollatingSeq();
            if (!great) {
                Return2.append(this.parent.getIndent());
            }
            Return2.append("if(");
            if (this.isCond) {
                VariableDeclaration par = this.tblItem.getVarDecl().parent;
                Return2.append(par.getQualUnivoqueName());
                Return2.append(this.tblItem.getSubscriptCode());
                Return2.append(".compareTo(");
                Return2.append(this.getCodeLiteral(this.tblItem.getVarDecl().getLowValue(0)));
                if (cs != null) {
                    Return2.append("," + cs.getDeclUnivoqueName());
                }
            } else {
                Return2.append(this.tblItem.getCode());
                Return2.append(".compareTo(");
                Return2.append(this.value.getCode());
                if (cs != null && !this.value.isNumeric()) {
                    Return2.append("," + cs.getDeclUnivoqueName());
                }
            }
            Return2.append(")");
            Return2.append(great ? ">" : "==");
            Return2.append("0) ");
            if (!great) {
                Return2.append(eol);
            }
            return Return2.toString();
        }

        public String getCodeAfter() {
            return this.getCode(true);
        }

        public Expression getValue() {
            return this.value;
        }

        public boolean isCond() {
            return this.isCond;
        }

        public boolean isAscendingKey() {
            return this.isAscKey;
        }

        public VariableName getTableItem() {
            return this.tblItem;
        }
    }

    public class SearchWhenPhrase
    extends Verb
    implements CobolToken,
    ErrorsNumbers {
        Condition cond;
        Block whenBlock;

        public SearchWhenPhrase(Token kw, Block par, Pcc p, TokenManager t, Errors err) throws GeneralErrorException, EndOfProgramException {
            super(kw, par, p, t, err);
            this.cond = new Condition(this.keyWord, this.parent, this.pc, this.tm, this.error);
            if (!this.cond.isFullCondition()) {
                throw new IllegalConditionException(this.keyWord, this.error);
            }
            Token tk = this.tm.getToken();
            if (tk.getToknum() == 595) {
                Search.this.nextSentence = tk;
                tk = this.tm.getToken();
                if (tk.getToknum() != 714) {
                    throw new ExpectedFoundException(tk, this.error, "SENTENCE");
                }
                tk = this.tm.getToken();
                if (tk.getToknum() != 10006 && tk.getToknum() != 810 && tk.getToknum() != 445) {
                    throw new ExpectedFoundException(tk, this.error, "WHEN|END-SEARCH|.");
                }
                this.tm.ungetToken();
            } else {
                this.tm.ungetToken();
                this.whenBlock = new Block(this.parent, this.parent.parent, Search.this, this.pc, this.tm, this.error, this.parent.nesting + 1);
            }
        }

        @Override
        public void check() throws GeneralErrorException {
            this.cond.check();
        }

        @Override
        public String getCode() {
            StringBuffer Return2 = new StringBuffer();
            Return2.append(this.parent.getIndent());
            Return2.append("if(");
            Return2.append(this.cond.getCode());
            Return2.append(")");
            Return2.append(eol);
            return Return2.toString();
        }

        public Condition getCondition() {
            return this.cond;
        }

        public Block getWhenBlock() {
            return this.whenBlock;
        }
    }
}

