/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.compiler.Block;
import com.iscobol.compiler.ClauseClashException;
import com.iscobol.compiler.CobolToken;
import com.iscobol.compiler.EndOfProgramException;
import com.iscobol.compiler.Errors;
import com.iscobol.compiler.ErrorsNumbers;
import com.iscobol.compiler.ExpectedFoundException;
import com.iscobol.compiler.GeneralErrorException;
import com.iscobol.compiler.Pcc;
import com.iscobol.compiler.Token;
import com.iscobol.compiler.TokenManager;
import com.iscobol.compiler.UnexpectedTokenException;
import com.iscobol.compiler.VariableName;
import com.iscobol.compiler.Verb;

public class Send
extends Verb
implements CobolToken,
ErrorsNumbers {
    private VariableName threadHandle;
    private VariableName msgVar;
    private Token msgToken;
    private boolean last;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Send(Token kw, Block par, Pcc p, TokenManager t, Errors err) throws GeneralErrorException, EndOfProgramException {
        super(kw, par, p, t, err);
        Token tk = this.tm.getToken();
        if (tk.getToknum() == 10009) {
            this.tm.ungetToken();
            this.msgVar = VariableName.get(this.tm, this.error, this.pc);
        } else {
            if (tk.getToknum() != 10001 && tk.getToknum() != 10002 && tk.getToknum() != 10017) throw new UnexpectedTokenException(tk, this.error);
            this.msgToken = tk;
            this.msgToken.setWord(tk.getWord());
        }
        tk = this.tm.getToken();
        if (tk.getToknum() != 773) throw new ExpectedFoundException(tk, this.error, "'TO'");
        tk = this.tm.getToken();
        if (tk.getToknum() == 763 || tk.getToknum() == 10009) {
            if (tk.getToknum() == 10009) {
                this.tm.ungetToken();
            }
            this.threadHandle = VariableName.get(this.tm, this.error, this.pc);
            if (this.threadHandle == null) {
                tk = this.tm.getToken();
                throw new UnexpectedTokenException(tk, this.error);
            }
            if (this.threadHandle.getVarDecl().isValidThreadHandle()) return;
            throw new ClauseClashException(tk, this.error, this.threadHandle.getName());
        }
        if (tk.getToknum() == 554) {
            this.last = true;
            tk = this.tm.getToken();
            if (tk.getToknum() == 763) return;
            throw new ExpectedFoundException(tk, this.error, "'THREAD'");
        }
        if (tk.getToknum() != 262) throw new UnexpectedTokenException(tk, this.error);
        tk = this.tm.getToken();
        if (tk.getToknum() == 766 || tk.getToknum() == 763) return;
        throw new UnexpectedTokenException(tk, this.error);
    }

    @Override
    public void check() throws GeneralErrorException {
    }

    @Override
    public String getCode() {
        StringBuffer Return2 = new StringBuffer();
        Return2.append(this.parent.getIndent());
        this.getCodeDebug(Return2);
        Return2.append("Factory.send (");
        if (this.threadHandle == null) {
            Return2.append("null");
        } else {
            Return2.append(this.threadHandle.getCode());
        }
        Return2.append(", ");
        if (this.msgVar != null) {
            Return2.append(this.msgVar.getCode());
        } else {
            Return2.append(this.getCodeLiteral(this.msgToken));
        }
        Return2.append(", ");
        Return2.append(this.last);
        Return2.append(");");
        Return2.append(eol);
        this.getCodeDebugEnd(Return2);
        return Return2.toString();
    }
}

