/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.compiler.CobolToken;
import com.iscobol.compiler.CopyBookDesc;
import com.iscobol.compiler.EndOfProgramException;
import com.iscobol.compiler.ErrorDirective;
import com.iscobol.compiler.Errors;
import com.iscobol.compiler.ErrorsNumbers;
import com.iscobol.compiler.GeneralErrorException;
import com.iscobol.compiler.InternalErrorException;
import com.iscobol.compiler.OptionList;
import com.iscobol.compiler.Pcc;
import com.iscobol.compiler.PreProcessor;
import com.iscobol.compiler.ReplaceList;
import com.iscobol.compiler.Token;
import com.iscobol.compiler.TokenList;
import com.iscobol.compiler.VariableDeclaration;
import com.iscobol.interfaces.compiler.ITokenManager;
import com.iscobol.rts.Config;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;

public class TokenManager
implements CobolToken,
ErrorsNumbers,
ITokenManager {
    public static final String EXTRAINFO_DELIMITERS = " \t\n\r\f=,;()";
    PreProcessor pp;
    private Vector tokenBuff = new Vector();
    private int tokenBuffIdx = -1;
    private OptionList optList;
    private Map<String, Object[]> allLiterals = new HashMap<String, Object[]>();
    private Map<String, Object[]> allUsedLiterals = new HashMap<String, Object[]>();
    private boolean lastVirtualDot;
    private Errors error;
    private Hashtable extraInfo = new Hashtable();
    boolean inExecSql;
    private int lowValue = 0;
    private int highValue = 255;
    private Vector workingStorageCopies = new Vector();
    private String inDoc;
    private boolean debug;
    private boolean debugExt;
    boolean declareAllLit;
    private boolean hexCompact;
    private boolean optionApost;
    private boolean optionCm;
    private boolean optionCa;
    private boolean optionCv;
    private boolean optionBig;
    private boolean optionB;
    private Token lastRemovedToken;
    private boolean optionCr;
    boolean optionMs;
    private boolean keepComments;
    boolean debuggingMode;
    private boolean hasResources;
    private HashSet<File> copyResources = new HashSet();
    private ArrayList<Token> commentList = new ArrayList();
    private ArrayList<Integer> commentIdxs = new ArrayList();
    private boolean keepAll;

    public TokenManager(PreProcessor preproc, OptionList ol, Errors err) {
        this.pp = preproc;
        this.optList = ol;
        this.error = err;
        this.initOptions();
        ol.setNotifier(new OptionList.Notifier(){

            @Override
            public void optionListChanged() {
                TokenManager.this.initOptions();
            }
        });
    }

    void initOptions() {
        this.debugExt = this.optList.getOption("-dx") != null;
        this.debug = this.debugExt || this.optList.getOption("-d") != null;
        this.optionApost = this.optList.getOption("-apost") != null;
        this.optionCm = this.optList.getOption("-cm") != null;
        this.optionCa = this.optList.getOption("-ca") != null;
        this.optionCv = this.optList.getOption("-cv") != null;
        this.optionMs = this.optList.getOption("-jjms") != null;
        this.keepComments = this.optionMs && Config.getProperty("iscobol.compiler.jjms.keep_comments", true);
        this.optionBig = !this.optionMs && this.optList.getOption("-big") != null;
        this.optionB = this.optList.getOption("-b") != null;
        this.hexCompact = this.optList.getOption("-xchlc") != null;
        this.optionCr = this.optList.getOption("-cr") != null;
    }

    public boolean isAcuCompFlag() {
        return this.optionCa;
    }

    public boolean isMainframeCompFlag() {
        return this.optionCv;
    }

    public boolean isRmCompFlag() {
        return this.optionCr;
    }

    public Marker getMarker() {
        return new Marker();
    }

    public void skipTillDot() throws EndOfProgramException, GeneralErrorException {
        while (this.getToken().getToknum() != 10006) {
        }
        this.ungetToken();
    }

    public void skipToDot() throws EndOfProgramException, GeneralErrorException {
        while (this.getToken().getToknum() != 10006) {
        }
    }

    public void skipTill(int[] tokens) throws EndOfProgramException, GeneralErrorException {
        block0: while (true) {
            int tkn = this.getToken().getToknum();
            int i = 0;
            while (true) {
                if (i >= tokens.length) continue block0;
                if (tkn == tokens[i]) {
                    this.ungetToken();
                    return;
                }
                ++i;
            }
            break;
        }
    }

    protected void setLowHighValues(int lw, int hw) {
        this.lowValue = lw;
        this.highValue = hw;
    }

    @Override
    public int getLowValue() {
        return this.lowValue;
    }

    @Override
    public int getHighValue() {
        return this.highValue;
    }

    public String getApost() {
        return this.optionApost ? "'''" : "'\"'";
    }

    @Override
    public Token getToken() throws EndOfProgramException, GeneralErrorException {
        return this.getToken(true);
    }

    @Override
    public Token getToken(boolean joinALL) throws EndOfProgramException, GeneralErrorException {
        Token con;
        Token Return2;
        while ((Return2 = this.getAllToken(joinALL)).isSeparator()) {
        }
        if (Return2.getToknum() == 10009 && (con = this.getConstVar(Return2.getWord())) != null) {
            Return2.makeConst(con);
        }
        if (Return2.getToknum() == 10026) {
            throw new ErrorDirective(Return2);
        }
        return Return2;
    }

    static String stringToHex(String str, boolean national, boolean unicode) {
        StringBuffer sb = new StringBuffer();
        for (char c : str.toCharArray()) {
            String h;
            if (national) {
                h = Integer.toHexString(c).toUpperCase();
                if (unicode) {
                    sb.append("\\u");
                }
                sb.append("0000".substring(0, 4 - h.length()));
                sb.append(h);
                continue;
            }
            h = Integer.toHexString(c & 0xFF).toUpperCase();
            if (unicode) {
                sb.append("\\u00");
            }
            sb.append("00".substring(0, 2 - h.length()));
            sb.append(h);
        }
        return sb.toString();
    }

    private static boolean hexToString(Token tk, Errors err, boolean national) {
        String word = tk.getWord();
        char q = word.charAt(1);
        StringBuffer ret = new StringBuffer().append(q);
        int idx = 2;
        int clen = national ? 4 : 2;
        int init0s = (word.length() - 3) % clen;
        if (init0s > 0) {
            word = "x'" + "000".substring(0, clen - init0s) + word.substring(2);
        }
        char[] line = word.toCharArray();
        while (idx < line.length && line[idx] != q) {
            int c = 0;
            int i = 0;
            while (i < clen && line[idx] != q) {
                c <<= 4;
                switch (line[idx]) {
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': {
                        c += (char)(line[idx] - 48);
                        break;
                    }
                    case 'A': 
                    case 'B': 
                    case 'C': 
                    case 'D': 
                    case 'E': 
                    case 'F': {
                        c += (char)(line[idx] - 65 + 10);
                        break;
                    }
                    case 'a': 
                    case 'b': 
                    case 'c': 
                    case 'd': 
                    case 'e': 
                    case 'f': {
                        c += (char)(line[idx] - 97 + 10);
                        break;
                    }
                    default: {
                        return false;
                    }
                }
                ++i;
                ++idx;
            }
            ret.append((char)c);
        }
        ret.append(q);
        if (ret.length() == 2) {
            tk.setToknum(10002);
            tk.setWord("0");
            return false;
        }
        tk.setWord(ret.toString());
        tk.setHexdecimal(true);
        return true;
    }

    private void checkNumLiteral(Token tk) throws GeneralErrorException {
        char[] a = tk.getWord().toCharArray();
        int cnt = 0;
        for (int i = 0; i < a.length; ++i) {
            if (a[i] < '0' || a[i] > '9') continue;
            ++cnt;
        }
        if (cnt > 31) {
            throw new GeneralErrorException(141, 4, tk, tk.getWord(), this.error);
        }
    }

    private void handleStringLiteral(Token tk) {
        char fc = tk.getWord().charAt(0);
        if (fc == 'X') {
            if (!TokenManager.hexToString(tk, this.error, false)) {
                // empty if block
            }
        } else if (fc == 'H') {
            if (this.optionCm) {
                String wrd = tk.getWord();
                long num = PreProcessor.hexToNum(wrd.toCharArray(), new int[]{2}, wrd.length() - 1);
                tk.setToknum(10002);
                tk.setWord("" + num);
            } else if (!TokenManager.hexToString(tk, this.error, false)) {
                // empty if block
            }
        } else {
            fc = tk.getWord().charAt(0);
            if (fc == 'N' || fc == 'n') {
                tk.setNational(true);
                fc = tk.getWord().charAt(1);
                if (fc == 'X' || fc == 'x') {
                    tk.setWord(tk.getWord().substring(1));
                    if (!TokenManager.hexToString(tk, this.error, true)) {
                        // empty if block
                    }
                } else {
                    tk.setWord(tk.getWord().substring(1));
                }
            } else {
                fc = tk.getWord().charAt(0);
                if (fc == 'R' || fc == 'r') {
                    if (!this.optionB) {
                        tk.setNational(true);
                    }
                    tk.setResource(true);
                    tk.setWord(tk.getWord().substring(1));
                }
            }
        }
    }

    private void concat(Token a, Token b) {
        String wa = a.getWord();
        String wb = b.getWord();
        char qa = wa.charAt(0);
        char qb = wb.charAt(0);
        boolean xa = a.isHexdecimal();
        boolean xb = b.isHexdecimal();
        StringBuffer sb = new StringBuffer(wa.substring(0, wa.length() - 1));
        if (qa == qb && xa == xb) {
            sb.append(wb.substring(1, wb.length()));
        } else {
            char[] cb = wb.toCharArray();
            for (int i = 1; i < cb.length - 1; ++i) {
                sb.append(cb[i]);
                if (cb[i] == qa) {
                    if (!xa) {
                        sb.append(cb[i]);
                        continue;
                    }
                    if (xb) continue;
                    ++i;
                    continue;
                }
                if (cb[i] != qb || xb) continue;
                ++i;
            }
            sb.append(qa);
        }
        a.setWord(sb.toString());
    }

    @Override
    public Token getAllToken() throws EndOfProgramException, GeneralErrorException {
        return this.getAllToken(true);
    }

    @Override
    public Token getAllToken(boolean joinALL) throws EndOfProgramException, GeneralErrorException {
        Token c;
        Token Return2 = this.myGetToken();
        Token all = null;
        if (joinALL && Return2.getToknum() == 262) {
            all = Return2;
            Return2 = this.myGetToken();
            switch (Return2.getToknum()) {
                case 10002: 
                case 10017: {
                    if (!Return2.isZero()) {
                        this.error.print(219, 3, Return2, all.getWord() + " " + Return2.getWord());
                    }
                    all = null;
                    break;
                }
                case 10009: {
                    c = this.getConstant(Return2.getWord());
                    if (c != null) {
                        if (c.getToknum() == 10002 || c.getToknum() == 10017) {
                            this.error.print(219, 3, Return2, all.getWord() + " " + Return2.getWord());
                            all = null;
                            break;
                        }
                        if (c.getToknum() == 10001 && c.getWord().length() == 2) {
                            this.error.print(317, 3, Return2, all.getWord() + " " + Return2.getWord());
                            if (this.keepAll) {
                                Return2 = new Token(c);
                                Return2.setWord("\" \"");
                            } else {
                                all = null;
                                break;
                            }
                        }
                    }
                    Return2.setAll(true);
                    break;
                }
                case 10001: {
                    if (Return2.getWord().length() == 2) {
                        this.error.print(317, 3, Return2, all.getWord() + " " + Return2.getWord());
                        if (this.keepAll) {
                            Return2.setWord("\" \"");
                        } else {
                            all = null;
                            break;
                        }
                    }
                }
                default: {
                    Return2.setAll(true);
                }
            }
        }
        block6 : switch (Return2.getToknum()) {
            default: {
                if (all == null) break;
                Return2.setAll(false);
                Return2 = all;
                this.ungetToken();
                break;
            }
            case 374: {
                break;
            }
            case 10017: {
                break;
            }
            case 10009: {
                c = this.getConstVar(Return2.getWord(), true);
                if (c == null || c.getToknum() != 10001) break;
                Return2.makeConst(c);
            }
            case 10001: {
                this.handleStringLiteral(Return2);
                if (Return2.getToknum() == 10002) break;
                block42: while (this.myGetToken().getToknum() == 38) {
                    Token str = this.myGetToken();
                    c = this.getConstVar(str.getWord(), true);
                    if (c != null && c.getToknum() == 10001) {
                        str.makeConst(c);
                    }
                    String s = null;
                    switch (str.getToknum()) {
                        case 10001: {
                            this.handleStringLiteral(str);
                            if (Return2.isResource() || str.isResource()) {
                                this.error.print(158, 3, Return2, Return2.getWord() + " & " + str.getWord());
                            }
                            this.concat(Return2, str);
                            this.tokenBuff.removeElementAt(this.tokenBuffIdx--);
                            this.tokenBuff.removeElementAt(this.tokenBuffIdx--);
                            break;
                        }
                        case 576: 
                        case 577: 
                        case 600: 
                        case 601: {
                            s = "\"\u0000\"";
                            break;
                        }
                        case 516: 
                        case 517: {
                            s = "\"\u00ff\"";
                            break;
                        }
                        case 822: 
                        case 824: 
                        case 825: {
                            s = "\"0\"";
                            break;
                        }
                        case 736: 
                        case 737: {
                            s = "\" \"";
                            break;
                        }
                        case 660: 
                        case 661: {
                            s = "\"\"\"";
                            break;
                        }
                        default: {
                            this.error.print(158, 4, Return2, " & " + str.getWord());
                            break block42;
                        }
                    }
                    if (s == null) continue;
                    str = new Token(10001, s, 1, 1, "");
                    this.concat(Return2, str);
                    this.tokenBuff.removeElementAt(this.tokenBuffIdx--);
                    this.tokenBuff.removeElementAt(this.tokenBuffIdx--);
                }
                this.ungetToken();
                break;
            }
            case 600: 
            case 601: {
                if (this.inExecSql) {
                    Return2.setNullFlag();
                    break;
                }
                Return2.setNull((char)this.lowValue);
                break;
            }
            case 822: 
            case 824: 
            case 825: {
                Return2.setToknum(10002);
                Return2.setWord("0");
                Return2.setAll(true);
                Return2.setFigurative(true);
                break;
            }
            case 736: 
            case 737: {
                Return2.setToknum(10001);
                Return2.setWord("' '");
                Return2.setFigurative(true);
                break;
            }
            case 576: 
            case 577: {
                Return2.setHexAll((char)this.lowValue);
                break;
            }
            case 516: 
            case 517: {
                Return2.setHexAll((char)this.highValue);
                break;
            }
            case 660: 
            case 661: {
                Return2.setToknum(10001);
                Return2.setWord(this.optionApost ? "'''" : "'\"'");
                Return2.setAll(true);
                Return2.setFigurative(true);
                break;
            }
            case 10014: {
                String word = "";
                int idx = this.tokenBuffIdx;
                char del = Return2.getWord().charAt(0);
                Token tk = Return2;
                char fc = del;
                String fcs = "" + fc;
                int len = tk.getWord().length();
                switch (fc) {
                    case 'B': 
                    case 'H': 
                    case 'O': 
                    case 'X': {
                        del = Return2.getWord().charAt(1);
                        word = word + tk.getWord().substring(2, len - 2);
                        break;
                    }
                    case 'N': {
                        if (Return2.getWord().length() > 1 && Return2.getWord().charAt(1) == 'X') {
                            del = Return2.getWord().charAt(2);
                            word = word + tk.getWord().substring(3, len - 2);
                            fcs = "NX";
                            break;
                        }
                    }
                    default: {
                        word = word + tk.getWord().substring(1, len - 2);
                    }
                }
                tk = this.myGetToken();
                if (tk.getToknum() != 10021) {
                    this.ungetToken();
                }
                while ((tk = this.myGetToken()).getToknum() == 10014) {
                    len = tk.getWord().length();
                    word = word + tk.getWord().substring(1, len - 2);
                    tk = this.myGetToken();
                    if (tk.getToknum() == 10021) continue;
                    this.ungetToken();
                }
                if (tk.getToknum() != 10001) {
                    throw new GeneralErrorException(1, 4, tk, tk.getWord(), this.error);
                }
                len = tk.getWord().length();
                Return2.setWord(del + word + tk.getWord().substring(1, len - 1) + del);
                if (fc != del) {
                    Return2.setWord(fcs + Return2.getWord());
                    this.handleStringLiteral(Return2);
                }
                if (all != null && Return2.getWord().length() == 2) {
                    this.error.print(317, 3, Return2, all.getWord() + " " + Return2.getWord());
                    if (this.keepAll) {
                        Return2.setWord("\" \"");
                    } else {
                        Return2.setAll(false);
                        all = null;
                    }
                }
                if (Return2.getToknum() == 10014) {
                    Return2.setToknum(10001);
                }
                while (this.tokenBuffIdx > idx) {
                    this.tokenBuff.removeElementAt(this.tokenBuffIdx--);
                }
                break;
            }
            case 10002: {
                int idx = this.tokenBuffIdx;
                try {
                    Token tkDec;
                    Token tkDp = this.myGetToken();
                    if (tkDp.getWord().length() == 1 && (tkDec = this.myGetToken()).getToknum() == 10002 && (this.inExecSql && tkDp.getToknum() == 10006 || !this.inExecSql && this.pp.getDecimalPoint() == ',' && tkDp.getToknum() == 44 || this.pp.getDecimalPoint() == '.' && tkDp.getToknum() == 10006)) {
                        Token tke = this.myGetToken();
                        if (tke.getToknum() == 10022) {
                            Token tkExp = this.myGetToken();
                            Return2.setDouble(true);
                            if (tkExp.getToknum() == 10002) {
                                Return2.setWord(Return2.getWord() + "." + tkDec.getWord() + "E" + tkExp.getWord());
                            } else {
                                --this.tokenBuffIdx;
                                Return2.setWord(Return2.getWord() + "." + tkDec.getWord() + "E00");
                            }
                        } else {
                            --this.tokenBuffIdx;
                            Return2.setWord(Return2.getWord() + tkDp.getWord() + tkDec.getWord());
                            Return2.setDecimals(tkDec.getWord().length());
                        }
                        Return2.setToknum(10017);
                        if (!this.inExecSql && this.pp.getDecimalPoint() == ',') {
                            tke = this.myGetToken();
                            if (tke.getWord().length() == 0 && tke.getToknum() == 10002) {
                                tkDp = this.myGetToken();
                                if (tkDp.getToknum() == 44 && tkDec.getOffset() + tkDec.getWord().length() == tkDp.getOffset()) {
                                    this.error.print(193, 2, tkDp.getFLN(), tkDp.getOffset(), tkDec.getWord() + ",", null, tkDp.getFileName());
                                } else {
                                    this.tokenBuffIdx -= 2;
                                }
                            } else {
                                --this.tokenBuffIdx;
                            }
                        }
                        while (this.tokenBuffIdx > idx) {
                            this.tokenBuff.removeElementAt(this.tokenBuffIdx--);
                        }
                    } else {
                        this.tokenBuffIdx = idx;
                    }
                }
                catch (EndOfProgramException e) {
                    this.tokenBuffIdx = idx;
                }
                this.checkNumLiteral(Return2);
                break;
            }
            case 558: {
                int tknum = this.myGetToken().getToknum();
                switch (tknum) {
                    case 609: {
                        Return2.setToknum(10009);
                        Return2.setWord("LENGTH OF");
                        this.tokenBuff.removeElementAt(this.tokenBuffIdx--);
                        break block6;
                    }
                    case 10001: 
                    case 10009: {
                        Return2.setToknum(10009);
                        Return2.setWord("LENGTH OF");
                        Return2 = new Token(Return2){

                            @Override
                            boolean isLength() {
                                return true;
                            }
                        };
                        this.tokenBuff.setElementAt(Return2, --this.tokenBuffIdx);
                        break block6;
                    }
                }
                --this.tokenBuffIdx;
                break;
            }
            case 259: {
                if (this.myGetToken().getToknum() == 609) {
                    Return2.setToknum(10009);
                    Return2.setWord("ADDRESS OF");
                    this.tokenBuff.removeElementAt(this.tokenBuffIdx--);
                    break;
                }
                --this.tokenBuffIdx;
            }
        }
        if (all == null && !Return2.isNull()) {
            switch (Return2.getToknum()) {
                case 10001: 
                case 10002: 
                case 10017: {
                    this.loadLiteral(Return2);
                }
            }
        }
        return Return2;
    }

    public void addWorkingStorageCopy(String cp) {
        this.workingStorageCopies.addElement(cp);
    }

    void startWorkingStorage(Token tk) {
        ReplaceList rl = new ReplaceList();
        int i = this.workingStorageCopies.size() - 1;
        if (i >= 0) {
            if (this.tokenBuffIdx < this.tokenBuff.size() - 1) {
                this.error.print(147, 4, tk, " (-exec=)");
            }
            while (i >= 0) {
                String copyName = this.workingStorageCopies.elementAt(i).toString();
                int err = this.pp.readCopy(tk, copyName, false, rl);
                if (err != 0) {
                    this.error.print(err, 4, tk, copyName);
                }
                --i;
            }
        }
    }

    private Token myGetToken() throws EndOfProgramException {
        Token Return2;
        while ((Return2 = this._myGetToken()) == null) {
        }
        return Return2;
    }

    private Token _myGetToken() throws EndOfProgramException {
        Token Return2 = null;
        ++this.tokenBuffIdx;
        while (this.tokenBuffIdx >= this.tokenBuff.size() && this.pp.getLine(this.tokenBuff, this) > 0) {
        }
        if (this.tokenBuffIdx < this.tokenBuff.size()) {
            Token lc = null;
            int lcIdx = this.tokenBuffIdx + 1;
            Return2 = (Token)this.tokenBuff.elementAt(this.tokenBuffIdx);
            if (Return2.getToknum() == 10024 || lcIdx == this.tokenBuff.size() && Return2.getToknum() != 10006) {
                while (true) {
                    if (lcIdx >= this.tokenBuff.size() && this.pp.getLine(this.tokenBuff, this) > 0) {
                        continue;
                    }
                    if (lcIdx >= this.tokenBuff.size() || (lc = (Token)this.tokenBuff.elementAt(lcIdx)).getToknum() != 10005 && lc.getToknum() != 10021) break;
                    ++lcIdx;
                }
            }
            if (lc != null) {
                if (lc.getToknum() == 10021 && Return2.getToknum() == 10024) {
                    this.pp.getLine(this.tokenBuff, this);
                    this.tokenBuff.removeElementAt(lcIdx);
                    lc = (Token)this.tokenBuff.elementAt(lcIdx);
                }
                if (lc.getToknum() == 1) {
                    this.tokenBuff.removeElementAt(lcIdx);
                    if (lcIdx < this.tokenBuff.size()) {
                        lc = (Token)this.tokenBuff.elementAt(lcIdx);
                        if (Return2.getToknum() == 10006) {
                            Return2.setWord(".");
                        } else if (Return2.getToknum() == 44) {
                            Return2.setWord(",");
                        } else if (Return2.getToknum() == 10024) {
                            Return2.setWord(Return2.getWord() + "\"-");
                            Return2.setToknum(10014);
                        } else {
                            String t1 = Return2.getWord();
                            String t2 = lc.getWord();
                            int t1Len = t1.length();
                            int t2Len = t2.length();
                            if (t1Len > 0 && t2Len > 0) {
                                char t1e = t1.charAt(t1Len - 1);
                                char t2s = t2.charAt(0);
                                if ((Character.isJavaIdentifierPart(t1e) || t1e == '-') && (Character.isJavaIdentifierPart(t2s) || t2s == '-')) {
                                    Return2.setWord(Return2.getWord() + lc.getWord());
                                    Return2.putKeyword(this.pp.getNotReservedWords());
                                    this.tokenBuff.removeElementAt(lcIdx);
                                }
                            }
                        }
                    }
                } else if (Return2.getToknum() == 10024 && Return2.doc != null) {
                    this.error.print(287, 3, Return2, Return2.getWord());
                    Return2.setWord(Return2.getWord() + Return2.doc);
                    Return2.doc = null;
                    Return2.setToknum(10001);
                }
            }
        }
        if (Return2 == null) {
            if (this.lastVirtualDot) {
                Object[] lt = this.pp.lastCondToken();
                if (lt != null) {
                    Return2 = (Token)lt[0];
                    int severity = lt[1] == null ? 2 : 4;
                    this.error.print(192, severity, Return2, ">>" + Return2.getWord());
                }
                throw new EndOfProgramException();
            }
            this.lastVirtualDot = true;
            Return2 = new Token(10006, ".", 0, 0, "");
        } else if (Return2.getToknum() == 10020) {
            this.addExtraInfo(Return2);
            this.tokenBuff.remove(this.tokenBuffIdx--);
            Return2 = null;
        } else if (Return2.getToknum() == 10005) {
            if (this.inDoc != null) {
                this.addExtraDoc(this.inDoc, Return2);
            } else if (this.keepComments && !this.commentList.contains(Return2)) {
                int idx = this.tokenBuff.indexOf(Return2);
                this.commentList.add(Return2);
                this.commentIdxs.add(idx);
            }
            if (!this.keepComments) {
                this.tokenBuff.remove(this.tokenBuffIdx--);
            }
            Return2 = null;
        }
        return Return2;
    }

    String getCommentCode(Token target, String indent) {
        if (!this.keepComments) {
            return "";
        }
        int lineNumber = target.getFLN();
        int fileIndex = target.getFileIndex();
        if (lineNumber <= 0) {
            return "";
        }
        int targetIdx = this.tokenBuff.indexOf(target);
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < this.commentList.size()) {
            Token comment = this.commentList.get(i);
            if (targetIdx < this.commentIdxs.get(i) && (comment.getFileIndex() != fileIndex || comment.getFLN() > lineNumber)) break;
            String w = comment.getWord();
            w = w.startsWith("|") ? w.substring(1) : (comment.getFileIndex() < fileIndex || comment.getFLN() < lineNumber ? w.substring(2) : null);
            if (w != null) {
                sb.append(indent).append("// ").append(w).append(eol);
                this.commentList.remove(i);
                this.commentIdxs.remove(i);
                continue;
            }
            ++i;
        }
        return sb.toString();
    }

    @Override
    public void ungetToken() throws EndOfProgramException {
        if (this.optionMs) {
            Token tk;
            do {
                this.ungetAllToken();
            } while (this.tokenBuffIdx > 0 && ((tk = (Token)this.tokenBuff.elementAt(this.tokenBuffIdx)).isSeparator() || tk.getToknum() == 10005));
        } else {
            do {
                this.ungetAllToken();
            } while (this.tokenBuffIdx > 0 && ((Token)this.tokenBuff.elementAt(this.tokenBuffIdx)).isSeparator());
        }
    }

    @Override
    public void ungetAllToken() throws EndOfProgramException {
        if (this.tokenBuffIdx >= 0) {
            --this.tokenBuffIdx;
        }
    }

    public void flushToken() {
        this.tokenBuffIdx = -1;
        this.tokenBuff = new Vector();
    }

    public void setMarker(Marker mk) {
        mk.marker = this.tokenBuffIdx;
    }

    int indexOf(Token tk) {
        int n = this.tokenBuff.size();
        for (int i = 0; i < n; ++i) {
            if (this.tokenBuff.elementAt(i) != tk) continue;
            return i;
        }
        return -1;
    }

    void setTokenBuffIdx(int idx) {
        this.tokenBuffIdx = idx;
    }

    int getTokenBuffIdx() {
        return this.tokenBuffIdx;
    }

    public void rewindToMarker(Marker mk) throws InternalErrorException {
        if (mk.marker == -1) {
            throw new InternalErrorException("marker not set");
        }
        this.tokenBuffIdx = mk.marker;
    }

    @Override
    public int getLineNumber() {
        return this.pp.getLineNumber();
    }

    @Override
    public String getFileName() {
        return this.pp.getFileName();
    }

    public boolean isNotReservedWord(String word) {
        Hashtable nrw = this.pp.getNotReservedWords();
        if (nrw == null) {
            return false;
        }
        return nrw.get(word) != null;
    }

    public Vector getCopyFileNames() {
        Vector tmp = this.getCopyFiles();
        Vector<String[]> Return2 = new Vector<String[]>();
        for (int i = 0; i < tmp.size(); ++i) {
            CopyBookDesc desc = (CopyBookDesc)tmp.elementAt(i);
            Return2.addElement(new String[]{desc.getParentName(), Integer.toString(desc.getParentLineNumber()), desc.getName()});
        }
        return Return2;
    }

    @Override
    public Vector getCopyFiles() {
        Vector Return2 = new Vector();
        Enumeration en = this.pp.getChildren().elements();
        while (en.hasMoreElements()) {
            this.getCopyFilesRecur((PreProcessor)en.nextElement(), Return2, false);
        }
        return Return2;
    }

    private void getCopyFilesRecur(PreProcessor child, Vector Return2, boolean orig) {
        CopyBookDesc elem = new CopyBookDesc(child.getFileName(), child.getParent().getFileName(), child.lineBeforeCopy, child.parentFileIndex, child.index());
        Return2.addElement(elem);
        Enumeration en = child.getChildren().elements();
        while (en.hasMoreElements()) {
            this.getCopyFilesRecur((PreProcessor)en.nextElement(), Return2, orig);
        }
    }

    public void setDecimalPointIsComma() {
        this.pp.setDecimalPointIsComma(true);
    }

    @Override
    public String getDecimalPointIsComma() {
        return this.pp.decimalPointIsComma();
    }

    @Override
    public char getDecimalPoint() {
        return this.pp.getDecimalPoint();
    }

    public void setEnvValue(String val) {
        this.pp.setEnvValue(val);
    }

    public String getEnvValue() {
        return this.pp.getEnvValue();
    }

    public void setEnvName(String val) {
        this.pp.setEnvName(val);
    }

    public String getEnvName() {
        return this.pp.getEnvName();
    }

    public boolean getExecSql() {
        return this.pp.getExecSql();
    }

    public OptionList getOptionList() {
        return this.optList;
    }

    void addConstant(VariableDeclaration v) {
        this.pp.addConstant(v);
    }

    Token getConstant(String name) {
        return this.pp.getConstant(name);
    }

    void addConstVar(VariableDeclaration v) {
        this.pp.addConstVar(v);
    }

    Token getConstVar(String name) {
        return this.pp.getConstVar(name);
    }

    Token getConstVar(String name, boolean getAlways) {
        return this.pp.getConstVar(name, getAlways);
    }

    public void removeToken(Token tk) {
        int i = this.tokenBuff.lastIndexOf(tk);
        if (i >= 0) {
            this.tokenBuff.remove(i);
        }
        --this.tokenBuffIdx;
    }

    public void removeLastToken() {
        this.tokenBuff.remove(this.tokenBuffIdx--);
    }

    public void removeToMarker(Marker mk) throws InternalErrorException {
        int tbi = this.tokenBuffIdx - 1;
        if (mk.marker == -1) {
            throw new InternalErrorException("marker not set");
        }
        for (int idx = tbi; idx >= mk.marker; --idx) {
            this.removeToken((Token)this.tokenBuff.elementAt(idx));
        }
        this.tokenBuffIdx = mk.marker;
    }

    public Token remgetToken(Token tk) throws GeneralErrorException, EndOfProgramException {
        this.lastRemovedToken = tk;
        this.removeToken(this.lastRemovedToken);
        return this.getToken();
    }

    public Token getLastRemovedToken() {
        return this.lastRemovedToken;
    }

    private static String buildName(Token tk) {
        StringBuffer Return2 = new StringBuffer(tk.getWord());
        if (tk.isResource()) {
            Return2.insert(0, "R");
        }
        if (tk.isNational()) {
            Return2.insert(0, "N");
        }
        if (tk.isAll()) {
            Return2.insert(0, "all ");
        } else if (tk.getNativeSize() > 0) {
            Return2.insert(0, "nat ");
        } else if (tk.getBitLen() > 0) {
            Return2.insert(0, "bin ");
        }
        return Return2.toString();
    }

    public void loadLiteral(Token tk) {
        String s = TokenManager.buildName(tk);
        if (this.allLiterals.get(s) == null) {
            String name = "$" + this.allLiterals.size() + "$";
            this.allLiterals.put(s, new Object[]{name, tk, Boolean.FALSE});
        }
    }

    public String getCodeLiteral(Token tk) {
        if (this.declareAllLit || this.debugExt || this.optionMs) {
            if (tk.isResource()) {
                StringBuffer Return2 = new StringBuffer();
                if (this.declareAllLit) {
                    Return2.append("Factory.");
                }
                Return2.append("getResource");
                if (!tk.isNational()) {
                    Return2.append("X");
                }
                Return2.append("(\"");
                Return2.append(tk.getCode());
                Return2.append("\")");
                return Return2.toString();
            }
            return tk.getLiteralFactory(this.pp.decimalPointIsComma(), this.hexCompact, this.optionMs);
        }
        String s = TokenManager.buildName(tk);
        Object[] o = this.allLiterals.get(s);
        if (o == null) {
            this.loadLiteral(tk);
            o = this.allLiterals.get(s);
        }
        this.allUsedLiterals.put(s, o);
        return (String)o[0];
    }

    public boolean hasResources() {
        return this.hasResources;
    }

    public String declareResources(boolean factory) {
        StringBuffer Return2 = new StringBuffer();
        StringBuffer resourceDecl = new StringBuffer();
        this.hasResources = false;
        for (String k : this.allLiterals.keySet()) {
            Object[] array = this.allLiterals.get(k);
            String name = (String)array[0];
            Token tk = (Token)array[1];
            if (!tk.isResource()) continue;
            this.hasResources = true;
            if (this.debugExt || this.optionMs) {
                resourceDecl.append("      resourceMap.put(");
                String key = "\"" + tk.getCode() + "\"";
                resourceDecl.append(key);
                resourceDecl.append(", ");
                if (tk.isNational()) {
                    resourceDecl.append("Factory.getResource(");
                } else {
                    resourceDecl.append("Factory.getResourceX(");
                }
                resourceDecl.append(key);
                resourceDecl.append("));");
            } else {
                resourceDecl.append("   ");
                if (factory) {
                    resourceDecl.append("static ");
                }
                resourceDecl.append("final");
                resourceDecl.append(tk.getLiteralDeclaration(name, this.pp.decimalPointIsComma(), this.optionMs, false));
            }
            resourceDecl.append(eol);
            array[2] = Boolean.TRUE;
        }
        if (this.hasResources) {
            if (this.debugExt || this.optionMs) {
                String mod = "   " + (!this.optionBig ? "private " : "") + (factory ? "static " : "");
                Return2.append(mod + "final java.util.Map<String, ICobolVar> resourceMap = new java.util.HashMap<String, ICobolVar>();");
                Return2.append(eol);
                Return2.append("   ");
                if (factory) {
                    Return2.append("static ");
                }
                Return2.append("{");
                Return2.append(eol);
                Return2.append(resourceDecl);
                Return2.append("   }");
                Return2.append(eol);
                Return2.append(mod + "final PicN getResource(String name) {");
                Return2.append(eol);
                Return2.append("      return (PicN) resourceMap.get(name);");
                Return2.append(eol);
                Return2.append("   }");
                Return2.append(eol);
                Return2.append(mod + "final PicX getResourceX(String name) {");
                Return2.append(eol);
                Return2.append("      return (PicX) resourceMap.get(name);");
                Return2.append(eol);
                Return2.append("   }");
                Return2.append(eol);
            } else {
                Return2.append(resourceDecl);
            }
        }
        return Return2.toString();
    }

    public String declareLiterals(String className, boolean split, int[] constInnerClassCount, boolean factory) {
        StringBuffer Return2 = new StringBuffer();
        int prog = 0;
        if (!this.debugExt && !this.optionMs) {
            int i = 0;
            for (String k : this.allUsedLiterals.keySet()) {
                Object[] array = this.allUsedLiterals.get(k);
                String name = (String)array[0];
                Token tk = (Token)array[1];
                if (array[2] == Boolean.FALSE && !tk.isResource()) {
                    if (split && i > 0 && i % Pcc.MAX_CONSTANTS == 0) {
                        Return2.append("}" + eol);
                        Return2.append("class " + className + "_CONST" + "_" + prog + " extends " + className + "_CONST" + "_" + (prog + 1));
                        ++prog;
                        if (this.debug) {
                            Return2.append(" implements IscobolDebugger");
                        }
                        Return2.append(" {" + eol);
                    }
                    Return2.append("   ");
                    if (!tk.isAll() || factory) {
                        Return2.append("static ");
                    }
                    Return2.append("final");
                    Return2.append(tk.getLiteralDeclaration(name, this.pp.decimalPointIsComma(), this.optionMs, this.hexCompact));
                    Return2.append(eol);
                }
                ++i;
            }
        }
        if (constInnerClassCount != null && constInnerClassCount.length > 0) {
            constInnerClassCount[0] = prog;
        }
        return Return2.toString();
    }

    public String declareAllLiterals(boolean factory) {
        if (this.debugExt || this.optionMs) {
            return "";
        }
        StringBuffer Return2 = new StringBuffer();
        for (String key : this.allLiterals.keySet()) {
            Object[] array = this.allLiterals.get(key);
            String name = (String)array[0];
            Token tk = (Token)array[1];
            if (!tk.isAll()) continue;
            Return2.append("   ");
            if (factory) {
                Return2.append("static ");
            }
            Return2.append("final");
            Return2.append(tk.getLiteralDeclaration(name, this.pp.decimalPointIsComma(), this.optionMs, this.hexCompact));
            Return2.append(eol);
            array[2] = Boolean.TRUE;
        }
        return Return2.toString();
    }

    boolean isPropagate() {
        return this.pp.isPropagate();
    }

    @Override
    public Vector getAllPreProcessors() {
        return this.pp.getAllPreProcessors();
    }

    private void addExtraDoc(String key, Token info) {
        TokenList tl = (TokenList)this.extraInfo.get(key);
        if (tl != null) {
            tl.addItem(info);
        }
    }

    private void addExtraInfo(Token info) {
        String xInfo = info.getWord();
        xInfo = xInfo.substring(4, xInfo.length() - 2).trim();
        TokenList tl = new TokenList();
        StringBuffer sb = new StringBuffer(xInfo);
        PreProcessor.tokenizer(tl, sb, info.getFLN(), "", 0, this.pp.getDecimalPoint(), this.pp.compFlags, new Errors(true), false);
        if (tl.getItemNum() > 1) {
            Token tk = tl.getFirst();
            String key = tl.getFirst().getCode().toUpperCase(Locale.US);
            TokenList ftl = (TokenList)this.extraInfo.get(key);
            if (ftl == null) {
                ftl = new TokenList();
                ftl.addItem(info);
            } else {
                Token t = ftl.getFirst();
                t.setWord(t.getWord() + " " + info.getWord());
            }
            tk = tl.getNext();
            while (tk != null) {
                if (tk.getToknum() != 10001) {
                    if (key.equals("ELK")) {
                        tk.setWord(tk.getOriginalWord());
                    } else {
                        tk.setWord(tk.getWord().toUpperCase(Locale.US));
                    }
                }
                ftl.addItem(tk);
                tk = tl.getNext();
            }
            this.extraInfo.put(key, ftl);
        } else {
            Token tk = tl.getFirst();
            if (tk != null) {
                String key = tk.getCode().toUpperCase(Locale.US);
                if ("DOC".equals(key)) {
                    this.inDoc = key;
                    this.extraInfo.put(key, tl);
                } else if ("END_DOC".equals(key)) {
                    this.inDoc = null;
                }
            }
        }
    }

    public TokenList getExtraInfo(String key) {
        return (TokenList)this.extraInfo.get(key.toUpperCase(Locale.US));
    }

    public TokenList delExtraInfo(String key) {
        return (TokenList)this.extraInfo.remove(key.toUpperCase(Locale.US));
    }

    public int getFormat() {
        return this.pp.getFormat();
    }

    public Vector getSvrFileNames() {
        return this.pp.getSvrFileNames();
    }

    public void putTokens(String str, Token tk0) {
        TokenList tl = PreProcessor.tokenizer(new StringBuffer(str), tk0.getFLN(), tk0.getFileName(), this.pp.getDecimalPoint(), false, true, this.pp.getNotReservedWords());
        int idx = this.tokenBuffIdx + 1;
        Token tk = tl.getLast();
        while (tk != null) {
            this.tokenBuff.add(idx, tk);
            tk = tl.getPrevious();
        }
    }

    void addCopyResource(File f) {
        try {
            this.copyResources.add(f.getCanonicalFile());
        }
        catch (IOException e) {
            this.copyResources.add(f);
        }
    }

    Collection<File> getCopyResources() {
        return this.copyResources;
    }

    boolean setKeepAll(boolean b) {
        boolean old = this.keepAll;
        this.keepAll = b;
        return old;
    }

    public class Marker {
        private int marker = -1;

        public void removeUntilHere() throws InternalErrorException {
            int tbi = TokenManager.this.tokenBuffIdx;
            if (this.marker == -1) {
                throw new InternalErrorException("marker not set");
            }
            for (int idx = tbi; idx >= this.marker; --idx) {
                TokenManager.this.removeToken((Token)TokenManager.this.tokenBuff.elementAt(idx));
            }
            TokenManager.this.tokenBuffIdx = this.marker - 1;
        }
    }
}

