/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.compiler.AmbiguousException;
import com.iscobol.compiler.Block;
import com.iscobol.compiler.CobolToken;
import com.iscobol.compiler.Compute;
import com.iscobol.compiler.Condition;
import com.iscobol.compiler.EndOfProgramException;
import com.iscobol.compiler.Errors;
import com.iscobol.compiler.ErrorsNumbers;
import com.iscobol.compiler.ExpectedFoundException;
import com.iscobol.compiler.Expression;
import com.iscobol.compiler.GeneralErrorException;
import com.iscobol.compiler.GetVarOpts;
import com.iscobol.compiler.IllegalConditionException;
import com.iscobol.compiler.MissingClassException;
import com.iscobol.compiler.Pcc;
import com.iscobol.compiler.Perform;
import com.iscobol.compiler.Token;
import com.iscobol.compiler.TokenManager;
import com.iscobol.compiler.UndefinedException;
import com.iscobol.compiler.UnexpectedTokenException;
import com.iscobol.compiler.VariableDeclaration;
import com.iscobol.compiler.VariableName;
import com.iscobol.compiler.Verb;

public class VaryingAfter
extends Verb
implements CobolToken,
ErrorsNumbers {
    private Condition until;
    private VariableName varying;
    private boolean varyingLocal;
    private VariableName fromVar;
    private Token fromToken;
    private VariableName byVar;
    private Token byToken;
    private boolean testAfter;
    private Perform prf;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VaryingAfter(Token kw, Block par, Pcc p, TokenManager t, Errors err, boolean ta, Perform prf) throws GeneralErrorException, EndOfProgramException {
        super(kw, par, p, t, err);
        this.testAfter = ta;
        Token tk = this.tm.getToken();
        if (tk.getToknum() != 10009) {
            throw new GeneralErrorException(17, 4, tk, tk.getWord(), this.error);
        }
        this.tm.ungetToken();
        TokenManager.Marker mk = this.tm.getMarker();
        this.tm.setMarker(mk);
        this.prf = prf;
        boolean ie = this.error.ignoreErrors;
        GetVarOpts opts = new GetVarOpts(prf, 1);
        try {
            this.error.ignoreErrors = true;
            this.varying = VariableName.getAny(this.tm, this.error, this.parent, this.pc, opts);
        }
        catch (UndefinedException ex) {
            this.error.ignoreErrors = ie;
            Token locName = tk;
            String className = null;
            if (this.tm.getToken().getToknum() == 280) {
                tk = this.tm.getToken();
                if (tk.getToknum() == 10009) {
                    if ("ACTIVE-CLASS".equals(tk.getWord())) {
                        className = "java.lang.Object";
                    } else {
                        this.tm.ungetToken();
                        VariableName vn = VariableName.getObject(this.tm, this.error, null, this.pc);
                        if (vn == null || !vn.getVarDecl().isFactory) {
                            throw new MissingClassException(tk.getWord(), tk, this.error);
                        }
                        className = vn.getVarDecl().getClassName();
                        tk = this.tm.getToken();
                        if (tk.getToknum() != 614) {
                            this.tm.ungetToken();
                        }
                    }
                } else if (tk.getToknum() == 10001) {
                    className = tk.getWord().substring(1, tk.getWord().length() - 1);
                    try {
                        this.pc.existsClass(className);
                    }
                    catch (ClassNotFoundException e) {
                        throw new MissingClassException(tk.getWord(), tk, this.error);
                    }
                }
            }
            if (className != null) {
                VariableDeclaration localVd = VariableDeclaration.getObject(this.pc, locName, this.tm, className, false);
                this.pc.putLocalVariable(localVd);
                this.varying = new VariableName(localVd);
                this.varyingLocal = true;
            } else {
                this.tm.rewindToMarker(mk);
                VariableName.getAny(this.tm, this.error, this.parent, this.pc, opts);
            }
        }
        catch (GeneralErrorException ex) {
            this.error.ignoreErrors = ie;
            this.tm.rewindToMarker(mk);
            VariableName.getAny(this.tm, this.error, this.parent, this.pc, opts);
        }
        finally {
            this.error.ignoreErrors = ie;
        }
        if (!this.varying.getVarDecl().isNumeric() || this.varying.getVarDecl().isEdited()) {
            throw new GeneralErrorException(23, 4, tk, tk.getWord(), this.error);
        }
        tk = this.tm.getToken();
        if (!this.varyingLocal && tk.getToknum() == 280) {
            throw new AmbiguousException(this.varying.getNameToken(), this.error, this.varying.getName());
        }
        if (tk.getToknum() != 498) {
            throw new ExpectedFoundException(tk, this.error, "'FROM'");
        }
        tk = this.tm.getToken();
        if (tk.getToknum() == 10009) {
            this.tm.ungetToken();
            this.fromVar = VariableName.getAny(this.tm, this.error, this.pc);
            if (!this.fromVar.getVarDecl().isNumeric() || this.fromVar.getVarDecl().isEdited()) {
                throw new GeneralErrorException(23, 4, tk, tk.getWord(), this.error);
            }
        } else if (Token.isNumLit(tk)) {
            this.fromToken = tk;
        } else {
            throw new UnexpectedTokenException(tk, this.error);
        }
        if ((tk = this.tm.getToken()).getToknum() != 312) {
            throw new ExpectedFoundException(tk, this.error, "'BY'");
        }
        tk = this.tm.getToken();
        if (tk.getToknum() == 10009) {
            this.tm.ungetToken();
            this.byVar = VariableName.getAny(this.tm, this.error, this.pc);
            if (!this.byVar.getVarDecl().isNumeric() || this.byVar.getVarDecl().isEdited()) {
                throw new GeneralErrorException(23, 4, tk, tk.getWord(), this.error);
            }
        } else if (Token.isNumLit(tk)) {
            this.byToken = tk;
        } else {
            throw new UnexpectedTokenException(tk, this.error);
        }
        if ((tk = this.tm.getToken()).getToknum() != 791) {
            throw new ExpectedFoundException(tk, this.error, "'UNTIL'");
        }
        this.until = new Condition(this.keyWord, this.parent, this.pc, this.tm, this.error);
        if (!this.until.isFullCondition()) {
            throw new IllegalConditionException(this.keyWord, this.error);
        }
    }

    @Override
    public void check() throws GeneralErrorException {
        if (this.until != null) {
            this.until.check();
        }
    }

    private void getCodeIncr(StringBuffer Return2) {
        if (this.varying.isPrimitive()) {
            Return2.append(this.varying.getCode());
            Return2.append(" = ");
            String vt = this.varying.getType().getName(true);
            if (this.byToken != null) {
                String lit = this.getCodeLiteral(this.byToken);
                if (Expression.couldBeNativeInt(this.fromToken, 18)) {
                    String code = this.varying.getCode() + " + " + lit + ".theValue.lnUnscValue";
                    Return2.append(Compute.addCast(vt, code));
                } else {
                    String code = Expression.couldBeNativeInt(this.varying.getVarDecl()) ? "CobolNum.noo(" + this.varying.getCode() + ", 0)" : "CobolNum.noo((double) " + this.varying.getCode() + ")";
                    code = code + ".add(" + lit + ".theValue)";
                    Return2.append(Compute.getConversionMethod(vt, code));
                }
            } else if (this.byVar.isPrimitive()) {
                String code = this.varying.getCode() + " + " + this.byVar.getCode();
                Return2.append(Compute.addCast(vt, code));
            } else {
                String code = Expression.couldBeNativeInt(this.varying.getVarDecl()) ? "CobolNum.noo(" + this.varying.getCode() + ", 0)" : "CobolNum.noo((double) " + this.varying.getCode() + ")";
                code = code + ".add(" + this.byVar.getCode() + ".num())";
                Return2.append(Compute.getConversionMethod(vt, code));
            }
        } else {
            Return2.append(this.varying.getCode());
            if (this.varying.getVarDecl().isInteger()) {
                if (this.byToken != null && this.byToken.getToknum() == 10002) {
                    Return2.append(".addToMe(");
                    Return2.append(this.byToken.getAsLong());
                    Return2.append(")");
                    return;
                }
                if (this.byVar != null && this.byVar.getVarDecl().isInteger() && this.byVar.getVarDecl().getLogicLen() <= 18) {
                    Return2.append(".addToMe(");
                    Return2.append(this.byVar.getCode());
                    Return2.append(".tolong())");
                    return;
                }
            }
            Return2.append(".set(");
            if (this.byToken != null) {
                Return2.append(this.getCodeLiteral(this.byToken));
                Return2.append(".num()");
            } else if (this.byVar.isPrimitive()) {
                if (Expression.couldBeNativeInt(this.byVar.getVarDecl())) {
                    Return2.append("CobolNum.noo(" + this.byVar.getCode() + ", 0)");
                } else {
                    Return2.append("CobolNum.noo((double) " + this.byVar.getCode() + ")");
                }
            } else {
                Return2.append(this.byVar.getCode());
                Return2.append(".num()");
            }
            Return2.append(".add(");
            Return2.append(this.varying.getCode());
            Return2.append(".num())");
            Return2.append(",");
            Return2.append(false);
            Return2.append(",");
            Return2.append(false);
            Return2.append(")");
        }
    }

    public String getCodeBefore() {
        StringBuffer Return2 = new StringBuffer();
        Return2.append(this.parent.getIndent());
        Return2.append("for (");
        if (this.varyingLocal) {
            Return2.append(this.varying.getType().getName() + " ");
        }
        if (this.varying.isPrimitive()) {
            Return2.append(this.varying.getCode());
            Return2.append(" = ");
            String vt = this.varying.getType().getName(true);
            if (this.fromToken != null) {
                String code = this.getCodeLiteral(this.fromToken);
                if (Expression.couldBeNativeInt(this.fromToken, 18)) {
                    Return2.append(Compute.addCast(vt, code + ".theValue.lnUnscValue"));
                } else {
                    Return2.append(Compute.getConversionMethod(vt, code + ".theValue"));
                }
            } else if (this.fromVar.isPrimitive()) {
                Return2.append(Compute.addCast(vt, this.fromVar.getCode()));
            } else {
                Return2.append(Compute.getConversionMethod(vt, this.fromVar.getCode() + ".num()"));
            }
        } else {
            if (this.fromVar != null && this.fromVar.isPrimitive()) {
                Return2.append(this.varying.getCode());
                Return2.append(".set(");
                Return2.append(this.fromVar.getCode());
            } else {
                if (this.fromToken != null) {
                    Return2.append(this.getCodeLiteral(this.fromToken));
                } else {
                    Return2.append(this.fromVar.getCode());
                }
                Return2.append(".moveTo(");
                Return2.append(this.varying.getCode());
            }
            Return2.append(")");
        }
        Return2.append("; ;");
        this.prf.endCode = null;
        this.getCodeIncr(Return2);
        Return2.append(") {");
        Return2.append(eol);
        this.prf.getEndCode(Return2);
        if (!this.testAfter) {
            Return2.append(this.parent.getIndent());
            Return2.append("if (");
            Return2.append(this.until.getCode());
            Return2.append(") break;");
            Return2.append(eol);
        }
        return Return2.toString();
    }

    @Override
    public String getCode() {
        StringBuffer Return2 = new StringBuffer();
        if (this.testAfter) {
            Return2.append(this.parent.getIndent());
            Return2.append("if (");
            Return2.append(this.until.getCode());
            Return2.append(") break;");
            Return2.append(eol);
        }
        Return2.append(this.parent.getIndent());
        Return2.append("}");
        Return2.append(eol);
        return Return2.toString();
    }

    public Condition getUntil() {
        return this.until;
    }

    public VariableName getVarying() {
        return this.varying;
    }

    public VariableName getFromVar() {
        return this.fromVar;
    }

    public Token getFromToken() {
        return this.fromToken;
    }

    public VariableName getByVar() {
        return this.byVar;
    }

    public Token getByToken() {
        return this.byToken;
    }

    public boolean isTestAfter() {
        return this.testAfter;
    }
}

