/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.compiler.Block;
import com.iscobol.compiler.BlockException;
import com.iscobol.compiler.ClauseClashException;
import com.iscobol.compiler.CobolToken;
import com.iscobol.compiler.EndOfProgramException;
import com.iscobol.compiler.Errors;
import com.iscobol.compiler.ErrorsNumbers;
import com.iscobol.compiler.ExpectedFoundException;
import com.iscobol.compiler.GeneralErrorException;
import com.iscobol.compiler.GetVarOpts;
import com.iscobol.compiler.MyClass;
import com.iscobol.compiler.Pcc;
import com.iscobol.compiler.Token;
import com.iscobol.compiler.TokenManager;
import com.iscobol.compiler.UnexpectedTokenException;
import com.iscobol.compiler.VariableName;
import com.iscobol.compiler.Verb;
import com.iscobol.rts.ThreadException;

public class Wait
extends Verb
implements CobolToken,
ErrorsNumbers {
    private VariableName threadHandle;
    private boolean last;
    private VariableName timeoutVar;
    private Token timeoutToken;
    private VariableName inThread;
    private VariableName size;
    private VariableName status;
    private BlockException onException;
    private Block notOnException;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Wait(Token kw, Block par, Pcc p, TokenManager t, Errors err) throws GeneralErrorException, EndOfProgramException {
        super(kw, par, p, t, err);
        Token tk = this.tm.getToken();
        if (tk.getToknum() != 494) throw new ExpectedFoundException(tk, this.error, "'FOR'");
        tk = this.tm.getToken();
        if (tk.getToknum() == 763 || tk.getToknum() == 10009) {
            if (tk.getToknum() == 10009) {
                this.tm.ungetToken();
            }
            this.threadHandle = VariableName.get(this.tm, this.error, this.pc);
            if (this.threadHandle == null) {
                tk = this.tm.getToken();
                throw new UnexpectedTokenException(tk, this.error);
            }
            if (!this.threadHandle.getVarDecl().isValidThreadHandle()) {
                throw new ClauseClashException(tk, this.error, this.threadHandle.getName());
            }
        } else {
            if (tk.getToknum() != 554) throw new UnexpectedTokenException(tk, this.error);
            this.last = true;
            tk = this.tm.getToken();
            if (tk.getToknum() != 763) {
                throw new ExpectedFoundException(tk, this.error, "'THREAD'");
            }
        }
        boolean goOn = true;
        block7: while (goOn) {
            tk = this.tm.getToken();
            switch (tk.getToknum()) {
                case 763: {
                    tk = this.tm.getToken();
                    if (tk.getToknum() == 526) {
                        tk = this.tm.getToken();
                    }
                    this.tm.ungetToken();
                    this.inThread = VariableName.get(this.tm, this.error, this.pc, new GetVarOpts(this, 1));
                    if (this.inThread == null) {
                        tk = this.tm.getToken();
                        throw new UnexpectedTokenException(tk, this.error);
                    }
                    if (this.inThread.getVarDecl().isValidThreadHandle()) continue block7;
                    throw new ClauseClashException(tk, this.error, this.threadHandle.getName());
                }
                case 728: {
                    tk = this.tm.getToken();
                    if (tk.getToknum() == 526) {
                        tk = this.tm.getToken();
                    }
                    this.tm.ungetToken();
                    this.size = VariableName.get(this.tm, this.error, this.pc, new GetVarOpts(this, 1));
                    if (this.size != null) continue block7;
                    throw new UnexpectedTokenException(tk, this.error);
                }
                case 742: {
                    tk = this.tm.getToken();
                    if (tk.getToknum() == 526) {
                        tk = this.tm.getToken();
                    }
                    this.tm.ungetToken();
                    this.status = VariableName.get(this.tm, this.error, this.pc, new GetVarOpts(this, 1));
                    if (this.status != null) continue block7;
                    throw new UnexpectedTokenException(tk, this.error);
                }
                case 299: {
                    tk = this.tm.getToken();
                    if (tk.getToknum() == 769) {
                        tk = this.tm.getToken();
                    }
                    if (this.timeoutToken != null || this.timeoutVar != null) {
                        throw new ClauseClashException(tk, this.error, "BEFORE TIME");
                    }
                    if (Token.isNumLit(tk)) {
                        this.timeoutToken = tk;
                        continue block7;
                    }
                    this.tm.ungetToken();
                    this.timeoutVar = VariableName.get(this.tm, this.error, this.pc);
                    if (this.timeoutVar != null) continue block7;
                    throw new UnexpectedTokenException(tk, this.error);
                }
                case 760: {
                    tk = this.tm.getToken();
                    if (tk.getToknum() != 614) {
                        throw new ExpectedFoundException(tk, this.error, "'ONLY'");
                    }
                    if (this.timeoutToken != null || this.timeoutVar != null) {
                        throw new ClauseClashException(tk, this.error, "TEST ONLY");
                    }
                    this.timeoutToken = tk;
                    tk.setToknum(10002);
                    tk.setWord("0");
                    continue block7;
                }
            }
            this.tm.ungetToken();
            goOn = false;
        }
        boolean not = false;
        tk = this.tm.getToken();
        if (tk.getToknum() == 598 || tk.getToknum() == 613 || tk.getToknum() == 472) {
            boolean on = false;
            if (tk.getToknum() == 598) {
                not = true;
                tk = this.tm.getToken();
            }
            if (tk.getToknum() == 613) {
                on = true;
                tk = this.tm.getToken();
            }
            if (tk.getToknum() == 472) {
                if (not) {
                    this.notOnException = new Block(this.parent, this.parent.parent, (Verb)this, this.pc, this.tm, this.error, this.parent.nesting + 1, 2);
                } else {
                    this.onException = new BlockException(this.parent, this.parent.parent, (Verb)this, this.pc, this.tm, this.error, this.parent.nesting + 1, MyClass.getInstance(ThreadException.class));
                }
                tk = this.tm.getToken();
                if (!not && tk.getToknum() == 598) {
                    tk = this.tm.getToken();
                    if (tk.getToknum() == 613) {
                        tk = this.tm.getToken();
                    }
                    if (tk.getToknum() != 472) {
                        throw new ExpectedFoundException(tk, this.error, "'EXCEPTION'");
                    }
                    this.notOnException = new Block(this.parent, this.parent.parent, this, this.pc, this.tm, this.error, this.parent.nesting + 1);
                } else {
                    this.tm.ungetToken();
                }
            } else {
                this.tm.ungetToken();
                if (not) {
                    this.tm.ungetToken();
                }
                if (on) {
                    this.tm.ungetToken();
                }
            }
        } else {
            this.tm.ungetToken();
        }
        tk = this.tm.getToken();
        if (tk.getToknum() != 453) {
            this.tm.ungetToken();
            return;
        } else {
            this.endStmt = true;
        }
    }

    @Override
    public void check() throws GeneralErrorException {
    }

    @Override
    public String getCode() {
        String myIndent = this.parent.getIndent();
        StringBuffer Return2 = new StringBuffer();
        Return2.append(myIndent);
        this.getCodeDebug(Return2);
        Return2.append("try {");
        Return2.append(eol);
        myIndent = myIndent + "   ";
        Return2.append(myIndent);
        Return2.append("Factory.waitEnd (");
        if (this.threadHandle == null) {
            Return2.append("null");
        } else {
            Return2.append(this.threadHandle.getCode());
        }
        Return2.append(", ");
        Return2.append(this.last);
        Return2.append(", ");
        if (this.timeoutVar != null) {
            Return2.append(this.timeoutVar.getCode());
        } else if (this.timeoutToken != null) {
            Return2.append(this.getCodeLiteral(this.timeoutToken));
        } else {
            Return2.append("null");
        }
        Return2.append(", ");
        if (this.inThread == null) {
            Return2.append("null");
        } else {
            Return2.append(this.inThread.getCode());
        }
        Return2.append(", ");
        if (this.size == null) {
            Return2.append("null");
        } else {
            Return2.append(this.size.getCode());
        }
        Return2.append(", ");
        if (this.status == null) {
            Return2.append("null");
        } else {
            Return2.append(this.status.getCode());
        }
        Return2.append(");");
        Return2.append(eol);
        if (this.notOnException != null) {
            Return2.append(this.notOnException.getCode());
        }
        Return2.append(this.parent.getIndent());
        Return2.append("} catch (ThreadException ");
        Return2.append(this.parent.getExceptName());
        Return2.append(")");
        if (this.onException != null) {
            Return2.append(this.onException.getCode());
        } else {
            Return2.append("{ }");
        }
        Return2.append(eol);
        this.getCodeDebugEnd(Return2);
        return Return2.toString();
    }
}

