/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.compiler.Block;
import com.iscobol.compiler.BlockException;
import com.iscobol.compiler.CobolMethod;
import com.iscobol.compiler.EndOfProgramException;
import com.iscobol.compiler.Errors;
import com.iscobol.compiler.ExpectedFoundException;
import com.iscobol.compiler.GeneralErrorException;
import com.iscobol.compiler.GetVarOpts;
import com.iscobol.compiler.LabelName;
import com.iscobol.compiler.MyClass;
import com.iscobol.compiler.Pcc;
import com.iscobol.compiler.Perform;
import com.iscobol.compiler.Subscript;
import com.iscobol.compiler.SubscriptList;
import com.iscobol.compiler.Token;
import com.iscobol.compiler.TokenManager;
import com.iscobol.compiler.VariableDeclaration;
import com.iscobol.compiler.VariableName;
import com.iscobol.compiler.Verb;
import com.iscobol.rts.XMLException;

public class Xml
extends Verb {
    private VariableName var1;
    private VariableName from;
    private VariableName count;
    private LabelName startLabel;
    private LabelName endLabel;
    private int[] parNum;
    private String perfName;
    private BlockException onException;
    private Block notOnException;

    public Xml(Token kw, Block blk, Pcc p, TokenManager t, Errors err) throws GeneralErrorException, EndOfProgramException {
        super(kw, blk, p, t, err);
        Token tk;
        if (!this.pc.xmlVarsDeclared) {
            Pcc par = this.pc instanceof CobolMethod ? this.pc : this.pc.parent;
            Token tk2 = new Token(10009, "XML-TEXT", 0, 0, this.tm.getFileName());
            VariableDeclaration vd = VariableDeclaration.getPicAnyLength(par, this.tm, tk2, null, false);
            this.pc.fixedVars.addItem(vd);
            this.pc.loadVariable(vd);
            vd.setUsed();
            tk2 = new Token(10009, "XML-CODE", 0, 0, this.tm.getFileName());
            vd = VariableDeclaration.getPicDefaultNum(par, this.tm, tk2, true);
            this.pc.fixedVars.addItem(vd);
            this.pc.loadVariable(vd);
            vd.setUsed();
            tk2 = new Token(10009, "XML-EVENT", 0, 0, this.tm.getFileName());
            vd = VariableDeclaration.getPicX(par, this.tm, tk2, 30, null);
            this.pc.fixedVars.addItem(vd);
            this.pc.loadVariable(vd);
            vd.setUsed();
            tk2 = new Token(10009, "XML-NTEXT", 0, 0, this.tm.getFileName());
            vd = VariableDeclaration.getPicAnyLength(par, this.tm, tk2, null, true);
            this.pc.fixedVars.addItem(vd);
            this.pc.loadVariable(vd);
            vd.setUsed();
            tk2 = new Token(10009, "XML-ERRMSG", 0, 0, this.tm.getFileName());
            vd = VariableDeclaration.getPicAnyLength(par, this.tm, tk2, null, true);
            this.pc.fixedVars.addItem(vd);
            this.pc.loadVariable(vd);
            vd.setUsed();
            this.pc.addImport("import com.iscobol.rts.XMLParseGenerate;");
            this.pc.addImport("import com.iscobol.rts.XMLException;");
            this.pc.xmlVarsDeclared = true;
        }
        if ((tk = this.tm.getToken()).getToknum() == 631) {
            this.parse();
        } else if (tk.getToknum() == 501) {
            this.generate();
        } else {
            throw new ExpectedFoundException(tk, this.error, "PARSE|GENERATE");
        }
    }

    private void parse() throws GeneralErrorException, EndOfProgramException {
        Token tk = this.tm.getToken();
        this.tm.ungetToken();
        this.var1 = VariableName.get(this.tm, this.error, this.pc, GetVarOpts.DYN_GRP_ALLOW);
        if (this.var1 == null) {
            throw new GeneralErrorException(17, 4, tk, tk.getWord(), this.error);
        }
        tk = this.tm.getToken();
        if (!"PROCESSING".equals(tk.getWord())) {
            throw new ExpectedFoundException(tk, this.error, "PROCESSING");
        }
        tk = this.tm.getToken();
        if (tk.getToknum() != 651) {
            throw new ExpectedFoundException(tk, this.error, "PROCEDURE");
        }
        tk = this.tm.getToken();
        if (tk.getToknum() != 545) {
            this.tm.ungetToken();
        }
        this.startLabel = LabelName.get(this.parent, this.tm, this.error, this.pc);
        if (this.startLabel == null) {
            throw new GeneralErrorException(47, 4, this.keyWord, null, this.error);
        }
        tk = this.tm.getToken();
        if (tk.getToknum() == 768 || tk.getToknum() == 767) {
            this.endLabel = LabelName.get(this.parent, this.tm, this.error, this.pc);
            if (this.endLabel == null) {
                throw new GeneralErrorException(47, 4, this.keyWord, null, this.error);
            }
        } else {
            this.tm.ungetToken();
        }
        this.onExcptn();
    }

    private void onExcptn() throws GeneralErrorException, EndOfProgramException {
        Token tk = this.tm.getToken();
        if (tk.getToknum() == 598 || tk.getToknum() == 613 || tk.getToknum() == 472) {
            boolean on = false;
            boolean not = false;
            if (tk.getToknum() == 598) {
                not = true;
                tk = this.tm.getToken();
            }
            if (tk.getToknum() == 613) {
                on = true;
                tk = this.tm.getToken();
            }
            if (tk.getToknum() == 472) {
                if (not) {
                    this.notOnException = new Block(this.parent, this.parent.parent, (Verb)this, this.pc, this.tm, this.error, this.parent.nesting + 1, 2);
                } else {
                    this.onException = new BlockException(this.parent, this.parent.parent, (Verb)this, this.pc, this.tm, this.error, this.parent.nesting + 1, MyClass.getInstance(XMLException.class));
                }
                TokenManager.Marker mk = this.tm.getMarker();
                this.tm.setMarker(mk);
                tk = this.tm.getToken();
                if (!not && tk.getToknum() == 598) {
                    tk = this.tm.getToken();
                    if (tk.getToknum() == 613) {
                        tk = this.tm.getToken();
                    }
                    if (tk.getToknum() != 472) {
                        this.tm.rewindToMarker(mk);
                    } else {
                        this.notOnException = new Block(this.parent, this.parent.parent, this, this.pc, this.tm, this.error, this.parent.nesting + 1);
                    }
                } else {
                    this.tm.ungetToken();
                }
            } else {
                this.tm.ungetToken();
                if (not) {
                    this.tm.ungetToken();
                }
                if (on) {
                    this.tm.ungetToken();
                }
            }
        } else {
            this.tm.ungetToken();
        }
        tk = this.tm.getToken();
        if (tk.getToknum() != 455) {
            this.tm.ungetToken();
        } else {
            this.endStmt = true;
        }
    }

    private void generate() throws GeneralErrorException, EndOfProgramException {
        Token tk = this.tm.getToken();
        this.tm.ungetToken();
        this.var1 = VariableName.get(this.tm, this.error, this.pc);
        if (this.var1 == null) {
            throw new GeneralErrorException(17, 4, tk, tk.getWord(), this.error);
        }
        tk = this.tm.getToken();
        if (tk.getToknum() != 498) {
            throw new ExpectedFoundException(tk, this.error, "FROM");
        }
        tk = this.tm.getToken();
        this.tm.ungetToken();
        this.from = VariableName.get(this.tm, this.error, this.pc, GetVarOpts.DYN_GRP_ALLOW);
        if (this.from == null) {
            throw new GeneralErrorException(17, 4, tk, tk.getWord(), this.error);
        }
        this.from.getVarDecl().setAutoIdentifiedBy();
        this.from.getVarDecl().setUsedAll();
        tk = this.tm.getToken();
        if (tk.getToknum() == 382) {
            tk = this.tm.getToken();
            if (tk.getToknum() != 526) {
                tk = this.tm.getToken();
            }
            tk = this.tm.getToken();
            this.tm.ungetToken();
            this.count = VariableName.get(this.tm, this.error, this.pc);
            if (this.count == null) {
                throw new GeneralErrorException(17, 4, tk, tk.getWord(), this.error);
            }
        } else {
            this.tm.ungetToken();
        }
        this.onExcptn();
    }

    @Override
    public void check() throws GeneralErrorException {
        if (this.startLabel != null) {
            this.parNum = new int[2];
            this.perfName = Perform.check(this.startLabel, this.endLabel, this.parNum, this.pc.inDeclaratives, this.pc);
        }
    }

    @Override
    public String getCode() {
        String myIndent = this.parent.getIndent();
        StringBuffer Return2 = new StringBuffer();
        this.getCodeDebug(Return2);
        Return2.append(myIndent);
        Return2.append("try {");
        Return2.append(eol);
        myIndent = myIndent + "   ";
        if (this.startLabel != null) {
            Return2.append(myIndent);
            Return2.append("(new XMLParseGenerate (");
            Return2.append(this.var1.getCode());
            if (this.var1.getVarDecl().isNational()) {
                Return2.append("," + this.getLocalVar("XML-CODE") + "," + this.getLocalVar("XML-EVENT") + "," + this.getLocalVar("XML-NTEXT") + "," + this.getLocalVar("XML-ERRMSG") + ") {");
            } else {
                Return2.append("," + this.getLocalVar("XML-CODE") + "," + this.getLocalVar("XML-EVENT") + "," + this.getLocalVar("XML-TEXT") + "," + this.getLocalVar("XML-ERRMSG") + ") {");
            }
            Return2.append(eol);
            Return2.append(myIndent);
            Return2.append("   public void processing() {");
            Return2.append(eol);
            StringBuffer performCode = new StringBuffer();
            boolean optimized = Perform.getPerformCode(this.pc, this.parNum[0], this.parNum[1], myIndent + "         ", performCode, this.perfName, this.startLabel, true);
            if (optimized) {
                Return2.append(myIndent);
                Return2.append("      try {");
                Return2.append(eol);
            }
            Return2.append(performCode);
            Return2.append(eol);
            if (optimized) {
                Return2.append(myIndent);
                Return2.append("      } catch (GotoException $g) { }");
            }
            Return2.append(eol);
            Return2.append(myIndent);
            Return2.append("   }");
            Return2.append(eol);
            Return2.append(myIndent);
            Return2.append("}).parse();");
            Return2.append(eol);
            Return2.append(myIndent);
        } else {
            Return2.append(myIndent);
            Return2.append("XMLParseGenerate.generate (");
            Return2.append(this.var1.getCode());
            Return2.append(",");
            Return2.append(this.from.getCode());
            SubscriptList idxs = this.from.getIndexes();
            if (idxs == null) {
                Return2.append(",null");
            } else {
                Return2.append(",new int[] {");
                Subscript s = idxs.getFirst();
                while (true) {
                    Return2.append(s.getCode());
                    s = idxs.getNext();
                    if (s == null) break;
                    Return2.append(",");
                }
                Return2.append("}");
            }
            Return2.append(",");
            if (this.count != null) {
                Return2.append(this.count.getCode());
            } else {
                Return2.append("null");
            }
            Return2.append("," + this.getLocalVar("XML-CODE") + ");");
            Return2.append(eol);
        }
        if (this.notOnException != null) {
            Return2.append(this.notOnException.getCode());
        }
        Return2.append(eol);
        Return2.append(this.parent.getIndent());
        Return2.append("} catch (XMLException ");
        Return2.append(this.parent.getExceptName());
        Return2.append(")");
        if (this.onException != null) {
            Return2.append(this.onException.getCode());
        } else {
            Return2.append("{ }");
        }
        Return2.append(eol);
        this.getCodeDebugEnd(Return2);
        return Return2.toString();
    }

    public LabelName getStartLabel() {
        return this.startLabel;
    }

    public LabelName getEndLabel() {
        return this.endLabel;
    }

    public VariableName getDestination() {
        return this.var1;
    }

    public VariableName getFrom() {
        return this.from;
    }

    public VariableName getCount() {
        return this.count;
    }

    public BlockException getOnException() {
        return this.onException;
    }

    public Block getNotOnException() {
        return this.notOnException;
    }

    public String getPerformMethodName() {
        return this.perfName;
    }

    public LabelName getStartName() {
        return this.startLabel;
    }

    public LabelName getEndName() {
        return this.endLabel;
    }
}

