/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler.remote.server;

import com.iscobol.compiler.remote.FileData;
import com.iscobol.compiler.remote.XmlParseException;
import com.iscobol.compiler.remote.server.Environment;
import com.iscobol.compiler.remote.server.Option;
import com.iscobol.compiler.remote.server.OptionList;
import com.iscobol.compiler.remote.server.RemoteCompiler;
import com.iscobol.interfaces.compiler.remote.IRemotePreProcessor;
import com.iscobol.rpc.dualrpc.server.IServerCallbackHandler;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PreProcessor
implements IRemotePreProcessor {
    private String name = "";
    private File executable;
    private Environment environment;
    private OptionList optionList;
    private String outExt = "cbl";
    private String listExt = "list";
    private String errExt = "err";

    PreProcessor(Element element) throws XmlParseException {
        this.name = element.getAttribute("name");
        String s = element.getAttribute("executable");
        if (s != null && s.length() > 0) {
            this.executable = new File(s);
            if (!this.executable.exists() || this.executable.isDirectory()) {
                throw new XmlParseException("Invalid executable name: '" + s + "'");
            }
        } else {
            throw new XmlParseException("Invalid executable name: '" + s + "'");
        }
        s = element.getAttribute("outputFileExt");
        if (s != null && s.length() > 0) {
            this.outExt = s;
        }
        if ((s = element.getAttribute("errorFileExt")) != null && s.length() > 0) {
            this.errExt = s;
        }
        if ((s = element.getAttribute("listFileExt")) != null && s.length() > 0) {
            this.listExt = s;
        }
        NodeList nl = element.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            if (n.getNodeType() == 1 && n.getNodeName().equals("environment")) {
                this.environment = new Environment((Element)n);
                continue;
            }
            if (n.getNodeType() != 1 || !n.getNodeName().equals("optionList")) continue;
            this.optionList = new OptionList((Element)n);
        }
    }

    @Override
    public String getOutputFileExtension() {
        return this.outExt;
    }

    @Override
    public String getListingFileExtension() {
        return this.listExt;
    }

    @Override
    public String getErrorFileExtension() {
        return this.errExt;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public File getExecutable() {
        return this.executable;
    }

    @Override
    public Environment getEnvironment() {
        return this.environment;
    }

    @Override
    public OptionList getOptionList() {
        return this.optionList;
    }

    public void compile(FileData fileData, File parentDir, File lstDir, File errDir, File trsDir, int sessionId) throws IOException {
        String inputFile = fileData.getInputFile();
        StringWriter stdOutStr = new StringWriter();
        StringWriter stdErrStr = new StringWriter();
        final PrintWriter stdOut = new PrintWriter(stdOutStr);
        final PrintWriter stdErr = new PrintWriter(stdErrStr);
        int exitCode = -1;
        File inFile = new File(inputFile);
        StringBuffer runArgs = new StringBuffer();
        runArgs.append(this.executable);
        Option[] opts = this.optionList != null ? this.optionList.getOptions() : new Option[]{};
        for (int o = 0; o < opts.length; ++o) {
            if (opts[o].getIf() != null && (!opts[o].getIf().equals("listing") || !fileData.getListing()) && (!opts[o].getIf().equals("error") || !fileData.getError())) continue;
            runArgs.append(' ').append(opts[o].getValue());
        }
        String baseFilename = inFile.getPath();
        int idx = baseFilename.lastIndexOf(46);
        if (idx >= 0) {
            baseFilename = baseFilename.substring(0, idx);
        }
        String outputFile = trsDir.getAbsolutePath() + "/" + baseFilename + "." + this.outExt;
        String listingFile = lstDir.getAbsolutePath() + "/" + baseFilename + "." + this.listExt;
        String errorFile = errDir.getAbsolutePath() + "/" + baseFilename + this.errExt;
        File f = new File(outputFile);
        if (f.getParentFile() != null) {
            f.getParentFile().mkdirs();
        }
        if ((f = new File(errorFile)).getParentFile() != null) {
            f.getParentFile().mkdirs();
        }
        if ((f = new File(listingFile)).getParentFile() != null) {
            f.getParentFile().mkdirs();
        }
        this.replace(runArgs, "${inputfile}", new File(inputFile).getName());
        this.replace(runArgs, "${listfile}", listingFile);
        this.replace(runArgs, "${errorfile}", errorFile);
        this.replace(runArgs, "${outputfile}", outputFile);
        String[] envp = null;
        if (this.environment != null) {
            envp = this.environment.toStringArray();
        }
        String wrkDir = parentDir.getAbsolutePath();
        if (inFile.getParent() != null) {
            wrkDir = wrkDir + "/" + inFile.getParent();
        }
        final Process process = Runtime.getRuntime().exec(runArgs.toString(), envp, new File(wrkDir));
        new Thread(){

            @Override
            public void run() {
                BufferedReader r = new BufferedReader(new InputStreamReader(process.getInputStream()));
                try {
                    String line = r.readLine();
                    while (line != null) {
                        stdOut.println(line);
                        line = r.readLine();
                    }
                }
                catch (IOException iOException) {
                }
                finally {
                    try {
                        r.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }.start();
        new Thread(){

            @Override
            public void run() {
                BufferedReader r = new BufferedReader(new InputStreamReader(process.getErrorStream()));
                try {
                    String line = r.readLine();
                    while (line != null) {
                        stdErr.println(line);
                        line = r.readLine();
                    }
                }
                catch (IOException iOException) {
                }
                finally {
                    try {
                        r.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }.start();
        IServerCallbackHandler scbh = new IServerCallbackHandler(){

            @Override
            public void brokenConnection() {
                process.destroy();
            }
        };
        RemoteCompiler.addServerCallbackHandler(sessionId, scbh);
        try {
            exitCode = process.waitFor();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        RemoteCompiler.removeServerCallbackHandler(sessionId, scbh);
        fileData.setStdErr(stdErrStr.toString());
        fileData.setStdOut(stdOutStr.toString());
        fileData.setExitCode(exitCode);
        if (exitCode == 0) {
            fileData.setOutputFile(outputFile);
            fileData.setErrorFile(errorFile);
            fileData.setListingFile(listingFile);
        }
    }

    private void replace(StringBuffer buff, String oldStr, String newStr) {
        int idx;
        for (int i = 0; i < buff.length() && (idx = buff.indexOf(oldStr, i)) >= 0; i += newStr.length()) {
            buff.replace(idx, idx + oldStr.length(), newStr);
        }
    }
}

