/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.debugger.commands;

import com.iscobol.debugger.DebuggerConstants;
import com.iscobol.debugger.commands.DebugCommand;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Vector;

public class CompositeCommand
implements DebugCommand {
    private static final long serialVersionUID = 1000006L;
    private Vector<DebugCommand> commandList;

    public CompositeCommand() {
    }

    public CompositeCommand(Vector<DebugCommand> commandList) {
        this.commandList = commandList;
    }

    public Vector<DebugCommand> getCommandList() {
        return this.commandList;
    }

    @Override
    public String getStringId() {
        return "???";
    }

    @Override
    public String getShortDescription() {
        return "???";
    }

    @Override
    public String getUsage() {
        return "???";
    }

    @Override
    public String getHelpPage() {
        return "???";
    }

    @Override
    public boolean isWholeWord() {
        return false;
    }

    @Override
    public int getId() {
        return 1000;
    }

    @Override
    public void writeExternal(DataOutput out) throws IOException {
        out.writeInt(this.commandList.size());
        for (DebugCommand c : this.commandList) {
            out.writeInt(c.getId());
            c.writeExternal(out);
        }
    }

    @Override
    public void readExternal(DataInput in) throws IOException {
        this.commandList = new Vector();
        int n = in.readInt();
        for (int i = 0; i < n; ++i) {
            int id = in.readInt();
            try {
                DebugCommand c = DebuggerConstants.commandClasses.get(id).newInstance();
                c.readExternal(in);
                this.commandList.addElement(c);
                continue;
            }
            catch (IllegalAccessException | InstantiationException e) {
                e.printStackTrace();
            }
        }
    }
}

