/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.debugger.dialogs;

import com.iscobol.debugger.GraphUtilities;
import com.iscobol.debugger.dialogs.DebugDialog;
import com.iscobol.debugger.dialogs.LMResize;
import com.iscobol.debugger.dialogs.LMResizeData;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;

public class ConnectDialog
extends DebugDialog {
    private static final long serialVersionUID = 123L;
    private JTextField hostField;
    private JTextField portField;
    private String hostname;
    private int port;
    private boolean isOk;
    private JButton ok;
    private JButton close;

    public ConnectDialog(JFrame parent, String title, String defHost, String defPort) {
        super(parent, title, true);
        LMResize layout = new LMResize(10, 10, 5, 0);
        this.getContentPane().setLayout(layout);
        JLabel hostLbl = new JLabel("Host name:");
        Dimension d = layout.getPreferredSize(hostLbl);
        hostLbl.setBounds(10, 10, d.width, d.height);
        this.getContentPane().add(hostLbl);
        this.hostField = new JTextField();
        this.hostField.addMouseListener(new GraphUtilities.TextFieldDefaultPopup(this.hostField));
        if (defHost != null) {
            this.hostField.setText(defHost);
        }
        JLabel portLbl = new JLabel("Port number:");
        d = layout.getPreferredSize(portLbl);
        portLbl.setBounds(LMResize.getLeft(hostLbl), LMResize.getBottom(hostLbl) + 15, d.width, d.height);
        this.getContentPane().add(portLbl);
        this.hostField.setBounds(LMResize.getRight(portLbl) + 5, LMResize.getTop(hostLbl), 200, this.hostField.getPreferredSize().height);
        this.getContentPane().add((Component)this.hostField, new LMResizeData(1));
        this.portField = new JTextField();
        this.portField.addMouseListener(new GraphUtilities.TextFieldDefaultPopup(this.portField));
        this.portField.setBounds(LMResize.getLeft(this.hostField), LMResize.getTop(portLbl), 200, this.portField.getPreferredSize().height);
        this.getContentPane().add((Component)this.portField, new LMResizeData(1));
        if (defPort != null) {
            this.portField.setText(defPort);
        }
        this.ok = new JButton("OK");
        this.ok.setMnemonic('o');
        this.ok.addActionListener(e -> {
            try {
                this.port = Integer.parseInt(this.portField.getText().trim());
                this.hostname = this.hostField.getText().trim();
                this.isOk = true;
                this.closeDialog();
            }
            catch (NumberFormatException ex) {
                JOptionPane.showMessageDialog(this, "Incorrect port number!", this.getTitle(), 0);
            }
        });
        this.close = new JButton("Close");
        this.close.setMnemonic('c');
        this.close.addActionListener(e -> this.closeDialog());
        d = layout.getPreferredSize(this.close);
        this.close.setBounds(LMResize.getRight(this.portField) - d.width + 5, LMResize.getBottom(this.portField) + 20, d.width, d.height);
        this.getContentPane().add((Component)this.close, new LMResizeData(10));
        this.ok.setBounds(LMResize.getLeft(this.close) - 15 - d.width, LMResize.getTop(this.close), d.width, d.height);
        this.getContentPane().add((Component)this.ok, new LMResizeData(10));
        this.pack();
        this.setDefaultButton(this.ok);
    }

    public boolean isOk() {
        return this.isOk;
    }

    public String getHost() {
        return this.hostname;
    }

    public int getPort() {
        return this.port;
    }
}

