/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.debugger.dialogs;

import com.iscobol.debugger.DebugPanel;
import com.iscobol.debugger.Settings;
import com.iscobol.debugger.dialogs.DebugDialog;
import com.iscobol.debugger.dialogs.LMResize;
import com.iscobol.debugger.dialogs.LMResizeData;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;

public class ConsoleSettingsDialog
extends DebugDialog {
    private static final long serialVersionUID = 123L;
    private JCheckBox attachedChk;
    private JCheckBox showWhenChangeChk;
    private JButton ok;
    private JButton close;
    private DebugPanel debugPanel;

    public ConsoleSettingsDialog(JFrame parent, DebugPanel dbgpanel) {
        super(parent, "Console Settings", true);
        this.debugPanel = dbgpanel;
        LMResize layout = new LMResize(10, 10, 5, 0);
        this.getContentPane().setLayout(layout);
        String lbl = "Show 'stdout' and 'stderr' in the Console Tab";
        if (dbgpanel.getGraphDebugger().isRemoteThinClient()) {
            lbl = "<html>" + lbl + "<br><i>(the change will take effect at the next execution of GraphDebugger)</i></html>";
        }
        this.attachedChk = new JCheckBox(lbl);
        this.attachedChk.setSelected(Settings.isConsoleAttached());
        Dimension d = layout.getPreferredSize(this.attachedChk);
        this.attachedChk.setBounds(10, 10, d.width, d.height);
        this.getContentPane().add(this.attachedChk);
        this.showWhenChangeChk = new JCheckBox("Show Console Tab when the content changes");
        this.showWhenChangeChk.setSelected(Settings.isShowConsole());
        d = layout.getPreferredSize(this.showWhenChangeChk);
        this.showWhenChangeChk.setBounds(LMResize.getLeft(this.attachedChk), LMResize.getBottom(this.attachedChk) + 15, d.width, d.height);
        this.getContentPane().add(this.showWhenChangeChk);
        this.ok = new JButton("OK");
        this.ok.setMnemonic('o');
        this.ok.addActionListener(e -> {
            Settings.setConsoleAttached(this.attachedChk.isSelected());
            Settings.setShowConsole(this.showWhenChangeChk.isSelected());
            this.debugPanel.updateConsoleButtons();
            this.closeDialog();
        });
        this.close = new JButton("Close");
        this.close.setMnemonic('c');
        this.close.addActionListener(e -> this.closeDialog());
        d = layout.getPreferredSize(this.close);
        this.close.setBounds(LMResize.getRight(this.showWhenChangeChk) - d.width + 5, LMResize.getBottom(this.showWhenChangeChk) + 20, d.width, d.height);
        this.getContentPane().add((Component)this.close, new LMResizeData(10));
        this.ok.setBounds(LMResize.getLeft(this.close) - 15 - d.width, LMResize.getTop(this.close), d.width, d.height);
        this.getContentPane().add((Component)this.ok, new LMResizeData(10));
        this.pack();
        ConsoleSettingsDialog.setFirstFocusedComponent(this.attachedChk);
        this.setDefaultButton(this.ok);
    }
}

